/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.sendpacket;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SpinnerNumberModel;
import javax.swing.Timer;
import jmri.CommandStation;
import jmri.InstanceManager;
import jmri.jmrit.sendpacket.Bundle;
import jmri.util.JmriJFrame;
import jmri.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendPacketFrame
extends JmriJFrame {
    JLabel jLabel1 = new JLabel();
    JButton sendButton = new JButton();
    JTextField packetTextField = new JTextField(12);
    static final int MAXSEQUENCE = 4;
    JTextField[] mPacketField = new JTextField[4];
    JCheckBox[] mUseField = new JCheckBox[4];
    JSpinner[] mDelaySpinner = new JSpinner[4];
    JToggleButton mRunButton = new JToggleButton(Bundle.getMessage("ButtonStart"));
    int mNextSequenceElement = 0;
    byte[] mNextEcho = null;
    Timer timer = null;
    private CommandStation cs = null;
    private static final Logger log = LoggerFactory.getLogger(SendPacketFrame.class);

    @Override
    public void initComponents() {
        this.setTitle(Bundle.getMessage("SendPacketTitle"));
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.getContentPane().add(new JLabel(Bundle.getMessage("SendOneLabel")));
        JPanel pane1 = new JPanel();
        pane1.setLayout(new BoxLayout(pane1, 1));
        this.jLabel1.setText(Bundle.getMessage("PacketLabel"));
        this.jLabel1.setVisible(true);
        this.sendButton.setText(Bundle.getMessage("ButtonSend"));
        this.sendButton.setVisible(true);
        this.sendButton.setToolTipText(Bundle.getMessage("SendToolTip"));
        this.packetTextField.setToolTipText(Bundle.getMessage("EnterHexBytesToolTip"));
        pane1.add(this.jLabel1);
        pane1.add(this.packetTextField);
        pane1.add(this.sendButton);
        pane1.add(Box.createVerticalGlue());
        this.sendButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SendPacketFrame.this.sendButtonActionPerformed(e);
            }
        });
        this.getContentPane().add(pane1);
        this.getContentPane().add(new JSeparator());
        this.getContentPane().add(new JLabel(Bundle.getMessage("SendSequenceLabel")));
        JPanel pane2 = new JPanel();
        pane2.setLayout(new GridLayout(6, 4));
        pane2.add(new JLabel(""));
        pane2.add(new JLabel(Bundle.getMessage("ButtonSend")));
        pane2.add(new JLabel(Bundle.getMessage("Packet")));
        pane2.add(new JLabel(Bundle.getMessage("WaitMsec")));
        int i = 0;
        while (i < 4) {
            pane2.add(new JLabel(Integer.toString(i + 1)));
            this.mUseField[i] = new JCheckBox();
            this.mPacketField[i] = new JTextField(10);
            this.mDelaySpinner[i] = new JSpinner(new SpinnerNumberModel(100, 0, 1000, 1));
            pane2.add(this.mUseField[i]);
            pane2.add(this.mPacketField[i]);
            pane2.add(this.mDelaySpinner[i]);
            ++i;
        }
        pane2.add(this.mRunButton);
        this.getContentPane().add(pane2);
        this.mRunButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SendPacketFrame.this.runButtonActionPerformed(e);
            }
        });
        this.cs = InstanceManager.getNullableDefault(CommandStation.class);
        if (this.cs == null) {
            log.error("No CommandStation object available");
        }
        this.addHelpMenu("package.jmri.jmrit.sendpacket.SendPacketFrame", true);
        this.pack();
    }

    public void sendButtonActionPerformed(ActionEvent e) {
        this.cs.sendPacket(this.createPacket(this.packetTextField.getText()), 1);
    }

    protected void restartTimer(int delay) {
        if (this.timer == null) {
            this.timer = new Timer(delay, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SendPacketFrame.this.sendNextItem();
                }
            });
        }
        this.timer.stop();
        this.timer.setInitialDelay(delay);
        this.timer.setRepeats(false);
        this.timer.start();
    }

    public void runButtonActionPerformed(ActionEvent e) {
        if (!this.mRunButton.isSelected()) {
            return;
        }
        boolean ok = false;
        int i = 0;
        while (i < 4) {
            if (this.mUseField[i].isSelected()) {
                ok = true;
            }
            ++i;
        }
        if (!ok) {
            this.mRunButton.setSelected(false);
            return;
        }
        this.mNextSequenceElement = 0;
        this.sendNextItem();
    }

    void startSequenceDelay() {
        int delay = 500;
        try {
            delay = (Integer)this.mDelaySpinner[this.mNextSequenceElement].getValue();
        }
        catch (NumberFormatException numberFormatException) {}
        ++this.mNextSequenceElement;
        this.restartTimer(delay);
    }

    void sendNextItem() {
        if (!this.mRunButton.isSelected()) {
            return;
        }
        if (this.mNextSequenceElement >= 4) {
            this.mNextSequenceElement = 0;
        }
        if (this.mUseField[this.mNextSequenceElement].isSelected()) {
            byte[] m = this.createPacket(this.mPacketField[this.mNextSequenceElement].getText());
            this.mNextEcho = m;
            if (m != null) {
                this.cs.sendPacket(m, 1);
            } else {
                log.warn("Message invalid: {}", (Object)this.mPacketField[this.mNextSequenceElement].getText());
            }
            if (this.mRunButton.isSelected()) {
                this.startSequenceDelay();
            }
        } else {
            ++this.mNextSequenceElement;
            this.sendNextItem();
        }
    }

    @SuppressFBWarnings(value={"PZLA_PREFER_ZERO_LENGTH_ARRAYS"}, justification="API defined by CommmandStation interface")
    byte[] createPacket(String s) {
        byte[] b = StringUtil.bytesFromHexString(s);
        if (b.length == 0) {
            return null;
        }
        return b;
    }

    @Override
    public void dispose() {
        this.mRunButton.setSelected(false);
        super.dispose();
    }
}

