/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.roster.swing.speedprofile;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.Timer;
import jmri.Block;
import jmri.BlockManager;
import jmri.DccThrottle;
import jmri.InstanceManager;
import jmri.LocoAddress;
import jmri.Sensor;
import jmri.SensorManager;
import jmri.SpeedStepMode;
import jmri.ThrottleListener;
import jmri.jmrit.logix.WarrantPreferences;
import jmri.jmrit.roster.Roster;
import jmri.jmrit.roster.RosterEntry;
import jmri.jmrit.roster.RosterSpeedProfile;
import jmri.jmrit.roster.swing.RosterEntryComboBox;
import jmri.jmrit.roster.swing.speedprofile.Bundle;
import jmri.jmrit.roster.swing.speedprofile.SpeedProfileTable;
import jmri.profile.ProfileManager;
import jmri.profile.ProfileUtils;
import jmri.util.ThreadingUtil;
import jmri.util.jdom.JDOMUtil;
import jmri.util.swing.BeanSelectCreatePanel;
import jmri.util.swing.JmriPanel;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SpeedProfilePanel
extends JmriPanel
implements ThrottleListener {
    public static final String XML_ROOT = "speedprofiler-config";
    public static final String XML_NAMESPACE = "http://jmri.org/xml/schema/speedometer-3-9-3.xsd";
    JButton profileButton = new JButton(Bundle.getMessage("ButtonStart"));
    JButton cancelButton = new JButton(Bundle.getMessage("ButtonCancel"));
    JButton testButton = new JButton(Bundle.getMessage("ButtonTest"));
    JButton testCancelButton = new JButton(Bundle.getMessage("ButtonCancel"));
    JButton clearNewDataButton = new JButton(Bundle.getMessage("ButtonClearNewData"));
    JButton viewNewButton = new JButton(Bundle.getMessage("ButtonViewNew"));
    JButton viewMergedButton = new JButton(Bundle.getMessage("ButtonViewMerged"));
    JButton viewButton = new JButton(Bundle.getMessage("ButtonViewCurrent"));
    JButton updateProfileButton = new JButton(Bundle.getMessage("ButtonUpdateProfile"));
    JButton replaceProfileButton = new JButton(Bundle.getMessage("ButtonSaveProfile"));
    JButton deleteProfileButton = new JButton(Bundle.getMessage("ButtonDeleteProfile"));
    JButton saveDefaultsButton = new JButton(Bundle.getMessage("ButtonSaveDefaults"));
    JTextField lengthField = new JTextField(10);
    JTextField sensorDelay = new JTextField(5);
    JTextField speedStepTest = new JTextField(5);
    JTextField speedStepTestFwd = new JTextField(10);
    JTextField speedStepTestRev = new JTextField(10);
    JTextField speedStepFrom = new JTextField(5);
    JTextField speedStepTo = new JTextField(5);
    JTextField speedStepIncr = new JTextField(5);
    JLabel warrentScaleLabel = new JLabel();
    BeanSelectCreatePanel<Sensor> sensorAPanel = new BeanSelectCreatePanel<Object>(InstanceManager.sensorManagerInstance(), null);
    BeanSelectCreatePanel<Sensor> sensorBPanel = new BeanSelectCreatePanel<Object>(InstanceManager.sensorManagerInstance(), null);
    BeanSelectCreatePanel<Block> blockCPanel = new BeanSelectCreatePanel<Object>(InstanceManager.getDefault(BlockManager.class), null);
    BeanSelectCreatePanel<Sensor> sensorCPanel = new BeanSelectCreatePanel<Object>(InstanceManager.sensorManagerInstance(), null);
    RosterEntryComboBox reBox = new RosterEntryComboBox();
    SpeedProfileTable table = null;
    boolean profile = false;
    boolean test = false;
    float testSpeedFwd = 0.0f;
    float testSpeedRev = 0.0f;
    boolean save = false;
    boolean unmergedNewData = false;
    boolean unsavedUpdatedProfile = false;
    private JLabel sourceLabel;
    SensorDetails sensorA;
    SensorDetails sensorB;
    RosterEntry re;
    DccThrottle t;
    int finishSpeedStep;
    protected int stepIncr;
    protected int profileStep;
    protected float profileSpeed;
    protected float profileIncrement;
    protected int profileSpeedStepMode;
    protected float profileSensorDelay;
    protected float profileBlockLength;
    RosterSpeedProfile rosterSpeedProfile;
    protected float profileSpeedAtStart;
    Timer overRunTimer = null;
    private volatile int throttleState = 0;
    PropertyChangeListener startListener = null;
    PropertyChangeListener finishListener = null;
    PropertyChangeListener middleListener = null;
    Sensor startSensor;
    Sensor finishSensor;
    SensorDetails middleBlockSensor;
    boolean isForward = true;
    boolean stepCalculated = false;
    long startTime;
    long finishTime;
    ArrayList<Double> forwardOverRuns = new ArrayList();
    ArrayList<Double> reverseOverRuns = new ArrayList();
    JPanel update;
    TreeMap<Integer, SpeedStep> speeds = new TreeMap();
    private static final Logger log = LoggerFactory.getLogger(SpeedProfilePanel.class);

    public SpeedProfilePanel() {
        JPanel main = new JPanel();
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        main.setLayout(gb);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.anchor = 10;
        JLabel label = new JLabel(Bundle.getMessage("LabelLengthOfBlock"));
        SpeedProfilePanel.addRow(main, gb, c, 0, label, this.lengthField);
        label = new JLabel(Bundle.getMessage("LabelSensorDelay"));
        SpeedProfilePanel.addRow(main, gb, c, 1, label, this.sensorDelay);
        label = new JLabel(Bundle.getMessage("MakeLabel", Bundle.getMessage("LabelStartSensor")));
        SpeedProfilePanel.addRow(main, gb, c, 2, label, this.sensorAPanel);
        label = new JLabel(Bundle.getMessage("MakeLabel", Bundle.getMessage("LabelBlockSensor")));
        SpeedProfilePanel.addRow(main, gb, c, 3, label, this.sensorCPanel);
        label = new JLabel(Bundle.getMessage("MakeLabel", Bundle.getMessage("LabelFinishSensor")));
        SpeedProfilePanel.addRow(main, gb, c, 4, label, this.sensorBPanel);
        label = new JLabel(Bundle.getMessage("LabelSelectRoster"));
        JPanel left = SpeedProfilePanel.makePadPanel(label);
        JPanel right = SpeedProfilePanel.makePadPanel(this.reBox);
        SpeedProfilePanel.addRow(main, gb, c, 5, left, right);
        JPanel panelViews = new JPanel();
        panelViews.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("TitleView")));
        panelViews.setLayout(new BoxLayout(panelViews, 2));
        panelViews.add(this.clearNewDataButton);
        panelViews.add(this.viewNewButton);
        panelViews.add(this.viewMergedButton);
        panelViews.add(this.viewButton);
        left = SpeedProfilePanel.makePadPanel(panelViews);
        JPanel panelProfileControl = new JPanel();
        panelProfileControl.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("ButtonProfile")));
        panelProfileControl.setLayout(new BoxLayout(panelProfileControl, 2));
        panelProfileControl.add(this.profileButton);
        panelProfileControl.add(this.cancelButton);
        right = SpeedProfilePanel.makePadPanel(panelProfileControl);
        SpeedProfilePanel.addRow(main, gb, c, 6, left, right);
        left = new JPanel();
        left.add(Box.createRigidArea(new Dimension(20, 10)));
        left.setLayout(new BoxLayout(left, 3));
        left.add(SpeedProfilePanel.makeLabelPanel("LabelStartStep", this.speedStepFrom));
        this.speedStepFrom.setToolTipText(Bundle.getMessage("StartStepToolTip"));
        left.add(SpeedProfilePanel.makeLabelPanel("LabelFinishStep", this.speedStepTo));
        this.speedStepTo.setToolTipText(Bundle.getMessage("FinishStepToolTip"));
        left.add(SpeedProfilePanel.makeLabelPanel("LabelStepIncr", this.speedStepIncr));
        this.speedStepIncr.setToolTipText(Bundle.getMessage("StepIncrToolTip"));
        right = new JPanel();
        SpeedProfilePanel.addRow(main, gb, c, 7, left, right);
        JPanel testDataPanel = new JPanel();
        testDataPanel.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("TestProfileData")));
        testDataPanel.setLayout(new BoxLayout(testDataPanel, 2));
        testDataPanel.add(SpeedProfilePanel.makeLabelPanel("LabelTestStep", this.speedStepTest));
        this.speedStepTest.setToolTipText(Bundle.getMessage("StepTestToolTip"));
        this.speedStepTestFwd.setEnabled(false);
        testDataPanel.add(SpeedProfilePanel.makeLabelPanel("LabelTestStepFwd", this.speedStepTestFwd));
        this.speedStepTestFwd.setToolTipText(Bundle.getMessage("ForwardTestToolTip"));
        this.speedStepTestRev.setEnabled(false);
        testDataPanel.add(SpeedProfilePanel.makeLabelPanel("LabelTestStepRev", this.speedStepTestRev));
        this.speedStepTestRev.setToolTipText(Bundle.getMessage("ReverseTestToolTip"));
        left = SpeedProfilePanel.makePadPanel(testDataPanel);
        JPanel testProfileControl = new JPanel();
        testProfileControl.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("TitleTestProfile")));
        testProfileControl.setLayout(new BoxLayout(testProfileControl, 2));
        testProfileControl.add(this.testButton);
        testProfileControl.add(this.testCancelButton);
        right = SpeedProfilePanel.makePadPanel(testProfileControl);
        SpeedProfilePanel.addRow(main, gb, c, 8, left, right);
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 9;
        c.gridwidth = 2;
        this.sourceLabel = new JLabel("   ");
        this.sourceLabel.setBackground(Color.white);
        left = SpeedProfilePanel.makePadPanel(this.sourceLabel);
        gb.setConstraints(left, c);
        main.add(left);
        WarrantPreferences preferences = WarrantPreferences.getDefault();
        this.warrentScaleLabel.setText(String.valueOf(Bundle.getMessage("LabelLayoutScale")) + " 1:" + Float.toString(preferences.getLayoutScale()));
        this.warrentScaleLabel.setBackground(Color.white);
        this.warrentScaleLabel.setToolTipText(Bundle.getMessage("LayoutScaleHint"));
        left = SpeedProfilePanel.makePadPanel(this.warrentScaleLabel);
        c.gridy = 11;
        gb.setConstraints(left, c);
        main.add(left);
        c.gridy = 12;
        JPanel southBtnPanel = new JPanel();
        southBtnPanel.add(this.clearNewDataButton);
        southBtnPanel.add(this.updateProfileButton);
        southBtnPanel.add(this.replaceProfileButton);
        southBtnPanel.add(this.deleteProfileButton);
        southBtnPanel.add(this.saveDefaultsButton);
        main.add((Component)southBtnPanel, c);
        this.add((Component)main, "Center");
        this.profileButton.addActionListener(e -> {
            this.profile = true;
            this.setupProfile();
        });
        this.cancelButton.addActionListener(e -> this.cancelButton());
        this.testButton.addActionListener(e -> {
            this.test = true;
            this.testButton();
        });
        this.testCancelButton.addActionListener(e -> this.cancelButton());
        this.viewButton.addActionListener(e -> this.viewRosterProfileData());
        this.viewNewButton.addActionListener(e -> this.viewNewProfileData());
        this.saveDefaultsButton.addActionListener(e -> this.doSaveSettings());
        this.clearNewDataButton.addActionListener(e -> this.clearNewData());
        this.viewMergedButton.addActionListener(e -> this.viewMergedData());
        this.updateProfileButton.addActionListener(e -> this.updateSpeedProfileWithResults());
        this.replaceProfileButton.addActionListener(e -> {
            this.removeSpeedProfile();
            this.updateSpeedProfileWithResults();
        });
        this.deleteProfileButton.addActionListener(e -> this.removeSpeedProfile());
        this.setButtonStates(true);
        this.doLoad();
    }

    static void addRow(JPanel main, GridBagLayout gb, GridBagConstraints c, int row, Component left, Component right) {
        c.gridx = 0;
        c.gridy = row;
        gb.setConstraints(left, c);
        main.add(left);
        c.gridx = 1;
        gb.setConstraints(right, c);
        main.add(right);
    }

    static JPanel makePadPanel(Component comp) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 3));
        panel.add(Box.createRigidArea(new Dimension(20, 20)));
        panel.add(comp);
        return panel;
    }

    static JPanel makeLabelPanel(String text, Component comp) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 2));
        panel.add(new JLabel(Bundle.getMessage("MakeLabel", Bundle.getMessage(text))));
        panel.add(comp);
        return panel;
    }

    void setupProfile() {
        this.finishSpeedStep = 0;
        this.stepIncr = 1;
        this.profileStep = 1;
        this.profileSensorDelay = 0.0f;
        try {
            this.profileBlockLength = Float.parseFloat(this.lengthField.getText());
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, Bundle.getMessage("ErrorLengthInvalid"));
            return;
        }
        String text = this.sensorDelay.getText();
        if (text != null && text.trim().length() > 0) {
            try {
                this.profileSensorDelay = Float.parseFloat(this.sensorDelay.getText());
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(null, Bundle.getMessage("ErrorSensorDelayInvalid"));
                return;
            }
        }
        this.setButtonStates(false);
        if (this.sensorA == null) {
            try {
                this.sensorA = new SensorDetails(this.sensorAPanel.getNamedBean());
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(null, Bundle.getMessage("ErrorSensorNotFound", Bundle.getMessage("LabelStartSensor")));
                this.setButtonStates(true);
                return;
            }
        }
        Sensor tmpSen = null;
        try {
            tmpSen = this.sensorAPanel.getNamedBean();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, Bundle.getMessage("ErrorSensorNotFound", Bundle.getMessage("LabelStartSensor")));
            this.setButtonStates(true);
            return;
        }
        if (tmpSen != this.sensorA.getSensor()) {
            this.sensorA.resetDetails();
            this.sensorA = new SensorDetails(tmpSen);
        }
        if (this.sensorB == null) {
            try {
                this.sensorB = new SensorDetails(this.sensorBPanel.getNamedBean());
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(null, Bundle.getMessage("ErrorSensorNotFound", Bundle.getMessage("LabelFinishSensor")));
                this.setButtonStates(true);
                return;
            }
        }
        tmpSen = null;
        try {
            tmpSen = this.sensorBPanel.getNamedBean();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, Bundle.getMessage("ErrorSensorNotFound", Bundle.getMessage("LabelFinishSensor")));
            this.setButtonStates(true);
            return;
        }
        if (tmpSen != this.sensorB.getSensor()) {
            this.sensorB.resetDetails();
            this.sensorB = new SensorDetails(tmpSen);
        }
        if (this.middleBlockSensor == null) {
            try {
                this.middleBlockSensor = new SensorDetails(this.sensorCPanel.getNamedBean());
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(null, Bundle.getMessage("ErrorSensorNotFound", Bundle.getMessage("LabelBlockSensor")));
                this.setButtonStates(true);
                return;
            }
        }
        tmpSen = null;
        try {
            tmpSen = this.sensorCPanel.getNamedBean();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, Bundle.getMessage("ErrorSensorNotFound", Bundle.getMessage("LabelBlockSensor")));
            this.setButtonStates(true);
            return;
        }
        if (tmpSen != this.middleBlockSensor.getSensor()) {
            this.middleBlockSensor.resetDetails();
            this.middleBlockSensor = new SensorDetails(tmpSen);
        }
        if (this.reBox.getSelectedRosterEntries().length == 0) {
            JOptionPane.showMessageDialog(null, Bundle.getMessage("ErrorNoRosterSelected"));
            log.warn("No Roster Entry selected.");
            this.setButtonStates(true);
            return;
        }
        text = this.speedStepFrom.getText();
        if (text != null && text.trim().length() > 0) {
            try {
                this.profileStep = Integer.parseInt(text);
                if (!this.speedStepNumOK(this.profileStep, "LabelStartStep")) {
                    this.setButtonStates(true);
                    return;
                }
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(null, Bundle.getMessage("ErrorSpeedStep", Bundle.getMessage("LabelStartStep")));
                this.setButtonStates(true);
                return;
            }
        }
        if ((text = this.speedStepTo.getText()) != null && text.trim().length() > 0) {
            try {
                this.finishSpeedStep = Integer.parseInt(text);
                if (!this.speedStepNumOK(this.finishSpeedStep, "LabelFinishStep")) {
                    this.setButtonStates(true);
                    return;
                }
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(null, Bundle.getMessage("ErrorSpeedStep", Bundle.getMessage("LabelFinishStep")));
                this.setButtonStates(true);
                return;
            }
        }
        if ((text = this.speedStepIncr.getText()) != null && text.trim().length() > 0) {
            try {
                this.stepIncr = Integer.parseInt(text);
                if (!this.speedStepNumOK(this.stepIncr, "LabelStepIncr")) {
                    this.setButtonStates(true);
                    return;
                }
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(null, Bundle.getMessage("ErrorSpeedStep", Bundle.getMessage("LabelStepIncr")));
                this.setButtonStates(true);
                return;
            }
        }
        this.throttleState = 0;
        this.re = this.reBox.getSelectedRosterEntries()[0];
        boolean ok = InstanceManager.throttleManagerInstance().requestThrottle(this.re, (ThrottleListener)this, true);
        if (!ok) {
            log.warn("Throttle for locomotive {} could not be set up.", (Object)this.re.getId());
            this.setButtonStates(true);
            return;
        }
        ThreadingUtil.newThread(new Runnable(){

            @Override
            public void run() {
                int count = 0;
                int trys = 10;
                while (SpeedProfilePanel.this.throttleState == 0 && count < trys) {
                    try {
                        Thread.sleep(1000L);
                        log.debug("Wait");
                    }
                    catch (Exception exception) {
                        log.warn("Throttle for locomotive {} could not be set up.", (Object)SpeedProfilePanel.this.re.getId());
                        SpeedProfilePanel.this.setButtonStates(true);
                        return;
                    }
                    ++count;
                }
                log.debug("Run");
                if (SpeedProfilePanel.this.throttleState != 1) {
                    log.warn("No Throttle, Aborting");
                    SpeedProfilePanel.this.setButtonStates(true);
                    return;
                }
                SpeedProfilePanel.this.runProfile();
            }
        }).start();
    }

    boolean speedStepNumOK(int num, String step) {
        if (num < 1 || num > 126) {
            JOptionPane.showMessageDialog(null, Bundle.getMessage("ErrorSpeedStep", Bundle.getMessage(step)));
            this.setButtonStates(true);
            return false;
        }
        return true;
    }

    @Override
    public void notifyThrottleFound(DccThrottle _throttle) {
        this.t = _throttle;
        if (this.t == null) {
            JOptionPane.showMessageDialog(null, Bundle.getMessage("ErrorThrottleNotFound"));
            log.warn("null throttle returned for train {} during automatic initialization.", (Object)this.re.getId());
            this.setButtonStates(true);
            this.throttleState = -1;
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("throttle address = {}", (Object)this.t.getLocoAddress().toString());
        }
        this.throttleState = 1;
    }

    private void runProfile() {
        SpeedStepMode speedStepMode = this.t.getSpeedStepMode();
        this.profileIncrement = this.t.getSpeedIncrement();
        this.profileSpeedStepMode = speedStepMode.numSteps;
        if (this.finishSpeedStep <= 0) {
            this.finishSpeedStep = this.profileSpeedStepMode;
        }
        log.debug("Speed step mode {}", (Object)this.profileSpeedStepMode);
        this.profileSpeedAtStart = this.profileSpeed = this.profileIncrement * (float)this.profileStep;
        if (this.profile) {
            this.startSensor = this.middleBlockSensor.getSensor();
            this.finishSensor = this.sensorB.getSensor();
            this.startListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    if (e.getPropertyName().equals("KnownState")) {
                        if ((Integer)e.getNewValue() == 2) {
                            SpeedProfilePanel.this.startTiming();
                        }
                        if ((Integer)e.getNewValue() == 4) {
                            SpeedProfilePanel.this.stopLoco();
                        }
                    }
                }
            };
            this.finishListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    if (e.getPropertyName().equals("KnownState") && (Integer)e.getNewValue() == 2) {
                        SpeedProfilePanel.this.stopCurrentSpeedStep();
                    }
                }
            };
            this.isForward = true;
            this.startProfile();
        } else {
            this.stepIncr = 1;
            this.finishSpeedStep = this.profileStep = Integer.parseInt(this.speedStepTest.getText());
            this.profileSpeed = this.profileIncrement * (float)this.profileStep;
            this.startSensor = this.middleBlockSensor.getSensor();
            this.finishSensor = this.sensorB.getSensor();
            this.startListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    if (e.getPropertyName().equals("KnownState")) {
                        if ((Integer)e.getNewValue() == 2) {
                            SpeedProfilePanel.this.startTiming();
                        }
                        if ((Integer)e.getNewValue() == 4) {
                            SpeedProfilePanel.this.stopLoco();
                        }
                    }
                }
            };
            this.finishListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    if (e.getPropertyName().equals("KnownState") && (Integer)e.getNewValue() == 2) {
                        SpeedProfilePanel.this.stopCurrentSpeedStep();
                    }
                }
            };
            this.isForward = true;
            this.startProfile();
        }
    }

    void setButtonStates(boolean state) {
        this.cancelButton.setEnabled(!state);
        this.profileButton.setEnabled(state);
        this.testButton.setEnabled(state);
        this.testCancelButton.setEnabled(!state);
        this.viewButton.setEnabled(state);
        this.deleteProfileButton.setEnabled(state);
        if (state && this.speeds.size() > 0) {
            this.viewNewButton.setEnabled(true);
            this.viewMergedButton.setEnabled(true);
            this.replaceProfileButton.setEnabled(true);
            this.updateProfileButton.setEnabled(true);
            this.clearNewDataButton.setEnabled(true);
        } else {
            this.viewNewButton.setEnabled(false);
            this.viewMergedButton.setEnabled(false);
            this.replaceProfileButton.setEnabled(false);
            this.updateProfileButton.setEnabled(false);
            this.clearNewDataButton.setEnabled(false);
        }
        if (state) {
            this.sourceLabel.setText("   ");
            this.profile = false;
            this.test = false;
        }
        if (this.sensorA != null) {
            this.sensorA.resetDetails();
        }
        if (this.sensorB != null) {
            this.sensorB.resetDetails();
        }
        if (this.middleBlockSensor != null) {
            this.middleBlockSensor.resetDetails();
        }
    }

    @Override
    public void notifyFailedThrottleRequest(LocoAddress address, String reason) {
        JOptionPane.showMessageDialog(null, Bundle.getMessage("ErrorFailThrottleRequest"));
        log.error("Throttle request for {} failed because {}", (Object)address, (Object)reason);
        this.setButtonStates(true);
        this.throttleState = -1;
    }

    @Override
    public void notifyDecisionRequired(LocoAddress address, ThrottleListener.DecisionType question) {
        JOptionPane.showMessageDialog(null, Bundle.getMessage("ErrorNoStealing"));
        InstanceManager.throttleManagerInstance().cancelThrottleRequest(address, (ThrottleListener)this);
        this.setButtonStates(true);
        this.throttleState = -1;
    }

    void startProfile() {
        this.stepCalculated = false;
        this.sourceLabel.setText(Bundle.getMessage("StatusLabelNextRun"));
        this.finishSensor = this.isForward ? this.sensorB.getSensor() : this.sensorA.getSensor();
        this.startSensor = this.middleBlockSensor.getSensor();
        this.startSensor.addPropertyChangeListener(this.startListener);
        this.finishSensor.addPropertyChangeListener(this.finishListener);
        this.t.setIsForward(!this.isForward);
        try {
            Thread.sleep(250L);
        }
        catch (InterruptedException interruptedException) {}
        this.t.setIsForward(this.isForward);
        try {
            Thread.sleep(250L);
        }
        catch (InterruptedException interruptedException) {}
        log.debug("Set speed to [{}] isForward [{}] Increment [{}] Step [{}] SpeedStepMode [{}]", new Object[]{Float.valueOf(this.profileSpeed), this.isForward, Float.valueOf(this.profileIncrement), this.profileStep, this.profileSpeedStepMode});
        this.t.setSpeedSetting(this.profileSpeed);
        this.sourceLabel.setText(Bundle.getMessage("StatusLabelBlockToGoActive"));
    }

    void startTiming() {
        this.startTime = System.nanoTime();
        this.sourceLabel.setText(Bundle.getMessage("StatusLabelCurrentRun", this.isForward ? Bundle.getMessage("LabelTestStepFwd") : Bundle.getMessage("LabelTestStepRev"), this.profileStep, this.finishSpeedStep));
    }

    void stopCurrentSpeedStep() {
        this.finishTime = System.nanoTime();
        this.stepCalculated = true;
        this.finishSensor.removePropertyChangeListener(this.finishListener);
        this.sourceLabel.setText(Bundle.getMessage("StatusLabelCalculating"));
        if (this.profileSpeed / 2.0f > this.profileSpeedAtStart) {
            this.t.setSpeedSetting(this.profileSpeed / 2.0f);
        } else {
            this.t.setSpeedSetting(this.profileSpeedAtStart);
        }
        this.calculateSpeed();
        this.sourceLabel.setText(Bundle.getMessage("StatusLabelWaitingToClear"));
    }

    void stopLoco() {
        if (!this.stepCalculated) {
            return;
        }
        this.startSensor.removePropertyChangeListener(this.startListener);
        this.finishSensor.removePropertyChangeListener(this.finishListener);
        boolean bl = this.isForward = !this.isForward;
        if (this.isForward) {
            this.profileSpeed = this.profileIncrement * (float)this.stepIncr + this.profileSpeed;
            this.profileStep += this.stepIncr;
        }
        if (this.profileStep > this.finishSpeedStep) {
            this.t.setSpeedSetting(0.0f);
            if (!this.profile) {
                this.speedStepTestFwd.setText(RosterSpeedProfile.convertMMSToScaleSpeedWithUnits(this.testSpeedFwd));
                this.speedStepTestRev.setText(RosterSpeedProfile.convertMMSToScaleSpeedWithUnits(this.testSpeedRev));
            }
            this.releaseThrottle();
            this.setButtonStates(true);
            return;
        }
        Timer stopTimer = new Timer(2500, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpeedProfilePanel.this.t.setSpeedSetting(0.0f);
                Timer restartTimer = new Timer(1000, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SpeedProfilePanel.this.startProfile();
                    }
                });
                restartTimer.setRepeats(false);
                restartTimer.start();
            }
        });
        stopTimer.setRepeats(false);
        stopTimer.start();
    }

    void calculateSpeed() {
        float duration = (float)(this.finishTime - this.startTime) / 1.0E9f;
        float speed = this.profileBlockLength / (duration -= this.profileSensorDelay / 1000.0f);
        log.debug("Step: {} duration: {} length: {} speed: {}", new Object[]{this.profileStep, Float.valueOf(duration), Float.valueOf(this.profileBlockLength), Float.valueOf(speed)});
        if (this.profile) {
            int iSpeedStep = Math.round(this.profileSpeed * 1000.0f);
            if (!this.speeds.containsKey(iSpeedStep)) {
                this.speeds.put(iSpeedStep, new SpeedStep());
            }
            SpeedStep ss = this.speeds.get(iSpeedStep);
            if (this.isForward) {
                ss.setForwardSpeed(speed);
            } else {
                ss.setReverseSpeed(speed);
            }
            this.save = true;
        } else if (this.isForward) {
            this.testSpeedFwd = speed;
        } else {
            this.testSpeedRev = speed;
        }
    }

    void updateSpeedProfileWithResults() {
        this.cancelButton();
        RosterSpeedProfile rosterSpeedProfile = this.re.getSpeedProfile();
        if (rosterSpeedProfile == null) {
            rosterSpeedProfile = new RosterSpeedProfile(this.re);
            this.re.setSpeedProfile(rosterSpeedProfile);
        }
        for (Map.Entry<Integer, SpeedStep> entry : this.speeds.entrySet()) {
            rosterSpeedProfile.setSpeed(entry.getKey(), entry.getValue().getForwardSpeed(), entry.getValue().getReverseSpeed());
        }
        this.re.updateFile();
        Roster.getDefault().writeRoster();
        this.clearNewData();
        this.setButtonStates(true);
        this.save = false;
    }

    void viewMergedData() {
        RosterEntry tmpRe = new RosterEntry();
        RosterSpeedProfile tmpRsp = new RosterSpeedProfile(tmpRe);
        RosterSpeedProfile rosterSpeedProfile = this.re.getSpeedProfile();
        for (Integer n : rosterSpeedProfile.getProfileSpeeds().keySet()) {
            tmpRsp.setSpeed(n, rosterSpeedProfile.getProfileSpeeds().get(n).getForwardSpeed(), rosterSpeedProfile.getProfileSpeeds().get(n).getReverseSpeed());
        }
        for (Map.Entry entry : this.speeds.entrySet()) {
            tmpRsp.setSpeed((Integer)entry.getKey(), ((SpeedStep)entry.getValue()).getForwardSpeed(), ((SpeedStep)entry.getValue()).getReverseSpeed());
        }
        tmpRe.setSpeedProfile(tmpRsp);
        RosterSpeedProfile rosterSpeedProfile2 = tmpRe.getSpeedProfile();
        if (rosterSpeedProfile2 != null) {
            if (this.table != null) {
                this.table.dispose();
            }
            this.table = new SpeedProfileTable(rosterSpeedProfile2, tmpRe.getId());
            this.table.setVisible(true);
            return;
        }
        JOptionPane.showMessageDialog(null, Bundle.getMessage("ErrorNoSpeedProfile"));
        this.setButtonStates(true);
    }

    void clearNewData() {
        this.speeds.clear();
    }

    void removeSpeedProfile() {
        this.cancelButton();
        RosterSpeedProfile rosterSpeedProfile = this.re.getSpeedProfile();
        if (rosterSpeedProfile != null) {
            rosterSpeedProfile.clearCurrentProfile();
        }
        this.re.updateFile();
        Roster.getDefault().writeRoster();
        this.save = false;
    }

    void viewNewProfileData() {
        RosterEntry tmpRe = new RosterEntry();
        RosterSpeedProfile rosterSpeedProfile = tmpRe.getSpeedProfile();
        if (rosterSpeedProfile == null) {
            rosterSpeedProfile = new RosterSpeedProfile(tmpRe);
            tmpRe.setSpeedProfile(rosterSpeedProfile);
        }
        for (Map.Entry<Integer, SpeedStep> entry : this.speeds.entrySet()) {
            rosterSpeedProfile.setSpeed(entry.getKey(), entry.getValue().getForwardSpeed(), entry.getValue().getReverseSpeed());
        }
        RosterSpeedProfile speedProfile = tmpRe.getSpeedProfile();
        if (speedProfile != null) {
            if (this.table != null) {
                this.table.dispose();
            }
            this.table = new SpeedProfileTable(speedProfile, tmpRe.getId());
            this.table.setVisible(true);
            return;
        }
        JOptionPane.showMessageDialog(null, Bundle.getMessage("ErrorNoSpeedProfile"));
        this.setButtonStates(true);
    }

    void viewRosterProfileData() {
        RosterSpeedProfile speedProfile;
        if (this.reBox.getSelectedRosterEntries().length == 0) {
            JOptionPane.showMessageDialog(null, Bundle.getMessage("ErrorNoRosterSelected"));
            this.setButtonStates(true);
            return;
        }
        this.re = this.reBox.getSelectedRosterEntries()[0];
        if (this.re != null && (speedProfile = this.re.getSpeedProfile()) != null) {
            if (this.table != null) {
                this.table.dispose();
            }
            this.table = new SpeedProfileTable(this.re.getSpeedProfile(), this.re.getId());
            this.table.setVisible(true);
            return;
        }
        JOptionPane.showMessageDialog(null, Bundle.getMessage("ErrorNoSpeedProfile"));
        this.setButtonStates(true);
    }

    private void releaseThrottle() {
        if (this.t != null) {
            log.debug("t not null");
            this.t.setSpeedSetting(0.0f);
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {
                log.warn("Wait interupted, release throttle immediatlely");
            }
            log.debug("releaseing[{}]", (Object)this.t.getLocoAddress().getNumber());
            InstanceManager.throttleManagerInstance().releaseThrottle(this.t, this);
            this.t = null;
        }
    }

    void cancelButton() {
        this.releaseThrottle();
        if (this.t != null) {
            this.t.setSpeedSetting(0.0f);
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {}
            InstanceManager.throttleManagerInstance().releaseThrottle(this.t, this);
            this.t = null;
        }
        if (this.startSensor != null) {
            this.startSensor.removePropertyChangeListener(this.startListener);
        }
        if (this.finishSensor != null) {
            this.finishSensor.removePropertyChangeListener(this.finishListener);
        }
        if (this.middleListener != null) {
            this.middleBlockSensor.getSensor().removePropertyChangeListener(this.middleListener);
        }
        this.setButtonStates(true);
    }

    void testButton() {
        try {
            Integer.parseInt(this.speedStepTest.getText());
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(null, Bundle.getMessage("ErrorSpeedStep", Bundle.getMessage("LabelTestStep")));
            return;
        }
        this.setupProfile();
    }

    void stopTrainTest() {
        int sectionlength = Integer.parseInt(this.lengthField.getText());
        this.re.getSpeedProfile().changeLocoSpeed(this.t, sectionlength, 0.0f);
        this.setButtonStates(true);
        this.startSensor.removePropertyChangeListener(this.startListener);
    }

    private void doSaveSettings() {
        log.debug("Start storing SpeedProfiler settings...");
        Element root = new Element(XML_ROOT, XML_NAMESPACE);
        Element values = new Element("configuration");
        root.addContent((Content)values);
        if (this.lengthField.getText().length() > 0) {
            values.addContent((Content)new Element("length").addContent(this.lengthField.getText()));
        }
        if (this.sensorDelay.getText().length() > 0) {
            values.addContent((Content)new Element("sensordelay").addContent(this.sensorDelay.getText()));
        }
        values = new Element("sensors");
        root.addContent((Content)values);
        Element e = new Element("sensor");
        e.addContent((Content)new Element("sensorname").addContent("sensorAPanel"));
        e.addContent((Content)new Element("sensorvalue").addContent(this.sensorAPanel.getDisplayName()));
        values.addContent((Content)e);
        e = new Element("sensor");
        e.addContent((Content)new Element("sensorname").addContent("sensorBPanel"));
        e.addContent((Content)new Element("sensorvalue").addContent(this.sensorBPanel.getDisplayName()));
        values.addContent((Content)e);
        e = new Element("sensor");
        e.addContent((Content)new Element("sensorname").addContent("sensorCPanel"));
        e.addContent((Content)new Element("sensorvalue").addContent(this.sensorCPanel.getDisplayName()));
        values.addContent((Content)e);
        values = new Element("steps");
        root.addContent((Content)values);
        if (this.speedStepFrom.getText().length() > 0) {
            values.addContent((Content)new Element("speedStepFrom").addContent(this.speedStepFrom.getText()));
        }
        if (this.speedStepTo.getText().length() > 0) {
            values.addContent((Content)new Element("speedStepTo").addContent(this.speedStepTo.getText()));
        }
        if (this.speedStepIncr.getText().length() > 0) {
            values.addContent((Content)new Element("speedStepIncr").addContent(this.speedStepIncr.getText()));
        }
        try {
            ProfileUtils.getAuxiliaryConfiguration(ProfileManager.getDefault().getActiveProfile()).putConfigurationFragment(JDOMUtil.toW3CElement(root), true);
        }
        catch (JDOMException ex) {
            log.error("Unable to create create XML", (Throwable)ex);
        }
        log.debug("...done");
    }

    private void doLoad() {
        block47: {
            Element e;
            List l;
            Element root;
            block45: {
                block43: {
                    log.debug("Check if there's anything to load");
                    try {
                        root = JDOMUtil.toJDOMElement(ProfileUtils.getAuxiliaryConfiguration(ProfileManager.getDefault().getActiveProfile()).getConfigurationFragment(XML_ROOT, XML_NAMESPACE, true));
                    }
                    catch (NullPointerException nullPointerException) {
                        log.debug("Nothing to load");
                        return;
                    }
                    log.debug("Start loading SpeedProfiler settings...");
                    if (root.getChild("configuration") == null) break block43;
                    l = root.getChild("configuration").getChildren();
                    if (log.isDebugEnabled()) {
                        log.debug("readFile sees {} configurations", (Object)l.size());
                    }
                    int i = 0;
                    while (i < l.size()) {
                        e = (Element)l.get(i);
                        switch (e.getName()) {
                            case "length": {
                                this.lengthField.setText(e.getValue());
                                break;
                            }
                            case "sensordelay": {
                                this.sensorDelay.setText(e.getValue());
                                break;
                            }
                            default: {
                                log.warn("Invalid field in PanelProSpeedProfiler.xml");
                            }
                        }
                        ++i;
                    }
                }
                if (root.getChild("sensors") == null) break block45;
                l = root.getChild("sensors").getChildren("sensor");
                if (log.isDebugEnabled()) {
                    log.debug("readFile sees {} sensors", (Object)l.size());
                }
                SensorManager manager = InstanceManager.getDefault(SensorManager.class);
                int i = 0;
                while (i < l.size()) {
                    String sensorType;
                    Element e2 = (Element)l.get(i);
                    switch (sensorType = e2.getChild("sensorname").getText()) {
                        case "sensorAPanel": {
                            this.sensorAPanel.setDefaultNamedBean(manager.getByUserName(e2.getChild("sensorvalue").getText()));
                            break;
                        }
                        case "sensorBPanel": {
                            this.sensorBPanel.setDefaultNamedBean(manager.getByUserName(e2.getChild("sensorvalue").getText()));
                            break;
                        }
                        case "sensorCPanel": {
                            this.sensorCPanel.setDefaultNamedBean(manager.getByUserName(e2.getChild("sensorvalue").getText()));
                            break;
                        }
                        default: {
                            log.warn("Invalid Sensor found in DecoderProSpeedProfile.xml");
                        }
                    }
                    ++i;
                }
            }
            if (root.getChild("steps") == null) break block47;
            l = root.getChild("steps").getChildren();
            int i = 0;
            while (i < l.size()) {
                e = (Element)l.get(i);
                switch (e.getName()) {
                    case "speedStepFrom": {
                        this.speedStepFrom.setText(e.getValue());
                        break;
                    }
                    case "speedStepTo": {
                        this.speedStepTo.setText(e.getValue());
                        break;
                    }
                    case "speedStepIncr": {
                        this.speedStepIncr.setText(e.getValue());
                        break;
                    }
                    default: {
                        log.warn("Invalid field in steps of PanelProSpeedProfiler.xml");
                    }
                }
                ++i;
            }
        }
        log.debug("...done");
    }

    static class SensorDetails {
        Sensor sensor = null;
        long inactiveDelay = 0L;
        long activeDelay = 0L;
        boolean usingGlobal = false;

        SensorDetails(Sensor sen) {
            this.sensor = sen;
            this.usingGlobal = sen.getUseDefaultTimerSettings();
            this.activeDelay = sen.getSensorDebounceGoingActiveTimer();
            this.inactiveDelay = sen.getSensorDebounceGoingInActiveTimer();
        }

        void setupSensor() {
            this.sensor.setUseDefaultTimerSettings(false);
            this.sensor.setSensorDebounceGoingActiveTimer(0L);
            this.sensor.setSensorDebounceGoingInActiveTimer(0L);
        }

        void resetDetails() {
            this.sensor.setUseDefaultTimerSettings(this.usingGlobal);
            this.sensor.setSensorDebounceGoingActiveTimer(this.activeDelay);
            this.sensor.setSensorDebounceGoingInActiveTimer(this.inactiveDelay);
        }

        Sensor getSensor() {
            return this.sensor;
        }
    }

    static class SpeedStep {
        float forward = 0.0f;
        float reverse = 0.0f;

        SpeedStep() {
        }

        void setForwardSpeed(float speed) {
            this.forward = speed;
        }

        void setReverseSpeed(float speed) {
            this.reverse = speed;
        }

        float getForwardSpeed() {
            return this.forward;
        }

        float getReverseSpeed() {
            return this.reverse;
        }
    }
}

