/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.roster.swing;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.EventObject;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.RowSorterEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;
import jmri.InstanceManager;
import jmri.jmrit.roster.Roster;
import jmri.jmrit.roster.RosterEntry;
import jmri.jmrit.roster.RosterEntrySelector;
import jmri.jmrit.roster.rostergroup.RosterGroupSelector;
import jmri.jmrit.roster.swing.RosterTableModel;
import jmri.util.AlphanumComparator;
import jmri.util.gui.GuiLafPreferencesManager;
import jmri.util.swing.JmriPanel;
import jmri.util.swing.XTableColumnModel;

public class RosterTable
extends JmriPanel
implements RosterEntrySelector,
RosterGroupSelector {
    RosterTableModel dataModel;
    TableRowSorter<RosterTableModel> sorter;
    JTable dataTable;
    JScrollPane dataScroll;
    XTableColumnModel columnModel = new XTableColumnModel();
    private RosterGroupSelector rosterGroupSource = null;
    protected transient ListSelectionListener tableSelectionListener;
    private RosterEntry[] selectedRosterEntries = null;
    private RosterEntry[] sortedRosterEntries = null;
    private RosterEntry re = null;

    public RosterTable() {
        this(false);
    }

    public RosterTable(boolean editable) {
        this(editable, 0);
    }

    public RosterTable(boolean editable, int selectionMode) {
        this.dataModel = new RosterTableModel(editable);
        this.sorter = new TableRowSorter<RosterTableModel>(this.dataModel);
        this.sorter.addRowSorterListener(rowSorterEvent -> {
            if (rowSorterEvent.getType() == RowSorterEvent.Type.SORTED) {
                this.sortedRosterEntries = null;
            }
        });
        this.dataTable = new JTable(this.dataModel);
        this.dataTable.setRowSorter(this.sorter);
        this.dataScroll = new JScrollPane(this.dataTable);
        this.dataTable.setRowHeight(InstanceManager.getDefault(GuiLafPreferencesManager.class).getFontSize() + 4);
        this.sorter.setComparator(0, new AlphanumComparator());
        ArrayList<RowSorter.SortKey> sortKeys = new ArrayList<RowSorter.SortKey>();
        sortKeys.add(new RowSorter.SortKey(1, SortOrder.ASCENDING));
        this.sorter.setSortKeys(sortKeys);
        this.dataTable.getTableHeader().setReorderingAllowed(true);
        this.dataTable.setAutoResizeMode(0);
        this.dataTable.setColumnModel(this.columnModel);
        this.dataModel.setColumnModel(this.columnModel);
        this.dataTable.createDefaultColumnsFromModel();
        this.dataTable.setAutoCreateColumnsFromModel(false);
        this.columnModel.getColumnByModelIndex(9).setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            protected void setValue(Object value) {
                if (value != null && value instanceof Date) {
                    super.setValue(DateFormat.getDateTimeInstance().format((Date)value));
                } else {
                    super.setValue(value);
                }
            }
        });
        TableColumn tc = this.columnModel.getColumnByModelIndex(10);
        this.columnModel.setColumnVisible(tc, false);
        for (String s : Roster.getDefault().getAllAttributeKeys()) {
            if (s.contains("RosterGroup") || s.toLowerCase().startsWith("sys") || s.toUpperCase().startsWith("VSD")) continue;
            String[] r = s.split("(?=\\p{Lu})");
            StringBuilder sb = new StringBuilder();
            sb.append(r[0].trim());
            int j = 1;
            while (j < r.length) {
                sb.append(" ");
                sb.append(r[j].trim());
                ++j;
            }
            TableColumn c = new TableColumn(this.dataModel.getColumnCount());
            c.setHeaderValue(sb.toString().trim());
            this.dataTable.addColumn(c);
            this.dataModel.addColumn(c.getHeaderValue());
            this.columnModel.setColumnVisible(c, false);
        }
        this.resetColumnWidths();
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.dataScroll);
        Dimension dataTableSize = this.dataTable.getPreferredSize();
        dataTableSize.height = Math.max(dataTableSize.height, 400);
        dataTableSize.width = Math.max(dataTableSize.width, 400);
        this.dataScroll.getViewport().setPreferredSize(dataTableSize);
        this.dataTable.setSelectionMode(selectionMode);
        TableHeaderListener mouseHeaderListener = new TableHeaderListener();
        this.dataTable.getTableHeader().addMouseListener(mouseHeaderListener);
        this.dataTable.setDefaultEditor(Object.class, new RosterCellEditor());
        this.tableSelectionListener = e -> {
            if (!e.getValueIsAdjusting()) {
                this.selectedRosterEntries = null;
                if (this.dataTable.getSelectedRowCount() == 1) {
                    this.re = Roster.getDefault().getEntryForId(this.dataModel.getValueAt(this.sorter.convertRowIndexToModel(this.dataTable.getSelectedRow()), 0).toString());
                } else if (this.dataTable.getSelectedRowCount() > 1) {
                    this.re = null;
                }
            } else if (e.getFirstIndex() == -1) {
                this.moveTableViewToSelected();
            }
        };
        this.dataTable.getSelectionModel().addListSelectionListener(this.tableSelectionListener);
    }

    public JTable getTable() {
        return this.dataTable;
    }

    public RosterTableModel getModel() {
        return this.dataModel;
    }

    public final void resetColumnWidths() {
        Enumeration<TableColumn> en = this.columnModel.getColumns(false);
        while (en.hasMoreElements()) {
            TableColumn tc = en.nextElement();
            int width = this.dataModel.getPreferredWidth(tc.getModelIndex());
            tc.setPreferredWidth(width);
        }
        this.dataTable.sizeColumnsToFit(-1);
    }

    @Override
    public void dispose() {
        this.setRosterGroupSource(null);
        if (this.dataModel != null) {
            this.dataModel.dispose();
        }
        this.dataModel = null;
        this.dataTable = null;
        super.dispose();
    }

    public void setRosterGroup(String rosterGroup) {
        this.dataModel.setRosterGroup(rosterGroup);
    }

    public String getRosterGroup() {
        return this.dataModel.getRosterGroup();
    }

    public RosterGroupSelector getRosterGroupSource() {
        return this.rosterGroupSource;
    }

    public void setRosterGroupSource(RosterGroupSelector rosterGroupSource) {
        if (this.rosterGroupSource != null) {
            this.rosterGroupSource.removePropertyChangeListener("selectedRosterGroup", this.dataModel);
        }
        this.rosterGroupSource = rosterGroupSource;
        if (this.rosterGroupSource != null) {
            this.rosterGroupSource.addPropertyChangeListener("selectedRosterGroup", this.dataModel);
        }
    }

    protected void showTableHeaderPopup(MouseEvent e) {
        JPopupMenu popupMenu = new JPopupMenu();
        int i = 0;
        while (i < this.columnModel.getColumnCount(false)) {
            TableColumn tc = this.columnModel.getColumnByModelIndex(i);
            JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(this.dataTable.getModel().getColumnName(i), this.columnModel.isColumnVisible(tc));
            menuItem.addActionListener(new HeaderActionListener(tc));
            popupMenu.add(menuItem);
            ++i;
        }
        popupMenu.show(e.getComponent(), e.getX(), e.getY());
    }

    protected void moveTableViewToSelected() {
        if (this.re == null) {
            return;
        }
        this.dataTable.getSelectionModel().removeListSelectionListener(this.tableSelectionListener);
        this.dataTable.clearSelection();
        int entires = this.dataTable.getRowCount();
        int i = 0;
        while (i < entires) {
            if (this.dataModel.getValueAt(this.sorter.convertRowIndexToModel(i), 0).equals(this.re.getId())) {
                this.dataTable.addRowSelectionInterval(i, i);
                this.dataTable.scrollRectToVisible(new Rectangle(this.dataTable.getCellRect(i, 0, true)));
            }
            ++i;
        }
        this.dataTable.getSelectionModel().addListSelectionListener(this.tableSelectionListener);
    }

    @Override
    public String getSelectedRosterGroup() {
        return this.dataModel.getRosterGroup();
    }

    @Override
    public RosterEntry[] getSelectedRosterEntries() {
        if (this.selectedRosterEntries == null) {
            int[] rows = this.dataTable.getSelectedRows();
            this.selectedRosterEntries = new RosterEntry[rows.length];
            int idx = 0;
            while (idx < rows.length) {
                this.selectedRosterEntries[idx] = Roster.getDefault().getEntryForId(this.dataModel.getValueAt(this.sorter.convertRowIndexToModel(rows[idx]), 0).toString());
                ++idx;
            }
        }
        return Arrays.copyOf(this.selectedRosterEntries, this.selectedRosterEntries.length);
    }

    public RosterEntry[] getSortedRosterEntries() {
        if (this.sortedRosterEntries == null) {
            this.sortedRosterEntries = new RosterEntry[this.sorter.getModelRowCount()];
            int idx = 0;
            while (idx < this.sorter.getModelRowCount()) {
                this.sortedRosterEntries[idx] = Roster.getDefault().getEntryForId(this.dataModel.getValueAt(this.sorter.convertRowIndexToModel(idx), 0).toString());
                ++idx;
            }
        }
        return Arrays.copyOf(this.sortedRosterEntries, this.sortedRosterEntries.length);
    }

    public void setEditable(boolean editable) {
        this.dataModel.editable = editable;
    }

    public boolean getEditable() {
        return this.dataModel.editable;
    }

    public void setSelectionMode(int selectionMode) {
        this.dataTable.setSelectionMode(selectionMode);
    }

    public int getSelectionMode() {
        return this.dataTable.getSelectionModel().getSelectionMode();
    }

    public void setSelection(RosterEntry ... selection) {
        this.dataTable.getSelectionModel().removeListSelectionListener(this.tableSelectionListener);
        this.dataTable.clearSelection();
        if (selection != null) {
            RosterEntry[] rosterEntryArray = selection;
            int n = selection.length;
            int n2 = 0;
            while (n2 < n) {
                RosterEntry entry;
                this.re = entry = rosterEntryArray[n2];
                int entries = this.dataTable.getRowCount();
                int i = 0;
                while (i < entries) {
                    if (this.dataModel.getValueAt(this.sorter.convertRowIndexToModel(i), 0).equals(this.re.getId())) {
                        this.dataTable.addRowSelectionInterval(i, i);
                    }
                    ++i;
                }
                ++n2;
            }
            if (selection.length > 1) {
                this.re = null;
            } else {
                this.moveTableViewToSelected();
            }
        } else {
            this.re = null;
        }
        this.dataTable.getSelectionModel().addListSelectionListener(this.tableSelectionListener);
    }

    class HeaderActionListener
    implements ActionListener {
        TableColumn tc;

        HeaderActionListener(TableColumn tc) {
            this.tc = tc;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JCheckBoxMenuItem check = (JCheckBoxMenuItem)e.getSource();
            if (!check.isSelected() && RosterTable.this.columnModel.getColumnCount(true) == 1) {
                return;
            }
            RosterTable.this.columnModel.setColumnVisible(this.tc, check.isSelected());
        }
    }

    public class RosterCellEditor
    extends DefaultCellEditor {
        public RosterCellEditor() {
            super(new JTextField(){

                @Override
                public void setBorder(Border border) {
                }
            });
        }

        @Override
        public boolean isCellEditable(EventObject e) {
            MouseEvent me;
            if (RosterTable.this.re == null) {
                return false;
            }
            if (e instanceof MouseEvent && (me = (MouseEvent)e).getClickCount() != 1) {
                return false;
            }
            return RosterTable.this.re.getId().equals(RosterTable.this.dataModel.getValueAt(RosterTable.this.sorter.convertRowIndexToModel(RosterTable.this.dataTable.getSelectedRow()), 0));
        }
    }

    class TableHeaderListener
    extends MouseAdapter {
        TableHeaderListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                RosterTable.this.showTableHeaderPopup(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                RosterTable.this.showTableHeaderPopup(e);
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.isPopupTrigger()) {
                RosterTable.this.showTableHeaderPopup(e);
            }
        }
    }
}

