/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.roster.swing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import javax.swing.JComboBox;
import jmri.jmrit.roster.Roster;
import jmri.jmrit.roster.rostergroup.RosterGroupSelector;
import jmri.jmrit.roster.swing.Bundle;

public class RosterGroupComboBox
extends JComboBox<String>
implements RosterGroupSelector {
    private Roster _roster;
    private boolean allEntriesEnabled = true;

    public RosterGroupComboBox(Roster roster) {
        this(roster, roster.getDefaultRosterGroup());
    }

    public RosterGroupComboBox(String selection) {
        this(Roster.getDefault(), selection);
    }

    public RosterGroupComboBox(Roster roster, String selection) {
        this._roster = roster;
        this.update(selection);
        roster.addPropertyChangeListener(pce -> {
            if (pce.getPropertyName().equals("RosterGroupAdded")) {
                this.update();
            } else if (pce.getPropertyName().equals("RosterGroupRemoved") || pce.getPropertyName().equals("RosterGroupRenamed")) {
                if (this.getSelectedItem().equals(pce.getOldValue())) {
                    this.update((String)pce.getNewValue());
                } else {
                    this.update();
                }
            }
        });
    }

    public RosterGroupComboBox() {
        this(Roster.getDefault(), Roster.getDefault().getDefaultRosterGroup());
    }

    public final void update() {
        this.update(this.getSelectedItem());
    }

    public final void update(String selection) {
        this.removeAllItems();
        ArrayList<String> l = this._roster.getRosterGroupList();
        Collections.sort(l);
        l.forEach(g -> this.addItem(g));
        if (this.allEntriesEnabled) {
            this.insertItemAt(Roster.allEntries(Locale.getDefault()), 0);
            if (selection == null) {
                selection = Roster.ALLENTRIES;
            }
            this.setToolTipText(null);
        } else if (this.getItemCount() == 0) {
            this.addItem(Bundle.getMessage("RosterGroupComboBoxNoGroups"));
            this.setToolTipText(Bundle.getMessage("RosterGroupComboBoxNoGroupsToolTip"));
        } else {
            this.setToolTipText(null);
        }
        this.setSelectedItem(selection);
        if (this.getItemCount() == 1) {
            this.setSelectedIndex(0);
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
        }
    }

    @Override
    public String getSelectedRosterGroup() {
        if (this.getSelectedItem() == null) {
            return null;
        }
        if (this.getSelectedItem().equals(Roster.ALLENTRIES) || this.getSelectedItem().equals(Roster.allEntries(Locale.getDefault()))) {
            return null;
        }
        return this.getSelectedItem();
    }

    public boolean isAllEntriesEnabled() {
        return this.allEntriesEnabled;
    }

    public void setAllEntriesEnabled(boolean allEntriesEnabled) {
        this.allEntriesEnabled = allEntriesEnabled;
        this.update();
    }

    @Override
    public String getSelectedItem() {
        Object item = super.getSelectedItem();
        return item != null ? item.toString() : null;
    }
}

