/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.roster.swing;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import jmri.jmrit.roster.Roster;
import jmri.jmrit.roster.RosterEntry;
import jmri.jmrit.roster.swing.Bundle;
import jmri.jmrit.roster.swing.RosterGroupComboBox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RosterEntryToGroupAction
extends AbstractAction {
    Component _who;
    JComboBox<String> rosterEntry = new JComboBox();
    RosterGroupComboBox selections;
    Roster roster;
    String lastGroupSelect = null;
    private static final Logger log = LoggerFactory.getLogger(RosterEntryToGroupAction.class);

    public RosterEntryToGroupAction(String s, Component who) {
        super(s);
        this._who = who;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        this.roster = Roster.getDefault();
        this.selections = new RosterGroupComboBox();
        this.selections.setAllEntriesEnabled(false);
        if (this.lastGroupSelect != null) {
            this.selections.setSelectedItem(this.lastGroupSelect);
        }
        this.rosterEntryUpdate();
        this.selections.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RosterEntryToGroupAction.this.rosterEntryUpdate();
            }
        });
        int retval = JOptionPane.showOptionDialog(this._who, Bundle.getMessage("AddEntryToGroupDialog"), Bundle.getMessage("AddEntryToGroupTitle"), 0, 1, null, new Object[]{Bundle.getMessage("ButtonDone"), Bundle.getMessage("ButtonOK"), this.selections, this.rosterEntry}, null);
        log.debug("Dialog value {} selected {}:{}, {}:{}", new Object[]{retval, this.selections.getSelectedIndex(), this.selections.getSelectedItem(), this.rosterEntry.getSelectedIndex(), this.rosterEntry.getSelectedItem()});
        if (retval != 1) {
            return;
        }
        String selEntry = (String)this.rosterEntry.getSelectedItem();
        this.lastGroupSelect = this.selections.getSelectedItem();
        RosterEntry re = this.roster.entryFromTitle(selEntry);
        String selGroup = Roster.getRosterGroupProperty(this.selections.getSelectedItem());
        re.putAttribute(selGroup, "yes");
        Roster.getDefault().writeRoster();
        re.updateFile();
        this.actionPerformed(event);
    }

    void rosterEntryUpdate() {
        if (this.rosterEntry != null) {
            this.rosterEntry.removeAllItems();
        }
        String group = "RosterGroup:" + this.selections.getSelectedItem();
        this.roster.getAllEntries().stream().filter(r -> r.getAttribute(group) == null).forEachOrdered(r -> this.rosterEntry.addItem(r.titleString()));
    }
}

