/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.roster.swing;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JPanel;
import jmri.jmrit.roster.RosterEntry;
import jmri.jmrit.roster.RosterEntrySelector;
import jmri.jmrit.roster.rostergroup.RosterGroupSelector;
import jmri.jmrit.roster.swing.RosterEntryComboBox;
import jmri.jmrit.roster.swing.RosterGroupComboBox;

public class RosterEntrySelectorPanel
extends JPanel
implements RosterEntrySelector,
RosterGroupSelector {
    private RosterEntryComboBox entryCombo;
    private RosterGroupComboBox groupCombo;

    public RosterEntrySelectorPanel() {
        this(null, null);
    }

    public RosterEntrySelectorPanel(RosterEntry re, String rg) {
        this.setLayout(new FlowLayout());
        this.entryCombo = new RosterEntryComboBox(rg);
        if (re != null) {
            this.entryCombo.setSelectedItem(re.titleString());
        }
        this.groupCombo = new RosterGroupComboBox(rg);
        this.add(this.groupCombo);
        this.add(this.entryCombo);
        this.groupCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                RosterEntrySelectorPanel.this.entryCombo.update(RosterEntrySelectorPanel.this.getSelectedRosterGroup());
            }
        });
        this.entryCombo.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent pce) {
                if (pce.getPropertyName().equals("selectedRosterEntries")) {
                    RosterEntrySelectorPanel.this.fireSelectedRosterEntriesPropertyChange(pce.getOldValue(), pce.getNewValue());
                }
            }
        });
    }

    protected void fireSelectedRosterEntriesPropertyChange(Object oldValue, Object newValue) {
        this.firePropertyChange("selectedRosterEntries", oldValue, newValue);
    }

    @Override
    public RosterEntry[] getSelectedRosterEntries() {
        return this.entryCombo.getSelectedRosterEntries();
    }

    public void setSelectedRosterEntry(RosterEntry re) {
        this.entryCombo.setSelectedItem(re != null ? re.getId() : null);
    }

    public void setSelectedRosterEntryAndGroup(RosterEntry re, String rg) {
        this.setSelectedRosterEntry(re);
        this.setSelectedRosterGroup(rg);
    }

    @Override
    public String getSelectedRosterGroup() {
        return this.groupCombo.getSelectedRosterGroup();
    }

    public void setSelectedRosterGroup(String rg) {
        this.groupCombo.update(rg);
    }

    public RosterEntryComboBox getRosterEntryComboBox() {
        return this.entryCombo;
    }

    public RosterGroupComboBox getRosterGroupComboBox() {
        return this.groupCombo;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.entryCombo.setEnabled(enabled);
        this.groupCombo.setEnabled(enabled);
    }

    @Override
    public boolean isEnabled() {
        return this.entryCombo.isEnabled();
    }

    public String getNonSelectedItem() {
        return this.entryCombo.getNonSelectedItem();
    }

    public void setNonSelectedItem(String itemText) {
        this.entryCombo.setNonSelectedItem(itemText);
    }
}

