/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.roster;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.MissingResourceException;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.tree.TreeNode;
import jmri.InstanceManager;
import jmri.jmrit.decoderdefn.DecoderFile;
import jmri.jmrit.decoderdefn.DecoderIndexFile;
import jmri.jmrit.progsupport.ProgModeSelector;
import jmri.jmrit.progsupport.ProgServiceModeComboBox;
import jmri.jmrit.roster.Bundle;
import jmri.jmrit.roster.Roster;
import jmri.jmrit.roster.RosterEntry;
import jmri.jmrit.symbolicprog.CombinedLocoSelTreePane;
import jmri.jmrit.symbolicprog.CvTableModel;
import jmri.jmrit.symbolicprog.CvValue;
import jmri.jmrit.symbolicprog.SymbolicProgBundle;
import jmri.util.swing.JmriAbstractAction;
import jmri.util.swing.JmriPanel;
import jmri.util.swing.WindowInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateDecoderDefinitionAction
extends JmriAbstractAction {
    public static final String QRY_PREFIX = "query:";
    public static final String QRY_SEPARATOR = "\\|";
    String replacementFamily;
    String replacementFamilyString;
    boolean hasReplacementFamilyQuery;
    String replacementModel;
    String replacementModelString;
    boolean hasReplacementModelQuery;
    int cV7Value;
    int cV8Value;
    JLabel lastActionDisplay;
    volatile transient RosterEntry tempRe;
    volatile transient List<DecoderFile> replacementList;
    volatile transient List<DecoderFile> versionMatchList;
    volatile transient DecoderIndexFile di;
    volatile transient FocusListener fListener;
    volatile transient JLabel statusLabel;
    volatile transient JDialog f;
    final ProgModeSelector modePane = new ProgServiceModeComboBox();
    JButton cancelButton;
    JToggleButton versionButton;
    JToggleButton replacementButton;
    CombinedLocoSelTreePane combinedLocoSelTree;
    private static final Logger log = LoggerFactory.getLogger(UpdateDecoderDefinitionAction.class);

    public UpdateDecoderDefinitionAction(String name) {
        super(name);
    }

    public UpdateDecoderDefinitionAction(String name, WindowInterface wi) {
        super(name, wi);
    }

    public UpdateDecoderDefinitionAction(String name, Icon i, WindowInterface wi) {
        super(name, i, wi);
    }

    @Override
    public synchronized void actionPerformed(ActionEvent e) {
        List<RosterEntry> list = Roster.getDefault().matchingList(null, null, null, null, null, null, null);
        boolean skipQueries = false;
        this.di = InstanceManager.getDefault(DecoderIndexFile.class);
        for (RosterEntry entry : list) {
            boolean missing;
            String model;
            String family = entry.getDecoderFamily();
            List<DecoderFile> decoders = this.di.matchingDecoderList(null, family, null, null, null, model = entry.getDecoderModel());
            boolean bl = missing = decoders.size() < 1;
            if (decoders.size() != 1 && !model.equals(family)) {
                log.error("Found {} decoders matching family \"{}\" model \"{}\" from roster entry \"{}\"", new Object[]{decoders.size(), family, model, entry.getId()});
                if (!missing) continue;
                this.replacementModelString = this.replacementModel = model;
                this.replacementFamily = null;
                this.replacementFamilyString = "";
            }
            for (DecoderFile decoder : decoders) {
                if (decoder.getReplacementFamily() != null || decoder.getReplacementModel() != null) {
                    log.debug("Indicated replacements are family \"{}\" model \"{}\"", (Object)decoder.getReplacementFamily(), (Object)decoder.getReplacementModel());
                }
                this.replacementFamily = decoder.getReplacementFamily();
                this.replacementModel = decoder.getReplacementModel();
                this.hasReplacementFamilyQuery = false;
                this.hasReplacementModelQuery = false;
                this.replacementFamilyString = this.replacementFamily;
                this.replacementModelString = this.replacementModel;
                if (this.replacementFamily != null && this.replacementFamily.startsWith(QRY_PREFIX)) {
                    this.hasReplacementFamilyQuery = true;
                    this.replacementFamilyString = this.replacementFamily.substring(QRY_PREFIX.length());
                } else if (this.replacementFamily == null) {
                    this.replacementFamilyString = family;
                }
                if (this.replacementModel != null && this.replacementModel.startsWith(QRY_PREFIX)) {
                    this.hasReplacementModelQuery = true;
                    this.replacementModelString = this.replacementModel.substring(QRY_PREFIX.length());
                } else if (this.replacementModel == null) {
                    this.replacementModelString = model;
                }
                log.trace("String replacements are family \"{}\", query={} and model \"{}\", query={}", new Object[]{this.replacementFamilyString, this.hasReplacementFamilyQuery, this.replacementModelString, this.hasReplacementModelQuery});
            }
            if (this.replacementModel == null && this.replacementFamily == null) continue;
            boolean isToUpdate = true;
            if (this.replacementModel != null && this.replacementModel.startsWith(QRY_PREFIX) || this.replacementFamily != null && this.replacementFamily.startsWith(QRY_PREFIX) || missing) {
                int retVal = 2;
                if (!skipQueries) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(Bundle.getMessage("TextMultRepl1", entry.getId(), family, model)).append("\n\n").append(Bundle.getMessage(missing ? "TextNoDefn1a" : "TextMultRepl1a")).append("\n");
                    if (this.replacementFamily != null && !this.replacementFamily.equals(family) && !this.replacementFamily.equals(QRY_PREFIX)) {
                        if (this.replacementFamily.startsWith(QRY_PREFIX)) {
                            sb.append(Bundle.getMessage("TextMultReplFamilyOneOf")).append(": \"");
                            sb.append(this.replacementFamily.substring(QRY_PREFIX.length()).replaceAll(QRY_SEPARATOR, "\",\""));
                            sb.append("\"\n");
                        } else {
                            sb.append(Bundle.getMessage("TextMultReplFamily"));
                            sb.append(": \"").append(this.replacementFamily).append("\"\n");
                        }
                    }
                    if (this.replacementModel != null && !this.replacementModel.equals(model) && !this.replacementModel.equals(QRY_PREFIX)) {
                        if (this.replacementModel.startsWith(QRY_PREFIX)) {
                            sb.append(Bundle.getMessage("TextMultReplModelOneOf")).append(": \"");
                            sb.append(this.replacementModel.substring(QRY_PREFIX.length()).replaceAll(QRY_SEPARATOR, "\",\""));
                            sb.append("\"\n");
                        } else {
                            sb.append(Bundle.getMessage("TextMultReplModel"));
                            sb.append(": \"").append(this.replacementModel).append("\"\n");
                        }
                    }
                    sb.append("\n").append(Bundle.getMessage("TextMultRepl2", Bundle.getMessage("ButtonMultReplSelectNew")));
                    sb.append("\n");
                    retVal = this.multiReplacementDialog(sb.toString(), missing);
                }
                log.trace("return value = {}", (Object)retVal);
                if (retVal == 2) {
                    skipQueries = true;
                    log.trace("Skip All");
                }
                if (retVal != 0) {
                    log.trace("Skip This");
                    isToUpdate = false;
                }
                log.trace("Is to Update = {}", (Object)isToUpdate);
                if (isToUpdate) {
                    this.decoderSelectionPane(entry);
                    if (this.tempRe == null) {
                        log.trace("dummy Roster Entry is null");
                        isToUpdate = false;
                    } else {
                        log.trace("dummy Roster Entry returned Family '{}', model '{}'", (Object)this.tempRe.getDecoderFamily(), (Object)this.tempRe.getDecoderModel());
                        this.replacementFamily = !this.tempRe.getDecoderFamily().equals(family) ? this.tempRe.getDecoderFamily() : null;
                        this.replacementModel = !this.tempRe.getDecoderModel().equals(model) ? this.tempRe.getDecoderModel() : null;
                    }
                }
            }
            if (!isToUpdate) continue;
            if (this.replacementFamily != null) {
                log.info("   *** Will update \"{}'\". replacementFamily='{}'", (Object)entry.getId(), (Object)this.replacementFamily);
                entry.setDecoderFamily(this.replacementFamily);
            }
            if (this.replacementModel != null) {
                log.info("   *** Will update \"{}'\". replacementModel='{}'", (Object)entry.getId(), (Object)this.replacementModel);
                entry.setDecoderModel(this.replacementModel);
            }
            entry.updateFile();
        }
        Roster.getDefault().makeBackupFile(Roster.getDefault().getRosterIndexPath());
        try {
            Roster.getDefault().writeFile(Roster.getDefault().getRosterIndexPath());
        }
        catch (IOException ex) {
            log.error("Exception while writing the new roster file, may not be complete: {}", (Throwable)ex);
        }
        Roster.getDefault().reloadRosterFile();
    }

    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST_OF_RETURN_VALUE"}, justification="Code calls method in such a way that the cast is guaranteed to be safe")
    synchronized JOptionPane getOptionPane(JComponent source) {
        JOptionPane pane = !(source instanceof JOptionPane) ? this.getOptionPane((JComponent)source.getParent()) : (JOptionPane)source;
        return pane;
    }

    synchronized int multiReplacementDialog(String text, boolean missing) {
        JButton select = new JButton(Bundle.getMessage("ButtonMultReplSelectNew"));
        select.setToolTipText(Bundle.getMessage("ToolTipMultReplSelectNew"));
        select.addActionListener(e -> {
            JOptionPane pane = this.getOptionPane((JComponent)e.getSource());
            pane.setValue(select);
        });
        JButton skipThis = new JButton(Bundle.getMessage("ButtonMultReplSkipThis"));
        skipThis.setToolTipText(Bundle.getMessage("ToolTipMultReplSkipThis"));
        skipThis.addActionListener(e -> {
            JOptionPane pane = this.getOptionPane((JComponent)e.getSource());
            pane.setValue(skipThis);
        });
        JButton skipAll = new JButton(Bundle.getMessage("ButtonMultReplSkipAll"));
        skipAll.setToolTipText(Bundle.getMessage("ToolTipMultReplSkipAll"));
        skipAll.addActionListener(e -> {
            JOptionPane pane = this.getOptionPane((JComponent)e.getSource());
            pane.setValue(skipAll);
        });
        int retVal = -1;
        while (retVal == -1) {
            retVal = JOptionPane.showOptionDialog(new JFrame(), text, Bundle.getMessage(missing ? "TitleNoDefn" : "TitleMultRepl"), -1, -1, null, new JButton[]{select, skipThis, skipAll}, select);
            log.trace("retVal={}", (Object)retVal);
        }
        return retVal;
    }

    synchronized void decoderSelectionPane(final RosterEntry theEntry) {
        String[] buttons;
        log.debug("Decoder Selection Pane requested");
        this.tempRe = null;
        this.statusLabel = new JLabel(SymbolicProgBundle.getMessage("StateIdle"));
        log.debug("New decoder requested");
        this.makeMatchLists(theEntry);
        log.trace("Version matchlist size={}", (Object)this.versionMatchList.size());
        log.trace("Replacement matchlist size={}", (Object)this.replacementList.size());
        this.f = new JDialog(null, Bundle.getMessage("TitleReplDefn", theEntry.getId()), true);
        Container dialogPane = this.f.getContentPane();
        dialogPane.setLayout(new BoxLayout(dialogPane, 1));
        this.f.addWindowListener(new WindowAdapter(){

            @Override
            public synchronized void windowClosing(WindowEvent we) {
                UpdateDecoderDefinitionAction.this.statusLabel.setText(SymbolicProgBundle.getMessage("StateIdle"));
                log.debug("window closing");
                UpdateDecoderDefinitionAction.this.f.dispose();
            }
        });
        this.f.getRootPane().registerKeyboardAction(e -> {
            this.statusLabel.setText(SymbolicProgBundle.getMessage("StateIdle"));
            log.debug("escape pressed");
            this.f.dispose();
        }, KeyStroke.getKeyStroke(27, 0), 2);
        final JPanel bottomPanel = new JPanel(new BorderLayout());
        this.combinedLocoSelTree = new CombinedLocoSelTreePane(this.statusLabel, this.modePane){

            @Override
            protected synchronized void openNewLoco() {
                this.go2.setToolTipText(Bundle.getMessage("ToolTipUseSelectedDecoder"));
                DecoderFile decoderFile = UpdateDecoderDefinitionAction.this.di.fileFromTitle(this.selectedDecoderType());
                log.debug("decoder file: {}", (Object)decoderFile.getFileName());
                UpdateDecoderDefinitionAction.this.tempRe = new RosterEntry();
                UpdateDecoderDefinitionAction.this.tempRe.setDecoderFamily(decoderFile.getFamily());
                UpdateDecoderDefinitionAction.this.tempRe.setDecoderModel(decoderFile.getModel());
                UpdateDecoderDefinitionAction.this.tempRe.setId(SymbolicProgBundle.getMessage("LabelNewDecoder"));
            }

            @Override
            protected synchronized JPanel layoutRosterSelection() {
                log.debug("layoutRosterSelection");
                return null;
            }

            @Override
            protected synchronized JPanel layoutDecoderSelection() {
                log.debug("layoutDecoderSelection");
                JPanel pan = super.layoutDecoderSelection();
                UpdateDecoderDefinitionAction.this.versionButton = this.versionMatchButton();
                this.viewButtons.add(UpdateDecoderDefinitionAction.this.versionButton);
                UpdateDecoderDefinitionAction.this.replacementButton = this.replacementMatchButton();
                this.viewButtons.add(UpdateDecoderDefinitionAction.this.replacementButton);
                UpdateDecoderDefinitionAction.this.updateMatchButtons(theEntry);
                this.dTree.removeTreeSelectionListener(this.dListener);
                this.dListener = e -> {
                    log.debug("selection changed, {}empty, {}", (Object)(this.dTree.isSelectionEmpty() ? "" : "not "), (Object)Arrays.toString(this.dTree.getSelectionPaths()));
                    if (this.dTree.hasFocus()) {
                        UpdateDecoderDefinitionAction.this.setLastActionDisplay("TextManualSelection");
                    }
                    if (!this.dTree.isSelectionEmpty() && this.dTree.getSelectionPath() != null && ((TreeNode)this.dTree.getSelectionPath().getLastPathComponent()).isLeaf() && this.dTree.getSelectionPath().getPathCount() > 2 && this.dTree.getSelectionCount() < 2) {
                        log.debug("Selection event with {}", (Object)this.dTree.getSelectionPath());
                        this.go2.setEnabled(true);
                        this.go2.setRequestFocusEnabled(true);
                        this.go2.requestFocus();
                        this.go2.setToolTipText(Bundle.getMessage("ToolTipUseSelectedDecoder"));
                    } else {
                        this.go2.setEnabled(false);
                        this.go2.setToolTipText(Bundle.getMessage("ToolTipNoSelectedDecoder"));
                    }
                };
                this.dTree.addTreeSelectionListener(this.dListener);
                this.dTree.removeFocusListener(UpdateDecoderDefinitionAction.this.fListener);
                UpdateDecoderDefinitionAction.this.fListener = new FocusListener(){

                    @Override
                    public synchronized void focusGained(FocusEvent e) {
                        log.debug("Focus Gained, {}empty, {}", (Object)(dTree.isSelectionEmpty() ? "" : "not "), (Object)Arrays.toString(dTree.getSelectionPaths()));
                        UpdateDecoderDefinitionAction.this.setLastActionDisplay("TextManualSelection");
                    }

                    @Override
                    public void focusLost(FocusEvent e) {
                        log.debug("Focus Lost, {}empty, {}", (Object)(dTree.isSelectionEmpty() ? "" : "not "), (Object)Arrays.toString(dTree.getSelectionPaths()));
                        UpdateDecoderDefinitionAction.this.setLastActionDisplay("TextManualSelection");
                    }
                };
                this.dTree.addFocusListener(UpdateDecoderDefinitionAction.this.fListener);
                return pan;
            }

            @Override
            protected synchronized void startIdentifyDecoder() {
                UpdateDecoderDefinitionAction.this.setLastActionDisplay("ButtonReadType");
                super.startIdentifyDecoder();
            }

            JToggleButton versionMatchButton() {
                JToggleButton button = new JToggleButton(Bundle.getMessage("ButtonShowVersionMatch"));
                button.setToolTipText(Bundle.getMessage("ToolTipVersionMatch", UpdateDecoderDefinitionAction.this.cV7Value, theEntry.getId()));
                button.addActionListener(e -> {
                    this.resetSelections();
                    this.updateForDecoderTypeID(UpdateDecoderDefinitionAction.this.versionMatchList);
                    button.setSelected(false);
                    UpdateDecoderDefinitionAction.this.setLastActionDisplay("ButtonShowVersionMatch");
                    this.setShowMatchedOnly(true);
                });
                return button;
            }

            JToggleButton replacementMatchButton() {
                JToggleButton button = new JToggleButton(Bundle.getMessage("ButtonShowSuggested"));
                button.setToolTipText(Bundle.getMessage("ToolTipShowSuggested"));
                button.addActionListener(e -> {
                    this.resetSelections();
                    this.updateForDecoderTypeID(UpdateDecoderDefinitionAction.this.replacementList);
                    button.setSelected(false);
                    UpdateDecoderDefinitionAction.this.setLastActionDisplay("ButtonShowSuggested");
                    this.setShowMatchedOnly(true);
                });
                return button;
            }

            @Override
            protected synchronized JPanel createProgrammerSelection() {
                log.debug("createProgrammerSelection");
                JPanel pane3a = new JPanel();
                pane3a.setLayout(new BoxLayout(pane3a, 1));
                UpdateDecoderDefinitionAction.this.cancelButton = new JButton(Bundle.getMessage("ButtonCancel"));
                UpdateDecoderDefinitionAction.this.cancelButton.addActionListener(e -> {
                    log.debug("Cancel");
                    log.debug("Closing f {}", (Object)UpdateDecoderDefinitionAction.this.f);
                    WindowEvent wev = new WindowEvent(UpdateDecoderDefinitionAction.this.f, 201);
                    Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(wev);
                    UpdateDecoderDefinitionAction.this.f.dispose();
                });
                UpdateDecoderDefinitionAction.this.cancelButton.setAlignmentX(1.0f);
                UpdateDecoderDefinitionAction.this.cancelButton.setToolTipText(Bundle.getMessage("ToolTipButtonCancel"));
                bottomPanel.add((Component)UpdateDecoderDefinitionAction.this.cancelButton, "West");
                UpdateDecoderDefinitionAction.this.lastActionDisplay = new JLabel("", 0);
                bottomPanel.add((Component)UpdateDecoderDefinitionAction.this.lastActionDisplay, "Center");
                this.go2 = new JButton(Bundle.getMessage("ButtonUseSelected"));
                this.go2.addActionListener(e -> {
                    log.debug("Use Selected pressed");
                    this.openButton();
                    log.debug("Closing f {}", (Object)UpdateDecoderDefinitionAction.this.f);
                    WindowEvent wev = new WindowEvent(UpdateDecoderDefinitionAction.this.f, 201);
                    Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(wev);
                    UpdateDecoderDefinitionAction.this.f.dispose();
                });
                this.go2.setAlignmentX(1.0f);
                this.go2.setEnabled(false);
                this.go2.setToolTipText(Bundle.getMessage("ToolTipNoSelectedDecoder"));
                bottomPanel.add((Component)this.go2, "East");
                return pane3a;
            }
        };
        JPanel helpPane = new JPanel();
        JScrollPane helpScroll = new JScrollPane(helpPane);
        helpPane.setLayout(new BoxLayout(helpPane, 1));
        String[] stringArray = buttons = new String[]{"ButtonReadType", "ButtonShowVersionMatch", "ButtonShowSuggested", "ButtonAllMatched", "ButtonUseSelected", "ButtonCancel"};
        int n = buttons.length;
        int n2 = 0;
        while (n2 < n) {
            String button = stringArray[n2];
            JLabel l = new JLabel("<html><strong>&quot;" + Bundle.getMessage(button) + "&quot;</strong></html>");
            l.setAlignmentX(0.0f);
            helpPane.add(l);
            int line = 1;
            while (line >= 0) {
                try {
                    String msg = Bundle.getMessage(String.valueOf(button) + "Help" + line, theEntry.getId());
                    if (msg.isEmpty()) {
                        msg = " ";
                    }
                    l = new JLabel(msg);
                    l.setAlignmentX(0.0f);
                    helpPane.add(l);
                    ++line;
                }
                catch (MissingResourceException missingResourceException) {
                    line = -1;
                }
            }
            l = new JLabel(" ");
            l.setAlignmentX(0.0f);
            helpPane.add(l);
            ++n2;
        }
        dialogPane.add(helpScroll);
        JPanel infoPane = new JPanel();
        JLabel l = new JLabel(Bundle.getMessage("TextReplDefn", theEntry.getDecoderFamily(), theEntry.getDecoderModel(), theEntry.getId()));
        infoPane.add(l);
        dialogPane.add(infoPane);
        JPanel selectorPane = new JPanel();
        selectorPane.setLayout(new BorderLayout());
        JPanel topPanel = new JPanel();
        topPanel.add(this.modePane);
        topPanel.add(new JSeparator(0));
        selectorPane.add((Component)topPanel, "North");
        this.combinedLocoSelTree.setAlignmentX(0.5f);
        selectorPane.add((Component)this.combinedLocoSelTree, "Center");
        this.statusLabel.setAlignmentX(0.5f);
        bottomPanel.add((Component)this.statusLabel, "South");
        selectorPane.add((Component)bottomPanel, "South");
        dialogPane.add((Component)selectorPane, "Center");
        this.f.pack();
        log.debug("Tab-Programmer setup created");
        if (!this.versionMatchList.isEmpty()) {
            this.combinedLocoSelTree.updateForDecoderTypeID(this.versionMatchList);
            this.setLastActionDisplay("ButtonShowVersionMatch");
            this.combinedLocoSelTree.setShowMatchedOnly(true);
        } else if (!this.replacementList.isEmpty()) {
            this.combinedLocoSelTree.updateForDecoderTypeID(this.replacementList);
            this.setLastActionDisplay("ButtonShowSuggested");
            this.combinedLocoSelTree.setShowMatchedOnly(true);
        }
        this.f.setVisible(true);
        log.trace("Test done");
    }

    synchronized void setLastActionDisplay(String propertyName) {
        this.lastActionDisplay.setText(Bundle.getMessage("TextLastAction", Bundle.getMessage(propertyName)));
        log.debug("Last Action display changed to {}", (Object)this.lastActionDisplay.getText());
    }

    synchronized void makeMatchLists(RosterEntry theEntry) {
        this.versionMatchList = new ArrayList<DecoderFile>();
        this.replacementList = new ArrayList<DecoderFile>();
        theEntry.readFile();
        CvTableModel cvModel = new CvTableModel(null, null);
        theEntry.loadCvModel(null, cvModel);
        this.cV7Value = 0;
        CvValue cvObject = cvModel.allCvMap().get("7");
        if (cvObject != null) {
            this.cV7Value = cvObject.getValue();
        }
        this.cV8Value = 0;
        cvObject = cvModel.allCvMap().get("8");
        if (cvObject != null) {
            this.cV8Value = cvObject.getValue();
        }
        log.trace("cV7Value = {}, cV8Value = {}", (Object)this.cV7Value, (Object)this.cV8Value);
        String[] stringArray = this.replacementFamilyString.split(QRY_SEPARATOR);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String theFamily = stringArray[n2];
            if (theFamily != null && theFamily.equals("")) {
                theFamily = null;
            }
            String[] stringArray2 = this.replacementModelString.split(QRY_SEPARATOR);
            int n3 = stringArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                String theModel = stringArray2[n4];
                if (theModel != null && theModel.equals("")) {
                    theModel = null;
                }
                log.trace("theFamily = {}, theModel = {}", (Object)theFamily, (Object)theModel);
                List<DecoderFile> decoders = this.di.matchingDecoderList(null, theFamily, null, null, null, theModel);
                log.trace("Found {} replacement decoders matching family \"{}\" model \"{}\"", new Object[]{decoders.size(), theFamily, theModel});
                for (DecoderFile decoder : decoders) {
                    if (decoder.getShowable() == DecoderFile.Showable.NO || decoder.getFamily().equals(theEntry.getDecoderFamily()) && decoder.getModel().equals(theEntry.getDecoderModel())) continue;
                    if (this.cV7Value > 0 && this.cV8Value > 0 && decoder.isVersion(this.cV7Value)) {
                        log.trace("Adding to versionMatchList mfg='{}', family='{}', model='{}'", new Object[]{decoder.getMfg(), decoder.getFamily(), decoder.getModel()});
                        this.versionMatchList.add(new DecoderFile(decoder.getMfg(), null, decoder.getModel(), null, null, decoder.getFamily(), null, 0, 0, null));
                    }
                    log.trace("Adding to replacementList mfg='{}', family='{}', model='{}'", new Object[]{decoder.getMfg(), decoder.getFamily(), decoder.getModel()});
                    this.replacementList.add(new DecoderFile(decoder.getMfg(), null, decoder.getModel(), null, null, decoder.getFamily(), null, 0, 0, null));
                }
                ++n4;
            }
            ++n2;
        }
        this.updateMatchButtons(theEntry);
    }

    synchronized void updateMatchButtons(RosterEntry theEntry) {
        if (this.versionButton != null) {
            if (this.versionMatchList == null || this.versionMatchList.isEmpty()) {
                this.versionButton.setEnabled(false);
                this.versionButton.setToolTipText(Bundle.getMessage("ToolTipNoVersionMatch", theEntry.getId()));
            } else {
                log.trace("versionMatchList size = {}", (Object)this.versionMatchList.size());
                this.versionButton.setEnabled(true);
                this.versionButton.setToolTipText(Bundle.getMessage("ToolTipVersionMatch", this.cV7Value, theEntry.getId()));
            }
        }
        if (this.replacementButton != null) {
            if (this.replacementList == null || this.replacementList.isEmpty()) {
                this.replacementButton.setEnabled(false);
                this.replacementButton.setToolTipText(Bundle.getMessage("ToolTipNoShowSuggested"));
            } else {
                log.trace("replacementList size = {}", (Object)this.replacementList.size());
                this.replacementButton.setEnabled(true);
                this.replacementButton.setToolTipText(Bundle.getMessage("ToolTipShowSuggested"));
            }
        }
    }

    @Override
    public synchronized JmriPanel makePanel() {
        throw new IllegalArgumentException("Should not be invoked");
    }
}

