/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.roster;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.Timer;
import jmri.Block;
import jmri.DccThrottle;
import jmri.InstanceManager;
import jmri.NamedBean;
import jmri.Section;
import jmri.implementation.SignalSpeedMap;
import jmri.jmrit.roster.Bundle;
import jmri.jmrit.roster.RosterEntry;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RosterSpeedProfile {
    RosterEntry _re = null;
    float overRunTimeReverse = 0.0f;
    float overRunTimeForward = 0.0f;
    boolean _hasForwardSpeeds = false;
    boolean _hasReverseSpeeds = false;
    public static final float MMS_TO_MPH = 0.00223694f;
    public static final float MMS_TO_KPH = 0.0036f;
    float distanceRemaining = 0.0f;
    float distanceTravelled = 0.0f;
    TreeMap<Integer, SpeedStep> speeds = new TreeMap();
    DccThrottle _throttle;
    float desiredSpeedStep = -1.0f;
    float extraDelay = 0.0f;
    NamedBean referenced = null;
    Timer stopTimer = null;
    long lastTimeTimerStarted = 0L;
    int extraTime = 0;
    LinkedList<SpeedSetting> stepQueue = new LinkedList();
    private static final Logger log = LoggerFactory.getLogger(RosterSpeedProfile.class);

    public RosterSpeedProfile(RosterEntry re) {
        this._re = re;
    }

    public RosterEntry getRosterEntry() {
        return this._re;
    }

    public float getOverRunTimeForward() {
        return this.overRunTimeForward;
    }

    public void setOverRunTimeForward(float dt) {
        this.overRunTimeForward = dt;
    }

    public float getOverRunTimeReverse() {
        return this.overRunTimeReverse;
    }

    public void setOverRunTimeReverse(float dt) {
        this.overRunTimeReverse = dt;
    }

    public void clearCurrentProfile() {
        this.speeds = new TreeMap();
    }

    public void deleteStep(Integer step) {
        this.speeds.remove(step);
    }

    public boolean hasForwardSpeeds() {
        return this._hasForwardSpeeds;
    }

    public boolean hasReverseSpeeds() {
        return this._hasReverseSpeeds;
    }

    public float MMSToScaleSpeed(float mms) {
        int interp = InstanceManager.getDefault(SignalSpeedMap.class).getInterpretation();
        float scale = InstanceManager.getDefault(SignalSpeedMap.class).getLayoutScale();
        switch (interp) {
            case 3: {
                return mms * scale * 0.00223694f;
            }
            case 4: {
                return mms * scale * 0.0036f;
            }
            case 1: 
            case 2: {
                return mms;
            }
        }
        log.warn("MMSToScaleSpeed: Signal Speed Map is not in a scale speed, not modifing.");
        return mms;
    }

    public static String convertMMSToScaleSpeedWithUnits(float mms) {
        String formattedWithUnits;
        int interp = InstanceManager.getDefault(SignalSpeedMap.class).getInterpretation();
        float scale = InstanceManager.getDefault(SignalSpeedMap.class).getLayoutScale();
        switch (interp) {
            case 3: {
                String unitsMph = Bundle.getMessage("mph");
                formattedWithUnits = String.format("%.2f %s", Float.valueOf(mms * scale * 0.00223694f), unitsMph);
                break;
            }
            case 4: {
                String unitsKph = Bundle.getMessage("kph");
                formattedWithUnits = String.format("%.2f %s", Float.valueOf(mms * scale * 0.0036f), unitsKph);
                break;
            }
            case 1: 
            case 2: {
                String unitsMms = Bundle.getMessage("mmps");
                formattedWithUnits = String.format("%.2f %s", Float.valueOf(mms), unitsMms);
                break;
            }
            default: {
                log.warn("ScaleSpeedToMMS: Signal Speed Map has no interp, not modifing.");
                formattedWithUnits = String.format("%.2f", Float.valueOf(mms));
            }
        }
        return formattedWithUnits;
    }

    public String convertThrottleSettingToScaleSpeedWithUnits(float throttleSetting, boolean isForward) {
        return RosterSpeedProfile.convertMMSToScaleSpeedWithUnits(this.getSpeed(throttleSetting, isForward));
    }

    public float convertScaleSpeedToMMS(float scaleSpeed) {
        float mmsSpeed;
        int interp = InstanceManager.getDefault(SignalSpeedMap.class).getInterpretation();
        float scale = InstanceManager.getDefault(SignalSpeedMap.class).getLayoutScale();
        switch (interp) {
            case 3: {
                mmsSpeed = scaleSpeed / scale / 0.00223694f;
                break;
            }
            case 4: {
                mmsSpeed = scaleSpeed / scale / 0.0036f;
                break;
            }
            default: {
                log.warn("ScaleSpeedToMMS: Signal Speed Map is not in a scale speed, not modifing.");
                mmsSpeed = scaleSpeed;
            }
        }
        return mmsSpeed;
    }

    public float getThrottleSettingFromSignalMapSpeed(float signalMapSpeed, boolean isForward) {
        int interp = InstanceManager.getDefault(SignalSpeedMap.class).getInterpretation();
        float throttleSetting = 0.0f;
        switch (interp) {
            case 1: 
            case 2: {
                throttleSetting = signalMapSpeed / 100.0f;
                break;
            }
            case 3: 
            case 4: {
                throttleSetting = this.getThrottleSetting(this.convertScaleSpeedToMMS(signalMapSpeed), isForward);
                break;
            }
            default: {
                log.warn("getThrottleSettingFromSignalMapSpeed: Signal Speed Map interp not supported.");
            }
        }
        return throttleSetting;
    }

    public void setSpeed(int speedStep, float forward, float reverse) {
        if (!this.speeds.containsKey(speedStep)) {
            this.speeds.put(speedStep, new SpeedStep());
        }
        SpeedStep ss = this.speeds.get(speedStep);
        ss.setForwardSpeed(forward);
        ss.setReverseSpeed(reverse);
        if (forward > 0.0f) {
            this._hasForwardSpeeds = true;
        }
        if (reverse > 0.0f) {
            this._hasReverseSpeeds = true;
        }
    }

    public SpeedStep getSpeedStep(float speed) {
        int iSpeedStep = Math.round(speed * 1000.0f);
        return this.speeds.get(iSpeedStep);
    }

    public void setForwardSpeed(float speedStep, float forward) {
        if (!(forward > 0.0f)) {
            return;
        }
        this._hasForwardSpeeds = true;
        int iSpeedStep = Math.round(speedStep * 1000.0f);
        if (!this.speeds.containsKey(iSpeedStep)) {
            this.speeds.put(iSpeedStep, new SpeedStep());
        }
        SpeedStep ss = this.speeds.get(iSpeedStep);
        ss.setForwardSpeed(forward);
    }

    public void setForwardSpeed(float throttleSetting, float speed, float speedIncrement) {
        int key;
        if (!(throttleSetting > 0.0f)) {
            return;
        }
        this._hasForwardSpeeds = true;
        Map.Entry<Integer, SpeedStep> entry = this.findEquivalentEntry(throttleSetting, speedIncrement);
        if (entry != null) {
            float value = entry.getValue().getForwardSpeed();
            speed = (speed + value) / 2.0f;
            key = entry.getKey();
        } else {
            key = Math.round(throttleSetting * 1000.0f);
        }
        if (!this.speeds.containsKey(key)) {
            this.speeds.put(key, new SpeedStep());
        }
        SpeedStep ss = this.speeds.get(key);
        ss.setForwardSpeed(speed);
    }

    private Map.Entry<Integer, SpeedStep> findEquivalentEntry(float throttleSetting, float speedIncrement) {
        Map.Entry<Integer, SpeedStep> entry = this.speeds.firstEntry();
        if (entry == null) {
            return null;
        }
        int key = entry.getKey();
        while (entry != null) {
            entry = this.speeds.higherEntry(key);
            if (entry == null) continue;
            float speed = entry.getKey().intValue();
            if (Math.abs(speed / 1000.0f - throttleSetting) <= speedIncrement) {
                return entry;
            }
            key = entry.getKey();
        }
        return null;
    }

    public void setReverseSpeed(float throttleSetting, float speed, float speedIncrement) {
        int key;
        if (!(throttleSetting > 0.0f)) {
            return;
        }
        this._hasReverseSpeeds = true;
        Map.Entry<Integer, SpeedStep> entry = this.findEquivalentEntry(throttleSetting, speedIncrement);
        if (entry != null) {
            float value = entry.getValue().getForwardSpeed();
            speed = (speed + value) / 2.0f;
            key = entry.getKey();
        } else {
            key = Math.round(throttleSetting * 1000.0f);
        }
        if (!this.speeds.containsKey(key)) {
            this.speeds.put(key, new SpeedStep());
        }
        SpeedStep ss = this.speeds.get(key);
        ss.setReverseSpeed(speed);
    }

    public void setReverseSpeed(float speedStep, float reverse) {
        if (!(reverse > 0.0f)) {
            return;
        }
        this._hasReverseSpeeds = true;
        int iSpeedStep = Math.round(speedStep * 1000.0f);
        if (!this.speeds.containsKey(iSpeedStep)) {
            this.speeds.put(iSpeedStep, new SpeedStep());
        }
        SpeedStep ss = this.speeds.get(iSpeedStep);
        ss.setReverseSpeed(reverse);
    }

    public float getForwardSpeed(float speedStep) {
        float speed;
        int iSpeedStep = Math.round(speedStep * 1000.0f);
        if (iSpeedStep <= 0 || !this._hasForwardSpeeds) {
            return 0.0f;
        }
        if (this.speeds.containsKey(iSpeedStep) && (speed = this.speeds.get(iSpeedStep).getForwardSpeed()) > 0.0f) {
            return speed;
        }
        log.debug("no exact match forward for {}", (Object)iSpeedStep);
        float lower = 0.0f;
        float higher = 0.0f;
        int highStep = iSpeedStep;
        int lowStep = iSpeedStep;
        Map.Entry<Integer, SpeedStep> entry = this.speeds.higherEntry(highStep);
        while (entry != null && higher <= 0.0f) {
            highStep = entry.getKey();
            float value = entry.getValue().getForwardSpeed();
            if (value > 0.0f) {
                higher = value;
            }
            entry = this.speeds.higherEntry(highStep);
        }
        boolean nothingHigher = higher <= 0.0f;
        entry = this.speeds.lowerEntry(lowStep);
        while (entry != null && lower <= 0.0f) {
            lowStep = entry.getKey();
            float value = entry.getValue().getForwardSpeed();
            if (value > 0.0f) {
                lower = value;
            }
            entry = this.speeds.lowerEntry(lowStep);
        }
        log.debug("lowStep={}, lower={} highStep={} higher={} for iSpeedStep={}", new Object[]{lowStep, Float.valueOf(lower), highStep, Float.valueOf(higher), iSpeedStep});
        if (lower <= 0.0f) {
            if (nothingHigher) {
                log.error("Nothing in speed Profile");
                return 0.0f;
            }
            return higher * (float)iSpeedStep / (float)highStep;
        }
        if (nothingHigher) {
            return lower + (float)(iSpeedStep - lowStep) * lower / (float)lowStep;
        }
        float valperstep = (higher - lower) / (float)(highStep - lowStep);
        float retValue = lower + valperstep * (float)(iSpeedStep - lowStep);
        return retValue;
    }

    public float getReverseSpeed(float speedStep) {
        float speed;
        int iSpeedStep = Math.round(speedStep * 1000.0f);
        if (iSpeedStep <= 0 || !this._hasReverseSpeeds) {
            return 0.0f;
        }
        if (this.speeds.containsKey(iSpeedStep) && (speed = this.speeds.get(iSpeedStep).getReverseSpeed()) > 0.0f) {
            return speed;
        }
        log.debug("no exact match reverse for {}", (Object)iSpeedStep);
        float lower = 0.0f;
        float higher = 0.0f;
        int highStep = iSpeedStep;
        int lowStep = iSpeedStep;
        Map.Entry<Integer, SpeedStep> entry = this.speeds.higherEntry(highStep);
        while (entry != null && higher <= 0.0f) {
            highStep = entry.getKey();
            float value = entry.getValue().getReverseSpeed();
            if (value > 0.0f) {
                higher = value;
            }
            entry = this.speeds.higherEntry(highStep);
        }
        boolean nothingHigher = higher <= 0.0f;
        entry = this.speeds.lowerEntry(lowStep);
        while (entry != null && lower <= 0.0f) {
            lowStep = entry.getKey();
            float value = entry.getValue().getReverseSpeed();
            if (value > 0.0f) {
                lower = value;
            }
            entry = this.speeds.lowerEntry(lowStep);
        }
        log.debug("lowStep={}, lower={} highStep={} higher={} for iSpeedStep={}", new Object[]{lowStep, Float.valueOf(lower), highStep, Float.valueOf(higher), iSpeedStep});
        if (lower <= 0.0f) {
            if (nothingHigher) {
                log.error("Nothing in speed Profile");
                return 0.0f;
            }
            return higher * (float)iSpeedStep / (float)highStep;
        }
        if (nothingHigher) {
            return lower * (1.0f + (float)(iSpeedStep - lowStep) / (1000.0f - (float)lowStep));
        }
        float valperstep = (higher - lower) / (float)(highStep - lowStep);
        float retValue = lower + valperstep * (float)(iSpeedStep - lowStep);
        return retValue;
    }

    public float getDurationOfTravelInSeconds(boolean isForward, float speedStep, int distance) {
        float spd = isForward ? this.getForwardSpeed(speedStep) : this.getReverseSpeed(speedStep);
        if (spd <= 0.0f) {
            log.error("Speed not available to compute duration of travel");
            return 0.0f;
        }
        return (float)distance / spd;
    }

    public float getDistanceTravelled(boolean isForward, float speedStep, float duration) {
        float spd = isForward ? this.getForwardSpeed(speedStep) : this.getReverseSpeed(speedStep);
        if (spd <= 0.01f) {
            log.error("Speed not available to compute distance travelled");
            return 0.0f;
        }
        return Math.abs(spd * duration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finishChange() {
        if (this.stopTimer != null) {
            this.stopTimer.stop();
        }
        this.stopTimer = null;
        this._throttle = null;
        this.distanceRemaining = 0.0f;
        this.desiredSpeedStep = -1.0f;
        this.extraDelay = 0.0f;
        this.referenced = null;
        RosterSpeedProfile rosterSpeedProfile = this;
        synchronized (rosterSpeedProfile) {
            this.distanceTravelled = 0.0f;
            this.stepQueue = new LinkedList();
        }
        this._throttle = null;
    }

    public void setExtraInitialDelay(float eDelay) {
        this.extraDelay = eDelay;
    }

    public void changeLocoSpeed(DccThrottle t, Block blk, float speed) {
        if (blk == this.referenced && Float.compare(speed, this.desiredSpeedStep) == 0) {
            return;
        }
        float blockLength = blk.getLengthMm();
        if (blk == this.referenced) {
            this.distanceRemaining -= this.getDistanceTravelled(this._throttle.getIsForward(), this._throttle.getSpeedSetting(), (float)(System.nanoTime() - this.lastTimeTimerStarted) / 1.0E9f);
            blockLength = this.distanceRemaining;
            log.debug("Block passed is the same as we are currently processing");
        } else {
            this.referenced = blk;
        }
        this.changeLocoSpeed(t, blockLength, speed);
    }

    @SuppressFBWarnings(value={"FE_FLOATING_POINT_EQUALITY"}, justification="OK to compare floats, as even tiny differences should trigger update")
    public void changeLocoSpeed(DccThrottle t, Section sec, float speed, float usePercentage) {
        if (sec == this.referenced && speed == this.desiredSpeedStep) {
            log.debug("Already setting to desired speed step for this Section");
            return;
        }
        float sectionLength = (float)sec.getActualLength() * usePercentage;
        if (sec == this.referenced) {
            this.distanceRemaining -= this.getDistanceTravelled(this._throttle.getIsForward(), this._throttle.getSpeedSetting(), (float)(System.nanoTime() - this.lastTimeTimerStarted) / 1.0E9f);
            sectionLength = this.distanceRemaining;
            log.debug("Block passed is the same as we are currently processing");
        } else {
            this.referenced = sec;
        }
        this.changeLocoSpeed(t, sectionLength, speed);
    }

    @SuppressFBWarnings(value={"FE_FLOATING_POINT_EQUALITY"}, justification="OK to compare floats, as even tiny differences should trigger update")
    public void changeLocoSpeed(DccThrottle t, Block blk, float speed, float usePercentage) {
        if (blk == this.referenced && speed == this.desiredSpeedStep) {
            return;
        }
        float blockLength = blk.getLengthMm() * usePercentage;
        if (blk == this.referenced) {
            this.distanceRemaining -= this.getDistanceTravelled(this._throttle.getIsForward(), this._throttle.getSpeedSetting(), (float)(System.nanoTime() - this.lastTimeTimerStarted) / 1.0E9f);
            blockLength = this.distanceRemaining;
            log.debug("Block passed is the same as we are currently processing");
        } else {
            this.referenced = blk;
        }
        this.changeLocoSpeed(t, blockLength, speed);
    }

    public void changeLocoSpeed(DccThrottle t, Section sec, float speed) {
        if (sec == this.referenced && Float.compare(speed, this.desiredSpeedStep) == 0) {
            log.debug("Already setting to desired speed step for this section");
            return;
        }
        float sectionLength = sec.getActualLength();
        log.debug("call to change speed via section {}", (Object)sec.getDisplayName());
        if (sec == this.referenced) {
            this.distanceRemaining -= this.getDistanceTravelled(this._throttle.getIsForward(), this._throttle.getSpeedSetting(), (float)(System.nanoTime() - this.lastTimeTimerStarted) / 1.0E9f);
            sectionLength = this.distanceRemaining;
        } else {
            this.referenced = sec;
        }
        this.changeLocoSpeed(t, sectionLength, speed);
    }

    public void changeLocoSpeed(DccThrottle t, float distance, float speed) {
        log.debug("Call to change speed over specific distance float {} distance {}", (Object)Float.valueOf(speed), (Object)Float.valueOf(distance));
        if (Float.compare(speed, t.getSpeedSetting()) == 0) {
            log.debug("Throttle and request speed setting are the same {} {} so will quit", (Object)Float.valueOf(speed), (Object)Float.valueOf(t.getSpeedSetting()));
            this.finishChange();
            return;
        }
        if (Float.compare(speed, this.desiredSpeedStep) == 0) {
            log.debug("Already setting to desired speed step");
            return;
        }
        log.debug("public change speed step by float {}", (Object)Float.valueOf(speed));
        log.debug("Desired Speed Step {} asked for {}", (Object)Float.valueOf(this.desiredSpeedStep), (Object)Float.valueOf(speed));
        if (this.stopTimer != null) {
            log.debug("stop timer valid so will cancel");
            this.cancelSpeedChange();
        }
        this._throttle = t;
        log.debug("Desired Speed Step {} asked for {}", (Object)Float.valueOf(this.desiredSpeedStep), (Object)Float.valueOf(speed));
        this.desiredSpeedStep = speed;
        log.debug("calculated current step {} required {} current {}", new Object[]{Float.valueOf(this._throttle.getSpeedSetting()), Float.valueOf(speed), Float.valueOf(this._throttle.getSpeedSetting())});
        if (this._throttle.getSpeedSetting() < speed) {
            log.debug("Going for acceleration");
        } else {
            log.debug("Going for deceleration");
        }
        this.calculateStepDetails(speed, distance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void calculateStepDetails(float speedStep, float distance) {
        float stepIncrement = this._throttle.getSpeedIncrement();
        log.debug("Desired Speed Step {} asked for {}", (Object)Float.valueOf(this.desiredSpeedStep), (Object)Float.valueOf(speedStep));
        this.desiredSpeedStep = speedStep;
        log.debug("calculated current step {} required {} current {} increment {}", new Object[]{Float.valueOf(this._throttle.getSpeedSetting()), Float.valueOf(speedStep), Float.valueOf(this._throttle.getSpeedSetting()), Float.valueOf(stepIncrement)});
        boolean increaseSpeed = false;
        if (this._throttle.getSpeedSetting() < speedStep) {
            increaseSpeed = true;
            log.debug("Going for acceleration");
        } else {
            log.debug("Going for deceleration");
        }
        if (distance <= 0.0f) {
            log.debug("Distance is less than 0 {}", (Object)Float.valueOf(distance));
            this._throttle.setSpeedSetting(speedStep);
            this.finishChange();
            return;
        }
        float calculatedDistance = distance;
        if (this.stopTimer != null) {
            this.stopTimer.stop();
            this.distanceRemaining = distance;
        } else {
            this.distanceRemaining = calculatedDistance = this.calculateInitialOverRun(distance);
        }
        float calculatingStep = this._throttle.getSpeedSetting();
        float endspd = 0.0f;
        if ((double)calculatingStep != 0.0 && this.desiredSpeedStep > 0.0f) {
            endspd = this._throttle.getIsForward() ? this.getForwardSpeed(this.desiredSpeedStep) : this.getReverseSpeed(this.desiredSpeedStep);
        } else if ((double)this.desiredSpeedStep != 0.0) {
            endspd = this._throttle.getIsForward() ? this.getForwardSpeed(this.desiredSpeedStep) : this.getReverseSpeed(this.desiredSpeedStep);
        }
        boolean calculated = false;
        while (!calculated) {
            float spd = 0.0f;
            if ((double)calculatingStep != 0.0) {
                spd = this._throttle.getIsForward() ? this.getForwardSpeed(calculatingStep) : this.getReverseSpeed(calculatingStep);
            }
            log.debug("end spd {} spd {}", (Object)Float.valueOf(endspd), (Object)Float.valueOf(spd));
            double avgSpeed = Math.abs((double)(endspd + spd) * 0.5);
            log.debug("avg Speed {}", (Object)avgSpeed);
            double time = (double)calculatedDistance / avgSpeed;
            float speeddiff = calculatingStep - this.desiredSpeedStep;
            float noSteps = speeddiff / stepIncrement;
            log.debug("Speed diff {} number of Steps {} step increment {}", new Object[]{Float.valueOf(speeddiff), Float.valueOf(noSteps), Float.valueOf(stepIncrement)});
            int timePerStep = Math.abs((int)((time *= 1000.0) / (double)noSteps));
            float calculatedStepInc = stepIncrement;
            if (calculatingStep > stepIncrement * 2.0f && timePerStep <= 500 && timePerStep > 0) {
                float tmp = 750.0f / (float)timePerStep;
                calculatedStepInc = stepIncrement * tmp;
                log.debug("time per step was {} no of increments in 750 ms is {} new step increment in {}", new Object[]{timePerStep, Float.valueOf(tmp), Float.valueOf(calculatedStepInc)});
                timePerStep = 750;
            }
            log.debug("per interval {}", (Object)timePerStep);
            if (increaseSpeed) {
                if ((calculatingStep += calculatedStepInc) > 1.0f) {
                    calculatingStep = 1.0f;
                    calculated = true;
                }
                if (calculatingStep > this.desiredSpeedStep) {
                    calculatingStep = this.desiredSpeedStep;
                    calculated = true;
                }
            } else {
                if ((calculatingStep -= calculatedStepInc) < this._throttle.getSpeedIncrement()) {
                    calculatingStep = 0.0f;
                    calculated = true;
                    timePerStep = 0;
                }
                if (calculatingStep < this.desiredSpeedStep) {
                    calculatingStep = this.desiredSpeedStep;
                    calculated = true;
                }
            }
            log.debug("Speed Step current {} speed to set {}", (Object)Float.valueOf(this._throttle.getSpeedSetting()), (Object)Float.valueOf(calculatingStep));
            SpeedSetting ss = new SpeedSetting(calculatingStep, timePerStep);
            RosterSpeedProfile rosterSpeedProfile = this;
            synchronized (rosterSpeedProfile) {
                this.stepQueue.addLast(ss);
            }
            if (this.stopTimer == null) {
                this.setNextStep();
            }
            if (this._throttle != null) {
                calculatedDistance -= this.getDistanceTravelled(this._throttle.getIsForward(), calculatingStep, (float)((double)timePerStep / 1000.0));
            } else {
                log.warn("Throttle destroyed before zero length[{}] remaining.", (Object)Float.valueOf(calculatedDistance));
                calculatedDistance = 0.0f;
            }
            if (!(calculatedDistance < 0.0f) || calculated) continue;
            log.error("distance remaining is now 0, but we have not reached desired speed setting {} v {}", (Object)Float.valueOf(this.desiredSpeedStep), (Object)Float.valueOf(calculatingStep));
            ss = new SpeedSetting(this.desiredSpeedStep, 10);
            rosterSpeedProfile = this;
            synchronized (rosterSpeedProfile) {
                this.stepQueue.addLast(ss);
            }
            calculated = true;
        }
    }

    float calculateInitialOverRun(float distance) {
        log.debug("Stop timer not configured so will add overrun {}", (Object)Float.valueOf(distance));
        if (this._throttle.getIsForward()) {
            float extraAsDouble = (this.getOverRunTimeForward() + this.extraDelay) / 1000.0f;
            if (log.isDebugEnabled()) {
                log.debug("Over run time to remove (Forward) {}", (Object)Float.valueOf(this.getOverRunTimeForward()));
                log.debug("{}", (Object)Float.valueOf(extraAsDouble));
            }
            float olddistance = this.getDistanceTravelled(true, this._throttle.getSpeedSetting(), extraAsDouble);
            distance -= olddistance;
        } else {
            float extraAsDouble = (this.getOverRunTimeReverse() + this.extraDelay) / 1000.0f;
            if (log.isDebugEnabled()) {
                log.debug("Over run time to remove (Reverse) {}", (Object)Float.valueOf(this.getOverRunTimeReverse()));
                log.debug("{}", (Object)Float.valueOf(extraAsDouble));
            }
            float olddistance = this.getDistanceTravelled(false, this._throttle.getSpeedSetting(), extraAsDouble);
            distance -= olddistance;
        }
        log.debug("Distance remaining {}", (Object)Float.valueOf(distance));
        return distance;
    }

    void stopLocoTimeOut(DccThrottle t) {
        log.debug("Stopping loco");
        t.setSpeedSetting(0.0f);
    }

    public void cancelSpeedChange() {
        if (this.stopTimer != null && this.stopTimer.isRunning()) {
            this.stopTimer.stop();
        }
        this.finishChange();
    }

    synchronized void setNextStep() {
        if (this.stepQueue.isEmpty()) {
            log.debug("No more results");
            this.finishChange();
            return;
        }
        SpeedSetting ss = this.stepQueue.getFirst();
        if (ss.getDuration() == 0) {
            this._throttle.setSpeedSetting(0.0f);
            this.finishChange();
            return;
        }
        if (this.stopTimer != null) {
            float distanceTravelledThisStep = this.getDistanceTravelled(this._throttle.getIsForward(), this._throttle.getSpeedSetting(), (float)((double)this.stopTimer.getDelay() / 1000.0));
            this.distanceTravelled += distanceTravelledThisStep;
            this.distanceRemaining -= distanceTravelledThisStep;
        }
        this.stepQueue.removeFirst();
        this._throttle.setSpeedSetting(ss.getSpeedStep());
        this.stopTimer = new Timer(ss.getDuration(), e -> this.setNextStep());
        this.stopTimer.setRepeats(false);
        this.lastTimeTimerStarted = System.nanoTime();
        this.stopTimer.start();
    }

    public void store(Element e) {
        Element d = new Element("speedprofile");
        d.addContent((Content)new Element("overRunTimeForward").addContent(Float.toString(this.getOverRunTimeForward())));
        d.addContent((Content)new Element("overRunTimeReverse").addContent(Float.toString(this.getOverRunTimeReverse())));
        Element s = new Element("speeds");
        this.speeds.keySet().stream().forEachOrdered(i -> {
            Element ss = new Element("speed");
            ss.addContent((Content)new Element("step").addContent(Integer.toString(i)));
            ss.addContent((Content)new Element("forward").addContent(Float.toString(this.speeds.get(i).getForwardSpeed())));
            ss.addContent((Content)new Element("reverse").addContent(Float.toString(this.speeds.get(i).getReverseSpeed())));
            s.addContent((Content)ss);
        });
        d.addContent((Content)s);
        e.addContent((Content)d);
    }

    public void load(Element e) {
        try {
            this.setOverRunTimeForward(Float.parseFloat(e.getChild("overRunTimeForward").getText()));
        }
        catch (NumberFormatException numberFormatException) {
            log.error("Over run Error For {}", (Object)this._re.getId());
        }
        try {
            this.setOverRunTimeReverse(Float.parseFloat(e.getChild("overRunTimeReverse").getText()));
        }
        catch (NumberFormatException numberFormatException) {
            log.error("Over Run Error Rev {}", (Object)this._re.getId());
        }
        e.getChild("speeds").getChildren("speed").forEach(spd -> {
            try {
                float reverseSpeed;
                String step = spd.getChild("step").getText();
                String forward = spd.getChild("forward").getText();
                String reverse = spd.getChild("reverse").getText();
                float forwardSpeed = Float.parseFloat(forward);
                if (forwardSpeed > 0.0f) {
                    this._hasForwardSpeeds = true;
                }
                if ((reverseSpeed = Float.parseFloat(reverse)) > 0.0f) {
                    this._hasReverseSpeeds = true;
                }
                this.setSpeed(Integer.parseInt(step), forwardSpeed, reverseSpeed);
            }
            catch (NumberFormatException ex) {
                log.error("Not loaded {}", (Object)ex.getMessage());
            }
        });
    }

    public int getProfileSize() {
        return this.speeds.size();
    }

    public TreeMap<Integer, SpeedStep> getProfileSpeeds() {
        return this.speeds;
    }

    public float getThrottleSetting(float speed, boolean isForward) {
        float value;
        float fasterValue;
        float fasterKey;
        if (isForward && !this._hasForwardSpeeds || !isForward && !this._hasReverseSpeeds) {
            return 0.0f;
        }
        int slowerKey = 0;
        float slowerValue = 0.0f;
        Map.Entry<Integer, SpeedStep> entry = this.speeds.firstEntry();
        if (entry == null) {
            log.warn("There is no speedprofile entries for [{}]", (Object)this.getRosterEntry().getId());
            return 0.0f;
        }
        if (isForward) {
            fasterKey = entry.getKey().intValue();
            fasterValue = entry.getValue().getForwardSpeed();
            while (entry != null && entry.getValue().getForwardSpeed() < speed) {
                slowerKey = entry.getKey();
                value = entry.getValue().getForwardSpeed();
                if (value > 0.0f) {
                    slowerValue = value;
                }
                if ((entry = this.speeds.higherEntry(slowerKey)) == null) continue;
                fasterKey = entry.getKey().intValue();
                value = entry.getValue().getForwardSpeed();
                if (!(value > 0.0f)) continue;
                fasterValue = value;
            }
        } else {
            fasterKey = entry.getKey().intValue();
            fasterValue = entry.getValue().getReverseSpeed();
            while (entry != null && entry.getValue().getReverseSpeed() < speed) {
                slowerKey = entry.getKey();
                value = entry.getValue().getReverseSpeed();
                if (value > 0.0f) {
                    slowerValue = value;
                }
                if ((entry = this.speeds.higherEntry(slowerKey)) == null) continue;
                fasterKey = entry.getKey().intValue();
                value = entry.getValue().getReverseSpeed();
                if (!(value > 0.0f)) continue;
                fasterValue = value;
            }
        }
        log.debug("slowerKey={}, slowerValue={} fasterKey={} fasterValue={} for speed={}", new Object[]{slowerKey, Float.valueOf(slowerValue), Float.valueOf(fasterKey), Float.valueOf(fasterValue), Float.valueOf(speed)});
        if (entry == null) {
            if (slowerValue <= 0.0f) {
                return 0.0f;
            }
            float key = (float)slowerKey * speed / slowerValue;
            if (key < 1000.0f) {
                return key / 1000.0f;
            }
            return 1.0f;
        }
        if (Float.compare(slowerValue, speed) == 0 || fasterValue <= slowerValue) {
            return (float)slowerKey / 1000.0f;
        }
        if (slowerValue <= 0.0f) {
            slowerKey = 0;
            if (fasterValue <= 0.0f) {
                return 0.0f;
            }
        }
        float ratio = (speed - slowerValue) / (fasterValue - slowerValue);
        float setting = ((float)slowerKey + (fasterKey - (float)slowerKey) * ratio) / 1000.0f;
        return setting;
    }

    public float getSpeed(float speedStep, boolean isForward) {
        if (speedStep < 1.0E-5f) {
            return 0.0f;
        }
        float speed = isForward ? this.getForwardSpeed(speedStep) : this.getReverseSpeed(speedStep);
        return speed;
    }

    static class SpeedSetting {
        float step = 0.0f;
        int duration = 0;

        SpeedSetting(float step, int duration) {
            this.step = step;
            this.duration = duration;
        }

        float getSpeedStep() {
            return this.step;
        }

        int getDuration() {
            return this.duration;
        }
    }

    public static class SpeedStep {
        float forward = 0.0f;
        float reverse = 0.0f;

        public void setForwardSpeed(float speed) {
            this.forward = speed;
        }

        public void setReverseSpeed(float speed) {
            this.reverse = speed;
        }

        public float getForwardSpeed() {
            return this.forward;
        }

        public float getReverseSpeed() {
            return this.reverse;
        }
    }
}

