/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.roster;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import jmri.jmrit.roster.Roster;
import jmri.jmrit.roster.RosterEntry;
import jmri.util.swing.EditableResizableImagePanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RosterMediaPane
extends JPanel {
    JLabel _imageFPlabel = new JLabel();
    EditableResizableImagePanel _imageFilePath;
    JLabel _iconFPlabel = new JLabel();
    EditableResizableImagePanel _iconFilePath;
    JLabel _URLlabel = new JLabel();
    JTextField _URL = new JTextField(30);
    RosterAttributesTableModel rosterAttributesModel;
    final ResourceBundle rb = ResourceBundle.getBundle("jmri.jmrit.roster.JmritRosterBundle");
    private static final Logger log = LoggerFactory.getLogger(RosterMediaPane.class);

    public RosterMediaPane() {
    }

    public RosterMediaPane(RosterEntry r) {
        this._imageFilePath = new EditableResizableImagePanel(r.getImagePath(), 320, 240);
        this._imageFilePath.setDropFolder(Roster.getDefault().getRosterFilesLocation());
        this._imageFilePath.setToolTipText(this.rb.getString("MediaRosterImageToolTip"));
        this._imageFilePath.setBorder(BorderFactory.createLineBorder(Color.blue));
        this._imageFPlabel.setText(this.rb.getString("MediaRosterImageLabel"));
        this._iconFilePath = new EditableResizableImagePanel(r.getIconPath(), 160, 120);
        this._iconFilePath.setDropFolder(Roster.getDefault().getRosterFilesLocation());
        this._iconFilePath.setToolTipText(this.rb.getString("MediaRosterIconToolTip"));
        this._iconFilePath.setBorder(BorderFactory.createLineBorder(Color.blue));
        this._iconFPlabel.setText(this.rb.getString("MediaRosterIconLabel"));
        this._URL.setText(r.getURL());
        this._URL.setToolTipText(this.rb.getString("MediaRosterURLToolTip"));
        this._URLlabel.setText(this.rb.getString("MediaRosterURLLabel"));
        this.rosterAttributesModel = new RosterAttributesTableModel(r);
        JTable jtAttributes = new JTable();
        jtAttributes.setModel(this.rosterAttributesModel);
        JScrollPane jsp = new JScrollPane(jtAttributes);
        jtAttributes.setFillsViewportHeight(true);
        JPanel mediap = new JPanel();
        GridBagLayout gbLayout = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        Dimension textFieldDim = new Dimension(320, 20);
        Dimension imageFieldDim = new Dimension(320, 200);
        Dimension iconFieldDim = new Dimension(160, 100);
        Dimension tableDim = new Dimension(400, 200);
        mediap.setLayout(gbLayout);
        gbc.insets = new Insets(0, 8, 0, 8);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbLayout.setConstraints(this._imageFPlabel, gbc);
        mediap.add(this._imageFPlabel);
        gbc.gridx = 1;
        gbc.gridy = 0;
        this._imageFilePath.setMinimumSize(imageFieldDim);
        this._imageFilePath.setMaximumSize(imageFieldDim);
        this._imageFilePath.setPreferredSize(imageFieldDim);
        gbLayout.setConstraints(this._imageFilePath, gbc);
        mediap.add(this._imageFilePath);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbLayout.setConstraints(this._iconFPlabel, gbc);
        mediap.add(this._iconFPlabel);
        gbc.gridx = 1;
        gbc.gridy = 2;
        this._iconFilePath.setMinimumSize(iconFieldDim);
        this._iconFilePath.setMaximumSize(iconFieldDim);
        this._iconFilePath.setPreferredSize(iconFieldDim);
        gbLayout.setConstraints(this._iconFilePath, gbc);
        mediap.add(this._iconFilePath);
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbLayout.setConstraints(this._URLlabel, gbc);
        mediap.add(this._URLlabel);
        gbc.gridx = 1;
        gbc.gridy = 4;
        this._URL.setMinimumSize(textFieldDim);
        this._URL.setPreferredSize(textFieldDim);
        gbLayout.setConstraints(this._URL, gbc);
        mediap.add(this._URL);
        this.setLayout(new BorderLayout());
        this.add((Component)mediap, "North");
        this.add((Component)new JLabel(this.rb.getString("MediaRosterAttributeTableDescription")), "Center");
        jsp.setMinimumSize(tableDim);
        jsp.setMaximumSize(tableDim);
        jsp.setPreferredSize(tableDim);
        this.add((Component)jsp, "South");
    }

    public boolean guiChanged(RosterEntry r) {
        if (!r.getURL().equals(this._URL.getText())) {
            return true;
        }
        if (r.getImagePath() != null && !r.getImagePath().equals(this._imageFilePath.getImagePath()) || r.getImagePath() == null && this._imageFilePath.getImagePath() != null) {
            return true;
        }
        if (r.getIconPath() != null && !r.getIconPath().equals(this._iconFilePath.getImagePath()) || r.getIconPath() == null && this._iconFilePath.getImagePath() != null) {
            return true;
        }
        return this.rosterAttributesModel.wasModified();
    }

    public void update(RosterEntry r) {
        r.setURL(this._URL.getText());
        r.setImagePath(this._imageFilePath.getImagePath());
        r.setIconPath(this._iconFilePath.getImagePath());
        this.rosterAttributesModel.updateModel(r);
    }

    public void dispose() {
        if (log.isDebugEnabled()) {
            log.debug("dispose");
        }
    }

    private class RosterAttributesTableModel
    extends AbstractTableModel {
        Vector<KeyValueModel> attributes;
        String[] titles;
        boolean wasModified;

        public RosterAttributesTableModel(RosterEntry r) {
            this.setModel(r);
            this.titles = new String[2];
            this.titles[0] = RosterMediaPane.this.rb.getString("MediaRosterAttributeName");
            this.titles[1] = RosterMediaPane.this.rb.getString("MediaRosterAttributeValue");
        }

        public void setModel(RosterEntry r) {
            this.attributes = new Vector(r.getAttributes().size());
            for (String key : r.getAttributes()) {
                this.attributes.add(new KeyValueModel(key, r.getAttribute(key)));
            }
            this.wasModified = false;
        }

        public void updateModel(RosterEntry r) {
            for (KeyValueModel kv : this.attributes) {
                if (kv.key.length() <= 0 || r.getAttribute(kv.key) != null && kv.value.compareTo(r.getAttribute(kv.key)) == 0) continue;
                r.putAttribute(kv.key, kv.value);
            }
            Iterator<String> ite = r.getAttributes().iterator();
            while (ite.hasNext()) {
                if (this.keyExist(ite.next())) continue;
                ite.remove();
            }
            this.wasModified = false;
        }

        private boolean keyExist(String k) {
            if (k == null) {
                return false;
            }
            for (KeyValueModel attribute : this.attributes) {
                if (k.compareTo(attribute.key) != 0) continue;
                return true;
            }
            return false;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.attributes.size() + 1;
        }

        @Override
        public String getColumnName(int col) {
            return this.titles[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (row < this.attributes.size()) {
                if (col == 0) {
                    return this.attributes.get((int)row).key;
                }
                if (col == 1) {
                    return this.attributes.get((int)row).value;
                }
            }
            return "...";
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            KeyValueModel kv = row < this.attributes.size() ? this.attributes.get(row) : new KeyValueModel("", "");
            if (col == 0) {
                if (!this.keyExist(((String)value).replaceAll("\\s", ""))) {
                    kv.key = ((String)value).replaceAll("\\s", "");
                } else {
                    this.setValueAt(value + "-1", row, col);
                    return;
                }
            }
            if (col == 1) {
                kv.value = (String)value;
            }
            if (row < this.attributes.size()) {
                this.attributes.set(row, kv);
            } else {
                this.attributes.add(row, kv);
            }
            if (col == 0 && kv.key.compareTo("") == 0) {
                this.attributes.remove(row);
            }
            this.wasModified = true;
            this.fireTableCellUpdated(row, col);
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return true;
        }

        public boolean wasModified() {
            return this.wasModified;
        }

        private class KeyValueModel {
            public String key;
            public String value;

            public KeyValueModel(String k, String v) {
                this.key = k;
                this.value = v;
            }
        }
    }
}

