/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.roster;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import jmri.DccLocoAddress;
import jmri.InstanceManager;
import jmri.LocoAddress;
import jmri.ThrottleManager;
import jmri.jmrit.DccLocoAddressSelector;
import jmri.jmrit.decoderdefn.DecoderFile;
import jmri.jmrit.decoderdefn.DecoderIndexFile;
import jmri.jmrit.roster.Roster;
import jmri.jmrit.roster.RosterEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RosterEntryPane
extends JPanel {
    JTextField id = new JTextField(30);
    JTextField roadName = new JTextField(30);
    JTextField maxSpeed = new JTextField(3);
    JSpinner maxSpeedSpinner = new JSpinner();
    JTextField roadNumber = new JTextField(30);
    JTextField mfg = new JTextField(30);
    JTextField model = new JTextField(30);
    JTextField owner = new JTextField(30);
    DccLocoAddressSelector addrSel = new DccLocoAddressSelector();
    JTextArea comment = new JTextArea(3, 50);
    JScrollPane commentScroller = new JScrollPane(this.comment, 22, 32);
    JLabel dateUpdated = new JLabel();
    JLabel decoderModel = new JLabel();
    JLabel decoderFamily = new JLabel();
    JTextArea decoderComment = new JTextArea(3, 50);
    JScrollPane decoderCommentScroller = new JScrollPane(this.decoderComment, 22, 32);
    Component pane;
    RosterEntry re;
    final ResourceBundle rb = ResourceBundle.getBundle("jmri.jmrit.roster.JmritRosterBundle");
    double maxSet;
    private static final Logger log = LoggerFactory.getLogger(RosterEntryPane.class);

    public RosterEntryPane(RosterEntry r) {
        ThrottleManager tm;
        ArrayList<LocoAddress.Protocol> protocoltypes;
        this.maxSpeedSpinner.setModel(new SpinnerNumberModel(1.0, 0.0, 1.0, 0.01));
        this.maxSpeedSpinner.setEditor(new JSpinner.NumberEditor(this.maxSpeedSpinner, "# %"));
        this.id.setText(r.getId());
        if (r.getDccAddress().equals("")) {
            this.addrSel.reset();
        } else {
            DccLocoAddress tempAddr = new DccLocoAddress(Integer.parseInt(r.getDccAddress()), r.getProtocol());
            this.addrSel.setAddress(tempAddr);
        }
        this.updateGUI(r);
        this.pane = this;
        this.re = r;
        this.id.setToolTipText(this.rb.getString("ToolTipID"));
        this.addrSel.setEnabled(false);
        this.addrSel.setLocked(false);
        if (!(InstanceManager.getNullableDefault(ThrottleManager.class) == null || InstanceManager.throttleManagerInstance().addressTypeUnique() || (protocoltypes = new ArrayList<LocoAddress.Protocol>(Arrays.asList((tm = InstanceManager.throttleManagerInstance()).getAddressProtocolTypes()))).contains((Object)LocoAddress.Protocol.DCC_LONG) || protocoltypes.contains((Object)LocoAddress.Protocol.DCC_SHORT))) {
            DecoderFile d;
            List<DecoderFile> l = InstanceManager.getDefault(DecoderIndexFile.class).matchingDecoderList(null, r.getDecoderFamily(), null, null, null, r.getDecoderModel());
            if (log.isDebugEnabled()) {
                log.debug("found {} matched", (Object)l.size());
            }
            if (l.isEmpty()) {
                log.debug("Loco uses {} {} decoder, but no such decoder defined", (Object)this.decoderFamily, (Object)this.decoderModel);
                l = InstanceManager.getDefault(DecoderIndexFile.class).matchingDecoderList(null, null, null, null, null, r.getDecoderModel());
                if (log.isDebugEnabled()) {
                    log.debug("found {} matches without family key", (Object)l.size());
                }
            }
            if (l.size() > 0 && (d = l.get(0)) != null && d.getSupportedProtocols().length > 0) {
                ArrayList<String> protocols = new ArrayList<String>(d.getSupportedProtocols().length);
                LocoAddress.Protocol[] protocolArray = d.getSupportedProtocols();
                int n = protocolArray.length;
                int n2 = 0;
                while (n2 < n) {
                    LocoAddress.Protocol i = protocolArray[n2];
                    if (protocoltypes.contains((Object)i)) {
                        protocols.add(tm.getAddressTypeString(i));
                    }
                    ++n2;
                }
                this.addrSel = new DccLocoAddressSelector(protocols.toArray(new String[protocols.size()]));
                DccLocoAddress tempAddr = new DccLocoAddress(Integer.parseInt(r.getDccAddress()), r.getProtocol());
                this.addrSel.setAddress(tempAddr);
                this.addrSel.setEnabled(false);
                this.addrSel.setLocked(false);
                this.addrSel.setEnabledProtocol(true);
            }
        }
        JPanel selPanel = this.addrSel.getCombinedJPanel();
        selPanel.setToolTipText(this.rb.getString("ToolTipDccAddress"));
        this.decoderModel.setToolTipText(this.rb.getString("ToolTipDecoderModel"));
        this.decoderFamily.setToolTipText(this.rb.getString("ToolTipDecoderFamily"));
        this.dateUpdated.setToolTipText(this.rb.getString("ToolTipDateUpdated"));
        this.id.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (RosterEntryPane.this.checkDuplicate()) {
                    JOptionPane.showMessageDialog(RosterEntryPane.this.pane, RosterEntryPane.this.rb.getString("ErrorDuplicateID"));
                }
            }
        });
        GridBagLayout gbLayout = new GridBagLayout();
        GridBagConstraints cL = new GridBagConstraints();
        GridBagConstraints cR = new GridBagConstraints();
        Dimension minFieldDim = new Dimension(150, 20);
        Dimension minScrollerDim = new Dimension(165, 42);
        super.setLayout(gbLayout);
        cL.gridx = 0;
        cL.gridy = 0;
        cL.ipadx = 3;
        cL.anchor = 18;
        cL.insets = new Insets(0, 0, 0, 15);
        JLabel row0Label = new JLabel(String.valueOf(this.rb.getString("FieldID")) + ":");
        gbLayout.setConstraints(row0Label, cL);
        super.add(row0Label);
        cR.gridx = 1;
        cR.gridy = 0;
        cR.anchor = 17;
        this.id.setMinimumSize(minFieldDim);
        gbLayout.setConstraints(this.id, cR);
        super.add(this.id);
        ++cL.gridy;
        JLabel row1Label = new JLabel(String.valueOf(this.rb.getString("FieldRoadName")) + ":");
        gbLayout.setConstraints(row1Label, cL);
        super.add(row1Label);
        cR.gridy = cL.gridy++;
        this.roadName.setMinimumSize(minFieldDim);
        gbLayout.setConstraints(this.roadName, cR);
        super.add(this.roadName);
        JLabel row2Label = new JLabel(String.valueOf(this.rb.getString("FieldRoadNumber")) + ":");
        gbLayout.setConstraints(row2Label, cL);
        super.add(row2Label);
        cR.gridy = cL.gridy++;
        this.roadNumber.setMinimumSize(minFieldDim);
        gbLayout.setConstraints(this.roadNumber, cR);
        super.add(this.roadNumber);
        JLabel row3Label = new JLabel(String.valueOf(this.rb.getString("FieldManufacturer")) + ":");
        gbLayout.setConstraints(row3Label, cL);
        super.add(row3Label);
        cR.gridy = cL.gridy++;
        this.mfg.setMinimumSize(minFieldDim);
        gbLayout.setConstraints(this.mfg, cR);
        super.add(this.mfg);
        JLabel row4Label = new JLabel(String.valueOf(this.rb.getString("FieldOwner")) + ":");
        gbLayout.setConstraints(row4Label, cL);
        super.add(row4Label);
        cR.gridy = cL.gridy++;
        this.owner.setMinimumSize(minFieldDim);
        gbLayout.setConstraints(this.owner, cR);
        super.add(this.owner);
        JLabel row5Label = new JLabel(String.valueOf(this.rb.getString("FieldModel")) + ":");
        gbLayout.setConstraints(row5Label, cL);
        super.add(row5Label);
        cR.gridy = cL.gridy++;
        this.model.setMinimumSize(minFieldDim);
        gbLayout.setConstraints(this.model, cR);
        super.add(this.model);
        JLabel row6Label = new JLabel(String.valueOf(this.rb.getString("FieldDCCAddress")) + ":");
        gbLayout.setConstraints(row6Label, cL);
        super.add(row6Label);
        cR.gridy = cL.gridy++;
        gbLayout.setConstraints(selPanel, cR);
        super.add(selPanel);
        JLabel row7Label = new JLabel(String.valueOf(this.rb.getString("FieldSpeedLimit")) + ":");
        gbLayout.setConstraints(row7Label, cL);
        super.add(row7Label);
        cR.gridy = cL.gridy++;
        gbLayout.setConstraints(this.maxSpeedSpinner, cR);
        super.add(this.maxSpeedSpinner);
        JLabel row8Label = new JLabel(String.valueOf(this.rb.getString("FieldComment")) + ":");
        gbLayout.setConstraints(row8Label, cL);
        super.add(row8Label);
        cR.gridy = cL.gridy++;
        this.commentScroller.setMinimumSize(minScrollerDim);
        gbLayout.setConstraints(this.commentScroller, cR);
        super.add(this.commentScroller);
        JLabel row9Label = new JLabel(String.valueOf(this.rb.getString("FieldDecoderFamily")) + ":");
        gbLayout.setConstraints(row9Label, cL);
        super.add(row9Label);
        cR.gridy = cL.gridy++;
        this.decoderFamily.setMinimumSize(minFieldDim);
        gbLayout.setConstraints(this.decoderFamily, cR);
        super.add(this.decoderFamily);
        JLabel row10Label = new JLabel(String.valueOf(this.rb.getString("FieldDecoderModel")) + ":");
        gbLayout.setConstraints(row10Label, cL);
        super.add(row10Label);
        cR.gridy = cL.gridy++;
        this.decoderModel.setMinimumSize(minFieldDim);
        gbLayout.setConstraints(this.decoderModel, cR);
        super.add(this.decoderModel);
        JLabel row11Label = new JLabel(String.valueOf(this.rb.getString("FieldDecoderComment")) + ":");
        gbLayout.setConstraints(row11Label, cL);
        super.add(row11Label);
        cR.gridy = cL.gridy++;
        this.decoderCommentScroller.setMinimumSize(minScrollerDim);
        gbLayout.setConstraints(this.decoderCommentScroller, cR);
        super.add(this.decoderCommentScroller);
        JLabel row13Label = new JLabel(String.valueOf(this.rb.getString("FieldDateUpdated")) + ":");
        gbLayout.setConstraints(row13Label, cL);
        super.add(row13Label);
        cR.gridy = cL.gridy;
        this.dateUpdated.setMinimumSize(minFieldDim);
        gbLayout.setConstraints(this.dateUpdated, cR);
        super.add(this.dateUpdated);
    }

    public boolean guiChanged(RosterEntry r) {
        if (!r.getRoadName().equals(this.roadName.getText())) {
            return true;
        }
        if (!r.getRoadNumber().equals(this.roadNumber.getText())) {
            return true;
        }
        if (!r.getMfg().equals(this.mfg.getText())) {
            return true;
        }
        if (!r.getOwner().equals(this.owner.getText())) {
            return true;
        }
        if (!r.getModel().equals(this.model.getText())) {
            return true;
        }
        if (!r.getComment().equals(this.comment.getText())) {
            return true;
        }
        if (!r.getDecoderFamily().equals(this.decoderFamily.getText())) {
            return true;
        }
        if (!r.getDecoderModel().equals(this.decoderModel.getText())) {
            return true;
        }
        if (!r.getDecoderComment().equals(this.decoderComment.getText())) {
            return true;
        }
        if (!r.getId().equals(this.id.getText())) {
            return true;
        }
        this.maxSet = (Double)this.maxSpeedSpinner.getValue();
        if (r.getMaxSpeedPCT() != (int)Math.round(100.0 * this.maxSet)) {
            log.debug("check: {}|{}", (Object)r.getMaxSpeedPCT(), (Object)((int)Math.round(100.0 * this.maxSet)));
            return true;
        }
        DccLocoAddress a = this.addrSel.getAddress();
        if (a == null) {
            return !r.getDccAddress().equals("");
        }
        if (r.getProtocol() != a.getProtocol()) {
            return true;
        }
        return !r.getDccAddress().equals("" + a.getNumber());
    }

    public boolean checkDuplicate() {
        List<RosterEntry> l = Roster.getDefault().matchingList(null, null, null, null, null, null, this.id.getText());
        boolean oops = false;
        for (RosterEntry rosterEntry : l) {
            if (this.re == rosterEntry) continue;
            oops = true;
            break;
        }
        return oops;
    }

    public void update(RosterEntry r) {
        r.setId(this.id.getText());
        r.setRoadName(this.roadName.getText());
        r.setRoadNumber(this.roadNumber.getText());
        r.setMfg(this.mfg.getText());
        r.setOwner(this.owner.getText());
        r.setModel(this.model.getText());
        DccLocoAddress a = this.addrSel.getAddress();
        if (a != null) {
            r.setDccAddress("" + a.getNumber());
            r.setProtocol(a.getProtocol());
        }
        r.setComment(this.comment.getText());
        this.maxSet = (Double)this.maxSpeedSpinner.getValue();
        log.debug("maxSet saved: {}", (Object)this.maxSet);
        r.setMaxSpeedPCT((int)Math.round(100.0 * this.maxSet));
        log.debug("maxSet read from config: {}", (Object)r.getMaxSpeedPCT());
        r.setDecoderFamily(this.decoderFamily.getText());
        r.setDecoderModel(this.decoderModel.getText());
        r.setDecoderComment(this.decoderComment.getText());
    }

    public void updateGUI(RosterEntry r) {
        this.roadName.setText(r.getRoadName());
        this.roadNumber.setText(r.getRoadNumber());
        this.mfg.setText(r.getMfg());
        this.owner.setText(r.getOwner());
        this.model.setText(r.getModel());
        this.comment.setText(r.getComment());
        this.decoderModel.setText(r.getDecoderModel());
        this.decoderFamily.setText(r.getDecoderFamily());
        this.decoderComment.setText(r.getDecoderComment());
        this.dateUpdated.setText(r.getDateModified() != null ? DateFormat.getDateTimeInstance().format(r.getDateModified()) : r.getDateUpdated());
        double maxSpeedSet = (double)r.getMaxSpeedPCT() / 100.0;
        log.debug("Max Speed set to: {}", (Object)maxSpeedSet);
        this.maxSpeedSpinner.setValue(maxSpeedSet);
        log.debug("Max Speed in spinner: {}", this.maxSpeedSpinner.getValue());
    }

    public void setDccAddress(String a) {
        DccLocoAddress addr = this.addrSel.getAddress();
        LocoAddress.Protocol protocol = addr.getProtocol();
        try {
            this.addrSel.setAddress(new DccLocoAddress(Integer.parseInt(a), protocol));
        }
        catch (NumberFormatException numberFormatException) {
            log.error("Can't set DccAddress to {}", (Object)a);
        }
    }

    public void setDccAddressLong(boolean m) {
        DccLocoAddress addr = this.addrSel.getAddress();
        int n = 0;
        if (addr != null) {
            if (addr.getProtocol() != LocoAddress.Protocol.DCC_LONG && addr.getProtocol() != LocoAddress.Protocol.DCC_SHORT && addr.getProtocol() != LocoAddress.Protocol.DCC) {
                return;
            }
            n = addr.getNumber();
        }
        this.addrSel.setAddress(new DccLocoAddress(n, m));
    }

    public void dispose() {
        log.debug("dispose");
    }
}

