/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.roster;

import com.fasterxml.jackson.databind.util.StdDateFormat;
import java.awt.HeadlessException;
import java.awt.Image;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Writer;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import jmri.BasicRosterEntry;
import jmri.DccLocoAddress;
import jmri.InstanceManager;
import jmri.LocoAddress;
import jmri.ThrottleManager;
import jmri.beans.ArbitraryBean;
import jmri.configurexml.LocoAddressXml;
import jmri.jmrit.roster.Bundle;
import jmri.jmrit.roster.LocoFile;
import jmri.jmrit.roster.Roster;
import jmri.jmrit.roster.RosterConfigManager;
import jmri.jmrit.roster.RosterObject;
import jmri.jmrit.roster.RosterSpeedProfile;
import jmri.jmrit.roster.rostergroup.RosterGroup;
import jmri.jmrit.symbolicprog.CvTableModel;
import jmri.jmrit.symbolicprog.VariableTableModel;
import jmri.util.FileUtil;
import jmri.util.StringUtil;
import jmri.util.davidflanagan.HardcopyWriter;
import jmri.util.jdom.LocaleSelector;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RosterEntry
extends ArbitraryBean
implements RosterObject,
BasicRosterEntry {
    public static final String ID = "id";
    public static final String FILENAME = "filename";
    public static final String ROADNAME = "roadname";
    public static final String MFG = "mfg";
    public static final String MODEL = "model";
    public static final String OWNER = "owner";
    public static final String DCC_ADDRESS = "dccaddress";
    public static final String LONG_ADDRESS = "longaddress";
    public static final String PROTOCOL = "protocol";
    public static final String COMMENT = "comment";
    public static final String DECODER_MODEL = "decodermodel";
    public static final String DECODER_DEVELOPERID = "developerID";
    public static final String DECODER_MANUFACTURERID = "manufacturerID";
    public static final String DECODER_PRODUCTID = "productID";
    public static final String DECODER_FAMILY = "decoderfamily";
    public static final String DECODER_COMMENT = "decodercomment";
    public static final String DECODER_MAXFNNUM = "decodermaxFnNum";
    public static final String DEFAULT_MAXFNNUM = "28";
    public static final String IMAGE_FILE_PATH = "imagefilepath";
    public static final String ICON_FILE_PATH = "iconfilepath";
    public static final String URL = "url";
    public static final String DATE_UPDATED = "dateupdated";
    public static final String FUNCTION_IMAGE = "functionImage";
    public static final String FUNCTION_LABEL = "functionlabel";
    public static final String FUNCTION_LOCKABLE = "functionLockable";
    public static final String FUNCTION_SELECTED_IMAGE = "functionSelectedImage";
    public static final String ATTRIBUTE_UPDATED = "attributeUpdated:";
    public static final String ATTRIBUTE_DELETED = "attributeDeleted";
    public static final String MAX_SPEED = "maxSpeed";
    public static final String SHUNTING_FUNCTION = "IsShuntingOn";
    public static final String SPEED_PROFILE = "speedprofile";
    public static final String SOUND_LABEL = "soundlabel";
    protected String _fileName = null;
    protected String _id = "";
    protected String _roadName = "";
    protected String _roadNumber = "";
    protected String _mfg = "";
    protected String _owner = "";
    protected String _model = "";
    protected String _dccAddress = "3";
    protected LocoAddress.Protocol _protocol = LocoAddress.Protocol.DCC_SHORT;
    protected String _comment = "";
    protected String _decoderModel = "";
    protected String _decoderFamily = "";
    protected String _decoderComment = "";
    protected String _maxFnNum = "28";
    protected String _dateUpdated = "";
    protected Date dateModified = null;
    protected int _maxSpeedPCT = 100;
    protected String _developerID = "";
    protected String _manufacturerID = "";
    protected String _productID = "";
    @Deprecated
    public static final int MAXFNNUM = Integer.parseInt("28");
    protected Map<Integer, String> functionLabels;
    protected Map<Integer, String> soundLabels;
    protected Map<Integer, String> functionSelectedImages;
    protected Map<Integer, String> functionImages;
    protected Map<Integer, Boolean> functionLockables;
    protected String _isShuntingOn = "";
    protected final TreeMap<String, String> attributePairs = new TreeMap();
    protected String _imageFilePath = null;
    protected String _iconFilePath = null;
    protected String _URL = "";
    protected RosterSpeedProfile _sp = null;
    int openCounter = 0;
    boolean loadedOnce = false;
    boolean soundLoadedOnce = false;
    private Element mRootElement = null;
    private int blanks = 0;
    private int textSpaceWithIcon = 0;
    String indent = "                      ";
    int indentWidth = this.indent.length();
    String newLine = "\n";
    private static final Logger log = LoggerFactory.getLogger(RosterEntry.class);

    public int getMAXFNNUM() {
        return Integer.parseInt(this.getMaxFnNum());
    }

    public RosterEntry() {
        this.functionLabels = Collections.synchronizedMap(new HashMap());
        this.soundLabels = Collections.synchronizedMap(new HashMap());
        this.functionSelectedImages = Collections.synchronizedMap(new HashMap());
        this.functionImages = Collections.synchronizedMap(new HashMap());
        this.functionLockables = Collections.synchronizedMap(new HashMap());
    }

    public RosterEntry(String fileName) {
        this();
        this._fileName = fileName;
    }

    public RosterEntry(RosterEntry pEntry, String pID) {
        this();
        this._id = pID;
        this._fileName = null;
        this._roadName = pEntry._roadName;
        this._roadNumber = pEntry._roadNumber;
        this._mfg = pEntry._mfg;
        this._model = pEntry._model;
        this._dccAddress = pEntry._dccAddress;
        this._protocol = pEntry._protocol;
        this._comment = pEntry._comment;
        this._decoderModel = pEntry._decoderModel;
        this._decoderFamily = pEntry._decoderFamily;
        this._developerID = pEntry._developerID;
        this._manufacturerID = pEntry._manufacturerID;
        this._productID = pEntry._productID;
        this._decoderComment = pEntry._decoderComment;
        this._owner = pEntry._owner;
        this._imageFilePath = pEntry._imageFilePath;
        this._iconFilePath = pEntry._iconFilePath;
        this._URL = pEntry._URL;
        this._maxSpeedPCT = pEntry._maxSpeedPCT;
        this._isShuntingOn = pEntry._isShuntingOn;
        if (pEntry.functionLabels != null) {
            pEntry.functionLabels.forEach((key, value) -> {
                if (value != null) {
                    this.functionLabels.put((Integer)key, (String)value);
                }
            });
        }
        if (pEntry.soundLabels != null) {
            pEntry.soundLabels.forEach((key, value) -> {
                if (value != null) {
                    this.soundLabels.put((Integer)key, (String)value);
                }
            });
        }
        if (pEntry.functionSelectedImages != null) {
            pEntry.functionSelectedImages.forEach((key, value) -> {
                if (value != null) {
                    this.functionSelectedImages.put((Integer)key, (String)value);
                }
            });
        }
        if (pEntry.functionImages != null) {
            pEntry.functionImages.forEach((key, value) -> {
                if (value != null) {
                    this.functionImages.put((Integer)key, (String)value);
                }
            });
        }
        if (pEntry.functionLockables != null) {
            pEntry.functionLockables.forEach((key, value) -> {
                if (value != null) {
                    this.functionLockables.put((Integer)key, (Boolean)value);
                }
            });
        }
    }

    public void setId(String s) {
        String oldID = this._id;
        this._id = s;
        if (oldID == null || !oldID.equals(s)) {
            this.firePropertyChange(ID, oldID, s);
        }
    }

    @Override
    public String getId() {
        return this._id;
    }

    public void setFileName(String s) {
        String oldName = this._fileName;
        this._fileName = s;
        this.firePropertyChange(FILENAME, oldName, s);
    }

    public String getFileName() {
        return this._fileName;
    }

    public String getPathName() {
        return String.valueOf(Roster.getDefault().getRosterFilesLocation()) + this._fileName;
    }

    public void ensureFilenameExists() {
        if (this.getFileName() == null || this.getFileName().isEmpty()) {
            String newFilename = Roster.makeValidFilename(this.getId());
            File testFile = new File(String.valueOf(Roster.getDefault().getRosterFilesLocation()) + newFilename);
            int count = 0;
            String oldFilename = newFilename;
            while (testFile.exists()) {
                newFilename = String.valueOf(oldFilename.substring(0, oldFilename.length() - 4)) + count + ".xml";
                ++count;
                log.debug("try to use {} as filename instead of {}", (Object)newFilename, (Object)oldFilename);
                testFile = new File(String.valueOf(Roster.getDefault().getRosterFilesLocation()) + newFilename);
            }
            this.setFileName(newFilename);
            log.debug("new filename: {}", (Object)this.getFileName());
        }
    }

    public void setRoadName(String s) {
        String old = this._roadName;
        this._roadName = s;
        this.firePropertyChange(ROADNAME, old, s);
    }

    public String getRoadName() {
        return this._roadName;
    }

    public void setRoadNumber(String s) {
        String old = this._roadNumber;
        this._roadNumber = s;
        this.firePropertyChange(ROADNAME, old, s);
    }

    public String getRoadNumber() {
        return this._roadNumber;
    }

    public void setMfg(String s) {
        String old = this._mfg;
        this._mfg = s;
        this.firePropertyChange(MFG, old, s);
    }

    public String getMfg() {
        return this._mfg;
    }

    public void setModel(String s) {
        String old = this._model;
        this._model = s;
        this.firePropertyChange(MODEL, old, s);
    }

    public String getModel() {
        return this._model;
    }

    public void setOwner(String s) {
        String old = this._owner;
        this._owner = s;
        this.firePropertyChange(OWNER, old, s);
    }

    public String getOwner() {
        RosterConfigManager manager;
        if (this._owner.isEmpty() && (manager = InstanceManager.getNullableDefault(RosterConfigManager.class)) != null) {
            this._owner = manager.getDefaultOwner();
        }
        return this._owner;
    }

    public void setDccAddress(String s) {
        String old = this._dccAddress;
        this._dccAddress = s;
        this.firePropertyChange(DCC_ADDRESS, old, s);
    }

    @Override
    public String getDccAddress() {
        return this._dccAddress;
    }

    public void setLongAddress(boolean b) {
        boolean old = false;
        if (this._protocol == LocoAddress.Protocol.DCC_LONG) {
            old = true;
        }
        this._protocol = b ? LocoAddress.Protocol.DCC_LONG : LocoAddress.Protocol.DCC_SHORT;
        this.firePropertyChange(LONG_ADDRESS, old, b);
    }

    public RosterSpeedProfile getSpeedProfile() {
        return this._sp;
    }

    public void setSpeedProfile(RosterSpeedProfile sp) {
        if (sp.getRosterEntry() != this) {
            log.error("Attempting to set a speed profile against the wrong roster entry");
            return;
        }
        RosterSpeedProfile old = this._sp;
        this._sp = sp;
        this.firePropertyChange(SPEED_PROFILE, old, this._sp);
    }

    @Override
    public boolean isLongAddress() {
        return this._protocol == LocoAddress.Protocol.DCC_LONG;
    }

    public void setProtocol(LocoAddress.Protocol protocol) {
        LocoAddress.Protocol old = this._protocol;
        this._protocol = protocol;
        this.firePropertyChange(PROTOCOL, (Object)old, (Object)this._protocol);
    }

    public LocoAddress.Protocol getProtocol() {
        return this._protocol;
    }

    public String getProtocolAsString() {
        return this._protocol.getPeopleName();
    }

    public void setComment(String s) {
        String old = this._comment;
        this._comment = s;
        this.firePropertyChange(COMMENT, old, s);
    }

    public String getComment() {
        return this._comment;
    }

    public void setDecoderModel(String s) {
        String old = this._decoderModel;
        this._decoderModel = s;
        this.firePropertyChange(DECODER_MODEL, old, s);
    }

    public String getDecoderModel() {
        return this._decoderModel;
    }

    public void setDeveloperID(String s) {
        String old = this._developerID;
        this._developerID = s;
        this.firePropertyChange(DECODER_DEVELOPERID, old, s);
    }

    public String getDeveloperID() {
        return this._developerID;
    }

    public void setManufacturerID(String s) {
        String old = this._manufacturerID;
        this._manufacturerID = s;
        this.firePropertyChange(DECODER_MANUFACTURERID, old, s);
    }

    public String getManufacturerID() {
        return this._manufacturerID;
    }

    public void setProductID(String s) {
        String old = this._productID;
        if (s == null) {
            s = "";
        }
        this._productID = s;
        this.firePropertyChange(DECODER_PRODUCTID, old, s);
    }

    public String getProductID() {
        return this._productID;
    }

    public void setDecoderFamily(String s) {
        String old = this._decoderFamily;
        this._decoderFamily = s;
        this.firePropertyChange(DECODER_FAMILY, old, s);
    }

    public String getDecoderFamily() {
        return this._decoderFamily;
    }

    public void setDecoderComment(String s) {
        String old = this._decoderComment;
        this._decoderComment = s;
        this.firePropertyChange(DECODER_COMMENT, old, s);
    }

    public String getDecoderComment() {
        return this._decoderComment;
    }

    public void setMaxFnNum(String s) {
        String old = this._maxFnNum;
        this._maxFnNum = s;
        this.firePropertyChange(DECODER_MAXFNNUM, old, s);
    }

    public String getMaxFnNum() {
        return this._maxFnNum;
    }

    @Override
    public DccLocoAddress getDccLocoAddress() {
        int n;
        try {
            n = Integer.parseInt(this.getDccAddress());
        }
        catch (NumberFormatException numberFormatException) {
            log.error("Illegal format for DCC address roster entry: \"{}\" value: \"{}\"", (Object)this.getId(), (Object)this.getDccAddress());
            n = 0;
        }
        return new DccLocoAddress(n, this._protocol);
    }

    public void setImagePath(String s) {
        String old = this._imageFilePath;
        this._imageFilePath = s;
        this.firePropertyChange(IMAGE_FILE_PATH, old, s);
    }

    public String getImagePath() {
        return this._imageFilePath;
    }

    public void setIconPath(String s) {
        String old = this._iconFilePath;
        this._iconFilePath = s;
        this.firePropertyChange(ICON_FILE_PATH, old, s);
    }

    public String getIconPath() {
        return this._iconFilePath;
    }

    public void setShuntingFunction(String fn) {
        String old = this._isShuntingOn;
        this._isShuntingOn = fn;
        this.firePropertyChange(SHUNTING_FUNCTION, old, this._isShuntingOn);
    }

    @Override
    public String getShuntingFunction() {
        return this._isShuntingOn;
    }

    public void setURL(String s) {
        String old = this._URL;
        this._URL = s;
        this.firePropertyChange(URL, old, s);
    }

    public String getURL() {
        return this._URL;
    }

    public void setDateModified(@Nonnull Date date) {
        Date old = this.dateModified;
        this.dateModified = date;
        this.firePropertyChange(DATE_UPDATED, old, date);
    }

    public void setDateModified(@Nonnull String date) throws ParseException {
        try {
            this.setDateModified(new StdDateFormat().parse(date));
        }
        catch (ParseException parseException) {
            log.debug("ParseException in setDateModified ISO attempt: \"{}\"", (Object)date);
            try {
                this.setDateModified(DateFormat.getDateTimeInstance().parse(date));
            }
            catch (ParseException parseException2) {
                SimpleDateFormat customFmt = new SimpleDateFormat("MMM dd, yyyy hh:mm:ss a");
                try {
                    this.setDateModified(customFmt.parse(date));
                }
                catch (ParseException parseException3) {
                    customFmt = new SimpleDateFormat("dd-MMM-yyyy hh:mm:ss");
                    this.setDateModified(customFmt.parse(date));
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            log.error("IllegalArgumentException in RosterEntry.setDateModified - this may indicate a problem with the classpath, specifically multiple copies of the 'jackson` library. See release notes");
            this.setDateModified(DateFormat.getDateTimeInstance().parse(date));
        }
    }

    @CheckForNull
    public Date getDateModified() {
        return this.dateModified;
    }

    protected void setDateUpdated(String s) {
        String old = this._dateUpdated;
        this._dateUpdated = s;
        try {
            this.setDateModified(s);
        }
        catch (ParseException parseException) {
            log.warn("Unable to parse \"{}\" as a date in roster entry \"{}\".", (Object)s, (Object)this.getId());
            this.firePropertyChange(DATE_UPDATED, old, s);
        }
    }

    public String getDateUpdated() {
        Date date = this.getDateModified();
        if (date == null) {
            return this._dateUpdated;
        }
        return new StdDateFormat().format(date);
    }

    @Override
    public void setOpen(boolean boo) {
        this.openCounter = boo ? ++this.openCounter : --this.openCounter;
        if (this.openCounter < 0) {
            this.openCounter = 0;
        }
    }

    @Override
    public boolean isOpen() {
        return this.openCounter != 0;
    }

    public RosterEntry(Element e) {
        Element d;
        Element e3;
        Attribute a;
        this.functionLabels = Collections.synchronizedMap(new HashMap());
        this.soundLabels = Collections.synchronizedMap(new HashMap());
        this.functionSelectedImages = Collections.synchronizedMap(new HashMap());
        this.functionImages = Collections.synchronizedMap(new HashMap());
        this.functionLockables = Collections.synchronizedMap(new HashMap());
        if (log.isDebugEnabled()) {
            log.debug("ctor from element {}", (Object)e);
        }
        if ((a = e.getAttribute(ID)) != null) {
            this._id = a.getValue();
        } else {
            log.warn("no id attribute in locomotive element when reading roster");
        }
        a = e.getAttribute("fileName");
        if (a != null) {
            this._fileName = a.getValue();
        }
        if ((a = e.getAttribute("roadName")) != null) {
            this._roadName = a.getValue();
        }
        if ((a = e.getAttribute("roadNumber")) != null) {
            this._roadNumber = a.getValue();
        }
        if ((a = e.getAttribute(OWNER)) != null) {
            this._owner = a.getValue();
        }
        if ((a = e.getAttribute(MFG)) != null) {
            this._mfg = a.getValue();
        }
        if ((a = e.getAttribute(MODEL)) != null) {
            this._model = a.getValue();
        }
        if ((a = e.getAttribute("dccAddress")) != null) {
            this._dccAddress = a.getValue();
        }
        if ((a = e.getAttribute("imageFilePath")) != null && !a.getValue().isEmpty()) {
            try {
                if (FileUtil.getFile(a.getValue()).isFile()) {
                    this._imageFilePath = FileUtil.getAbsoluteFilename(a.getValue());
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                try {
                    if (FileUtil.getFile(String.valueOf(FileUtil.getUserResourcePath()) + a.getValue()).isFile()) {
                        this._imageFilePath = String.valueOf(FileUtil.getUserResourcePath()) + a.getValue();
                    }
                }
                catch (FileNotFoundException fileNotFoundException2) {
                    this._imageFilePath = null;
                }
            }
        }
        if ((a = e.getAttribute("iconFilePath")) != null && !a.getValue().isEmpty()) {
            try {
                if (FileUtil.getFile(a.getValue()).isFile()) {
                    this._iconFilePath = FileUtil.getAbsoluteFilename(a.getValue());
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                try {
                    if (FileUtil.getFile(String.valueOf(FileUtil.getUserResourcePath()) + a.getValue()).isFile()) {
                        this._iconFilePath = String.valueOf(FileUtil.getUserResourcePath()) + a.getValue();
                    }
                }
                catch (FileNotFoundException fileNotFoundException3) {
                    this._iconFilePath = null;
                }
            }
        }
        if ((a = e.getAttribute("URL")) != null) {
            this._URL = a.getValue();
        }
        if ((a = e.getAttribute(SHUNTING_FUNCTION)) != null) {
            this._isShuntingOn = a.getValue();
        }
        if ((a = e.getAttribute(MAX_SPEED)) != null) {
            this._maxSpeedPCT = Integer.parseInt(a.getValue());
        }
        if ((a = e.getAttribute(DECODER_DEVELOPERID)) != null) {
            this._developerID = a.getValue();
        }
        if ((a = e.getAttribute(DECODER_MANUFACTURERID)) != null) {
            this._manufacturerID = a.getValue();
        }
        if ((a = e.getAttribute(DECODER_PRODUCTID)) != null) {
            this._productID = a.getValue();
        }
        if ((e3 = e.getChild("dateUpdated")) != null) {
            this.setDateUpdated(e3.getText());
        }
        if ((e3 = e.getChild("locoaddress")) != null) {
            DccLocoAddress la = (DccLocoAddress)new LocoAddressXml().getAddress(e3);
            if (la != null) {
                this._dccAddress = "" + la.getNumber();
                this._protocol = la.getProtocol();
            } else {
                this._dccAddress = "";
                this._protocol = LocoAddress.Protocol.DCC_SHORT;
            }
        } else {
            int address;
            ThrottleManager tf = InstanceManager.getNullableDefault(ThrottleManager.class);
            try {
                address = Integer.parseInt(this._dccAddress);
            }
            catch (NumberFormatException numberFormatException) {
                address = 3;
            }
            if (tf != null && tf.canBeLongAddress(address) && !tf.canBeShortAddress(address)) {
                this._protocol = LocoAddress.Protocol.DCC_LONG;
            } else if (tf != null && !tf.canBeLongAddress(address) && tf.canBeShortAddress(address)) {
                this._protocol = LocoAddress.Protocol.DCC_SHORT;
            } else {
                this.warnShortLong(this._id);
                this._protocol = LocoAddress.Protocol.DCC_SHORT;
            }
        }
        a = e.getAttribute(COMMENT);
        if (a != null) {
            this._comment = a.getValue();
        }
        if ((d = e.getChild("decoder")) != null) {
            a = d.getAttribute(MODEL);
            if (a != null) {
                this._decoderModel = a.getValue();
            }
            if ((a = d.getAttribute("family")) != null) {
                this._decoderFamily = a.getValue();
            }
            if ((a = d.getAttribute(DECODER_DEVELOPERID)) != null) {
                this._developerID = a.getValue();
            }
            if ((a = d.getAttribute(DECODER_MANUFACTURERID)) != null) {
                this._manufacturerID = a.getValue();
            }
            if ((a = d.getAttribute(DECODER_PRODUCTID)) != null) {
                this._productID = a.getValue();
            }
            if ((a = d.getAttribute(COMMENT)) != null) {
                this._decoderComment = a.getValue();
            }
            if ((a = d.getAttribute("maxFnNum")) != null) {
                this._maxFnNum = a.getValue();
            }
        }
        this.loadFunctions(e.getChild("functionlabels"), "RosterEntry");
        this.loadSounds(e.getChild("soundlabels"), "RosterEntry");
        this.loadAttributes(e.getChild("attributepairs"));
        if (e.getChild(SPEED_PROFILE) != null) {
            this._sp = new RosterSpeedProfile(this);
            this._sp.load(e.getChild(SPEED_PROFILE));
        }
    }

    public void loadFunctions(Element e3) {
        this.loadFunctions(e3, "family");
    }

    public void loadFunctions(Element e3, String source) {
        if (this.loadedOnce) {
            return;
        }
        if (e3 != null) {
            List l = e3.getChildren(FUNCTION_LABEL);
            for (Element fn : l) {
                int num = Integer.parseInt(fn.getAttribute("num").getValue());
                String lock = fn.getAttribute("lockable").getValue();
                String val = LocaleSelector.getAttribute(fn, "text");
                if (val == null) {
                    val = fn.getText();
                }
                if (this.getFunctionLabel(num) != null && !source.equalsIgnoreCase(MODEL)) continue;
                this.setFunctionLabel(num, val);
                this.setFunctionLockable(num, lock.equals("true"));
                Attribute a = fn.getAttribute(FUNCTION_IMAGE);
                if (a != null && !a.getValue().isEmpty()) {
                    try {
                        if (FileUtil.getFile(a.getValue()).isFile()) {
                            this.setFunctionImage(num, FileUtil.getAbsoluteFilename(a.getValue()));
                        }
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        try {
                            if (FileUtil.getFile(String.valueOf(FileUtil.getUserResourcePath()) + a.getValue()).isFile()) {
                                this.setFunctionImage(num, String.valueOf(FileUtil.getUserResourcePath()) + a.getValue());
                            }
                        }
                        catch (FileNotFoundException fileNotFoundException2) {
                            this.setFunctionImage(num, null);
                        }
                    }
                }
                if ((a = fn.getAttribute("functionImageSelected")) == null || a.getValue().isEmpty()) continue;
                try {
                    if (!FileUtil.getFile(a.getValue()).isFile()) continue;
                    this.setFunctionSelectedImage(num, FileUtil.getAbsoluteFilename(a.getValue()));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    try {
                        if (!FileUtil.getFile(String.valueOf(FileUtil.getUserResourcePath()) + a.getValue()).isFile()) continue;
                        this.setFunctionSelectedImage(num, String.valueOf(FileUtil.getUserResourcePath()) + a.getValue());
                    }
                    catch (FileNotFoundException fileNotFoundException3) {
                        this.setFunctionSelectedImage(num, null);
                    }
                }
            }
        }
        if (source.equalsIgnoreCase("RosterEntry")) {
            this.loadedOnce = true;
        }
    }

    public void loadSounds(Element e3, String source) {
        if (this.soundLoadedOnce) {
            return;
        }
        if (e3 != null) {
            List l = e3.getChildren(SOUND_LABEL);
            for (Element fn : l) {
                int num = Integer.parseInt(fn.getAttribute("num").getValue());
                String val = LocaleSelector.getAttribute(fn, "text");
                if (val == null) {
                    val = fn.getText();
                }
                if (this.getSoundLabel(num) != null && !source.equalsIgnoreCase(MODEL)) continue;
                this.setSoundLabel(num, val);
            }
        }
        if (source.equalsIgnoreCase("RosterEntry")) {
            this.soundLoadedOnce = true;
        }
    }

    public void loadAttributes(Element e3) {
        if (e3 != null) {
            List l = e3.getChildren("keyvaluepair");
            for (Element fn : l) {
                String key = fn.getChild("key").getText();
                String value = fn.getChild("value").getText();
                this.putAttribute(key, value);
            }
        }
    }

    public void setFunctionLabel(int fn, String label) {
        if (this.functionLabels == null) {
            this.functionLabels = Collections.synchronizedMap(new HashMap());
        }
        String old = this.functionLabels.get(fn);
        this.functionLabels.put(fn, label);
        this.firePropertyChange(FUNCTION_LABEL + fn, old, label);
    }

    public String getFunctionLabel(int fn) {
        if (this.functionLabels == null) {
            return null;
        }
        return this.functionLabels.get(fn);
    }

    public void setSoundLabel(int fn, String label) {
        if (this.soundLabels == null) {
            this.soundLabels = Collections.synchronizedMap(new HashMap());
        }
        String old = this.soundLabels.get(fn);
        this.soundLabels.put(fn, label);
        this.firePropertyChange(SOUND_LABEL + fn, old, label);
    }

    public String getSoundLabel(int fn) {
        if (this.soundLabels == null) {
            return null;
        }
        return this.soundLabels.get(fn);
    }

    public void setFunctionImage(int fn, String s) {
        if (this.functionImages == null) {
            this.functionImages = Collections.synchronizedMap(new HashMap());
        }
        String old = this.functionImages.get(fn);
        this.functionImages.put(fn, s);
        this.firePropertyChange(FUNCTION_IMAGE + fn, old, s);
    }

    public String getFunctionImage(int fn) {
        if (this.functionImages == null) {
            return null;
        }
        return this.functionImages.get(fn);
    }

    public void setFunctionSelectedImage(int fn, String s) {
        if (this.functionSelectedImages == null) {
            this.functionSelectedImages = Collections.synchronizedMap(new HashMap());
        }
        String old = this.functionSelectedImages.get(fn);
        this.functionSelectedImages.put(fn, s);
        this.firePropertyChange(FUNCTION_SELECTED_IMAGE + fn, old, s);
    }

    public String getFunctionSelectedImage(int fn) {
        if (this.functionSelectedImages == null) {
            return null;
        }
        return this.functionSelectedImages.get(fn);
    }

    public void setFunctionLockable(int fn, boolean lockable) {
        if (this.functionLockables == null) {
            this.functionLockables = Collections.synchronizedMap(new HashMap());
            this.functionLockables.put(fn, true);
        }
        boolean old = this.functionLockables.get(fn) != null ? this.functionLockables.get(fn) : true;
        this.functionLockables.put(fn, lockable);
        this.firePropertyChange(FUNCTION_LOCKABLE + fn, old, lockable);
    }

    public boolean getFunctionLockable(int fn) {
        if (this.functionLockables == null) {
            return true;
        }
        return this.functionLockables.get(fn) != null ? this.functionLockables.get(fn) : true;
    }

    @Override
    public void putAttribute(String key, String value) {
        String oldValue = this.getAttribute(key);
        this.attributePairs.put(key, value);
        this.firePropertyChange(ATTRIBUTE_UPDATED + key, oldValue, value);
    }

    @Override
    public String getAttribute(String key) {
        return this.attributePairs.get(key);
    }

    @Override
    public void deleteAttribute(String key) {
        if (this.attributePairs.containsKey(key)) {
            this.attributePairs.remove(key);
            this.firePropertyChange(ATTRIBUTE_DELETED, key, null);
        }
    }

    public Set<String> getAttributes() {
        return this.attributePairs.keySet();
    }

    @Override
    public String[] getAttributeList() {
        return this.attributePairs.keySet().toArray(new String[this.attributePairs.size()]);
    }

    public List<RosterGroup> getGroups() {
        return this.getGroups(Roster.getDefault());
    }

    public List<RosterGroup> getGroups(Roster roster) {
        ArrayList<RosterGroup> groups = new ArrayList<RosterGroup>();
        if (!this.getAttributes().isEmpty()) {
            for (String attribute : this.getAttributes()) {
                if (!attribute.startsWith("RosterGroup:")) continue;
                String name = attribute.substring("RosterGroup:".length());
                if (roster.getRosterGroups().containsKey(name)) {
                    groups.add(roster.getRosterGroups().get(name));
                    continue;
                }
                groups.add(new RosterGroup(name));
            }
        }
        return groups;
    }

    @Override
    public int getMaxSpeedPCT() {
        return this._maxSpeedPCT;
    }

    public void setMaxSpeedPCT(int maxSpeedPCT) {
        int old = this._maxSpeedPCT;
        this._maxSpeedPCT = maxSpeedPCT;
        this.firePropertyChange(MAX_SPEED, old, this._maxSpeedPCT);
    }

    protected void warnShortLong(String id) {
        log.warn("Roster entry \"{}\" should be saved again to store the short/long address value", (Object)id);
    }

    @Override
    public Element store() {
        Element s;
        Element e = new Element("locomotive");
        e.setAttribute(ID, this.getId());
        e.setAttribute("fileName", this.getFileName());
        e.setAttribute("roadNumber", this.getRoadNumber());
        e.setAttribute("roadName", this.getRoadName());
        e.setAttribute(MFG, this.getMfg());
        e.setAttribute(OWNER, this.getOwner());
        e.setAttribute(MODEL, this.getModel());
        e.setAttribute("dccAddress", this.getDccAddress());
        e.setAttribute(COMMENT, this.getComment());
        e.setAttribute(DECODER_DEVELOPERID, this.getDeveloperID());
        e.setAttribute(DECODER_MANUFACTURERID, this.getManufacturerID());
        e.setAttribute(DECODER_PRODUCTID, this.getProductID());
        e.setAttribute(MAX_SPEED, Integer.toString(this.getMaxSpeedPCT()));
        e.setAttribute("imageFilePath", this.getImagePath() != null ? FileUtil.getPortableFilename(this.getImagePath()) : "");
        e.setAttribute("iconFilePath", this.getIconPath() != null ? FileUtil.getPortableFilename(this.getIconPath()) : "");
        e.setAttribute("URL", this.getURL());
        e.setAttribute(SHUNTING_FUNCTION, this.getShuntingFunction());
        if (this._dateUpdated.isEmpty()) {
            this.changeDateUpdated();
        }
        e.addContent((Content)new Element("dateUpdated").addContent(this.getDateUpdated()));
        Element d = new Element("decoder");
        d.setAttribute(MODEL, this.getDecoderModel());
        d.setAttribute("family", this.getDecoderFamily());
        d.setAttribute(COMMENT, this.getDecoderComment());
        d.setAttribute("maxFnNum", this.getMaxFnNum());
        e.addContent((Content)d);
        if (this._dccAddress.isEmpty()) {
            e.addContent((Content)new LocoAddressXml().store(null));
        } else {
            e.addContent((Content)new LocoAddressXml().store(new DccLocoAddress(Integer.parseInt(this._dccAddress), this._protocol)));
        }
        if (this.functionLabels != null) {
            s = new Element("functionlabels");
            this.functionLabels.forEach((key, value) -> {
                if (value != null && !value.isEmpty()) {
                    Element fne = new Element(FUNCTION_LABEL);
                    fne.setAttribute("num", "" + key);
                    fne.setAttribute("lockable", this.getFunctionLockable((int)key) ? "true" : "false");
                    fne.setAttribute(FUNCTION_IMAGE, this.getFunctionImage((int)key) != null ? FileUtil.getPortableFilename(this.getFunctionImage((int)key)) : "");
                    fne.setAttribute("functionImageSelected", this.getFunctionSelectedImage((int)key) != null ? FileUtil.getPortableFilename(this.getFunctionSelectedImage((int)key)) : "");
                    fne.addContent(value);
                    s.addContent((Content)fne);
                }
            });
            e.addContent((Content)s);
        }
        if (this.soundLabels != null) {
            s = new Element("soundlabels");
            this.soundLabels.forEach((key, value) -> {
                if (value != null && !value.isEmpty()) {
                    Element fne = new Element(SOUND_LABEL);
                    fne.setAttribute("num", "" + key);
                    fne.addContent(value);
                    s.addContent((Content)fne);
                }
            });
            e.addContent((Content)s);
        }
        if (!this.getAttributes().isEmpty()) {
            d = new Element("attributepairs");
            for (String key2 : this.getAttributes()) {
                d.addContent((Content)new Element("keyvaluepair").addContent((Content)new Element("key").addContent(key2)).addContent((Content)new Element("value").addContent(this.getAttribute(key2))));
            }
            e.addContent((Content)d);
        }
        if (this._sp != null) {
            this._sp.store(e);
        }
        return e;
    }

    @Override
    public String titleString() {
        return this.getId();
    }

    @Override
    public String toString() {
        String out = "[RosterEntry: " + this._id + " " + (this._fileName != null ? this._fileName : "<null>") + " " + this._roadName + " " + this._roadNumber + " " + this._mfg + " " + this._owner + " " + this._model + " " + this._dccAddress + " " + this._comment + " " + this._decoderModel + " " + this._decoderFamily + " " + this._developerID + " " + this._manufacturerID + " " + this._productID + " " + this._decoderComment + "]";
        return out;
    }

    public void updateFile() {
        LocoFile df = new LocoFile();
        String fullFilename = String.valueOf(Roster.getDefault().getRosterFilesLocation()) + this.getFileName();
        try {
            this.mRootElement = df.rootFromName(fullFilename);
        }
        catch (IOException | JDOMException e) {
            log.error("Exception while loading loco XML file: {} exception: {}", (Object)this.getFileName(), (Object)e);
        }
        try {
            File f = new File(fullFilename);
            df.makeBackupFile(String.valueOf(Roster.getDefault().getRosterFilesLocation()) + this.getFileName());
            df.writeFile(f, this.mRootElement, this.store());
        }
        catch (Exception e) {
            log.error("error during locomotive file output", (Throwable)e);
            try {
                JOptionPane.showMessageDialog(null, String.valueOf(Bundle.getMessage("ErrorSavingText")) + "\n" + e.getMessage(), Bundle.getMessage("ErrorSavingTitle"), 0);
            }
            catch (HeadlessException headlessException) {}
        }
    }

    public void writeFile(CvTableModel cvModel, VariableTableModel variableModel) {
        LocoFile df = new LocoFile();
        FileUtil.createDirectory(Roster.getDefault().getRosterFilesLocation());
        try {
            String fullFilename = String.valueOf(Roster.getDefault().getRosterFilesLocation()) + this.getFileName();
            File f = new File(fullFilename);
            df.makeBackupFile(String.valueOf(Roster.getDefault().getRosterFilesLocation()) + this.getFileName());
            this.changeDateUpdated();
            df.writeFile(f, cvModel, variableModel, this);
        }
        catch (Exception e) {
            log.error("error during locomotive file output", (Throwable)e);
            try {
                JOptionPane.showMessageDialog(null, String.valueOf(Bundle.getMessage("ErrorSavingText")) + "\n" + e.getMessage(), Bundle.getMessage("ErrorSavingTitle"), 0);
            }
            catch (HeadlessException headlessException) {}
        }
    }

    public void changeDateUpdated() {
        this.setDateModified(new Date());
    }

    public void loadCvModel(VariableTableModel varModel, CvTableModel cvModel) {
        if (cvModel == null) {
            log.error("loadCvModel must be given a non-null argument");
            return;
        }
        if (this.mRootElement == null) {
            log.error("loadCvModel called before readFile() succeeded");
            return;
        }
        try {
            if (varModel != null) {
                LocoFile.loadVariableModel(this.mRootElement.getChild("locomotive"), varModel);
            }
            LocoFile.loadCvModel(this.mRootElement.getChild("locomotive"), cvModel, this.getDecoderFamily());
        }
        catch (Exception ex) {
            log.error("Error reading roster entry", (Throwable)ex);
            try {
                JOptionPane.showMessageDialog(null, String.valueOf(Bundle.getMessage("ErrorReadingText")) + "\n" + this._fileName, Bundle.getMessage("ErrorReadingTitle"), 0);
            }
            catch (HeadlessException headlessException) {}
        }
    }

    public void printEntryLine(HardcopyWriter w) {
        try {
            String thisText = "";
            String thisLine = "";
            w.write(this.newLine, 0, 1);
            int colWidth = 15;
            if (this._id != null) {
                thisText = String.format("%-" + colWidth + "s", this._id.substring(0, Math.min(this._id.length(), colWidth)));
                log.debug("thisText = |{}|, length = {}", (Object)thisText, (Object)thisText.length());
            } else {
                thisText = String.format("%-" + colWidth + "s", "<null>");
            }
            thisLine = String.valueOf(thisLine) + thisText;
            colWidth = 6;
            thisLine = String.valueOf(thisLine) + StringUtil.padString(this._dccAddress, colWidth);
            colWidth = 6;
            thisLine = String.valueOf(thisLine) + StringUtil.padString(this._roadName, colWidth);
            colWidth = 6;
            thisLine = String.valueOf(thisLine) + StringUtil.padString(this._roadNumber, colWidth);
            colWidth = 6;
            thisLine = String.valueOf(thisLine) + StringUtil.padString(this._mfg, colWidth);
            colWidth = 10;
            thisLine = String.valueOf(thisLine) + StringUtil.padString(this._model, colWidth);
            colWidth = 10;
            thisLine = String.valueOf(thisLine) + StringUtil.padString(this._decoderModel, colWidth);
            colWidth = 12;
            thisLine = String.valueOf(thisLine) + StringUtil.padString(this._protocol.toString(), colWidth);
            colWidth = 6;
            thisLine = String.valueOf(thisLine) + StringUtil.padString(this._owner, colWidth);
            colWidth = 10;
            if (this.dateModified != null) {
                DateFormat.getDateTimeInstance().format(this.dateModified);
                thisText = String.format("%-" + colWidth + "s", this.dateModified.toString().substring(0, Math.min(this.dateModified.toString().length(), colWidth)));
                thisLine = String.valueOf(thisLine) + thisText;
            }
            w.write(thisLine);
        }
        catch (IOException e) {
            log.error("Error printing RosterEntry: ", (Throwable)e);
        }
    }

    public void printEntry(HardcopyWriter w) {
        if (this.getIconPath() != null) {
            ImageIcon icon = new ImageIcon(this.getIconPath());
            int imagesize = 150;
            Image img = icon.getImage();
            int width = img.getWidth(null);
            int height = img.getHeight(null);
            double widthratio = (double)width / (double)imagesize;
            double heightratio = (double)height / (double)imagesize;
            double ratio = Math.max(widthratio, heightratio);
            width = (int)((double)width / ratio);
            height = (int)((double)height / ratio);
            Image newImg = img.getScaledInstance(width, height, 4);
            ImageIcon newIcon = new ImageIcon(newImg);
            w.writeNoScale(newIcon.getImage(), new JLabel(newIcon));
            this.blanks = (newImg.getHeight(null) - w.getLineAscent()) / w.getLineHeight();
            this.textSpaceWithIcon = w.getCharactersPerLine() - newImg.getWidth(null) / w.getCharWidth() - this.indentWidth - 1;
        }
        this.printEntryDetails(w);
    }

    public void printEntryDetails(Writer w) {
        if (!(w instanceof HardcopyWriter)) {
            throw new IllegalArgumentException("No HardcopyWriter instance passed");
        }
        int linesadded = -1;
        String leftMargin = "   ";
        int labelColumn = 19;
        try {
            HardcopyWriter ww = (HardcopyWriter)w;
            int textSpace = ww.getCharactersPerLine() - this.indentWidth - 1;
            String title = String.format("%-" + labelColumn + "s", Bundle.getMessage("MakeLabel", Bundle.getMessage("FieldID")));
            linesadded = this.textSpaceWithIcon != 0 && linesadded < this.blanks ? this.writeWrappedComment(w, this._id, String.valueOf(leftMargin) + title, this.textSpaceWithIcon) + linesadded : this.writeWrappedComment(w, this._id, String.valueOf(leftMargin) + title, textSpace) + linesadded;
            title = String.format("%-" + labelColumn + "s", Bundle.getMessage("MakeLabel", Bundle.getMessage("FieldFilename")));
            linesadded = this.textSpaceWithIcon != 0 && linesadded < this.blanks ? this.writeWrappedComment(w, this._fileName != null ? this._fileName : "<null>", String.valueOf(leftMargin) + title, this.textSpaceWithIcon) + linesadded : this.writeWrappedComment(w, this._fileName != null ? this._fileName : "<null>", String.valueOf(leftMargin) + title, textSpace) + linesadded;
            if (!this._roadName.isEmpty()) {
                title = String.format("%-" + labelColumn + "s", Bundle.getMessage("MakeLabel", Bundle.getMessage("FieldRoadName")));
                linesadded = this.textSpaceWithIcon != 0 && linesadded < this.blanks ? this.writeWrappedComment(w, this._roadName, String.valueOf(leftMargin) + title, this.textSpaceWithIcon) + linesadded : this.writeWrappedComment(w, this._roadName, String.valueOf(leftMargin) + title, textSpace) + linesadded;
            }
            if (!this._roadNumber.isEmpty()) {
                title = String.format("%-" + labelColumn + "s", Bundle.getMessage("MakeLabel", Bundle.getMessage("FieldRoadNumber")));
                linesadded = this.textSpaceWithIcon != 0 && linesadded < this.blanks ? this.writeWrappedComment(w, this._roadNumber, String.valueOf(leftMargin) + title, this.textSpaceWithIcon) + linesadded : this.writeWrappedComment(w, this._roadNumber, String.valueOf(leftMargin) + title, textSpace) + linesadded;
            }
            if (!this._mfg.isEmpty()) {
                title = String.format("%-" + labelColumn + "s", Bundle.getMessage("MakeLabel", Bundle.getMessage("FieldManufacturer")));
                linesadded = this.textSpaceWithIcon != 0 && linesadded < this.blanks ? this.writeWrappedComment(w, this._mfg, String.valueOf(leftMargin) + title, this.textSpaceWithIcon) + linesadded : this.writeWrappedComment(w, this._mfg, String.valueOf(leftMargin) + title, textSpace) + linesadded;
            }
            if (!this._owner.isEmpty()) {
                title = String.format("%-" + labelColumn + "s", Bundle.getMessage("MakeLabel", Bundle.getMessage("FieldOwner")));
                linesadded = this.textSpaceWithIcon != 0 && linesadded < this.blanks ? this.writeWrappedComment(w, this._owner, String.valueOf(leftMargin) + title, this.textSpaceWithIcon) + linesadded : this.writeWrappedComment(w, this._owner, String.valueOf(leftMargin) + title, textSpace) + linesadded;
            }
            if (!this._model.isEmpty()) {
                title = String.format("%-" + labelColumn + "s", Bundle.getMessage("MakeLabel", Bundle.getMessage("FieldModel")));
                linesadded = this.textSpaceWithIcon != 0 && linesadded < this.blanks ? this.writeWrappedComment(w, this._model, String.valueOf(leftMargin) + title, this.textSpaceWithIcon) + linesadded : this.writeWrappedComment(w, this._model, String.valueOf(leftMargin) + title, textSpace) + linesadded;
            }
            if (!this._dccAddress.isEmpty()) {
                w.write(this.newLine, 0, 1);
                title = String.format("%-" + labelColumn + "s", Bundle.getMessage("MakeLabel", Bundle.getMessage("FieldDCCAddress")));
                String s = String.valueOf(leftMargin) + title + this._dccAddress;
                w.write(s, 0, s.length());
                ++linesadded;
            }
            if (!this._comment.isEmpty()) {
                int i = 0;
                while (i < this.blanks - linesadded) {
                    w.write(this.newLine, 0, 1);
                    ++i;
                }
                if (this.blanks != 0) {
                    this.blanks = 0;
                }
                title = String.format("%-" + labelColumn + "s", Bundle.getMessage("MakeLabel", Bundle.getMessage("FieldComment")));
                linesadded = this.writeWrappedComment(w, this._comment, String.valueOf(leftMargin) + title, textSpace) + linesadded;
            }
            if (!this._decoderModel.isEmpty()) {
                title = String.format("%-" + labelColumn + "s", Bundle.getMessage("MakeLabel", Bundle.getMessage("FieldDecoderModel")));
                linesadded = this.textSpaceWithIcon != 0 && linesadded < this.blanks ? this.writeWrappedComment(w, this._decoderModel, String.valueOf(leftMargin) + title, this.textSpaceWithIcon) + linesadded : this.writeWrappedComment(w, this._decoderModel, String.valueOf(leftMargin) + title, textSpace) + linesadded;
            }
            if (!this._decoderFamily.isEmpty()) {
                title = String.format("%-" + labelColumn + "s", Bundle.getMessage("MakeLabel", Bundle.getMessage("FieldDecoderFamily")));
                linesadded = this.textSpaceWithIcon != 0 && linesadded < this.blanks ? this.writeWrappedComment(w, this._decoderFamily, String.valueOf(leftMargin) + title, this.textSpaceWithIcon) + linesadded : this.writeWrappedComment(w, this._decoderFamily, String.valueOf(leftMargin) + title, textSpace) + linesadded;
            }
            if (!this._decoderComment.isEmpty()) {
                int i = 0;
                while (i < this.blanks - linesadded) {
                    w.write(this.newLine, 0, 1);
                    ++i;
                }
                if (this.blanks != 0) {
                    this.blanks = 0;
                }
                title = String.format("%-" + labelColumn + "s", Bundle.getMessage("MakeLabel", Bundle.getMessage("FieldDecoderComment")));
                linesadded = this.writeWrappedComment(w, this._decoderComment, String.valueOf(leftMargin) + title, textSpace) + linesadded;
            }
            w.write(this.newLine, 0, 1);
            int i = -1;
            while (i < this.blanks - linesadded) {
                w.write(this.newLine, 0, 1);
                ++i;
            }
        }
        catch (IOException e) {
            log.error("Error printing RosterEntry: {}", (Throwable)e);
        }
    }

    private int writeWrappedComment(Writer w, String text, String title, int textSpace) {
        Vector<String> commentVector = this.wrapComment(text, textSpace);
        int k = 0;
        try {
            w.write(this.newLine, 0, 1);
            String s = String.valueOf(title) + commentVector.elementAt(k);
            w.write(s, 0, s.length());
            ++k;
            while (k < commentVector.size()) {
                String token = commentVector.elementAt(k);
                s = !token.equals("\n") ? String.valueOf(this.indent) + token : token;
                w.write(s, 0, s.length());
                ++k;
            }
        }
        catch (IOException e) {
            log.error("Error printing RosterEntry: {}", (Throwable)e);
        }
        return k;
    }

    public Vector<String> wrapComment(String comment, int textSpace) {
        StringTokenizer commentTokens = new StringTokenizer(comment, "\n", true);
        Vector<String> textVector = new Vector<String>(commentTokens.countTokens());
        while (commentTokens.hasMoreTokens()) {
            String commentToken = commentTokens.nextToken();
            int startIndex = 0;
            if (commentToken.length() < startIndex + textSpace) {
                textVector.addElement(commentToken);
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug("token: /{}/", (Object)commentToken);
            }
            while (startIndex < commentToken.length()) {
                String tokenPiece = commentToken.substring(startIndex, startIndex + textSpace);
                if (log.isDebugEnabled()) {
                    log.debug("loop: /{}/ {}", (Object)tokenPiece, (Object)tokenPiece.lastIndexOf(" "));
                }
                if (tokenPiece.lastIndexOf(" ") == -1) {
                    textVector.addElement(tokenPiece);
                    textVector.addElement(this.newLine);
                    startIndex += textSpace;
                } else {
                    int endIndex = tokenPiece.lastIndexOf(" ") + 1;
                    if (log.isDebugEnabled()) {
                        log.debug("/{}/ {} {}", new Object[]{tokenPiece, startIndex, endIndex});
                    }
                    textVector.addElement(tokenPiece.substring(0, endIndex));
                    textVector.addElement(this.newLine);
                    startIndex += endIndex;
                }
                if (commentToken.substring(startIndex).length() >= textSpace) continue;
                textVector.addElement(commentToken.substring(startIndex));
                startIndex += textSpace;
            }
        }
        return textVector;
    }

    public void readFile() {
        if (this.getFileName() == null) {
            log.warn("readFile invoked with null filename");
            return;
        }
        log.debug("readFile invoked with filename {}", (Object)this.getFileName());
        LocoFile lf = new LocoFile();
        String file = String.valueOf(Roster.getDefault().getRosterFilesLocation()) + this.getFileName();
        if (!new File(file).exists()) {
            file = this.getFileName();
        }
        try {
            this.mRootElement = lf.rootFromName(file);
        }
        catch (IOException | JDOMException e) {
            log.error("Exception while loading loco XML file: {} from {}", new Object[]{this.getFileName(), file, e});
        }
    }

    public static RosterEntry fromFile(@Nonnull File file) throws JDOMException, IOException {
        Element loco = new LocoFile().rootFromFile(file).getChild("locomotive");
        if (loco == null) {
            throw new JDOMException("missing expected element");
        }
        RosterEntry re = new RosterEntry(loco);
        re.setFileName(file.getName());
        return re;
    }

    @Override
    public String getDisplayName() {
        if (this.getRoadName() != null && !this.getRoadName().isEmpty()) {
            return Bundle.getMessage("RosterEntryDisplayName", this.getDccAddress(), this.getRoadName(), this.getRoadNumber());
        }
        return Bundle.getMessage("RosterEntryDisplayName", this.getDccAddress(), this.getId(), "");
    }
}

