/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.roster;

import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import jmri.InstanceManager;
import jmri.jmrit.roster.Bundle;
import jmri.jmrit.roster.Roster;
import jmri.jmrit.roster.RosterConfigManager;
import jmri.profile.Profile;
import jmri.profile.ProfileManager;
import jmri.swing.PreferencesPanel;
import jmri.util.FileUtil;

public class RosterConfigPane
extends JPanel
implements PreferencesPanel {
    JLabel filename;
    JTextField owner = new JTextField(20);
    JFileChooser fc = new JFileChooser(FileUtil.getUserFilesPath());

    public RosterConfigPane() {
        FileFilter filt = new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.getName().equals("roster.xml")) {
                    return true;
                }
                return f.isDirectory();
            }

            @Override
            public String getDescription() {
                return "roster.xml only";
            }
        };
        this.fc.setDialogTitle(Bundle.getMessage("DialogTitleMove"));
        this.fc.setFileFilter(filt);
        this.setLayout(new BoxLayout(this, 1));
        JPanel p = new JPanel();
        p.setLayout(new FlowLayout());
        p.add(new JLabel(Bundle.getMessage("LabelMoveLocation")));
        this.filename = new JLabel(Roster.getDefault().getRosterLocation());
        p.add(this.filename);
        if (FileUtil.getUserFilesPath().equals(Roster.getDefault().getRosterLocation())) {
            this.filename.setText("");
        }
        JButton b = new JButton(Bundle.getMessage("ButtonSetDots"));
        b.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (JOptionPane.showConfirmDialog(RosterConfigPane.this.getTopLevelAncestor(), Bundle.getMessage("DialogMsgMoveWarning"), Bundle.getMessage("DialogMsgMoveQuestion"), 2) != 0) {
                    return;
                }
                RosterConfigPane.this.fc.rescanCurrentDirectory();
                RosterConfigPane.this.fc.showOpenDialog(null);
                if (RosterConfigPane.this.fc.getSelectedFile() == null) {
                    return;
                }
                if (!RosterConfigPane.this.fc.getSelectedFile().getName().equals("roster.xml")) {
                    return;
                }
                RosterConfigPane.this.filename.setText(String.valueOf(RosterConfigPane.this.fc.getSelectedFile().getParent()) + File.separator);
                RosterConfigPane.this.validate();
                RosterConfigPane.this.packTopFrame();
            }
        });
        p.add(b);
        b = new JButton(Bundle.getMessage("ButtonReset"));
        b.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RosterConfigPane.this.filename.setText("");
                RosterConfigPane.this.validate();
                RosterConfigPane.this.packTopFrame();
            }
        });
        p.add(b);
        this.add(p);
        JPanel p2 = new JPanel();
        p2.setLayout(new FlowLayout());
        p2.add(new JLabel(Bundle.getMessage("LabelDefaultOwner")));
        this.owner.setText(InstanceManager.getDefault(RosterConfigManager.class).getDefaultOwner());
        p2.add(this.owner);
        this.add(p2);
    }

    private void packTopFrame() {
        Container co = this.getTopLevelAncestor();
        if (co instanceof JFrame) {
            ((JFrame)co).pack();
        }
    }

    public String getDefaultOwner() {
        return this.owner.getText();
    }

    public void setDefaultOwner(String defaultOwner) {
        this.owner.setText(defaultOwner);
    }

    public String getSelectedItem() {
        return this.filename.getText();
    }

    @Override
    public String getPreferencesItem() {
        return "ROSTER";
    }

    @Override
    public String getPreferencesItemText() {
        return Bundle.getMessage("MenuItemRoster");
    }

    @Override
    public String getTabbedPreferencesTitle() {
        return Bundle.getMessage("TabbedLayoutRoster");
    }

    @Override
    public String getLabelKey() {
        return Bundle.getMessage("LabelTabbedLayoutRoster");
    }

    @Override
    public JComponent getPreferencesComponent() {
        return this;
    }

    @Override
    public boolean isPersistant() {
        return true;
    }

    @Override
    public String getPreferencesTooltip() {
        return null;
    }

    @Override
    public void savePreferences() {
        Profile project = ProfileManager.getDefault().getActiveProfile();
        RosterConfigManager manager = InstanceManager.getDefault(RosterConfigManager.class);
        manager.setDefaultOwner(project, this.getDefaultOwner());
        manager.setDirectory(project, this.getSelectedItem());
        manager.savePreferences(project);
    }

    @Override
    public boolean isDirty() {
        return this.isFileLocationChanged() || !InstanceManager.getDefault(RosterConfigManager.class).getDefaultOwner().equals(this.getDefaultOwner());
    }

    @Override
    public boolean isRestartRequired() {
        return this.isFileLocationChanged();
    }

    private boolean isFileLocationChanged() {
        return this.getSelectedItem() == null || this.getSelectedItem().isEmpty() ? !Roster.getDefault().getRosterLocation().equals(FileUtil.getUserFilesPath()) : !Roster.getDefault().getRosterLocation().equals(this.getSelectedItem());
    }

    @Override
    public boolean isPreferencesValid() {
        return true;
    }
}

