/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.roster;

import java.awt.HeadlessException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.JOptionPane;
import jmri.InstanceManager;
import jmri.UserPreferencesManager;
import jmri.beans.PropertyChangeProvider;
import jmri.jmrit.XmlFile;
import jmri.jmrit.roster.Bundle;
import jmri.jmrit.roster.LocoFile;
import jmri.jmrit.roster.RosterConfigManager;
import jmri.jmrit.roster.RosterEntry;
import jmri.jmrit.roster.rostergroup.RosterGroup;
import jmri.jmrit.roster.rostergroup.RosterGroupSelector;
import jmri.jmrit.symbolicprog.SymbolicProgBundle;
import jmri.profile.Profile;
import jmri.profile.ProfileManager;
import jmri.util.FileUtil;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.ProcessingInstruction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Roster
extends XmlFile
implements RosterGroupSelector,
PropertyChangeProvider,
PropertyChangeListener {
    private final List<RosterEntry> _list = new ArrayList<RosterEntry>();
    private boolean dirty = false;
    private String rosterLocation = FileUtil.getUserFilesPath();
    private String rosterIndexFileName = "roster.xml";
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    public static final String schemaVersion = "";
    private String defaultRosterGroup = null;
    private final HashMap<String, RosterGroup> rosterGroups = new HashMap();
    public static final String DEFAULT_ROSTER_INDEX = "roster.xml";
    public static final String ADD = "add";
    public static final String REMOVE = "remove";
    public static final String CHANGE = "change";
    public static final String SAVED = "saved";
    public static final String ROSTER_GROUP_ADDED = "RosterGroupAdded";
    public static final String ROSTER_GROUP_REMOVED = "RosterGroupRemoved";
    public static final String ROSTER_GROUP_RENAMED = "RosterGroupRenamed";
    public static final String ROSTER_GROUP_PREFIX = "RosterGroup:";
    public static final String ALLENTRIES = Bundle.getMessage("ALLENTRIES");
    private static final Logger log = LoggerFactory.getLogger(Roster.class);

    public Roster() {
        FileUtil.getDefault().addPropertyChangeListener("preference:", evt -> {
            FileUtil.Property oldValue = (FileUtil.Property)evt.getOldValue();
            FileUtil.Property newValue = (FileUtil.Property)evt.getNewValue();
            Profile project = oldValue.getKey();
            if (this.equals(Roster.getRoster(project)) && this.getRosterLocation().equals(oldValue.getValue())) {
                this.setRosterLocation(newValue.getValue());
                this.reloadRosterFile();
            }
        });
        InstanceManager.getOptionalDefault(UserPreferencesManager.class).ifPresent(upm -> this.setDefaultRosterGroup((String)upm.getProperty(Roster.class.getCanonicalName(), "defaultRosterGroup")));
    }

    public Roster(String rosterFilename) {
        this();
        try {
            if (rosterFilename == null) {
                rosterFilename = this.getRosterIndexPath();
            }
            this.readFile(rosterFilename);
        }
        catch (IOException | JDOMException e) {
            log.error("Exception during reading while constructing roster", e);
            try {
                JOptionPane.showMessageDialog(null, String.valueOf(Bundle.getMessage("ErrorReadingText")) + "\n" + e.getMessage(), Bundle.getMessage("ErrorReadingTitle"), 0);
            }
            catch (HeadlessException headlessException) {}
        }
    }

    public static synchronized Roster getDefault() {
        return Roster.getRoster(ProfileManager.getDefault().getActiveProfile());
    }

    @Nonnull
    public static synchronized Roster getRoster(@CheckForNull Profile profile) {
        return InstanceManager.getDefault(RosterConfigManager.class).getRoster(profile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEntry(RosterEntry e) {
        log.debug("Add entry {}", (Object)e);
        List<RosterEntry> list = this._list;
        synchronized (list) {
            int i = this._list.size() - 1;
            while (i >= 0) {
                if (e.getId().compareToIgnoreCase(this._list.get(i).getId()) > 0) break;
                --i;
            }
            this._list.add(i + 1, e);
        }
        e.addPropertyChangeListener(this);
        this.addRosterGroups(e.getGroups(this));
        this.setDirty(true);
        this.firePropertyChange(ADD, null, e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEntry(RosterEntry e) {
        log.debug("Remove entry {}", (Object)e);
        List<RosterEntry> list = this._list;
        synchronized (list) {
            this._list.remove(e);
        }
        e.removePropertyChangeListener(this);
        this.setDirty(true);
        this.firePropertyChange(REMOVE, e, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int numEntries() {
        List<RosterEntry> list = this._list;
        synchronized (list) {
            return this._list.size();
        }
    }

    public int numGroupEntries(String group) {
        if (group != null && !group.equals(ALLENTRIES) && !group.equals(Roster.allEntries(Locale.getDefault()))) {
            return this.rosterGroups.get(group) != null ? this.rosterGroups.get(group).getEntries().size() : 0;
        }
        return this.numEntries();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RosterEntry entryFromTitle(String title) {
        List<RosterEntry> list = this._list;
        synchronized (list) {
            for (RosterEntry re : this._list) {
                if (!re.titleString().equals(title)) continue;
                return re;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RosterEntry getEntryForId(String id) {
        List<RosterEntry> list = this._list;
        synchronized (list) {
            for (RosterEntry re : this._list) {
                if (!re.getId().equals(id)) continue;
                return re;
            }
        }
        return null;
    }

    @Nonnull
    public List<RosterEntry> getEntriesByDccAddress(String a) {
        return this.findMatchingEntries(r -> r.getDccAddress().equals(a));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public RosterEntry getEntry(int i) {
        List<RosterEntry> list = this._list;
        synchronized (list) {
            return this._list.get(i);
        }
    }

    @Nonnull
    public List<RosterEntry> getAllEntries() {
        return this.getEntriesInGroup(null);
    }

    public RosterEntry getGroupEntry(String group, int i) {
        List<RosterEntry> l = this.matchingList(null, null, null, null, null, null, null);
        int num = 0;
        for (RosterEntry r : l) {
            if (group != null) {
                if (r.getAttribute(Roster.getRosterGroupProperty(group)) == null || !r.getAttribute(Roster.getRosterGroupProperty(group)).equals("yes")) continue;
                if (num == i) {
                    return r;
                }
                ++num;
                continue;
            }
            if (num == i) {
                return r;
            }
            ++num;
        }
        return null;
    }

    public int getGroupIndex(String group, RosterEntry re) {
        List<RosterEntry> l = this.matchingList(null, null, null, null, null, null, null);
        int num = 0;
        for (RosterEntry r : l) {
            if (group != null) {
                if (r.getAttribute(Roster.getRosterGroupProperty(group)) == null || !r.getAttribute(Roster.getRosterGroupProperty(group)).equals("yes")) continue;
                if (r == re) {
                    return num;
                }
                ++num;
                continue;
            }
            if (re == r) {
                return num;
            }
            ++num;
        }
        return -1;
    }

    public String fileFromTitle(String title) {
        RosterEntry r = this.entryFromTitle(title);
        if (r != null) {
            return r.getFileName();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RosterEntry> getEntriesWithAttributeKey(String key) {
        ArrayList<RosterEntry> result = new ArrayList<RosterEntry>();
        List<RosterEntry> list = this._list;
        synchronized (list) {
            this._list.stream().filter(r -> r.getAttribute(key) != null).forEachOrdered(r -> result.add((RosterEntry)r));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RosterEntry> getEntriesWithAttributeKeyValue(String key, String value) {
        ArrayList<RosterEntry> result = new ArrayList<RosterEntry>();
        List<RosterEntry> list = this._list;
        synchronized (list) {
            this._list.stream().forEach(r -> {
                String v = r.getAttribute(key);
                if (v != null && v.equals(value)) {
                    result.add((RosterEntry)r);
                }
            });
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getAllAttributeKeys() {
        TreeSet<String> result = new TreeSet<String>();
        List<RosterEntry> list = this._list;
        synchronized (list) {
            this._list.stream().forEach(r -> result.addAll(r.getAttributes()));
        }
        return result;
    }

    public List<RosterEntry> getEntriesInGroup(String group) {
        if (group == null || group.equals(ALLENTRIES) || group.isEmpty()) {
            return this.matchingList(null, null, null, null, null, null, null);
        }
        return this.getEntriesWithAttributeKeyValue(Roster.getRosterGroupProperty(group), "yes");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<RosterEntry> findMatchingEntries(RosterComparator c) {
        ArrayList<RosterEntry> l = new ArrayList<RosterEntry>();
        List<RosterEntry> list = this._list;
        synchronized (list) {
            this._list.stream().filter(r -> c.check((RosterEntry)r)).forEachOrdered(r -> l.add((RosterEntry)r));
        }
        return l;
    }

    @Nonnull
    public List<RosterEntry> getEntriesMatchingCriteria(String roadName, String roadNumber, String dccAddress, String mfg, String decoderModel, String decoderFamily, String id, String group, String developerID, String manufacturerID, String productID) {
        return this.findMatchingEntries(r -> this.checkEntry(r, roadName, roadNumber, dccAddress, mfg, decoderModel, decoderFamily, id, group, developerID, manufacturerID, productID));
    }

    @Nonnull
    public List<RosterEntry> getEntriesMatchingCriteria(String roadName, String roadNumber, String dccAddress, String mfg, String decoderModel, String decoderFamily, String id, String group) {
        return this.findMatchingEntries(r -> this.checkEntry(r, roadName, roadNumber, dccAddress, mfg, decoderModel, decoderFamily, id, group, null, null, null));
    }

    @Nonnull
    public List<RosterEntry> matchingList(String roadName, String roadNumber, String dccAddress, String mfg, String decoderModel, String decoderFamily, String id) {
        return this.getEntriesMatchingCriteria(roadName, roadNumber, dccAddress, mfg, decoderModel, decoderFamily, id, null, null, null, null);
    }

    @Nonnull
    public List<RosterEntry> matchingList(String roadName, String roadNumber, String dccAddress, String mfg, String decoderModel, String decoderFamily, String id, String developerID, String manufacturerID, String productID) {
        return this.getEntriesMatchingCriteria(roadName, roadNumber, dccAddress, mfg, decoderModel, decoderFamily, id, null, developerID, manufacturerID, productID);
    }

    @Nonnull
    public List<RosterEntry> matchingList(String dccAddress, String productID) {
        return this.getEntriesMatchingCriteria(null, null, dccAddress, null, null, null, null, null, null, null, productID);
    }

    public boolean checkEntry(int i, String roadName, String roadNumber, String dccAddress, String mfg, String decoderModel, String decoderFamily, String id, String group) {
        return this.checkEntry(this._list, i, roadName, roadNumber, dccAddress, mfg, decoderModel, decoderFamily, id, group);
    }

    public boolean checkEntry(List<RosterEntry> list, int i, String roadName, String roadNumber, String dccAddress, String mfg, String decoderModel, String decoderFamily, String id, String group) {
        RosterEntry r = list.get(i);
        return this.checkEntry(r, roadName, roadNumber, dccAddress, mfg, decoderModel, decoderFamily, id, group, null, null, null);
    }

    public boolean checkEntry(RosterEntry r, String roadName, String roadNumber, String dccAddress, String mfg, String decoderModel, String decoderFamily, String id, String group, String developerID, String manufacturerID, String productID) {
        if (id != null && !id.equals(r.getId())) {
            return false;
        }
        if (roadName != null && !roadName.equals(r.getRoadName())) {
            return false;
        }
        if (roadNumber != null && !roadNumber.equals(r.getRoadNumber())) {
            return false;
        }
        if (dccAddress != null && !dccAddress.equals(r.getDccAddress())) {
            return false;
        }
        if (mfg != null && !mfg.equals(r.getMfg())) {
            return false;
        }
        if (decoderModel != null && !decoderModel.equals(r.getDecoderModel())) {
            return false;
        }
        if (decoderFamily != null && !decoderFamily.equals(r.getDecoderFamily())) {
            return false;
        }
        if (developerID != null && !developerID.equals(r.getDeveloperID())) {
            return false;
        }
        if (manufacturerID != null && !manufacturerID.equals(r.getManufacturerID())) {
            return false;
        }
        if (productID != null && !productID.equals(r.getProductID())) {
            return false;
        }
        return group == null || ALLENTRIES.equals(group) || r.getAttribute(Roster.getRosterGroupProperty(group)) != null && r.getAttribute(Roster.getRosterGroupProperty(group)).equals("yes");
    }

    void writeFile(String name) throws FileNotFoundException, IOException {
        File file;
        if (log.isDebugEnabled()) {
            log.debug("writeFile {}", (Object)name);
        }
        if ((file = this.findFile(name)) == null) {
            file = new File(name);
        }
        this.writeFile(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeFile(File file) throws IOException {
        Element root = new Element("roster-config");
        root.setAttribute("noNamespaceSchemaLocation", "http://jmri.org/xml/schema/roster.xsd", Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance"));
        Document doc = Roster.newDocument(root);
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("type", "text/xsl");
        m.put("href", "/xml/XSLT/roster2array.xsl");
        ProcessingInstruction p = new ProcessingInstruction("xml-stylesheet", m);
        doc.addContent(0, (Content)p);
        String newLocoString = SymbolicProgBundle.getMessage("LabelNewDecoder");
        List<RosterEntry> list = this._list;
        synchronized (list) {
            this._list.forEach(entry -> {
                if (!entry.getId().equals(newLocoString)) {
                    String tempComment = entry.getComment();
                    StringBuilder xmlComment = new StringBuilder();
                    int k = 0;
                    while (k < tempComment.length()) {
                        if (tempComment.startsWith("\n", k)) {
                            xmlComment.append("<?p?>");
                        } else {
                            xmlComment.append(tempComment.substring(k, k + 1));
                        }
                        ++k;
                    }
                    entry.setComment(xmlComment.toString());
                    String tempDecoderComment = entry.getDecoderComment();
                    StringBuilder xmlDecoderComment = new StringBuilder();
                    int k2 = 0;
                    while (k2 < tempDecoderComment.length()) {
                        if (tempDecoderComment.startsWith("\n", k2)) {
                            xmlDecoderComment.append("<?p?>");
                        } else {
                            xmlDecoderComment.append(tempDecoderComment.substring(k2, k2 + 1));
                        }
                        ++k2;
                    }
                    entry.setDecoderComment(xmlDecoderComment.toString());
                } else {
                    log.debug("skip unsaved roster entry with default name {}", (Object)entry.getId());
                }
            });
        }
        Element values = new Element("roster");
        root.addContent((Content)values);
        List<RosterEntry> list2 = this._list;
        synchronized (list2) {
            this._list.stream().forEach(entry -> {
                if (!entry.getId().equals(newLocoString)) {
                    values.addContent((Content)entry.store());
                } else {
                    log.debug("skip unsaved roster entry with default name {}", (Object)entry.getId());
                }
            });
        }
        if (!this.rosterGroups.isEmpty()) {
            Element rosterGroup = new Element("rosterGroup");
            this.rosterGroups.keySet().stream().forEach(name -> {
                Element group = new Element("group");
                if (!name.equals(ALLENTRIES)) {
                    group.addContent(name);
                    rosterGroup.addContent((Content)group);
                }
            });
            root.addContent((Content)rosterGroup);
        }
        this.writeXML(file, doc);
        list2 = this._list;
        synchronized (list2) {
            this._list.stream().forEach(entry -> {
                if (!entry.getId().equals(newLocoString)) {
                    String xmlComment = entry.getComment();
                    StringBuilder tempComment = new StringBuilder();
                    int k = 0;
                    while (k < xmlComment.length()) {
                        if (xmlComment.startsWith("<?p?>", k)) {
                            tempComment.append("\n");
                            k += 4;
                        } else {
                            tempComment.append(xmlComment.substring(k, k + 1));
                        }
                        ++k;
                    }
                    entry.setComment(tempComment.toString());
                    String xmlDecoderComment = entry.getDecoderComment();
                    StringBuilder tempDecoderComment = new StringBuilder();
                    int k2 = 0;
                    while (k2 < xmlDecoderComment.length()) {
                        if (xmlDecoderComment.startsWith("<?p?>", k2)) {
                            tempDecoderComment.append("\n");
                            k2 += 4;
                        } else {
                            tempDecoderComment.append(xmlDecoderComment.substring(k2, k2 + 1));
                        }
                        ++k2;
                    }
                    entry.setDecoderComment(tempDecoderComment.toString());
                } else {
                    log.debug("skip unsaved roster entry with default name {}", (Object)entry.getId());
                }
            });
        }
        this.setDirty(false);
        this.firePropertyChange(SAVED, false, true);
    }

    public static String makeValidFilename(String entry) {
        if (entry == null) {
            throw new IllegalArgumentException("makeValidFilename requires non-null argument");
        }
        if (entry.isEmpty()) {
            throw new IllegalArgumentException("makeValidFilename requires non-empty argument");
        }
        String cleanName = entry.replaceAll("[\\W]", "_");
        return String.valueOf(cleanName) + ".xml";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readFile(String name) throws JDOMException, IOException {
        if (!new File(name).exists()) {
            log.debug("no roster file found; this is normal if you haven't put decoders in your roster yet");
            return;
        }
        Element root = this.rootFromName(name);
        if (root == null) {
            log.error("Roster file exists, but could not be read; roster not available");
            return;
        }
        if (root.getChild("roster") != null) {
            List l = root.getChild("roster").getChildren("locomotive");
            if (log.isDebugEnabled()) {
                log.debug("readFile sees {} children", (Object)l.size());
            }
            l.stream().forEach(e -> this.addEntry(new RosterEntry((Element)e)));
            List<RosterEntry> list = this._list;
            synchronized (list) {
                this._list.stream().map(entry -> {
                    String tempComment = entry.getComment();
                    StringBuilder xmlComment = new StringBuilder();
                    int k = 0;
                    while (k < tempComment.length()) {
                        if (tempComment.startsWith("<?p?>", k)) {
                            xmlComment.append("\n");
                            k += 4;
                        } else {
                            xmlComment.append(tempComment.substring(k, k + 1));
                        }
                        ++k;
                    }
                    entry.setComment(xmlComment.toString());
                    return entry;
                }).forEachOrdered(r -> {
                    String tempDecoderComment = r.getDecoderComment();
                    StringBuilder xmlDecoderComment = new StringBuilder();
                    int k = 0;
                    while (k < tempDecoderComment.length()) {
                        if (tempDecoderComment.startsWith("<?p?>", k)) {
                            xmlDecoderComment.append("\n");
                            k += 4;
                        } else {
                            xmlDecoderComment.append(tempDecoderComment.substring(k, k + 1));
                        }
                        ++k;
                    }
                    r.setDecoderComment(xmlDecoderComment.toString());
                });
            }
        } else {
            log.error("Unrecognized roster file contents in file: {}", (Object)name);
        }
        if (root.getChild("rosterGroup") != null) {
            List groups = root.getChild("rosterGroup").getChildren("group");
            groups.stream().forEach(group -> this.addRosterGroup(group.getText()));
        }
    }

    void setDirty(boolean b) {
        this.dirty = b;
    }

    boolean isDirty() {
        return this.dirty;
    }

    public void dispose() {
        if (log.isDebugEnabled()) {
            log.debug("dispose");
        }
        if (this.dirty) {
            log.error("Dispose invoked on dirty Roster");
        }
    }

    public void writeRoster() {
        this.makeBackupFile(this.getRosterIndexPath());
        try {
            this.writeFile(this.getRosterIndexPath());
        }
        catch (IOException e) {
            log.error("Exception while writing the new roster file, may not be complete: {}", (Throwable)e);
            try {
                JOptionPane.showMessageDialog(null, String.valueOf(Bundle.getMessage("ErrorSavingText")) + "\n" + e.getMessage(), Bundle.getMessage("ErrorSavingTitle"), 0);
            }
            catch (HeadlessException headlessException) {}
        }
    }

    public void reindex() {
        Roster roster = new Roster();
        String[] stringArray = Roster.getAllFileNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            try {
                Element loco = new LocoFile().rootFromName(String.valueOf(this.getRosterFilesLocation()) + fileName).getChild("locomotive");
                if (loco != null) {
                    RosterEntry re = new RosterEntry(loco);
                    re.setFileName(fileName);
                    roster.addEntry(re);
                }
            }
            catch (IOException | JDOMException ex) {
                log.error("Exception while loading loco XML file: {}", (Object)fileName, (Object)ex);
            }
            ++n2;
        }
        this.makeBackupFile(this.getRosterIndexPath());
        try {
            roster.writeFile(this.getRosterIndexPath());
        }
        catch (IOException ex) {
            log.error("Exception while writing the new roster file, may not be complete: {}", (Throwable)ex);
        }
        this.reloadRosterFile();
        log.info("Roster rebuilt, stored in {}", (Object)this.getRosterIndexPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadRosterFile() {
        List<RosterEntry> list = this._list;
        synchronized (list) {
            this._list.clear();
        }
        this.rosterGroups.clear();
        try {
            this.readFile(this.getRosterIndexPath());
        }
        catch (IOException | JDOMException e) {
            log.error("Exception during reading while reloading roster", e);
        }
    }

    public void setRosterIndexFileName(String fileName) {
        this.rosterIndexFileName = fileName;
    }

    public String getRosterIndexFileName() {
        return this.rosterIndexFileName;
    }

    public String getRosterIndexPath() {
        return String.valueOf(this.getRosterLocation()) + this.getRosterIndexFileName();
    }

    public String getRosterFilesLocation() {
        return String.valueOf(Roster.getDefault().getRosterLocation()) + "roster" + File.separator;
    }

    public void setRosterLocation(String f) {
        String oldRosterLocation = this.rosterLocation;
        String p = f;
        if (p != null) {
            if (p.isEmpty()) {
                p = null;
            } else if (!(p = FileUtil.getAbsoluteFilename(p)).endsWith(File.separator)) {
                p = String.valueOf(p) + File.separator;
            }
        }
        if (p == null) {
            p = FileUtil.getUserFilesPath();
        }
        this.rosterLocation = p;
        log.debug("Setting roster location from {} to {}", (Object)oldRosterLocation, (Object)this.rosterLocation);
        if (this.rosterLocation.equals(FileUtil.getUserFilesPath())) {
            log.debug("Roster location reset to default");
        }
        if (!this.rosterLocation.equals(oldRosterLocation)) {
            this.firePropertyChange("directory", oldRosterLocation, this.rosterLocation);
        }
        this.reloadRosterFile();
    }

    @Nonnull
    public String getRosterLocation() {
        return this.rosterLocation;
    }

    @Override
    public synchronized void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    @Override
    public synchronized void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    protected void firePropertyChange(String p, Object old, Object n) {
        this.pcs.firePropertyChange(p, old, n);
    }

    @Override
    public synchronized void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    @Override
    public synchronized void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
    }

    @Override
    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.pcs.getPropertyChangeListeners();
    }

    @Override
    public PropertyChangeListener[] getPropertyChangeListeners(String propertyName) {
        return this.pcs.getPropertyChangeListeners(propertyName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void entryIdChanged(RosterEntry r) {
        log.debug("EntryIdChanged");
        List<RosterEntry> list = this._list;
        synchronized (list) {
            Collections.sort(this._list, (o1, o2) -> o1.getId().compareToIgnoreCase(o2.getId()));
        }
        this.firePropertyChange(CHANGE, null, r);
    }

    public static String getRosterGroupName(String rosterGroup) {
        if (rosterGroup == null) {
            return ALLENTRIES;
        }
        return rosterGroup;
    }

    public static String getRosterGroupProperty(String name) {
        return ROSTER_GROUP_PREFIX + name;
    }

    public void addRosterGroup(RosterGroup rg) {
        if (this.rosterGroups.containsKey(rg.getName())) {
            return;
        }
        this.rosterGroups.put(rg.getName(), rg);
        log.debug("firePropertyChange Roster Groups model: {}", (Object)rg.getName());
        this.firePropertyChange(ROSTER_GROUP_ADDED, null, rg.getName());
    }

    public void addRosterGroup(String rg) {
        if (this.rosterGroups.containsKey(rg)) {
            return;
        }
        this.addRosterGroup(new RosterGroup(rg));
    }

    public void addRosterGroups(List<RosterGroup> groups) {
        groups.stream().forEach(rg -> this.addRosterGroup((RosterGroup)rg));
    }

    public void removeRosterGroup(RosterGroup rg) {
        this.delRosterGroupList(rg.getName());
    }

    public void delRosterGroupList(String rg) {
        RosterGroup group = this.rosterGroups.remove(rg);
        String str = Roster.getRosterGroupProperty(rg);
        group.getEntries().stream().forEach(re -> re.deleteAttribute(str));
        this.firePropertyChange(ROSTER_GROUP_REMOVED, rg, null);
    }

    public void copyRosterGroupList(String oldName, String newName) {
        if (this.rosterGroups.containsKey(newName)) {
            return;
        }
        this.rosterGroups.put(newName, new RosterGroup(newName));
        String newGroup = Roster.getRosterGroupProperty(newName);
        this.rosterGroups.get(oldName).getEntries().stream().forEach(re -> re.putAttribute(newGroup, "yes"));
        this.addRosterGroup(new RosterGroup(newName));
    }

    public void rosterGroupRenamed(String oldName, String newName) {
        this.firePropertyChange(ROSTER_GROUP_RENAMED, oldName, newName);
    }

    public void renameRosterGroupList(String oldName, String newName) {
        if (this.rosterGroups.containsKey(newName)) {
            return;
        }
        this.rosterGroups.get(oldName).setName(newName);
    }

    public ArrayList<String> getRosterGroupList() {
        ArrayList<String> list = new ArrayList<String>(this.rosterGroups.keySet());
        Collections.sort(list);
        return list;
    }

    public static String allEntries(Locale locale) {
        return Bundle.getMessage(locale, "ALLENTRIES");
    }

    @Override
    public String getSelectedRosterGroup() {
        return this.getDefaultRosterGroup();
    }

    public String getDefaultRosterGroup() {
        return this.defaultRosterGroup;
    }

    public void setDefaultRosterGroup(String defaultRosterGroup) {
        this.defaultRosterGroup = defaultRosterGroup;
        InstanceManager.getOptionalDefault(UserPreferencesManager.class).ifPresent(upm -> upm.setProperty(Roster.class.getCanonicalName(), "defaultRosterGroup", defaultRosterGroup));
    }

    static String[] getAllFileNames() {
        int i;
        File fp;
        FileUtil.createDirectory(Roster.getDefault().getRosterFilesLocation());
        int np = 0;
        String[] sp = null;
        if (log.isDebugEnabled()) {
            log.debug("search directory {}", (Object)Roster.getDefault().getRosterFilesLocation());
        }
        if ((fp = new File(Roster.getDefault().getRosterFilesLocation())).exists()) {
            sp = fp.list();
            if (sp != null) {
                i = 0;
                while (i < sp.length) {
                    if (sp[i].endsWith(".xml") || sp[i].endsWith(".XML")) {
                        ++np;
                    }
                    ++i;
                }
            } else {
                log.warn("expected directory, but {} was a file", (Object)Roster.getDefault().getRosterFilesLocation());
            }
        } else {
            log.warn("{}roster directory was missing, though tried to create it", (Object)FileUtil.getUserFilesPath());
        }
        Object[] sbox = new String[np];
        int n = 0;
        if (sp != null && np > 0) {
            i = 0;
            while (i < sp.length) {
                if (sp[i].endsWith(".xml") || sp[i].endsWith(".XML")) {
                    sbox[n++] = sp[i];
                }
                ++i;
            }
        }
        Arrays.sort(sbox);
        if (log.isDebugEnabled()) {
            log.debug("filename list:");
            i = 0;
            while (i < sbox.length) {
                log.debug("      {}", sbox[i]);
                ++i;
            }
        }
        return sbox;
    }

    public HashMap<String, RosterGroup> getRosterGroups() {
        return new HashMap<String, RosterGroup>(this.rosterGroups);
    }

    public void remapRosterGroup(RosterGroup group, String newKey) {
        this.rosterGroups.remove(group.getName());
        this.rosterGroups.put(newKey, group);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() instanceof RosterEntry && evt.getPropertyName().equals("id")) {
            this.entryIdChanged((RosterEntry)evt.getSource());
        }
    }

    private static interface RosterComparator {
        public boolean check(RosterEntry var1);
    }
}

