/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.roster;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jmri.InstanceManager;
import jmri.jmrit.XmlFile;
import jmri.jmrit.decoderdefn.DecoderFile;
import jmri.jmrit.decoderdefn.DecoderIndexFile;
import jmri.jmrit.roster.Bundle;
import jmri.jmrit.roster.FunctionLabelPane;
import jmri.jmrit.roster.RosterEntry;
import jmri.jmrit.roster.RosterMediaPane;
import jmri.jmrit.symbolicprog.CvTableModel;
import jmri.jmrit.symbolicprog.ResetTableModel;
import jmri.jmrit.symbolicprog.VariableTableModel;
import jmri.jmrit.symbolicprog.tabbedframe.PaneContainer;
import jmri.jmrit.symbolicprog.tabbedframe.PaneProgPane;
import jmri.util.BusyGlassPane;
import jmri.util.FileUtil;
import jmri.util.JmriJFrame;
import jmri.util.davidflanagan.HardcopyWriter;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrintRosterEntry
implements PaneContainer {
    RosterEntry _rosterEntry;
    List<JPanel> _paneList = new ArrayList<JPanel>();
    FunctionLabelPane _flPane = null;
    RosterMediaPane _rMPane = null;
    JmriJFrame _parent = null;
    private static final Logger log = LoggerFactory.getLogger(PrintRosterEntry.class);

    public PrintRosterEntry(RosterEntry rosterEntry, JmriJFrame parent, String programmerFilename) {
        Element decoderRoot;
        this._rosterEntry = rosterEntry;
        this._flPane = new FunctionLabelPane(rosterEntry);
        this._rMPane = new RosterMediaPane(rosterEntry);
        this._parent = parent;
        JLabel progStatus = new JLabel(Bundle.getMessage("StateIdle"));
        ResetTableModel resetModel = new ResetTableModel(progStatus, null);
        log.debug("Try PrintRosterEntry {} from file {}", (Object)this._rosterEntry.getDisplayName(), (Object)programmerFilename);
        XmlFile pf = new XmlFile(){};
        Element base = null;
        try {
            Element root = pf.rootFromName(programmerFilename);
            if (root == null) {
                log.error("Programmer file name incorrect {}", (Object)programmerFilename);
                return;
            }
            base = root.getChild("programmer");
            if (base == null) {
                log.error("xml file top element is not 'programmer'");
                return;
            }
            log.debug("Success: xml file top element is 'programmer'");
        }
        catch (IOException | JDOMException e) {
            log.error("exception reading programmer file {}", (Object)programmerFilename, (Object)e);
            return;
        }
        CvTableModel cvModel = new CvTableModel(progStatus, null);
        VariableTableModel variableModel = new VariableTableModel(progStatus, new String[]{"Name", "Value"}, cvModel);
        String decoderModel = this._rosterEntry.getDecoderModel();
        String decoderFamily = this._rosterEntry.getDecoderFamily();
        log.debug("selected loco uses decoder {} {}", (Object)decoderFamily, (Object)decoderModel);
        List<DecoderFile> l = InstanceManager.getDefault(DecoderIndexFile.class).matchingDecoderList(null, decoderFamily, null, null, null, decoderModel);
        log.debug("found {} matches", (Object)l.size());
        if (l.isEmpty()) {
            log.debug("Loco uses {} {} decoder, but no such decoder defined", (Object)decoderFamily, (Object)decoderModel);
            l = InstanceManager.getDefault(DecoderIndexFile.class).matchingDecoderList(null, null, null, null, null, decoderModel);
            log.debug("found {} matches without family key", (Object)l.size());
        }
        DecoderFile decoderFile = null;
        if (l.size() > 0) {
            decoderFile = l.get(0);
        } else if (decoderModel.equals("")) {
            log.debug("blank decoderModel requested, so nothing loaded");
        } else {
            log.warn("no matching \"{}\" decoder found for loco, no decoder info loaded", (Object)decoderModel);
        }
        if (decoderFile == null) {
            log.warn("no decoder file found for this loco");
            return;
        }
        log.debug("Try to read decoder root from {} {}", (Object)DecoderFile.fileLocation, (Object)decoderFile.getFileName());
        try {
            decoderRoot = decoderFile.rootFromName(String.valueOf(DecoderFile.fileLocation) + decoderFile.getFileName());
        }
        catch (JDOMException exj) {
            log.error("could not parse {}: {}", (Object)decoderFile.getFileName(), (Object)exj.getMessage());
            return;
        }
        catch (IOException exj) {
            log.error("could not read {}: {}", (Object)decoderFile.getFileName(), (Object)exj.getMessage());
            return;
        }
        decoderFile.loadVariableModel(decoderRoot.getChild("decoder"), variableModel);
        decoderFile.loadResetModel(decoderRoot.getChild("decoder"), resetModel);
        rosterEntry.readFile();
        rosterEntry.loadCvModel(variableModel, cvModel);
        List rawPaneList = base.getChildren("pane");
        log.debug("rawPaneList size = {}", (Object)rawPaneList.size());
        for (Element elPane : rawPaneList) {
            Element _name = elPane.getChild("name");
            String name = "Tab name";
            if (_name != null) {
                name = _name.getText();
                log.debug("Tab '{}' added", (Object)name);
            } else {
                log.debug("Did not find name element in pane");
            }
            PaneProgPane p = new PaneProgPane(this, name, elPane, cvModel, variableModel, decoderFile.getModelElement(), this._rosterEntry);
            this._paneList.add(p);
            log.debug("_paneList size = {}", (Object)this._paneList.size());
        }
    }

    @Override
    public BusyGlassPane getBusyGlassPane() {
        return null;
    }

    @Override
    public void prepGlassPane(AbstractButton activeButton) {
    }

    @Override
    public void enableButtons(boolean enable) {
    }

    @Override
    public void paneFinished() {
    }

    @Override
    public boolean isBusy() {
        return false;
    }

    public PrintRosterEntry(RosterEntry rosterEntry, List<JPanel> paneList, FunctionLabelPane flPane, RosterMediaPane rMPane, JmriJFrame parent) {
        this._rosterEntry = rosterEntry;
        this._paneList = paneList;
        this._flPane = flPane;
        this._rMPane = rMPane;
        this._parent = parent;
    }

    public void doPrintPanes(boolean preview) {
        HardcopyWriter w = null;
        try {
            w = new HardcopyWriter(this._parent, this._rosterEntry.getId(), 10, 0.8, 0.5, 0.5, 0.5, preview);
        }
        catch (HardcopyWriter.PrintCanceledException printCanceledException) {
            log.debug("Print cancelled");
            return;
        }
        this.printInfoSection(w);
        if (this._flPane.includeInPrint()) {
            this._flPane.printPane(w);
        }
        log.debug("List size length: {}", (Object)this._paneList.size());
        int i = 0;
        while (i < this._paneList.size()) {
            log.debug("start printing page {}", (Object)i);
            PaneProgPane pane = (PaneProgPane)this._paneList.get(i);
            if (pane.includeInPrint()) {
                pane.printPane(w);
            }
            ++i;
        }
        w.write(w.getCurrentLineNumber(), 0, w.getCurrentLineNumber(), w.getCharactersPerLine() + 1);
        w.close();
    }

    public void printPanes(final boolean preview) {
        final JFrame frame = new JFrame(Bundle.getMessage("TitleSelectItemsToPrint"));
        JPanel p1 = new JPanel();
        p1.setLayout(new BoxLayout(p1, 3));
        JPanel instruct = new JPanel();
        JLabel l1 = new JLabel(Bundle.getMessage("LabelSelectLine1"));
        instruct.add(l1);
        l1 = new JLabel(Bundle.getMessage("LabelSelectLine2"));
        instruct.add(l1);
        p1.add(instruct);
        JPanel select = new JPanel();
        select.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("ItemsLabel")));
        final Hashtable<JCheckBox, PaneProgPane> printList = new Hashtable<JCheckBox, PaneProgPane>();
        select.setLayout(new BoxLayout(select, 3));
        final JCheckBox funct = new JCheckBox(Bundle.getMessage("LabelFunctionList"));
        funct.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrintRosterEntry.this._flPane.includeInPrint(funct.isSelected());
            }
        });
        this._flPane.includeInPrint(false);
        select.add(funct);
        log.debug("List size length: {}", (Object)this._paneList.size());
        int i = 0;
        while (i < this._paneList.size()) {
            final PaneProgPane pane = (PaneProgPane)this._paneList.get(i);
            pane.includeInPrint(false);
            final JCheckBox item = new JCheckBox(this._paneList.get(i).getName());
            printList.put(item, pane);
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    pane.includeInPrint(item.isSelected());
                }
            });
            select.add(item);
            ++i;
        }
        p1.add(select);
        JPanel selectAllBox = new JPanel();
        final JCheckBox selectAll = new JCheckBox(Bundle.getMessage("SelectAll"));
        selectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrintRosterEntry.this._flPane.includeInPrint(selectAll.isSelected());
                funct.setSelected(selectAll.isSelected());
                Enumeration en = printList.keys();
                while (en.hasMoreElements()) {
                    JCheckBox check = (JCheckBox)en.nextElement();
                    ((PaneProgPane)printList.get(check)).includeInPrint(selectAll.isSelected());
                    check.setSelected(selectAll.isSelected());
                }
            }
        });
        selectAllBox.add(selectAll);
        p1.add(selectAllBox);
        JButton cancel = new JButton(Bundle.getMessage("ButtonCancel"));
        JButton ok = new JButton(Bundle.getMessage("ButtonOK"));
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                frame.dispose();
            }
        });
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrintRosterEntry.this.doPrintPanes(preview);
                frame.dispose();
            }
        });
        JPanel buttons = new JPanel();
        buttons.add(cancel);
        buttons.add(ok);
        p1.add(buttons);
        frame.add(p1);
        frame.pack();
        frame.setVisible(true);
    }

    public void printInfoSection(HardcopyWriter w) {
        ImageIcon icon = new ImageIcon(FileUtil.findURL("resources/decoderpro.gif", FileUtil.Location.INSTALLED));
        w.write(icon.getImage(), new JLabel(icon));
        w.setFontStyle(1);
        int height = icon.getImage().getHeight(null);
        int blanks = (height - w.getLineAscent()) / w.getLineHeight();
        try {
            int i = 0;
            while (i < blanks) {
                String s = "\n";
                w.write(s, 0, s.length());
                ++i;
            }
        }
        catch (IOException e) {
            log.warn("error during printing: ", (Throwable)e);
        }
        this._rosterEntry.printEntry(w);
        w.setFontStyle(0);
    }
}

