/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.roster;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import jmri.jmrit.XmlFile;
import jmri.jmrit.roster.Roster;
import jmri.jmrit.roster.RosterEntry;
import jmri.jmrit.symbolicprog.CvTableModel;
import jmri.jmrit.symbolicprog.CvValue;
import jmri.jmrit.symbolicprog.VariableTableModel;
import jmri.jmrit.symbolicprog.VariableValue;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.ProcessingInstruction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocoFile
extends XmlFile {
    private static final Logger log = LoggerFactory.getLogger(LocoFile.class);

    public String titleString() {
        return "no title form yet";
    }

    public static void loadCvModel(Element loco, CvTableModel cvModel, String family) {
        CvValue cvObject;
        List elementList;
        String rosterName = loco.getAttributeValue("id");
        Element values = loco.getChild("values");
        if (values == null && (elementList = loco.getChildren("CVvalue")) != null) {
            values = loco;
        }
        if (values != null) {
            if (log.isDebugEnabled()) {
                log.debug("Found {} CVvalues", (Object)values.getChildren("CVvalue").size());
            }
            for (Element element : values.getChildren("CVvalue")) {
                if (element.getAttribute("name") == null) {
                    if (log.isDebugEnabled()) {
                        log.debug("unexpected null in name {} {}", (Object)element, (Object)element.getAttributes());
                    }
                    break;
                }
                if (element.getAttribute("value") == null) {
                    if (log.isDebugEnabled()) {
                        log.debug("unexpected null in value {} {}", (Object)element, (Object)element.getAttributes());
                    }
                    break;
                }
                String name = element.getAttribute("name").getValue();
                String value = element.getAttribute("value").getValue();
                log.debug("CV named {} has value: {}", (Object)name, (Object)value);
                if (family != null && (family.startsWith("Tsunami2") || family.startsWith("Econami")) && name.matches("\\d+\\.\\d+")) {
                    String oldName = name;
                    name = "16." + oldName;
                    log.info("CV{} renamed to {} has value: {}", new Object[]{oldName, name, value});
                }
                if ((cvObject = cvModel.allCvMap().get(name)) == null) {
                    cvModel.addCV(name, false, false, false);
                    cvObject = cvModel.allCvMap().get(name);
                }
                cvObject.setValue(Integer.parseInt(value));
                cvObject.setState(256);
            }
        } else {
            log.error("no values element found in config file; CVs not configured for ID=\"{}\"", (Object)rosterName);
        }
        if ((cvObject = cvModel.allCvMap().get("17")) != null) {
            cvObject.setState(256);
        }
    }

    public static void loadVariableModel(Element loco, VariableTableModel varModel) {
        Element values = loco.getChild("values");
        if (values == null) {
            log.error("no values element found in config file; Variable values not loaded for \"{}\"", (Object)loco.getAttributeValue("id"));
            return;
        }
        Element decoderDef = values.getChild("decoderDef");
        if (decoderDef == null) {
            log.error("no decoderDef element found in config file; Variable values not loaded for \"{}\"", (Object)loco.getAttributeValue("id"));
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("Found {} varValue elements", (Object)decoderDef.getChildren("varValue").size());
        }
        HashMap<String, VariableValue> map = new HashMap<String, VariableValue>();
        int i = 0;
        while (i < varModel.getRowCount()) {
            log.debug("  map put {} to {}", (Object)varModel.getItem(i), (Object)varModel.getVariable(i));
            map.put(varModel.getItem(i), varModel.getVariable(i));
            map.put(varModel.getLabel(i), varModel.getVariable(i));
            ++i;
        }
        for (Element element : decoderDef.getChildren("varValue")) {
            if (element.getAttribute("item") == null) {
                if (!log.isDebugEnabled()) break;
                log.debug("unexpected null in item {} {}", (Object)element, (Object)element.getAttributes());
                break;
            }
            if (element.getAttribute("value") == null) {
                if (!log.isDebugEnabled()) break;
                log.debug("unexpected null in value {} {}", (Object)element, (Object)element.getAttributes());
                break;
            }
            String item = element.getAttribute("item").getValue();
            String value = element.getAttribute("value").getValue();
            log.debug("Variable \"{}\" has value: {}", (Object)item, (Object)value);
            VariableValue var = (VariableValue)map.get(item);
            if (var != null) {
                var.setValue(value);
                continue;
            }
            if (LocoFile.selectMissingVarResponse(item) != MessageResponse.REPORT) continue;
            log.warn("Did not find locofile variable \"{}\" in decoder definition, not loading", (Object)item);
        }
    }

    protected static MessageResponse selectMissingVarResponse(String var) {
        if (var.startsWith("ESU Function Row")) {
            return MessageResponse.IGNORE;
        }
        return MessageResponse.REPORT;
    }

    public void writeFile(File file, CvTableModel cvModel, VariableTableModel variableModel, RosterEntry r) {
        if (log.isDebugEnabled()) {
            log.debug("writeFile to {} {}", (Object)file.getAbsolutePath(), (Object)file.getName());
        }
        try {
            int i;
            Element root = new Element("locomotive-config");
            root.setAttribute("noNamespaceSchemaLocation", "http://jmri.org/xml/schema/locomotive-config.xsd", Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance"));
            Document doc = LocoFile.newDocument(root);
            HashMap<String, String> m = new HashMap<String, String>();
            m.put("type", "text/xsl");
            m.put("href", "/xml/XSLT/locomotive.xsl");
            ProcessingInstruction p = new ProcessingInstruction("xml-stylesheet", m);
            doc.addContent(0, (Content)p);
            Element locomotive = r.store();
            root.addContent((Content)locomotive);
            Element values = new Element("values");
            locomotive.addContent((Content)values);
            Element decoderDef = new Element("decoderDef");
            values.addContent((Content)decoderDef);
            if (variableModel != null) {
                i = 0;
                while (i < variableModel.getRowCount()) {
                    decoderDef.addContent((Content)new Element("varValue").setAttribute("item", variableModel.getItem(i)).setAttribute("value", variableModel.getValString(i)));
                    ++i;
                }
                variableModel.setFileDirty(false);
            }
            if (cvModel != null) {
                i = 0;
                while (i < cvModel.getRowCount()) {
                    values.addContent((Content)new Element("CVvalue").setAttribute("name", cvModel.getName(i)).setAttribute("value", cvModel.getValString(i)));
                    ++i;
                }
            }
            this.writeXML(file, doc);
        }
        catch (IOException ex) {
            log.error("IOException", (Throwable)ex);
        }
    }

    public void writeFile(File pFile, Element pRootElement, RosterEntry pEntry) {
        if (log.isDebugEnabled()) {
            log.debug("writeFile to {} {}", (Object)pFile.getAbsolutePath(), (Object)pFile.getName());
        }
        try {
            Document doc = LocoFile.newDocument(pRootElement, String.valueOf(this.dtdLocation) + "locomotive-config.dtd");
            if (log.isDebugEnabled()) {
                log.debug("pEntry: {}", (Object)pEntry);
            }
            pRootElement.getChild("locomotive").getAttribute("id").setValue(pEntry.getId());
            this.writeXML(pFile, doc);
        }
        catch (IOException ex) {
            log.error("Unable to write {}", (Object)pFile, (Object)ex);
        }
    }

    public void writeFile(File pFile, Element existingElement, Element newLocomotive) {
        if (log.isDebugEnabled()) {
            log.debug("writeFile to {} {}", (Object)pFile.getAbsolutePath(), (Object)pFile.getName());
        }
        try {
            Element root = new Element("locomotive-config");
            Document doc = LocoFile.newDocument(root, String.valueOf(this.dtdLocation) + "locomotive-config.dtd");
            root.addContent((Content)newLocomotive);
            HashMap<String, String> m = new HashMap<String, String>();
            m.put("type", "text/xsl");
            m.put("href", "/xml/XSLT/locomotive.xsl");
            ProcessingInstruction p = new ProcessingInstruction("xml-stylesheet", m);
            doc.addContent(0, (Content)p);
            Element values = existingElement.getChild("locomotive").getChild("values");
            newLocomotive.addContent((Content)values.clone());
            this.writeXML(pFile, doc);
        }
        catch (IOException ex) {
            log.error("Unable to write {}", (Object)pFile, (Object)ex);
        }
    }

    public static String getFileLocation() {
        return Roster.getDefault().getRosterFilesLocation();
    }

    static enum MessageResponse {
        IGNORE,
        REPORT;

    }
}

