/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.roster;

import java.awt.Component;
import java.io.File;
import javax.swing.Icon;
import jmri.jmrit.roster.AbstractRosterItemAction;
import jmri.jmrit.roster.LocoFile;
import jmri.jmrit.roster.Roster;
import jmri.jmrit.roster.RosterEntry;
import jmri.util.FileUtil;
import jmri.util.swing.JmriPanel;
import jmri.util.swing.WindowInterface;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportRosterItemAction
extends AbstractRosterItemAction {
    private static final Logger log = LoggerFactory.getLogger(ImportRosterItemAction.class);

    public ImportRosterItemAction(String s, WindowInterface wi) {
        super(s, wi);
    }

    public ImportRosterItemAction(String s, Icon i, WindowInterface wi) {
        super(s, i, wi);
    }

    public ImportRosterItemAction(String pName, Component pWho) {
        super(pName, pWho);
    }

    @Override
    protected boolean selectFrom() {
        return this.selectNewFromFile();
    }

    @Override
    boolean selectTo() {
        return this.selectNewToEntryID();
    }

    @Override
    boolean doTransfer() {
        Element lroot;
        FileUtil.createDirectory(Roster.getDefault().getRosterFilesLocation());
        LocoFile lf = new LocoFile();
        try {
            lroot = lf.rootFromFile(this.mFromFile).clone();
        }
        catch (Exception e) {
            log.error("Exception while loading loco XML file: {} exception: {}", (Object)this.mFullFromFilename, (Object)e);
            return false;
        }
        return this.loadEntryFromElement(lroot);
    }

    protected boolean loadEntryFromElement(Element lroot) {
        Element loco = lroot.getChild("locomotive");
        this.mToEntry = new RosterEntry(loco);
        this.mToEntry.setId(this.mToID);
        this.mToEntry.setFileName("");
        this.mToEntry.ensureFilenameExists();
        LocoFile newLocoFile = new LocoFile();
        File fout = new File(String.valueOf(Roster.getDefault().getRosterFilesLocation()) + this.mToEntry.getFileName());
        newLocoFile.writeFile(fout, lroot, this.mToEntry);
        return true;
    }

    @Override
    public JmriPanel makePanel() {
        throw new IllegalArgumentException("Should not be invoked");
    }
}

