/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.roster;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import jmri.jmrit.roster.Bundle;
import jmri.jmrit.roster.Roster;
import jmri.jmrit.roster.RosterEntry;
import jmri.util.FileUtil;
import jmri.util.davidflanagan.HardcopyWriter;
import jmri.util.swing.EditableResizableImagePanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionLabelPane
extends JPanel {
    RosterEntry re;
    JTextField[] labels;
    JCheckBox[] lockable;
    JRadioButton[] shunterMode;
    ButtonGroup shunterModeGroup;
    EditableResizableImagePanel[] _imageFilePath;
    EditableResizableImagePanel[] _imagePressedFilePath;
    private int maxfunction = 28;
    boolean print = false;
    private static final Logger log = LoggerFactory.getLogger(FunctionLabelPane.class);

    public FunctionLabelPane() {
    }

    public FunctionLabelPane(RosterEntry r) {
        this.re = r;
        this.initGUI();
    }

    private void initGUI() {
        this.maxfunction = this.re.getMAXFNNUM();
        GridBagLayout gbLayout = new GridBagLayout();
        GridBagConstraints cL = new GridBagConstraints();
        this.setLayout(gbLayout);
        this.labels = new JTextField[this.maxfunction + 1];
        this.lockable = new JCheckBox[this.maxfunction + 1];
        this.shunterMode = new JRadioButton[this.maxfunction + 1];
        this.shunterModeGroup = new ButtonGroup();
        this._imageFilePath = new EditableResizableImagePanel[this.maxfunction + 1];
        this._imagePressedFilePath = new EditableResizableImagePanel[this.maxfunction + 1];
        cL.gridx = 0;
        cL.gridy = 0;
        cL.ipadx = 3;
        cL.anchor = 18;
        cL.insets = new Insets(0, 0, 0, 15);
        cL.fill = 2;
        cL.weighty = 1.0;
        int nextx = 0;
        this.add((Component)new JLabel(Bundle.getMessage("FunctionButtonN")), cL);
        ++cL.gridx;
        this.add((Component)new JLabel(Bundle.getMessage("FunctionButtonLabel")), cL);
        ++cL.gridx;
        this.add((Component)new JLabel(Bundle.getMessage("FunctionButtonLockable")), cL);
        ++cL.gridx;
        this.add((Component)new JLabel(Bundle.getMessage("FunctionButtonImageOff")), cL);
        ++cL.gridx;
        this.add((Component)new JLabel(Bundle.getMessage("FunctionButtonImageOn")), cL);
        ++cL.gridx;
        this.add((Component)new JLabel(Bundle.getMessage("FunctionButtonShunterFn")), cL);
        ++cL.gridx;
        this.add((Component)new JLabel(Bundle.getMessage("FunctionButtonN")), cL);
        ++cL.gridx;
        this.add((Component)new JLabel(Bundle.getMessage("FunctionButtonLabel")), cL);
        ++cL.gridx;
        this.add((Component)new JLabel(Bundle.getMessage("FunctionButtonLockable")), cL);
        ++cL.gridx;
        this.add((Component)new JLabel(Bundle.getMessage("FunctionButtonImageOff")), cL);
        ++cL.gridx;
        this.add((Component)new JLabel(Bundle.getMessage("FunctionButtonImageOn")), cL);
        ++cL.gridx;
        this.add((Component)new JLabel(Bundle.getMessage("FunctionButtonShunterFn")), cL);
        ++cL.gridx;
        cL.gridx = 0;
        cL.gridy = 1;
        int i = 0;
        while (i <= this.maxfunction) {
            this.add((Component)new JLabel("" + i), cL);
            ++cL.gridx;
            this.labels[i] = new JTextField(20);
            if (this.re.getFunctionLabel(i) != null) {
                this.labels[i].setText(this.re.getFunctionLabel(i));
            }
            this.add((Component)this.labels[i], cL);
            ++cL.gridx;
            this.lockable[i] = new JCheckBox();
            this.lockable[i].setSelected(this.re.getFunctionLockable(i));
            this.add((Component)this.lockable[i], cL);
            ++cL.gridx;
            this._imageFilePath[i] = new EditableResizableImagePanel(this.re.getFunctionImage(i), 20, 20);
            this._imageFilePath[i].setDropFolder(Roster.getDefault().getRosterFilesLocation());
            this._imageFilePath[i].setBackground(new Color(0, 0, 0, 0));
            this._imageFilePath[i].setToolTipText(Bundle.getMessage("FunctionButtonRosterImageToolTip"));
            this._imageFilePath[i].setBorder(BorderFactory.createLineBorder(Color.blue));
            this._imageFilePath[i].addMenuItemBrowseFolder(Bundle.getMessage("MediaRosterOpenSystemFileBrowserOnJMRIfnButtonsRessources"), FileUtil.getExternalFilename("resources/icons/functionicons"));
            this.add((Component)this._imageFilePath[i], cL);
            ++cL.gridx;
            this._imagePressedFilePath[i] = new EditableResizableImagePanel(this.re.getFunctionSelectedImage(i), 20, 20);
            this._imagePressedFilePath[i].setDropFolder(Roster.getDefault().getRosterFilesLocation());
            this._imagePressedFilePath[i].setBackground(new Color(0, 0, 0, 0));
            this._imagePressedFilePath[i].setToolTipText(Bundle.getMessage("FunctionButtonPressedRosterImageToolTip"));
            this._imagePressedFilePath[i].setBorder(BorderFactory.createLineBorder(Color.blue));
            this._imagePressedFilePath[i].addMenuItemBrowseFolder(Bundle.getMessage("MediaRosterOpenSystemFileBrowserOnJMRIfnButtonsRessources"), FileUtil.getExternalFilename("resources/icons/functionicons"));
            this.add((Component)this._imagePressedFilePath[i], cL);
            ++cL.gridx;
            this.shunterMode[i] = new JRadioButton();
            this.shunterModeGroup.add(this.shunterMode[i]);
            if (("F" + i).compareTo(this.re.getShuntingFunction()) == 0) {
                this.shunterMode[i].setSelected(true);
            }
            this.add((Component)this.shunterMode[i], cL);
            ++cL.gridx;
            ++cL.gridy;
            if (cL.gridy == (this.maxfunction + 2) / 2 + 1) {
                cL.gridy = 1;
                nextx += 6;
            }
            cL.gridx = nextx;
            ++i;
        }
    }

    public boolean guiChanged(RosterEntry r) {
        int i;
        if (this.labels != null) {
            i = 0;
            while (i < this.labels.length) {
                if (this.labels[i] != null) {
                    if (r.getFunctionLabel(i) == null && !this.labels[i].getText().equals("")) {
                        return true;
                    }
                    if (r.getFunctionLabel(i) != null && !r.getFunctionLabel(i).equals(this.labels[i].getText())) {
                        return true;
                    }
                }
                ++i;
            }
        }
        if (this.lockable != null) {
            i = 0;
            while (i < this.lockable.length) {
                if (this.lockable[i] != null) {
                    if (r.getFunctionLockable(i) && !this.lockable[i].isSelected()) {
                        return true;
                    }
                    if (!r.getFunctionLockable(i) && this.lockable[i].isSelected()) {
                        return true;
                    }
                }
                ++i;
            }
        }
        if (this._imageFilePath != null) {
            i = 0;
            while (i < this._imageFilePath.length) {
                if (this._imageFilePath[i] != null) {
                    if (r.getFunctionImage(i) == null && this._imageFilePath[i].getImagePath() != null) {
                        return true;
                    }
                    if (r.getFunctionImage(i) != null && !r.getFunctionImage(i).equals(this._imageFilePath[i].getImagePath())) {
                        return true;
                    }
                }
                ++i;
            }
        }
        if (this._imagePressedFilePath != null) {
            i = 0;
            while (i < this._imagePressedFilePath.length) {
                if (this._imagePressedFilePath[i] != null) {
                    if (r.getFunctionSelectedImage(i) == null && this._imagePressedFilePath[i].getImagePath() != null) {
                        return true;
                    }
                    if (r.getFunctionSelectedImage(i) != null && !r.getFunctionSelectedImage(i).equals(this._imagePressedFilePath[i].getImagePath())) {
                        return true;
                    }
                }
                ++i;
            }
        }
        if (this.shunterMode != null) {
            String shunFn = "";
            int i2 = 0;
            while (i2 < this.shunterMode.length) {
                if (this.shunterMode[i2] != null && this.shunterMode[i2].isSelected()) {
                    shunFn = "F" + i2;
                }
                ++i2;
            }
            if (shunFn.compareTo(r.getShuntingFunction()) != 0) {
                return true;
            }
        }
        return false;
    }

    public void update(RosterEntry r) {
        if (this.labels != null) {
            String shunFn = "";
            int i = 0;
            while (i < this.labels.length) {
                if (this.labels[i] != null && !this.labels[i].getText().equals("")) {
                    r.setFunctionLabel(i, this.labels[i].getText());
                    r.setFunctionLockable(i, this.lockable[i].isSelected());
                    r.setFunctionImage(i, this._imageFilePath[i].getImagePath());
                    r.setFunctionSelectedImage(i, this._imagePressedFilePath[i].getImagePath());
                } else if (this.labels[i] != null && this.labels[i].getText().equals("") && r.getFunctionLabel(i) != null) {
                    r.setFunctionLabel(i, null);
                    r.setFunctionImage(i, null);
                    r.setFunctionSelectedImage(i, null);
                }
                if (this.shunterMode[i] != null && this.shunterMode[i].isSelected()) {
                    shunFn = "F" + i;
                }
                ++i;
            }
            r.setShuntingFunction(shunFn);
        }
    }

    public void dispose() {
        if (log.isDebugEnabled()) {
            log.debug("dispose");
        }
    }

    public boolean includeInPrint() {
        return this.print;
    }

    public void includeInPrint(boolean inc) {
        this.print = inc;
    }

    public void printPane(HardcopyWriter w) {
        int col1Width = w.getCharactersPerLine() / 2 - 3 - 5;
        int col2Width = w.getCharactersPerLine() / 2 - 3 + 5;
        try {
            StringBuilder spaces = new StringBuilder();
            int i = 0;
            while (i < col1Width) {
                spaces.append(" ");
                ++i;
            }
            String heading1 = Bundle.getMessage("ColumnHeadingFunction");
            String heading2 = Bundle.getMessage("ColumnHeadingDescription");
            int interval = spaces.length() - heading1.length();
            w.setFontStyle(1);
            String s = Bundle.getMessage("HeadingFunctionLabels");
            w.write(s, 0, s.length());
            w.writeBorders();
            w.write(w.getCurrentLineNumber(), 0, w.getCurrentLineNumber(), w.getCharactersPerLine() + 1);
            s = "\n";
            w.write(s, 0, s.length());
            w.setFontStyle(3);
            s = "   " + heading1 + spaces.substring(0, interval) + "   " + heading2;
            w.write(s, 0, s.length());
            w.writeBorders();
            s = "\n";
            w.write(s, 0, s.length());
            w.setFontStyle(0);
            int i2 = 0;
            while (i2 <= this.maxfunction) {
                String value;
                String name = "" + i2;
                if (this.re.getFunctionLockable(i2)) {
                    name = String.valueOf(name) + " (locked)";
                }
                if ((value = this.re.getFunctionLabel(i2)) != null) {
                    int nameLeftIndex = 0;
                    int nameRightIndex = name.length();
                    int valueLeftIndex = 0;
                    int valueRightIndex = value.length();
                    while (valueLeftIndex < value.length() || nameLeftIndex < name.length()) {
                        String trimmedValue;
                        int space;
                        String trimmedName;
                        String delimiter;
                        int j;
                        if (name.substring(nameLeftIndex).length() > col1Width) {
                            j = 0;
                            while (j < col1Width) {
                                delimiter = name.substring(nameLeftIndex + col1Width - j - 1, nameLeftIndex + col1Width - j);
                                if (delimiter.equals(" ") || delimiter.equals(";") || delimiter.equals(",")) {
                                    nameRightIndex = nameLeftIndex + col1Width - j;
                                    break;
                                }
                                ++j;
                            }
                            trimmedName = name.substring(nameLeftIndex, nameRightIndex);
                            nameLeftIndex = nameRightIndex;
                            space = spaces.length() - trimmedName.length();
                            s = "   " + trimmedName + spaces.substring(0, space);
                        } else {
                            trimmedName = name.substring(nameLeftIndex);
                            space = spaces.length() - trimmedName.length();
                            s = "   " + trimmedName + spaces.substring(0, space);
                            name = "";
                            nameLeftIndex = 0;
                        }
                        if (value.substring(valueLeftIndex).length() > col2Width) {
                            j = 0;
                            while (j < col2Width) {
                                delimiter = value.substring(valueLeftIndex + col2Width - j - 1, valueLeftIndex + col2Width - j);
                                if (delimiter.equals(" ") || delimiter.equals(";") || delimiter.equals(",")) {
                                    valueRightIndex = valueLeftIndex + col2Width - j;
                                    break;
                                }
                                ++j;
                            }
                            trimmedValue = value.substring(valueLeftIndex, valueRightIndex);
                            valueLeftIndex = valueRightIndex;
                            s = String.valueOf(s) + "   " + trimmedValue;
                        } else {
                            trimmedValue = value.substring(valueLeftIndex);
                            s = String.valueOf(s) + "   " + trimmedValue;
                            valueLeftIndex = 0;
                            value = "";
                        }
                        w.write(s, 0, s.length());
                        w.writeBorders();
                        s = "\n";
                        w.write(s, 0, s.length());
                    }
                }
                ++i2;
            }
            s = "\n";
            w.writeBorders();
            w.write(s, 0, s.length());
            w.writeBorders();
            w.write(s, 0, s.length());
        }
        catch (IOException e) {
            log.warn("error during printing: {}", (Throwable)e);
        }
    }
}

