/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.roster;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;
import jmri.jmrit.roster.Bundle;
import jmri.jmrit.roster.ImportRosterItemAction;
import jmri.jmrit.roster.LocoFile;
import jmri.jmrit.roster.Roster;
import jmri.jmrit.roster.RosterEntry;
import jmri.util.FileUtil;
import jmri.util.swing.WindowInterface;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FullBackupImportAction
extends ImportRosterItemAction {
    boolean acceptAll;
    boolean acceptAllDup;
    private static final Logger log = LoggerFactory.getLogger(FullBackupImportAction.class);

    public FullBackupImportAction(String s, WindowInterface wi) {
        super(s, wi);
    }

    public FullBackupImportAction(String s, Icon i, WindowInterface wi) {
        super(s, i, wi);
    }

    public FullBackupImportAction(String title, Component parent) {
        super(title, parent);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        FileUtil.createDirectory(Roster.getDefault().getRosterFilesLocation());
        Roster.getDefault();
        ZipInputStream zipper = null;
        FileInputStream inputfile = null;
        JFileChooser chooser = new JFileChooser();
        String roster_filename_extension = "roster";
        FileNameExtensionFilter filter = new FileNameExtensionFilter("JMRI full roster files", roster_filename_extension);
        chooser.addChoosableFileFilter(filter);
        int returnVal = chooser.showOpenDialog(this.mParent);
        if (returnVal != 0) {
            return;
        }
        String filename = chooser.getSelectedFile().getAbsolutePath();
        try {
            try {
                ZipEntry entry;
                inputfile = new FileInputStream(filename);
                zipper = new ZipInputStream(inputfile){

                    @Override
                    public void close() {
                    }
                };
                this.acceptAll = false;
                this.acceptAllDup = false;
                while ((entry = zipper.getNextEntry()) != null) {
                    log.debug(String.format("Entry: %s len %d (%d) added %TD content: %s", entry.getName(), entry.getSize(), entry.getCompressedSize(), new Date(entry.getTime()), entry.getComment()));
                    if (entry.getName().endsWith(".xml") || entry.getName().endsWith(".XML")) {
                        boolean retval = this.processRosterFile(zipper);
                        if (retval) continue;
                        return;
                    }
                    this.processImageFile(zipper, entry, entry.getName());
                }
                return;
            }
            catch (FileNotFoundException ex) {
                log.error("Unable to find {}", (Object)filename, (Object)ex);
                if (inputfile == null) return;
                try {
                    inputfile.close();
                    return;
                }
                catch (IOException ex2) {
                    log.error("Unable to close {}", (Object)filename, (Object)ex2);
                }
                return;
            }
            catch (IOException ex) {
                log.error("Unable to read {}", (Object)filename, (Object)ex);
                if (inputfile == null) return;
                try {
                    inputfile.close();
                    return;
                }
                catch (IOException ex3) {
                    log.error("Unable to close {}", (Object)filename, (Object)ex3);
                }
                return;
            }
        }
        finally {
            if (inputfile != null) {
                try {
                    inputfile.close();
                }
                catch (IOException ex) {
                    log.error("Unable to close {}", (Object)filename, (Object)ex);
                }
            }
        }
    }

    void processImageFile(ZipInputStream zipper, ZipEntry entry, String path) throws IOException {
        if (!path.startsWith("roster/")) {
            log.error("Can't cope with image files outside the roster/ directory: {}", (Object)path);
            return;
        }
        String fullPath = String.valueOf(Roster.getDefault().getRosterFilesLocation()) + path.substring(7);
        log.debug("fullpath: {}", (Object)fullPath);
        if (new File(fullPath).exists()) {
            log.info("skipping existing file: {}", (Object)path);
            return;
        }
        Files.copy(zipper, Paths.get(fullPath, new String[0]), new CopyOption[0]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean processRosterFile(ZipInputStream zipper) throws IOException {
        try {
            RosterEntry currentEntry;
            LocoFile xfile = new LocoFile();
            Element lroot = xfile.rootFromInputStream(zipper).clone();
            if (lroot.getChild("locomotive") == null) {
                return true;
            }
            this.mToID = lroot.getChild("locomotive").getAttributeValue("id");
            int retval = 2;
            if (!this.acceptAll) {
                retval = JOptionPane.showOptionDialog(this.mParent, Bundle.getMessage("ConfirmImportID", this.mToID), Bundle.getMessage("ConfirmImport"), 0, 1, null, new Object[]{Bundle.getMessage("CancelImports"), Bundle.getMessage("Skip"), Bundle.getMessage("ButtonOK"), Bundle.getMessage("ButtonAcceptAll")}, null);
            }
            if (retval == 0) {
                return false;
            }
            if (retval == 1) {
                return true;
            }
            if (retval == 3) {
                this.acceptAll = true;
            }
            if ((currentEntry = Roster.getDefault().getEntryForId(this.mToID)) != null) {
                if (!this.acceptAllDup) {
                    retval = JOptionPane.showOptionDialog(this.mParent, Bundle.getMessage("ConfirmImportDup", this.mToID), Bundle.getMessage("ConfirmImport"), 0, 1, null, new Object[]{Bundle.getMessage("CancelImports"), Bundle.getMessage("Skip"), Bundle.getMessage("ButtonOK"), Bundle.getMessage("ButtonAcceptAll")}, null);
                }
                if (retval == 0) {
                    return false;
                }
                if (retval == 1) {
                    return true;
                }
                if (retval == 3) {
                    this.acceptAllDup = true;
                }
                LocoFile df = new LocoFile();
                df.makeBackupFile(String.valueOf(Roster.getDefault().getRosterFilesLocation()) + currentEntry.getFileName());
                Roster.getDefault().removeEntry(currentEntry);
            }
            this.loadEntryFromElement(lroot);
            this.addToEntryToRoster();
            Roster.getDefault().reloadRosterFile();
            return true;
        }
        catch (JDOMException ex) {
            log.error("Unable to parse entry", (Throwable)ex);
        }
        return true;
    }
}

