/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.roster;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;
import jmri.Version;
import jmri.jmrit.roster.Roster;
import jmri.jmrit.roster.RosterEntry;
import jmri.util.swing.JmriAbstractAction;
import jmri.util.swing.JmriPanel;
import jmri.util.swing.WindowInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FullBackupExportAction
extends JmriAbstractAction {
    private Component _parent;
    private static final Logger log = LoggerFactory.getLogger(FullBackupExportAction.class);

    public FullBackupExportAction(String s, WindowInterface wi) {
        super(s, wi);
    }

    public FullBackupExportAction(String s, Icon i, WindowInterface wi) {
        super(s, i, wi);
    }

    public FullBackupExportAction(String s, Component parent) {
        super(s);
        this._parent = parent;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Roster roster = Roster.getDefault();
        String roster_filename_extension = "roster";
        JFileChooser chooser = new JFileChooser();
        FileNameExtensionFilter filter = new FileNameExtensionFilter("JMRI full roster files", roster_filename_extension);
        chooser.setFileFilter(filter);
        int returnVal = chooser.showSaveDialog(this._parent);
        if (returnVal != 0) {
            return;
        }
        String filename = chooser.getSelectedFile().getAbsolutePath();
        if (!filename.endsWith(roster_filename_extension)) {
            filename = filename.concat(roster_filename_extension);
        }
        try {
            Throwable throwable = null;
            Object var9_12 = null;
            try (ZipOutputStream zipper = new ZipOutputStream(new FileOutputStream(filename));){
                for (RosterEntry entry : roster.getAllEntries()) {
                    try {
                        this.copyFileToStream(entry.getPathName(), "roster", zipper, "roster: " + entry.getId());
                        if (entry.getImagePath() != null && !entry.getImagePath().isEmpty()) {
                            this.copyFileToStream(entry.getImagePath(), "roster", zipper, "image: " + entry.getId());
                        }
                        if (entry.getIconPath() == null || entry.getIconPath().isEmpty()) continue;
                        this.copyFileToStream(entry.getIconPath(), "roster", zipper, "icon: " + entry.getId());
                    }
                    catch (FileNotFoundException ex) {
                        log.error("Unable to find file in entry {}", (Object)entry.getId(), (Object)ex);
                    }
                    catch (IOException ex) {
                        log.error("Unable to write during entry {}", (Object)entry.getId(), (Object)ex);
                    }
                    catch (Exception ex) {
                        log.error("Unexpected exception during entry {}", (Object)entry.getId(), (Object)ex);
                    }
                }
                this.copyFileToStream(Roster.getDefault().getRosterIndexPath(), null, zipper, null);
                zipper.setComment("Roster file saved from DecoderPro " + Version.name());
                zipper.close();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException ex) {
            log.error("Unable to find file {}", (Object)filename, (Object)ex);
        }
        catch (IOException ex) {
            log.error("Unable to write to {}", (Object)filename, (Object)ex);
        }
    }

    private void copyFileToStream(String filename, String dirname, ZipOutputStream zipper, String comment) throws IOException {
        log.debug("write: {}", (Object)filename);
        File file = new File(filename);
        String entryName = dirname != null ? String.valueOf(dirname) + "/" + file.getName() : file.getName();
        ZipEntry zipEntry = new ZipEntry(entryName);
        zipEntry.setTime(file.lastModified());
        zipEntry.setSize(file.length());
        if (comment != null) {
            zipEntry.setComment(comment);
        }
        zipper.putNextEntry(zipEntry);
        try (FileInputStream fis = new FileInputStream(file);){
            int c;
            while ((c = fis.read()) != -1) {
                zipper.write(c);
            }
        }
        zipper.closeEntry();
    }

    @Override
    public JmriPanel makePanel() {
        throw new IllegalArgumentException("Should not be invoked");
    }
}

