/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.roster;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import jmri.beans.BeanUtil;
import jmri.jmrit.roster.Bundle;
import jmri.jmrit.roster.LocoFile;
import jmri.jmrit.roster.Roster;
import jmri.jmrit.roster.RosterEntry;
import jmri.jmrit.roster.swing.RosterEntryComboBox;
import jmri.util.FileUtil;
import jmri.util.swing.JmriAbstractAction;
import jmri.util.swing.JmriPanel;
import jmri.util.swing.WindowInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteRosterItemAction
extends JmriAbstractAction {
    Component _who;
    private static final Logger log = LoggerFactory.getLogger(DeleteRosterItemAction.class);

    public DeleteRosterItemAction(String s, WindowInterface wi) {
        super(s, wi);
    }

    public DeleteRosterItemAction(String s, Icon i, WindowInterface wi) {
        super(s, i, wi);
    }

    public DeleteRosterItemAction(String s, Component who) {
        super(s);
        this._who = who;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        RosterEntry[] entries;
        Roster roster = Roster.getDefault();
        String rosterGroup = Roster.getDefault().getDefaultRosterGroup();
        if (BeanUtil.hasProperty(this.wi, "selectedRosterGroup")) {
            rosterGroup = (String)BeanUtil.getProperty(this.wi, "selectedRosterGroup");
            log.debug("selectedRosterGroup was {}", (Object)rosterGroup);
        }
        if (BeanUtil.hasProperty(this.wi, "selectedRosterEntries")) {
            entries = (RosterEntry[])BeanUtil.getProperty(this.wi, "selectedRosterEntries");
            if (entries != null) {
                log.debug("selectedRosterEntries found {} entries", (Object)entries.length);
            } else {
                log.debug("selectedRosterEntries left entries null");
            }
        } else {
            entries = this.selectRosterEntry(rosterGroup);
            if (entries.length > 0) {
                log.debug("selectRosterEntry(rosterGroup) found {} entries", (Object)entries.length);
            } else {
                log.debug("selectRosterEntry(rosterGroup) found no entries");
            }
        }
        if (entries == null || entries.length == 0) {
            return;
        }
        RosterEntry[] rosterEntryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            RosterEntry re = rosterEntryArray[n2];
            String filename = roster.fileFromTitle(re.titleString());
            String fullFilename = String.valueOf(Roster.getDefault().getRosterFilesLocation()) + filename;
            log.debug("resolves to [{}], [{}]", (Object)filename, (Object)fullFilename);
            log.debug("rosterGroup now {}", (Object)rosterGroup);
            if (rosterGroup == null) {
                if (!this.userOK(re.titleString(), filename, fullFilename)) {
                    return;
                }
                roster.removeEntry(re);
            } else {
                String group = Roster.getRosterGroupProperty(rosterGroup);
                log.debug("removing {} group from entry", (Object)group);
                re.deleteAttribute(group);
                re.updateFile();
            }
            Roster.getDefault().writeRoster();
            if (rosterGroup == null) {
                try {
                    FileUtil.createDirectory(Roster.getDefault().getRosterFilesLocation());
                    LocoFile df = new LocoFile();
                    df.makeBackupFile(String.valueOf(Roster.getDefault().getRosterFilesLocation()) + filename);
                }
                catch (Exception ex) {
                    log.error("error during locomotive file output: {}", (Throwable)ex);
                }
            }
            ++n2;
        }
    }

    protected RosterEntry[] selectRosterEntry(String rosterGroup) {
        RosterEntry[] entries = new RosterEntry[1];
        RosterEntryComboBox selections = new RosterEntryComboBox(rosterGroup);
        int retval = JOptionPane.showOptionDialog(this._who, "Select one roster entry", "Delete roster entry", 0, 1, null, new Object[]{Bundle.getMessage("ButtonCancel"), Bundle.getMessage("ButtonOK"), selections}, null);
        log.debug("Dialog value {} selected {}:{}", new Object[]{retval, selections.getSelectedIndex(), selections.getSelectedItem()});
        if (retval != 1) {
            return entries;
        }
        entries[0] = (RosterEntry)selections.getSelectedItem();
        return entries;
    }

    boolean userOK(String entry, String filename, String fullFileName) {
        return JOptionPane.showConfirmDialog(this._who, MessageFormat.format(ResourceBundle.getBundle("jmri.jmrit.roster.JmritRosterBundle").getString("DeletePrompt"), entry, fullFileName), MessageFormat.format(ResourceBundle.getBundle("jmri.jmrit.roster.JmritRosterBundle").getString("DeleteTitle"), entry), 0) == 0;
    }

    @Override
    public JmriPanel makePanel() {
        throw new IllegalArgumentException("Should not be invoked");
    }
}

