/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.roster;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import jmri.beans.BeanUtil;
import jmri.jmrit.XmlFile;
import jmri.jmrit.roster.Bundle;
import jmri.jmrit.roster.Roster;
import jmri.jmrit.roster.RosterEntry;
import jmri.jmrit.roster.swing.RosterEntryComboBox;
import jmri.util.swing.JmriAbstractAction;
import jmri.util.swing.JmriPanel;
import jmri.util.swing.WindowInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRosterItemAction
extends JmriAbstractAction {
    Component mParent;
    String mFromID = null;
    RosterEntry mFromEntry = null;
    File mFromFile = null;
    String mFromFilename = null;
    String mFullFromFilename = null;
    String mToID = null;
    RosterEntry mToEntry = null;
    File mToFile = null;
    String mToFilename = null;
    String mFullToFilename = null;
    JFileChooser fileChooser;
    private static final Logger log = LoggerFactory.getLogger(AbstractRosterItemAction.class);

    public AbstractRosterItemAction(String pName, Component pWho) {
        super(pName);
        this.mParent = pWho;
    }

    public AbstractRosterItemAction(String s, WindowInterface wi) {
        super(s, wi);
    }

    public AbstractRosterItemAction(String s, Icon i, WindowInterface wi) {
        super(s, i, wi);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (!this.selectFrom()) {
            return;
        }
        if (!this.selectTo()) {
            return;
        }
        if (!this.doTransfer()) {
            return;
        }
        this.updateRoster();
    }

    protected abstract boolean selectFrom();

    abstract boolean selectTo();

    abstract boolean doTransfer();

    void updateRoster() {
        this.addToEntryToRoster();
    }

    boolean selectExistingFromEntry() {
        String group = null;
        if (BeanUtil.hasProperty(this.wi, "selectedRosterGroup")) {
            group = (String)BeanUtil.getProperty(this.wi, "selectedRosterGroup");
        }
        RosterEntryComboBox selections = new RosterEntryComboBox(group);
        int retval = JOptionPane.showOptionDialog(this.mParent, Bundle.getMessage("CopyEntrySelectDialog"), Bundle.getMessage("CopyEntrySelectDialogTitle"), 0, 1, null, new Object[]{Bundle.getMessage("ButtonCancel"), Bundle.getMessage("ButtonOK"), selections}, null);
        log.debug("Dialog value {} selected {}:\"{}\"", new Object[]{retval, selections.getSelectedIndex(), selections.getSelectedItem()});
        if (retval != 1) {
            return false;
        }
        this.setExistingEntry((RosterEntry)Objects.requireNonNull(selections.getSelectedItem()));
        return true;
    }

    public void setExistingEntry(RosterEntry mFromEntry) {
        this.mFromEntry = mFromEntry;
        this.mFromFilename = mFromEntry.getFileName();
        this.mFullFromFilename = String.valueOf(Roster.getDefault().getRosterFilesLocation()) + this.mFromFilename;
        log.debug(" from resolves to \"{}\", \"{}\"", (Object)this.mFromFilename, (Object)this.mFullFromFilename);
    }

    boolean selectNewToEntryID() {
        while (true) {
            this.mToID = JOptionPane.showInputDialog(this.mParent, (Object)Bundle.getMessage("NewEntryDialog"));
            if (this.mToID == null) {
                return false;
            }
            if (this.mToID.isEmpty()) {
                JOptionPane.showMessageDialog(this.mParent, Bundle.getMessage("NewEntryEmptyWarn"));
                continue;
            }
            if (Roster.getDefault().matchingList(null, null, null, null, null, null, this.mToID).size() == 0) break;
            JOptionPane.showMessageDialog(this.mParent, Bundle.getMessage("NewEntryDuplicateWarn"));
        }
        return true;
    }

    boolean selectNewFromFile() {
        if (this.fileChooser == null) {
            this.fileChooser = XmlFile.userFileChooser();
        }
        this.fileChooser.rescanCurrentDirectory();
        int retVal = this.fileChooser.showOpenDialog(this.mParent);
        if (retVal != 0) {
            return false;
        }
        this.mFromFile = this.fileChooser.getSelectedFile();
        this.mFromFilename = this.mFromFile.getName();
        this.mFullFromFilename = this.mFromFile.getAbsolutePath();
        log.debug("New from file: {} at {}", (Object)this.mFromFilename, (Object)this.mFullFromFilename);
        return true;
    }

    boolean selectNewToFile() {
        if (this.fileChooser == null) {
            this.fileChooser = XmlFile.userFileChooser();
        }
        this.fileChooser.setSelectedFile(new File(this.mFromFilename));
        int retVal = this.fileChooser.showSaveDialog(this.mParent);
        if (retVal != 0) {
            return false;
        }
        this.mToFile = this.fileChooser.getSelectedFile();
        this.mToFilename = this.mToFile.getName();
        this.mFullToFilename = this.mToFile.getAbsolutePath();
        log.debug("New to file: {} at {}", (Object)this.mToFilename, (Object)this.mFullToFilename);
        return true;
    }

    void addToEntryToRoster() {
        Roster.getDefault().addEntry(this.mToEntry);
        Roster.getDefault().writeRoster();
    }

    @Override
    public JmriPanel makePanel() {
        throw new IllegalArgumentException("Should not be invoked");
    }
}

