/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.revhistory;

import java.util.ArrayList;
import java.util.Date;
import jmri.InstanceManagerAutoDefault;

public class FileHistory
implements InstanceManagerAutoDefault {
    ArrayList<OperationMemo> list = new ArrayList();

    public void addOperation(String type, String date, String filename, FileHistory history) {
        OperationMemo r = new OperationMemo();
        r.type = type;
        r.date = date;
        r.filename = filename;
        r.history = history;
        this.list.add(r);
    }

    public void addOperation(OperationMemo r) {
        this.list.add(r);
    }

    public void addOperation(String type, String filename, FileHistory history) {
        OperationMemo r = new OperationMemo();
        r.type = type;
        r.date = new Date().toString();
        r.filename = filename;
        r.history = history;
        this.list.add(r);
    }

    public void purge(int keep) {
        int i = 0;
        while (i < this.list.size()) {
            OperationMemo r = this.list.get(i);
            if (keep <= 1) {
                r.history = null;
            }
            if (r.history != null) {
                r.history.purge(keep - 1);
            }
            ++i;
        }
    }

    public String toString(String prefix) {
        StringBuilder retval = new StringBuilder();
        this.list.stream().forEachOrdered(r -> {
            retval.append(prefix).append(r.date).append(": ").append(r.type).append(" ").append(r.filename).append("\n");
            if (r.history != null) {
                retval.append(r.history.toString(String.valueOf(prefix) + "    "));
            }
        });
        return retval.toString();
    }

    public String toString() {
        return this.toString("");
    }

    public ArrayList<OperationMemo> getList() {
        return this.list;
    }

    public class OperationMemo {
        public String type;
        public String date;
        public String filename;
        public FileHistory history;
    }
}

