/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.progsupport;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import jmri.GlobalProgrammerManager;
import jmri.InstanceManager;
import jmri.Programmer;
import jmri.ProgrammingMode;
import jmri.jmrit.progsupport.Bundle;
import jmri.jmrit.progsupport.ProgModeSelector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProgServiceModeComboBox
extends ProgModeSelector
implements PropertyChangeListener,
ActionListener {
    JLabel progLabel = new JLabel(Bundle.getMessage("ProgrammerLabel"));
    JComboBox<GlobalProgrammerManager> progBox;
    JComboBox<ProgrammingMode> modeBox;
    ArrayList<Integer> modes = new ArrayList();
    private static final Logger log = LoggerFactory.getLogger(ProgServiceModeComboBox.class);

    @Override
    public Programmer getProgrammer() {
        if (this.progBox == null) {
            return null;
        }
        GlobalProgrammerManager pm = (GlobalProgrammerManager)this.progBox.getSelectedItem();
        if (pm == null) {
            return null;
        }
        return pm.getGlobalProgrammer();
    }

    @Override
    public boolean isSelected() {
        return true;
    }

    public ProgServiceModeComboBox() {
        this(0);
    }

    protected List<GlobalProgrammerManager> getMgrList() {
        return InstanceManager.getList(GlobalProgrammerManager.class);
    }

    public ProgServiceModeComboBox(int direction) {
        log.trace("ctor starts");
        this.modeBox = new JComboBox();
        this.modeBox.addActionListener(this);
        this.setLayout(new BoxLayout(this, direction));
        this.progBox = new JComboBox();
        Vector<GlobalProgrammerManager> v = new Vector<GlobalProgrammerManager>();
        for (GlobalProgrammerManager pm : this.getMgrList()) {
            Programmer globProg = null;
            if (pm != null) {
                globProg = pm.getGlobalProgrammer();
            }
            if (globProg == null) continue;
            v.add(pm);
            log.debug("ProgSMCombo added programmer {} as item {}", pm != null ? pm.getClass() : "null", (Object)v.size());
            globProg.addPropertyChangeListener(this);
        }
        this.add(this.progLabel);
        this.progBox = new JComboBox(v);
        this.add(this.progBox);
        this.progBox.setSelectedItem(InstanceManager.getDefault(GlobalProgrammerManager.class));
        this.progBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProgServiceModeComboBox.this.programmerSelected();
            }
        });
        this.add(new JLabel(Bundle.getMessage("ProgrammingModeLabel")));
        this.add(this.modeBox);
        this.programmerSelected();
    }

    void programmerSelected() {
        ProgrammingMode mode2;
        DefaultComboBoxModel<ProgrammingMode> model = new DefaultComboBoxModel<ProgrammingMode>();
        Programmer p = this.getProgrammer();
        if (p != null) {
            for (ProgrammingMode mode2 : this.getProgrammer().getSupportedModes()) {
                model.addElement(mode2);
            }
        }
        log.trace("programmerSelected sets model");
        this.modeBox.setModel(model);
        mode2 = this.getProgrammer() != null ? this.getProgrammer().getMode() : null;
        log.trace("programmerSelected sets mode {}", (Object)mode2);
        this.modeBox.setSelectedItem(mode2);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        log.debug("Selected mode: {}", this.modeBox.getSelectedItem());
        if (this.modeBox.getSelectedItem() != null) {
            this.getProgrammer().setMode((ProgrammingMode)this.modeBox.getSelectedItem());
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if ("Mode".equals(e.getPropertyName()) && this.getProgrammer().equals(e.getSource()) && this.isSelected()) {
            this.modeBox.setSelectedItem(e.getNewValue());
        }
    }

    @Override
    public void dispose() {
    }
}

