/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.progsupport;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import jmri.AddressedProgrammer;
import jmri.AddressedProgrammerManager;
import jmri.InstanceManager;
import jmri.Programmer;
import jmri.ProgrammingMode;
import jmri.implementation.AccessoryOpsModeProgrammerFacade;
import jmri.jmrit.progsupport.Bundle;
import jmri.jmrit.progsupport.ProgModeSelector;
import jmri.jmrix.loconet.LnProgrammerManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProgOpsModePane
extends ProgModeSelector
implements PropertyChangeListener,
ActionListener {
    ButtonGroup modeGroup = new ButtonGroup();
    HashMap<ProgrammingMode, JRadioButton> buttonMap = new HashMap();
    JComboBox<AddressedProgrammerManager> progBox;
    ArrayList<JRadioButton> buttonPool = new ArrayList();
    SpinnerNumberModel model = new SpinnerNumberModel(0, 0, 10239, 1);
    JSpinner mAddrField = new JSpinner(this.model);
    int lowAddrLimit = 0;
    int highAddrLimit = 10239;
    int oldAddrValue = 3;
    ButtonGroup addrGroup = new ButtonGroup();
    JRadioButton shortAddrButton = new JRadioButton(Bundle.getMessage("ShortAddress"));
    JRadioButton longAddrButton = new JRadioButton(Bundle.getMessage("LongAddress"));
    JCheckBox offsetAddrCheckBox = new JCheckBox(Bundle.getMessage("DccAccessoryAddressOffSet"));
    JLabel addressLabel = new JLabel(Bundle.getMessage("AddressLabel"));
    boolean oldLongAddr = false;
    boolean opsAccyMode = false;
    boolean oldOpsAccyMode = false;
    boolean opsSigMode = false;
    boolean oldOpsSigMode = false;
    boolean lnSv2Mode = false;
    boolean oldLnSv2Mode = false;
    boolean lncvMode = false;
    boolean oldLncvMode = false;
    boolean oldoffsetAddrCheckBox = false;
    volatile transient AddressedProgrammer programmer = null;
    volatile transient AccessoryOpsModeProgrammerFacade facadeProgrammer = null;
    private static final Logger log = LoggerFactory.getLogger((String)ProgOpsModePane.class.getName());

    @Override
    public Programmer getProgrammer() {
        log.debug("getProgrammer mLongAddrCheck.isSelected()={}, oldLongAddr={}, mAddrField.getValue()={}, oldAddrValue={}, opsAccyMode={}, oldOpsAccyMode={}, opsSigMode={}, oldOpsSigMode={}, lnSv2Mode={}, oldLnSv2Mode={}, lncvMode={}, oldLncvMode={}, oldoffsetAddrCheckBox={})", new Object[]{this.longAddrButton.isSelected(), this.oldLongAddr, this.mAddrField.getValue(), this.oldAddrValue, this.opsAccyMode, this.oldOpsAccyMode, this.opsSigMode, this.oldOpsSigMode, this.lnSv2Mode, this.oldLnSv2Mode, this.lncvMode, this.oldLncvMode, this.oldoffsetAddrCheckBox});
        if (this.longAddrButton.isSelected() == this.oldLongAddr && this.mAddrField.getValue().equals(this.oldAddrValue) && this.offsetAddrCheckBox.isSelected() == this.oldoffsetAddrCheckBox && this.opsAccyMode == this.oldOpsAccyMode && this.opsSigMode == this.oldOpsSigMode && this.lnSv2Mode == this.oldLnSv2Mode && this.lncvMode == this.oldLncvMode) {
            log.debug("getProgrammer hasn't changed");
            if (this.opsAccyMode || this.opsSigMode) {
                return this.facadeProgrammer;
            }
            return this.programmer;
        }
        AddressedProgrammerManager pm = (AddressedProgrammerManager)this.progBox.getSelectedItem();
        this.oldLongAddr = this.longAddrButton.isSelected();
        this.oldAddrValue = (Integer)this.mAddrField.getValue();
        this.oldOpsAccyMode = this.opsAccyMode;
        this.oldOpsSigMode = this.opsSigMode;
        this.oldLnSv2Mode = this.lnSv2Mode;
        this.oldLncvMode = this.lncvMode;
        this.oldoffsetAddrCheckBox = this.offsetAddrCheckBox.isSelected();
        this.setAddrParams();
        if (pm != null) {
            int address = 3;
            try {
                address = (Integer)this.mAddrField.getValue();
            }
            catch (NumberFormatException numberFormatException) {
                log.error("loco address \"{}\" not correct", this.mAddrField.getValue());
                this.programmer = null;
            }
            boolean longAddr = this.longAddrButton.isSelected();
            log.debug("ops programmer for address {}, long address {}", (Object)address, (Object)longAddr);
            this.programmer = pm.getAddressedProgrammer(longAddr, address);
            log.debug("   programmer: {}", (Object)this.programmer);
            this.setProgrammerFromGui(this.programmer);
        } else {
            log.warn("request for ops mode programmer with no ProgrammerManager configured");
            this.programmer = null;
        }
        if (this.opsAccyMode) {
            log.debug("   getting AccessoryOpsModeProgrammerFacade");
            this.facadeProgrammer = new AccessoryOpsModeProgrammerFacade(this.programmer, this.longAddrButton.isSelected() ? "accessory" : "decoder", 200, this.programmer);
            return this.facadeProgrammer;
        }
        if (this.opsSigMode) {
            String addrType = this.offsetAddrCheckBox.isSelected() ? "signal" : "altsignal";
            log.debug("   getting AccessoryOpsModeProgrammerFacade {}", (Object)addrType);
            this.facadeProgrammer = new AccessoryOpsModeProgrammerFacade(this.programmer, addrType, 200, this.programmer);
            return this.facadeProgrammer;
        }
        return this.programmer;
    }

    @Override
    public boolean isSelected() {
        for (JRadioButton button : this.buttonMap.values()) {
            if (!button.isSelected()) continue;
            return true;
        }
        return false;
    }

    public ProgOpsModePane(int direction) {
        this(direction, new ButtonGroup());
    }

    public ProgOpsModePane(int direction, ButtonGroup group) {
        this.modeGroup = group;
        this.addrGroup.add(this.shortAddrButton);
        this.addrGroup.add(this.longAddrButton);
        this.setLayout(new BoxLayout(this, direction));
        this.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("TitleProgramOnMain")));
        ArrayList<AddressedProgrammerManager> v = new ArrayList<AddressedProgrammerManager>();
        for (AddressedProgrammerManager pm : InstanceManager.getList(AddressedProgrammerManager.class)) {
            v.add(pm);
        }
        this.progBox = new JComboBox<AddressedProgrammerManager>(v.toArray(new AddressedProgrammerManager[0]));
        this.add(this.progBox);
        if (this.progBox.getItemCount() < 2) {
            this.progBox.setVisible(false);
        }
        this.progBox.setSelectedItem(InstanceManager.getDefault(AddressedProgrammerManager.class));
        this.progBox.addActionListener(e -> this.programmerSelected());
        this.add(new JLabel(" "));
        this.add(this.shortAddrButton);
        this.add(this.longAddrButton);
        this.add(this.offsetAddrCheckBox);
        this.offsetAddrCheckBox.setToolTipText(Bundle.getMessage("DccOffsetTooltip"));
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout());
        panel.add(this.addressLabel);
        panel.add(this.mAddrField);
        this.mAddrField.setToolTipText(Bundle.getMessage("ToolTipEnterDecoderAddress"));
        this.add(panel);
        this.add(new JLabel(Bundle.getMessage("OpsModeLabel")));
        this.shortAddrButton.addActionListener(e -> this.programmerSelected());
        this.longAddrButton.addActionListener(e -> this.programmerSelected());
        this.offsetAddrCheckBox.addActionListener(e -> this.programmerSelected());
        this.shortAddrButton.setSelected(true);
        this.offsetAddrCheckBox.setSelected(false);
        this.offsetAddrCheckBox.setVisible(false);
        this.programmerSelected();
    }

    void programmerSelected() {
        log.debug("programmerSelected starts with {} buttons", (Object)this.buttonPool.size());
        for (JRadioButton button : this.buttonPool) {
            button.setVisible(false);
        }
        this.buttonMap.clear();
        this.oldAddrValue = -1;
        int index = 0;
        ArrayList<ProgrammingMode> modes = new ArrayList<ProgrammingMode>();
        if (this.getProgrammer() != null) {
            modes.addAll(this.programmer.getSupportedModes());
        } else if (this.progBox.getSelectedItem() != null) {
            modes.addAll(((AddressedProgrammerManager)this.progBox.getSelectedItem()).getDefaultModes());
        }
        if (modes.contains(ProgrammingMode.OPSBYTEMODE)) {
            if (!modes.contains(ProgrammingMode.OPSACCBYTEMODE)) {
                log.debug("   adding button for {} via AccessoryOpsModeProgrammerFacade", (Object)ProgrammingMode.OPSACCBYTEMODE);
                modes.add(ProgrammingMode.OPSACCBYTEMODE);
            }
            if (!modes.contains(ProgrammingMode.OPSACCEXTBYTEMODE)) {
                log.debug("   adding button for {} via AccessoryOpsModeProgrammerFacade", (Object)ProgrammingMode.OPSACCEXTBYTEMODE);
                modes.add(ProgrammingMode.OPSACCEXTBYTEMODE);
            }
        }
        log.debug("   has {} modes", (Object)modes.size());
        for (ProgrammingMode mode : modes) {
            JRadioButton button;
            if (index >= this.buttonPool.size()) {
                log.debug("   add button");
                button = new JRadioButton();
                this.buttonPool.add(button);
                this.modeGroup.add(button);
                button.addActionListener(this);
                this.add(button);
            }
            log.debug("   set for {}", (Object)mode.toString());
            button = this.buttonPool.get(index++);
            button.setVisible(true);
            this.modeGroup.add(button);
            button.setText(mode.toString());
            this.buttonMap.put(mode, button);
        }
        this.setGuiFromProgrammer();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        log.debug("Selected button: {}", (Object)e.getActionCommand());
        for (ProgrammingMode mode : this.buttonMap.keySet()) {
            if (!mode.toString().equals(e.getActionCommand())) continue;
            log.debug("      setting mode {} on {}", (Object)mode.toString(), (Object)this.getProgrammer());
            if (this.getProgrammer() != null) {
                log.debug("getProgrammer() != null");
                if (mode == ProgrammingMode.OPSACCBYTEMODE) {
                    log.debug("OPS ACCY was selected in actionPerformed");
                    this.opsAccyMode = true;
                    this.opsSigMode = false;
                    this.lnSv2Mode = false;
                    this.lncvMode = false;
                } else if (mode == ProgrammingMode.OPSACCEXTBYTEMODE) {
                    log.debug("OPS SIG was selected in actionPerformed");
                    this.opsAccyMode = false;
                    this.opsSigMode = true;
                    this.lnSv2Mode = false;
                    this.lncvMode = false;
                } else {
                    this.opsAccyMode = false;
                    this.opsSigMode = false;
                    this.lnSv2Mode = mode == LnProgrammerManager.LOCONETSV2MODE;
                    this.lncvMode = mode == LnProgrammerManager.LOCONETLNCVMODE;
                    this.getProgrammer().setMode(mode);
                }
            }
            this.setAddrParams();
            return;
        }
    }

    void setProgrammerFromGui(Programmer programmer) {
        for (Map.Entry<ProgrammingMode, JRadioButton> entry : this.buttonMap.entrySet()) {
            if (!entry.getValue().isSelected()) continue;
            if (entry.getKey() == ProgrammingMode.OPSACCBYTEMODE) {
                log.debug("OPS ACCY was selected in setProgrammerFromGui");
                this.opsAccyMode = true;
                this.opsSigMode = false;
                this.lnSv2Mode = false;
                this.lncvMode = false;
                continue;
            }
            if (entry.getKey() == ProgrammingMode.OPSACCEXTBYTEMODE) {
                log.debug("OPS SIG was selected in setProgrammerFromGui");
                this.opsAccyMode = false;
                this.opsSigMode = true;
                this.lnSv2Mode = false;
                this.lncvMode = false;
                continue;
            }
            this.opsAccyMode = false;
            this.opsSigMode = false;
            this.lnSv2Mode = entry.getKey() == LnProgrammerManager.LOCONETSV2MODE;
            this.lncvMode = entry.getKey() == LnProgrammerManager.LOCONETLNCVMODE;
            this.getProgrammer().setMode(entry.getKey());
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if ("Mode".equals(e.getPropertyName()) && this.getProgrammer().equals(e.getSource()) && this.isSelected()) {
            this.setGuiFromProgrammer();
        }
    }

    void setGuiFromProgrammer() {
        if (this.getProgrammer() == null) {
            for (JRadioButton button : this.buttonPool) {
                button.setSelected(false);
            }
            return;
        }
        ProgrammingMode mode = this.getProgrammer().getMode();
        if (this.opsAccyMode) {
            mode = ProgrammingMode.OPSACCBYTEMODE;
        } else if (this.opsSigMode) {
            mode = ProgrammingMode.OPSACCEXTBYTEMODE;
        }
        JRadioButton button = this.buttonMap.get(mode);
        if (button == null) {
            log.error("setGuiFromProgrammer found mode \"{}\" that's not supported by the programmer", (Object)mode);
            return;
        }
        log.debug("  setting button for mode {}", (Object)mode);
        button.setSelected(true);
        this.setAddrParams();
    }

    void setAddrParams() {
        int address;
        if (this.opsAccyMode) {
            this.shortAddrButton.setText(Bundle.getMessage("DecoderAddress"));
            this.shortAddrButton.setToolTipText(Bundle.getMessage("ToolTipDecoderAddress"));
            this.shortAddrButton.setVisible(true);
            this.longAddrButton.setText(Bundle.getMessage("AccessoryAddress"));
            this.longAddrButton.setToolTipText(Bundle.getMessage("ToolTipAccessoryAddress"));
            this.offsetAddrCheckBox.setVisible(false);
            this.addressLabel.setText(Bundle.getMessage("AddressLabel"));
            if (this.longAddrButton.isSelected()) {
                this.lowAddrLimit = 1;
                this.highAddrLimit = 2044;
            } else {
                this.lowAddrLimit = 1;
                this.highAddrLimit = 511;
            }
        } else if (this.opsSigMode) {
            this.shortAddrButton.setVisible(false);
            this.longAddrButton.setVisible(false);
            this.offsetAddrCheckBox.setVisible(true);
            this.addressLabel.setText(Bundle.getMessage("SignalAddressLabel"));
            this.lowAddrLimit = 1;
            this.highAddrLimit = 2044;
        } else if (this.lnSv2Mode) {
            this.shortAddrButton.setVisible(false);
            this.longAddrButton.setVisible(false);
            this.offsetAddrCheckBox.setVisible(false);
            this.addressLabel.setText(Bundle.getMessage("NodeLabel"));
            this.lowAddrLimit = 0;
            this.highAddrLimit = 65535;
        } else if (this.lncvMode) {
            this.shortAddrButton.setVisible(false);
            this.longAddrButton.setVisible(false);
            this.offsetAddrCheckBox.setVisible(false);
            this.addressLabel.setText(Bundle.getMessage("ModuleLabel"));
            this.lowAddrLimit = 0;
            this.highAddrLimit = 65535;
        } else {
            this.shortAddrButton.setText(Bundle.getMessage("ShortAddress"));
            this.shortAddrButton.setToolTipText(Bundle.getMessage("ToolTipShortAddress"));
            this.shortAddrButton.setVisible(true);
            this.longAddrButton.setText(Bundle.getMessage("LongAddress"));
            this.longAddrButton.setToolTipText(Bundle.getMessage("ToolTipLongAddress"));
            this.offsetAddrCheckBox.setVisible(false);
            this.addressLabel.setText(Bundle.getMessage("AddressLabel"));
            if (this.longAddrButton.isSelected()) {
                this.lowAddrLimit = 0;
                this.highAddrLimit = 10239;
            } else {
                this.lowAddrLimit = 1;
                this.highAddrLimit = 127;
            }
        }
        log.debug("Setting lowAddrLimit={}, highAddrLimit={}", (Object)this.lowAddrLimit, (Object)this.highAddrLimit);
        this.model.setMinimum(Integer.valueOf(this.lowAddrLimit));
        this.model.setMaximum(Integer.valueOf(this.highAddrLimit));
        try {
            address = (Integer)this.mAddrField.getValue();
        }
        catch (NumberFormatException numberFormatException) {
            log.debug("loco address \"{}\" not correct", this.mAddrField.getValue());
            return;
        }
        if (address < this.lowAddrLimit) {
            this.mAddrField.setValue(this.lowAddrLimit);
        } else if (address > this.highAddrLimit) {
            this.mAddrField.setValue(this.highAddrLimit);
        }
    }

    @Override
    public void dispose() {
    }
}

