/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.progsupport;

import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import jmri.AddressedProgrammerManager;
import jmri.GlobalProgrammerManager;
import jmri.InstanceManager;
import jmri.Programmer;
import jmri.jmrit.progsupport.Bundle;
import jmri.jmrit.progsupport.ProgModeSelector;
import jmri.jmrit.progsupport.ProgOpsModePane;
import jmri.jmrit.progsupport.ProgServiceModePane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProgModePane
extends ProgModeSelector {
    ProgOpsModePane mOpsPane;
    ProgServiceModePane mServicePane;
    ButtonGroup group = new ButtonGroup();
    private static final Logger log = LoggerFactory.getLogger(ProgModePane.class);

    public ProgModePane(int direction) {
        if (log.isDebugEnabled()) {
            log.debug("AddressedProgrammerManager:");
            InstanceManager.getList(AddressedProgrammerManager.class).forEach(p -> log.debug("   {}", (Object)p.toString()));
            log.debug("GlobalProgrammerManager:");
            InstanceManager.getList(GlobalProgrammerManager.class).forEach(p -> log.debug("   {}", (Object)p.toString()));
        }
        this.setLayout(new BoxLayout(this, direction));
        boolean addSep = false;
        this.mOpsPane = null;
        if (InstanceManager.getNullableDefault(AddressedProgrammerManager.class) != null && InstanceManager.getDefault(AddressedProgrammerManager.class).isAddressedModePossible()) {
            this.mOpsPane = new ProgOpsModePane(direction, this.group);
        }
        if (InstanceManager.getNullableDefault(GlobalProgrammerManager.class) != null) {
            this.mServicePane = new ProgServiceModePane(direction, this.group);
            JPanel temp = new JPanel();
            temp.add(this.mServicePane);
            temp.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("TitleProgramServiceMode")));
            this.add(temp);
            addSep = true;
        }
        if (this.mOpsPane != null) {
            if (addSep) {
                this.add(new JSeparator());
            }
            this.add(this.mOpsPane);
        }
    }

    @Override
    public boolean isSelected() {
        return true;
    }

    @Override
    public Programmer getProgrammer() {
        if (this.mServicePane != null && this.mServicePane.isSelected()) {
            return this.mServicePane.getProgrammer();
        }
        if (this.mOpsPane != null && this.mOpsPane.isSelected()) {
            return this.mOpsPane.getProgrammer();
        }
        return null;
    }

    @Override
    public void dispose() {
        if (this.mServicePane != null) {
            this.mServicePane.dispose();
        }
        this.mServicePane = null;
        if (this.mOpsPane != null) {
            this.mOpsPane.dispose();
        }
        this.mOpsPane = null;
    }
}

