/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.pragotronclock;

import java.awt.Color;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Date;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import jmri.InstanceManager;
import jmri.Timebase;
import jmri.jmrit.catalog.NamedIcon;
import jmri.jmrit.pragotronclock.Bundle;
import jmri.util.JmriJFrame;

public class PragotronClockFrame
extends JmriJFrame
implements PropertyChangeListener {
    JLabel h24;
    JLabel m1;
    JLabel m2;
    JLabel colon;
    double aspect;
    double iconAspect10;
    double iconAspectDot;
    double iconAspect24;
    Timebase clock;
    NamedIcon[] foldingSheets10 = new NamedIcon[10];
    NamedIcon[] baseFoldingSheets10 = new NamedIcon[10];
    NamedIcon[] foldingSheets24 = new NamedIcon[24];
    NamedIcon[] baseFoldingSheets24 = new NamedIcon[24];
    NamedIcon colonIcon;
    NamedIcon baseColon;
    JButton b;

    public PragotronClockFrame() {
        super(Bundle.getMessage("MenuItemPragotronClock"));
        Image scaledImage;
        this.getContentPane().setBackground(new Color(0x3D3D3D));
        this.clock = InstanceManager.getDefault(Timebase.class);
        int i = 0;
        while (i < 10) {
            this.baseFoldingSheets10[i] = new NamedIcon("resources/icons/misc/Pragotron/M" + i + ".png", "resources/icons/misc/Pragotron/M" + i + ".png");
            this.foldingSheets10[i] = new NamedIcon("resources/icons/misc/Pragotron/M" + i + ".png", "resources/icons/misc/Pragotron/M" + i + ".png");
            ++i;
        }
        i = 0;
        while (i < 24) {
            this.baseFoldingSheets24[i] = new NamedIcon("resources/icons/misc/Pragotron/H" + i + ".png", "resources/icons/misc/Pragotron/H" + i + ".png");
            this.foldingSheets24[i] = new NamedIcon("resources/icons/misc/Pragotron/H" + i + ".png", "resources/icons/misc/Pragotron/H" + i + ".png");
            ++i;
        }
        this.colonIcon = new NamedIcon("resources/icons/misc/Pragotron/dot.png", "resources/icons/misc/Pragotron/dot.png");
        this.baseColon = new NamedIcon("resources/icons/misc/Pragotron/dot.png", "resources/icons/misc/Pragotron/dot.png");
        i = 0;
        while (i < 10) {
            scaledImage = this.baseFoldingSheets10[i].getImage().getScaledInstance(32, 48, 4);
            this.foldingSheets10[i].setImage(scaledImage);
            ++i;
        }
        i = 0;
        while (i < 24) {
            scaledImage = this.baseFoldingSheets24[i].getImage().getScaledInstance(80, 48, 4);
            this.foldingSheets24[i].setImage(scaledImage);
            ++i;
        }
        Image scaledImage2 = this.baseColon.getImage().getScaledInstance(10, 48, 4);
        this.colonIcon.setImage(scaledImage2);
        this.iconAspect10 = 0.7916666666666666;
        this.iconAspect24 = 1.6666666666666667;
        this.iconAspectDot = 0.20833333333333334;
        this.aspect = !this.clock.getShowStopButton() ? 3.4583333333333335 : 4.25;
        this.clock.addPropertyChangeListener(this);
        this.m1 = new JLabel(this.foldingSheets10[0]);
        this.m2 = new JLabel(this.foldingSheets10[0]);
        this.h24 = new JLabel(this.foldingSheets24[0]);
        this.colon = new JLabel(this.colonIcon);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 0));
        this.getContentPane().add(this.h24);
        this.getContentPane().add(this.colon);
        this.getContentPane().add(this.m1);
        this.getContentPane().add(this.m2);
        this.b = new JButton(Bundle.getMessage("ButtonPauseClock"));
        this.getContentPane().add(this.b);
        this.b.addActionListener(new ButtonListener());
        this.b.setVisible(this.clock.getShowStopButton());
        this.updateButtonText();
        this.update();
        this.pack();
        this.clock.addMinuteChangeListener(e -> this.update());
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                PragotronClockFrame.this.scaleImage();
            }
        });
    }

    public void scaleImage() {
        Image scaledImage;
        int iconWidthDot;
        int iconHeightDot;
        int iconWidth24;
        int iconHeight24;
        int iconWidth10;
        int iconHeight10;
        int frameWidth = this.getContentPane().getSize().width;
        int frameHeight = this.getContentPane().getSize().height;
        if ((double)frameWidth / (double)frameHeight > this.aspect) {
            iconHeight10 = frameHeight;
            iconWidth10 = (int)(this.iconAspect10 * (double)iconHeight10);
            iconHeight24 = frameHeight;
            iconWidth24 = (int)(this.iconAspect24 * (double)iconHeight24);
            iconHeightDot = frameHeight;
            iconWidthDot = (int)(this.iconAspectDot * (double)iconHeightDot);
        } else {
            iconWidth10 = (int)((double)frameWidth / 664.0 * 152.0);
            iconHeight10 = (int)((double)iconWidth10 / this.iconAspect10);
            iconWidth24 = (int)((double)frameWidth / 664.0 * 320.0);
            iconHeight24 = (int)((double)iconWidth24 / this.iconAspect24);
            iconWidthDot = (int)((double)frameWidth / 664.0 * 40.0);
            iconHeightDot = (int)((double)iconWidthDot / this.iconAspectDot);
        }
        int i = 0;
        while (i < 10) {
            scaledImage = this.baseFoldingSheets10[i].getImage().getScaledInstance(iconWidth10, iconHeight10, 4);
            this.foldingSheets10[i].setImage(scaledImage);
            ++i;
        }
        i = 0;
        while (i < 24) {
            scaledImage = this.baseFoldingSheets24[i].getImage().getScaledInstance(iconWidth24, iconHeight24, 4);
            this.foldingSheets24[i].setImage(scaledImage);
            ++i;
        }
        Image scaledImage2 = this.baseColon.getImage().getScaledInstance(iconWidthDot, iconHeightDot, 4);
        this.colonIcon.setImage(scaledImage2);
        this.getContentPane().revalidate();
    }

    void update() {
        Date now = this.clock.getTime();
        int hours = now.getHours();
        int minutes = now.getMinutes();
        this.h24.setIcon(this.foldingSheets24[hours]);
        this.m1.setIcon(this.foldingSheets10[minutes / 10]);
        this.m2.setIcon(this.foldingSheets10[minutes - minutes / 10 * 10]);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        this.updateButtonText();
    }

    private void updateButtonText() {
        this.b.setText(Bundle.getMessage(this.clock.getRun() ? "ButtonPauseClock" : "ButtonRunClock"));
    }

    private class ButtonListener
    implements ActionListener {
        private ButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent a) {
            PragotronClockFrame.this.clock.setRun(!PragotronClockFrame.this.clock.getRun());
            PragotronClockFrame.this.updateButtonText();
        }
    }
}

