/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.powerpanel;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import jmri.JmriException;
import jmri.PowerManager;
import jmri.jmrit.catalog.NamedIcon;
import jmri.jmrit.powerpanel.Bundle;
import jmri.swing.PowerManagerMenu;
import jmri.util.javaworld.GridLayout2;
import jmri.util.swing.JmriPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PowerPane
extends JmriPanel
implements PropertyChangeListener {
    JLabel onOffStatus = new JLabel(Bundle.getMessage("LabelUnknown"));
    JButton onButton = new JButton(Bundle.getMessage("ButtonOn"));
    JButton offButton = new JButton(Bundle.getMessage("ButtonOff"));
    JButton idleButton = new JButton(Bundle.getMessage("ButtonIdle"));
    NamedIcon onIcon = new NamedIcon("resources/icons/throttles/power_green.png", "resources/icons/throttles/power_green.png");
    NamedIcon offIcon = new NamedIcon("resources/icons/throttles/power_red.png", "resources/icons/throttles/power_red.png");
    NamedIcon unknownIcon = new NamedIcon("resources/icons/throttles/power_yellow.png", "resources/icons/throttles/power_yellow.png");
    PowerManagerMenu selectMenu;
    PowerManager listening = null;
    private static final Logger log = LoggerFactory.getLogger(PowerPane.class);

    @Override
    public String getHelpTarget() {
        return "package.jmri.jmrit.powerpanel.PowerPanelFrame";
    }

    @Override
    public String getTitle() {
        return Bundle.getMessage("TitlePowerPanel");
    }

    @Override
    public List<JMenu> getMenus() {
        ArrayList<JMenu> list = new ArrayList<JMenu>();
        list.add(this.selectMenu);
        return list;
    }

    public PowerPane() {
        this.init();
    }

    private void init() {
        this.selectMenu = new PowerManagerMenu(){

            @Override
            protected void choiceChanged() {
                PowerPane.this.managerChanged();
            }
        };
        this.onButton.addActionListener(e -> this.onButtonPushed());
        this.offButton.addActionListener(e -> this.offButtonPushed());
        this.idleButton.addActionListener(e -> this.idleButtonPushed());
        if (this.selectMenu != null && this.selectMenu.getManager() != null) {
            this.idleButton.setVisible(this.selectMenu.getManager().implementsIdle());
        } else {
            this.idleButton.setVisible(false);
        }
        this.idleButton.setToolTipText(Bundle.getMessage("ToolTipIdleButton"));
        this.setLayout(new GridLayout2(3, 2, 6, 0));
        this.add(new JLabel(Bundle.getMessage("LabelLayoutPower")));
        this.add(this.onButton);
        this.add(this.onOffStatus);
        this.add(this.offButton);
        this.add(new JLabel(""));
        this.add(this.idleButton);
        this.setStatus();
    }

    void setStatus() {
        if (this.mgrOK()) {
            switch (this.listening.getPower()) {
                case 2: {
                    this.onOffStatus.setText(Bundle.getMessage("StatusOn"));
                    this.onOffStatus.setIcon(this.onIcon);
                    break;
                }
                case 4: {
                    this.onOffStatus.setText(Bundle.getMessage("StatusOff"));
                    this.onOffStatus.setIcon(this.offIcon);
                    break;
                }
                case 8: {
                    this.onOffStatus.setText(Bundle.getMessage("StatusIdle"));
                    this.onOffStatus.setIcon(this.unknownIcon);
                    break;
                }
                case 1: {
                    this.onOffStatus.setText(Bundle.getMessage("StatusUnknown"));
                    this.onOffStatus.setIcon(this.unknownIcon);
                    break;
                }
                default: {
                    this.onOffStatus.setText(Bundle.getMessage("StatusUnknown"));
                    this.onOffStatus.setIcon(this.unknownIcon);
                    log.error("Unexpected state value: {}", (Object)this.selectMenu.getManager().getPower());
                }
            }
        }
    }

    void managerChanged() {
        if (this.listening != null) {
            this.listening.removePropertyChangeListener(this);
        }
        this.listening = null;
        this.setStatus();
    }

    private boolean mgrOK() {
        if (this.listening == null) {
            this.listening = this.selectMenu.getManager();
            log.debug("Manager = {}", (Object)this.listening);
            if (this.listening == null) {
                log.debug("No power manager instance found, panel not active");
                return false;
            }
            this.listening.addPropertyChangeListener(this);
            this.idleButton.setVisible(this.listening.implementsIdle());
        }
        return true;
    }

    public void onButtonPushed() {
        if (this.mgrOK()) {
            try {
                this.selectMenu.getManager().setPower(2);
            }
            catch (JmriException e) {
                log.error("Exception trying to turn power on {}", (Throwable)e);
            }
        }
    }

    public void offButtonPushed() {
        if (this.mgrOK()) {
            try {
                this.selectMenu.getManager().setPower(4);
            }
            catch (JmriException e) {
                log.error("Exception trying to turn power off {}", (Throwable)e);
            }
        }
    }

    public void idleButtonPushed() {
        if (this.mgrOK()) {
            if (!this.listening.implementsIdle()) {
                return;
            }
            try {
                this.selectMenu.getManager().setPower(8);
            }
            catch (JmriException e) {
                log.error("Exception trying to set power to idle {}", (Throwable)e);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent ev) {
        log.debug("PropertyChange received ");
        switch (this.listening.getPower()) {
            case 2: {
                this.onOffStatus.setText(Bundle.getMessage("StatusOn"));
                this.onOffStatus.setIcon(this.onIcon);
                break;
            }
            case 4: {
                this.onOffStatus.setText(Bundle.getMessage("StatusOff"));
                this.onOffStatus.setIcon(this.offIcon);
                break;
            }
            case 8: {
                this.onOffStatus.setText(Bundle.getMessage("StatusIdle"));
                this.onOffStatus.setIcon(this.unknownIcon);
                break;
            }
            case 1: {
                this.onOffStatus.setText(Bundle.getMessage("StatusUnknown"));
                this.onOffStatus.setIcon(this.unknownIcon);
                break;
            }
            default: {
                this.onOffStatus.setText(Bundle.getMessage("StatusUnknown"));
                this.onOffStatus.setIcon(this.unknownIcon);
                log.error("Unexpected state value: {}", (Object)this.listening.getPower());
            }
        }
    }

    @Override
    public void dispose() {
        if (this.listening != null) {
            this.listening.removePropertyChangeListener(this);
        }
    }
}

