/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.picker;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jmri.jmrit.beantable.AddNewDevicePanel;
import jmri.jmrit.picker.Bundle;
import jmri.jmrit.picker.PickFrame;
import jmri.jmrit.picker.PickListModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PickPanel
extends JPanel
implements ListSelectionListener,
ChangeListener {
    private int ROW_HEIGHT;
    PickListModel[] _models;
    JTabbedPane _tabPane = new JTabbedPane();
    JPanel _addPanel;
    JPanel _cantAddPanel;
    JTextField _sysNametext;
    JTextField _userNametext;
    PickFrame _pickTables;
    private static final Logger log = LoggerFactory.getLogger(PickPanel.class);

    public PickPanel(PickListModel[] models) {
        this._models = new PickListModel[models.length];
        System.arraycopy(models, 0, this._models, 0, models.length);
        int i = 0;
        while (i < models.length) {
            JTable table = models[i].makePickTable();
            JPanel p = new JPanel();
            p.setLayout(new BorderLayout(5, 5));
            p.add((Component)new JLabel(models[i].getName(), 0), "North");
            p.add((Component)new JScrollPane(table), "Center");
            this._tabPane.add((Component)p, models[i].getName());
            this.ROW_HEIGHT = table.getRowHeight();
            ++i;
        }
        this.setLayout(new BorderLayout(5, 5));
        this.add((Component)this._tabPane, "Center");
        this.add((Component)this.makeAddToTablePanel(), "South");
        this._tabPane.addChangeListener(this);
    }

    private JPanel makeAddToTablePanel() {
        this._sysNametext = new JTextField();
        this._userNametext = new JTextField();
        ActionListener cancelListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent a) {
            }
        };
        ActionListener okListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent a) {
                PickPanel.this.addToTable();
            }
        };
        this._addPanel = new AddNewDevicePanel(this._sysNametext, this._userNametext, "addToTable", okListener, cancelListener);
        this._cantAddPanel = new JPanel();
        this._cantAddPanel.setLayout(new BorderLayout(5, 5));
        this._cantAddPanel.add((Component)new JLabel(Bundle.getMessage("CantAddNew"), 0), "North");
        this._cantAddPanel.add((Component)new JLabel(Bundle.getMessage("OpenToAdd"), 0), "South");
        JPanel p = new JPanel();
        p.add(this._addPanel);
        p.add(this._cantAddPanel);
        this.stateChanged(null);
        int width = Math.max(100, this.getPreferredSize().width);
        this._sysNametext.setPreferredSize(new Dimension(width, this._sysNametext.getPreferredSize().height));
        return p;
    }

    void addToTable() {
        String sysname = this._sysNametext.getText();
        if (sysname != null && sysname.length() > 1) {
            PickListModel model = this._models[this._tabPane.getSelectedIndex()];
            String uname = this._userNametext.getText();
            if (uname != null && uname.trim().length() == 0) {
                uname = null;
            }
            Object bean = null;
            try {
                bean = model.addBean(sysname, uname);
            }
            catch (IllegalArgumentException ex) {
                JOptionPane.showMessageDialog(null, Bundle.getMessage("PickAddFailed", ex.getMessage()), Bundle.getMessage("WarningTitle"), 2);
            }
            if (bean != null) {
                int setRow = model.getIndexOf(bean);
                model.getTable().setRowSelectionInterval(setRow, setRow);
                JPanel p = (JPanel)this._tabPane.getSelectedComponent();
                ((JScrollPane)p.getComponent(1)).getVerticalScrollBar().setValue(setRow * this.ROW_HEIGHT);
                this._sysNametext.setText("");
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        PickListModel model = this._models[this._tabPane.getSelectedIndex()];
        if (model.canAddBean()) {
            this._cantAddPanel.setVisible(false);
            this._addPanel.setVisible(true);
        } else {
            this._addPanel.setVisible(false);
            this._cantAddPanel.setVisible(true);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (log.isDebugEnabled()) {
            log.debug("ListSelectionEvent from {} idx= {}", (Object)e.getSource().getClass().getName(), (Object)e.getFirstIndex());
        }
    }
}

