/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.picker;

import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import java.util.TreeSet;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.JTable;
import javax.swing.SortOrder;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;
import jmri.Block;
import jmri.BlockManager;
import jmri.InstanceManager;
import jmri.Light;
import jmri.LightManager;
import jmri.Logix;
import jmri.LogixManager;
import jmri.Manager;
import jmri.Memory;
import jmri.MemoryManager;
import jmri.NamedBean;
import jmri.Reporter;
import jmri.ReporterManager;
import jmri.Sensor;
import jmri.SensorManager;
import jmri.SignalHead;
import jmri.SignalHeadManager;
import jmri.SignalMast;
import jmri.SignalMastManager;
import jmri.Turnout;
import jmri.TurnoutManager;
import jmri.jmrit.beantable.BeanTableDataModel;
import jmri.jmrit.entryexit.DestinationPoints;
import jmri.jmrit.entryexit.EntryExitPairs;
import jmri.jmrit.logix.OBlock;
import jmri.jmrit.logix.OBlockManager;
import jmri.jmrit.logix.Warrant;
import jmri.jmrit.logix.WarrantManager;
import jmri.jmrit.picker.Bundle;
import jmri.swing.RowSorterUtil;
import jmri.util.AlphanumComparator;
import jmri.util.DnDTableExportHandler;
import jmri.util.NamedBeanComparator;
import jmri.util.swing.XTableColumnModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PickListModel<E extends NamedBean>
extends BeanTableDataModel<E> {
    protected ArrayList<E> _pickList;
    protected String _name;
    private JTable _table;
    protected TableRowSorter<PickListModel<E>> _sorter;
    public static final int SNAME_COLUMN = 0;
    public static final int UNAME_COLUMN = 1;
    public static final int POSITION_COL = 2;
    public static final ResourceBundle rb = ResourceBundle.getBundle("jmri.jmrit.beantable.BeanTableBundle");
    static HashMap<String, Integer> _listMap = new HashMap();
    private static final Logger log = LoggerFactory.getLogger(PickListModel.class);

    public static int getNumInstances(@Nonnull String type) {
        Integer num = _listMap.get(type.toLowerCase());
        log.debug("getNumInstances of {} num={}", (Object)type, (Object)num);
        if (num != null) {
            return num;
        }
        return 0;
    }

    @CheckForNull
    public E getBeanAt(int index) {
        if (index >= this._pickList.size()) {
            return null;
        }
        return (E)((NamedBean)this._pickList.get(index));
    }

    public int getIndexOf(@Nonnull E bean) {
        int i = 0;
        while (i < this._pickList.size()) {
            if (((NamedBean)this._pickList.get(i)).equals(bean)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Nonnull
    public List<E> getBeanList() {
        return this._pickList;
    }

    @Override
    protected synchronized void updateNameList() {
        this.makePickList();
    }

    private void makePickList() {
        if (this._pickList != null) {
            for (NamedBean e : this._pickList) {
                e.removePropertyChangeListener(this);
            }
        }
        TreeSet ts = new TreeSet(new NamedBeanComparator());
        ts.addAll(this.getManager().getNamedBeanSet());
        this._pickList = new ArrayList(this.getManager().getNamedBeanSet().size());
        this._pickList.addAll(ts);
        for (NamedBean e : this._pickList) {
            e.addPropertyChangeListener(this);
        }
        log.debug("_pickList has {} beans", (Object)this._pickList.size());
    }

    @Override
    @CheckForNull
    public E getBySystemName(@Nonnull String name) {
        return this.getManager().getBySystemName(name);
    }

    @Override
    @CheckForNull
    protected E getByUserName(@Nonnull String name) {
        return this.getManager().getByUserName(name);
    }

    @Override
    @Nonnull
    public abstract Manager<E> getManager();

    @CheckForNull
    public abstract E addBean(@Nonnull String var1) throws IllegalArgumentException;

    @CheckForNull
    public abstract E addBean(@Nonnull String var1, String var2) throws IllegalArgumentException;

    public abstract boolean canAddBean();

    @Override
    protected String getMasterClassName() {
        return "PickListModel";
    }

    @Override
    public void clickOn(E t) {
    }

    @Override
    public Class<?> getColumnClass(int c) {
        return String.class;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int c) {
        if (c == 0) {
            return Bundle.getMessage("ColumnSystemName");
        }
        if (c == 1) {
            return Bundle.getMessage("ColumnUserName");
        }
        return "";
    }

    @Override
    public boolean isCellEditable(int r, int c) {
        return false;
    }

    @Override
    public int getRowCount() {
        return this._pickList.size();
    }

    @Override
    public Object getValueAt(int r, int c) {
        if (r >= this._pickList.size()) {
            log.debug("row is greater than picklist size");
            return null;
        }
        if (c == 0) {
            return ((NamedBean)this._pickList.get(r)).getSystemName();
        }
        if (c == 1) {
            return ((NamedBean)this._pickList.get(r)).getUserName();
        }
        return null;
    }

    @Override
    public void setValueAt(Object type, int r, int c) {
    }

    @Override
    public String getValue(String systemName) {
        return systemName;
    }

    public String getName() {
        return this._name;
    }

    @Override
    protected String getBeanType() {
        return this._name;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("length")) {
            this.makePickList();
            this.fireTableDataChanged();
        }
        if (e.getSource() instanceof NamedBean) {
            NamedBean bean = (NamedBean)e.getSource();
            int i = 0;
            while (i < this._pickList.size()) {
                if (bean.equals(this._pickList.get(i))) {
                    this.fireTableRowsUpdated(i, i);
                    break;
                }
                ++i;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("propertyChange of \"{}\" for {}", (Object)e.getPropertyName(), (Object)e.getSource().toString());
        }
    }

    public JTable makePickTable() {
        this._sorter = new TableRowSorter<PickListModel>(this);
        this._table = new JTable(this){

            @Override
            public void changeSelection(int row, int col, boolean toggle, boolean extend) {
                if (super.getValueAt(row, col) != null) {
                    super.changeSelection(row, col, toggle, extend);
                }
            }
        };
        this._sorter.setComparator(0, new AlphanumComparator());
        this._sorter.setComparator(1, new AlphanumComparator());
        RowSorterUtil.setSortOrder(this._sorter, 0, SortOrder.ASCENDING);
        this._table.setRowSorter(this._sorter);
        this._table.setRowSelectionAllowed(true);
        this._table.setSelectionMode(0);
        this._table.setPreferredScrollableViewportSize(new Dimension(250, this._table.getRowHeight() * 7));
        this._table.setDragEnabled(true);
        this._table.setTransferHandler(new DnDTableExportHandler());
        this._table.getTableHeader().setReorderingAllowed(true);
        this._table.setColumnModel(new XTableColumnModel());
        this._table.createDefaultColumnsFromModel();
        TableColumnModel columnModel = this._table.getColumnModel();
        TableColumn sNameColumnT = columnModel.getColumn(0);
        sNameColumnT.setResizable(true);
        sNameColumnT.setMinWidth(50);
        TableColumn uNameColumnT = columnModel.getColumn(1);
        uNameColumnT.setResizable(true);
        uNameColumnT.setMinWidth(100);
        this.addMouseListenerToHeader(this._table);
        this._table.setAutoCreateColumnsFromModel(false);
        return this._table;
    }

    public void makeSorter(@Nonnull JTable table) {
        this._sorter = new TableRowSorter<PickListModel>(this);
        this._sorter.setComparator(0, new AlphanumComparator());
        this._sorter.setComparator(1, new AlphanumComparator());
        RowSorterUtil.setSortOrder(this._sorter, 0, SortOrder.ASCENDING);
        table.setRowSorter(this._sorter);
    }

    @Nonnull
    public JTable getTable() {
        return this._table;
    }

    @Override
    public void dispose() {
        this.getManager().removePropertyChangeListener(this);
    }

    @Nonnull
    public static PickListModel<Turnout> turnoutPickModelInstance() {
        Integer num = _listMap.get("turnout");
        if (num != null) {
            _listMap.put("turnout", num + 1);
        } else {
            _listMap.put("turnout", 1);
        }
        return new TurnoutPickModel();
    }

    @Nonnull
    public static PickListModel<Sensor> sensorPickModelInstance() {
        Integer num = _listMap.get("sensor");
        if (num != null) {
            _listMap.put("sensor", num + 1);
        } else {
            _listMap.put("sensor", 1);
        }
        return new SensorPickModel();
    }

    @Nonnull
    public static PickListModel<Sensor> multiSensorPickModelInstance() {
        Integer num = _listMap.get("multisensor");
        if (num != null) {
            _listMap.put("multisensor", num + 1);
        } else {
            _listMap.put("multisensor", 1);
        }
        return new MultiSensorPickModel();
    }

    @Nonnull
    public static PickListModel<SignalHead> signalHeadPickModelInstance() {
        Integer num = _listMap.get("signalhead");
        if (num != null) {
            _listMap.put("signalhead", num + 1);
        } else {
            _listMap.put("signalhead", 1);
        }
        return new SignalHeadPickModel();
    }

    @Nonnull
    public static PickListModel<SignalMast> signalMastPickModelInstance() {
        Integer num = _listMap.get("signalmast");
        if (num != null) {
            _listMap.put("signalmast", num + 1);
        } else {
            _listMap.put("signalmast", 1);
        }
        return new SignalMastPickModel();
    }

    @Nonnull
    public static PickListModel<Memory> memoryPickModelInstance() {
        Integer num = _listMap.get("memory");
        if (num != null) {
            _listMap.put("memory", num + 1);
        } else {
            _listMap.put("memory", 1);
        }
        return new MemoryPickModel();
    }

    @Nonnull
    public static PickListModel<Block> blockPickModelInstance() {
        Integer num = _listMap.get("block");
        if (num != null) {
            _listMap.put("block", num + 1);
        } else {
            _listMap.put("block", 1);
        }
        return new BlockPickModel();
    }

    @Nonnull
    public static PickListModel<Reporter> reporterPickModelInstance() {
        Integer num = _listMap.get("reporter");
        if (num != null) {
            _listMap.put("reporter", num + 1);
        } else {
            _listMap.put("reporter", 1);
        }
        return new ReporterPickModel();
    }

    @Nonnull
    public static PickListModel<Light> lightPickModelInstance() {
        Integer num = _listMap.get("light");
        if (num != null) {
            _listMap.put("light", num + 1);
        } else {
            _listMap.put("light", 1);
        }
        return new LightPickModel();
    }

    @Nonnull
    public static PickListModel<OBlock> oBlockPickModelInstance() {
        Integer num = _listMap.get("oBlock");
        if (num != null) {
            _listMap.put("oBlock", num + 1);
        } else {
            _listMap.put("oBlock", 1);
        }
        return new OBlockPickModel();
    }

    @Nonnull
    public static PickListModel<Warrant> warrantPickModelInstance() {
        Integer num = _listMap.get("warrant");
        if (num != null) {
            _listMap.put("warrant", num + 1);
        } else {
            _listMap.put("warrant", 1);
        }
        return new WarrantPickModel();
    }

    @Nonnull
    public static PickListModel<DestinationPoints> entryExitPickModelInstance() {
        Integer num = _listMap.get("entryExit");
        if (num != null) {
            _listMap.put("entryExit", num + 1);
        } else {
            _listMap.put("entryExit", 1);
        }
        return new EntryExitPickModel();
    }

    public static PickListModel<Logix> logixPickModelInstance() {
        Integer num = _listMap.get("logix");
        if (num != null) {
            _listMap.put("logix", num + 1);
        } else {
            _listMap.put("logix", 1);
        }
        return new LogixPickModel();
    }

    static class BlockPickModel
    extends PickListModel<Block> {
        BlockManager manager = InstanceManager.getDefault(BlockManager.class);

        BlockPickModel() {
            this._name = rb.getString("TitleBlockTable");
        }

        @Override
        @Nonnull
        public Manager<Block> getManager() {
            this.manager = InstanceManager.getDefault(BlockManager.class);
            return this.manager;
        }

        @Override
        public Block addBean(@Nonnull String name) throws IllegalArgumentException {
            return this.manager.provideBlock(name);
        }

        @Override
        public Block addBean(@Nonnull String sysName, String userName) throws IllegalArgumentException {
            return this.manager.createNewBlock(sysName, userName);
        }

        @Override
        public boolean canAddBean() {
            return true;
        }
    }

    static class EntryExitPickModel
    extends PickListModel<DestinationPoints> {
        EntryExitPairs manager = InstanceManager.getDefault(EntryExitPairs.class);

        EntryExitPickModel() {
            this._name = rb.getString("TitleEntryExitTable");
        }

        @Override
        @Nonnull
        public Manager<DestinationPoints> getManager() {
            this.manager = InstanceManager.getDefault(EntryExitPairs.class);
            return this.manager;
        }

        @Override
        public DestinationPoints addBean(@Nonnull String name) {
            return null;
        }

        @Override
        public DestinationPoints addBean(@Nonnull String sysName, String userName) {
            return null;
        }

        @Override
        public boolean canAddBean() {
            return false;
        }

        @Override
        public String getColumnName(int c) {
            if (c == 0) {
                return "Unique Id";
            }
            if (c == 1) {
                return Bundle.getMessage("ColumnUserName");
            }
            return "";
        }
    }

    static class LightPickModel
    extends PickListModel<Light> {
        LightManager manager = InstanceManager.lightManagerInstance();

        LightPickModel() {
            this._name = rb.getString("TitleLightTable");
        }

        @Override
        @Nonnull
        public Manager<Light> getManager() {
            this.manager = InstanceManager.lightManagerInstance();
            return this.manager;
        }

        @Override
        public Light addBean(@Nonnull String name) throws IllegalArgumentException {
            return this.manager.provideLight(name);
        }

        @Override
        public Light addBean(@Nonnull String sysName, String userName) throws IllegalArgumentException {
            return this.manager.newLight(sysName, userName);
        }

        @Override
        public boolean canAddBean() {
            return true;
        }
    }

    static class LogixPickModel
    extends PickListModel<Logix> {
        LogixManager manager;

        LogixPickModel() {
            this._name = rb.getString("TitleLogixTable");
        }

        @Override
        @Nonnull
        public Manager<Logix> getManager() {
            this.manager = InstanceManager.getDefault(LogixManager.class);
            return this.manager;
        }

        @Override
        public Logix addBean(@Nonnull String name) {
            return null;
        }

        @Override
        public Logix addBean(@Nonnull String sysName, String userName) {
            return null;
        }

        @Override
        public boolean canAddBean() {
            return false;
        }
    }

    static class MemoryPickModel
    extends PickListModel<Memory> {
        MemoryManager manager = InstanceManager.memoryManagerInstance();

        MemoryPickModel() {
            this._name = rb.getString("TitleMemoryTable");
        }

        @Override
        @Nonnull
        public Manager<Memory> getManager() {
            this.manager = InstanceManager.memoryManagerInstance();
            return this.manager;
        }

        @Override
        public Memory addBean(@Nonnull String name) throws IllegalArgumentException {
            return this.manager.provideMemory(name);
        }

        @Override
        public Memory addBean(@Nonnull String sysName, String userName) throws IllegalArgumentException {
            return this.manager.newMemory(sysName, userName);
        }

        @Override
        public boolean canAddBean() {
            return true;
        }
    }

    static class MultiSensorPickModel
    extends SensorPickModel {
        private final HashMap<Integer, String> _position = new HashMap();

        MultiSensorPickModel() {
        }

        @Override
        public Object getValueAt(int r, int c) {
            if (c == 2) {
                return this._position.get(r);
            }
            return super.getValueAt(r, c);
        }

        @Override
        public void setValueAt(Object type, int r, int c) {
            if (c == 2) {
                this._position.put(r, (String)type);
            }
        }
    }

    static class OBlockPickModel
    extends PickListModel<OBlock> {
        OBlockManager manager = InstanceManager.getDefault(OBlockManager.class);

        OBlockPickModel() {
            this._name = rb.getString("TitleBlockTable");
        }

        @Override
        @Nonnull
        public Manager<OBlock> getManager() {
            this.manager = InstanceManager.getDefault(OBlockManager.class);
            return this.manager;
        }

        @Override
        public OBlock addBean(@Nonnull String name) throws IllegalArgumentException {
            return this.manager.provideOBlock(name);
        }

        @Override
        public OBlock addBean(@Nonnull String sysName, String userName) {
            return this.manager.createNewOBlock(sysName, userName);
        }

        @Override
        public boolean canAddBean() {
            return true;
        }
    }

    static class ReporterPickModel
    extends PickListModel<Reporter> {
        ReporterManager manager = InstanceManager.getDefault(ReporterManager.class);

        ReporterPickModel() {
            this._name = rb.getString("TitleReporterTable");
        }

        @Override
        @Nonnull
        public Manager<Reporter> getManager() {
            this.manager = InstanceManager.getDefault(ReporterManager.class);
            return this.manager;
        }

        @Override
        public Reporter addBean(@Nonnull String name) throws IllegalArgumentException {
            return this.manager.provideReporter(name);
        }

        @Override
        public Reporter addBean(@Nonnull String sysName, String userName) throws IllegalArgumentException {
            return this.manager.newReporter(sysName, userName);
        }

        @Override
        public boolean canAddBean() {
            return true;
        }
    }

    static class SensorPickModel
    extends PickListModel<Sensor> {
        SensorManager manager = InstanceManager.getDefault(SensorManager.class);

        SensorPickModel() {
            this._name = rb.getString("TitleSensorTable");
        }

        @Override
        @Nonnull
        public Manager<Sensor> getManager() {
            this.manager = InstanceManager.sensorManagerInstance();
            return this.manager;
        }

        @Override
        public Sensor addBean(@Nonnull String name) throws IllegalArgumentException {
            return this.manager.provideSensor(name);
        }

        @Override
        public Sensor addBean(@Nonnull String sysName, String userName) throws IllegalArgumentException {
            return this.manager.newSensor(sysName, userName);
        }

        @Override
        public boolean canAddBean() {
            return true;
        }
    }

    static class SignalHeadPickModel
    extends PickListModel<SignalHead> {
        SignalHeadManager manager = InstanceManager.getDefault(SignalHeadManager.class);

        SignalHeadPickModel() {
            this._name = rb.getString("TitleSignalTable");
        }

        @Override
        @Nonnull
        public Manager<SignalHead> getManager() {
            this.manager = InstanceManager.getDefault(SignalHeadManager.class);
            return this.manager;
        }

        @Override
        public SignalHead addBean(@Nonnull String name) {
            return this.manager.getSignalHead(name);
        }

        @Override
        public SignalHead addBean(@Nonnull String sysName, String userName) {
            SignalHead sh = this.manager.getSignalHead(userName);
            if (sh == null) {
                sh = this.manager.getSignalHead(sysName);
            }
            return sh;
        }

        @Override
        public boolean canAddBean() {
            return false;
        }
    }

    static class SignalMastPickModel
    extends PickListModel<SignalMast> {
        SignalMastManager manager = InstanceManager.getDefault(SignalMastManager.class);

        SignalMastPickModel() {
            this._name = rb.getString("TitleSignalMastTable");
        }

        @Override
        @Nonnull
        public Manager<SignalMast> getManager() {
            this.manager = InstanceManager.getDefault(SignalMastManager.class);
            return this.manager;
        }

        @Override
        public SignalMast addBean(@Nonnull String name) throws IllegalArgumentException {
            return this.manager.provideSignalMast(name);
        }

        @Override
        public SignalMast addBean(@Nonnull String sysName, String userName) throws IllegalArgumentException {
            SignalMast sm = this.manager.getSignalMast(userName);
            if (sm == null) {
                sm = this.manager.provideSignalMast(sysName);
            }
            return sm;
        }

        @Override
        public boolean canAddBean() {
            return false;
        }
    }

    static class TurnoutPickModel
    extends PickListModel<Turnout> {
        TurnoutManager manager = InstanceManager.turnoutManagerInstance();

        TurnoutPickModel() {
            this._name = rb.getString("TitleTurnoutTable");
        }

        @Override
        @Nonnull
        public Manager<Turnout> getManager() {
            this.manager = InstanceManager.turnoutManagerInstance();
            return this.manager;
        }

        @Override
        public Turnout addBean(@Nonnull String name) throws IllegalArgumentException {
            return this.manager.provideTurnout(name);
        }

        @Override
        public Turnout addBean(@Nonnull String sysName, String userName) throws IllegalArgumentException {
            return this.manager.newTurnout(sysName, userName);
        }

        @Override
        public boolean canAddBean() {
            return true;
        }
    }

    static class WarrantPickModel
    extends PickListModel<Warrant> {
        WarrantManager manager = InstanceManager.getDefault(WarrantManager.class);

        WarrantPickModel() {
            this._name = rb.getString("TitleWarrantTable");
        }

        @Override
        @Nonnull
        public Manager<Warrant> getManager() {
            this.manager = InstanceManager.getDefault(WarrantManager.class);
            return this.manager;
        }

        @Override
        public Warrant addBean(@Nonnull String name) throws IllegalArgumentException {
            return this.manager.provideWarrant(name);
        }

        @Override
        public Warrant addBean(@Nonnull String sysName, String userName) {
            return this.manager.createNewWarrant(sysName, userName, false, 0L);
        }

        @Override
        public boolean canAddBean() {
            return false;
        }
    }
}

