/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.trains.tools;

import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import jmri.InstanceManager;
import jmri.jmrit.operations.OperationsFrame;
import jmri.jmrit.operations.OperationsXml;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.operations.trains.Train;
import jmri.jmrit.operations.trains.TrainManager;
import jmri.jmrit.operations.trains.tools.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrainsTableSetColorFrame
extends OperationsFrame
implements PropertyChangeListener {
    TrainManager trainManager = InstanceManager.getDefault(TrainManager.class);
    JRadioButton manualRadioButton = new JRadioButton(Bundle.getMessage("Manual"));
    JRadioButton autoRadioButton = new JRadioButton(Bundle.getMessage("Auto"));
    JButton saveButton = new JButton(Bundle.getMessage("ButtonSave"));
    JComboBox<Train> trainBox = InstanceManager.getDefault(TrainManager.class).getTrainComboBox();
    JComboBox<String> colorBox = InstanceManager.getDefault(TrainManager.class).getRowColorComboBox();
    JComboBox<String> colorResetBox = InstanceManager.getDefault(TrainManager.class).getRowColorComboBox();
    JComboBox<String> colorBuiltBox = InstanceManager.getDefault(TrainManager.class).getRowColorComboBox();
    JComboBox<String> colorBuildFailedBox = InstanceManager.getDefault(TrainManager.class).getRowColorComboBox();
    JComboBox<String> colorTrainEnRouteBox = InstanceManager.getDefault(TrainManager.class).getRowColorComboBox();
    JComboBox<String> colorTerminatedBox = InstanceManager.getDefault(TrainManager.class).getRowColorComboBox();
    JPanel pTrains;
    JPanel pColor;
    JPanel pColorReset;
    JPanel pColorBuilt;
    JPanel pColorBuildFailed;
    JPanel pColorTrainEnRoute;
    JPanel pColorTerminated;
    private static final Logger log = LoggerFactory.getLogger(TrainsTableSetColorFrame.class);

    public TrainsTableSetColorFrame(Train train) {
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel pOption = new JPanel();
        pOption.setLayout(new GridBagLayout());
        pOption.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Option")));
        this.addItem(pOption, this.manualRadioButton, 0, 0);
        this.addItem(pOption, this.autoRadioButton, 1, 0);
        ButtonGroup bGroup = new ButtonGroup();
        bGroup.add(this.manualRadioButton);
        bGroup.add(this.autoRadioButton);
        this.manualRadioButton.setSelected(this.trainManager.isRowColorManual());
        this.autoRadioButton.setSelected(!this.trainManager.isRowColorManual());
        this.pTrains = new JPanel();
        this.pTrains.setLayout(new GridBagLayout());
        this.pTrains.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Train")));
        this.addItem(this.pTrains, this.trainBox, 0, 0);
        this.trainBox.setSelectedItem(train);
        this.pColor = new JPanel();
        this.pColor.setLayout(new GridBagLayout());
        this.pColor.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("SelectRowColor")));
        this.addItem(this.pColor, this.colorBox, 0, 0);
        this.pColorReset = new JPanel();
        this.pColorReset.setLayout(new GridBagLayout());
        this.pColorReset.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("SelectRowColorReset")));
        this.addItem(this.pColorReset, this.colorResetBox, 0, 0);
        this.pColorBuilt = new JPanel();
        this.pColorBuilt.setLayout(new GridBagLayout());
        this.pColorBuilt.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("SelectRowColorBuilt")));
        this.addItem(this.pColorBuilt, this.colorBuiltBox, 0, 0);
        this.colorBuiltBox.setSelectedItem(this.trainManager.getRowColorNameForBuilt());
        this.pColorBuildFailed = new JPanel();
        this.pColorBuildFailed.setLayout(new GridBagLayout());
        this.pColorBuildFailed.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("SelectRowColorBuildFailed")));
        this.addItem(this.pColorBuildFailed, this.colorBuildFailedBox, 0, 0);
        this.colorBuildFailedBox.setSelectedItem(this.trainManager.getRowColorNameForBuildFailed());
        this.pColorTrainEnRoute = new JPanel();
        this.pColorTrainEnRoute.setLayout(new GridBagLayout());
        this.pColorTrainEnRoute.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("SelectRowColorTrainEnRoute")));
        this.addItem(this.pColorTrainEnRoute, this.colorTrainEnRouteBox, 0, 0);
        this.colorTrainEnRouteBox.setSelectedItem(this.trainManager.getRowColorNameForTrainEnRoute());
        this.pColorTerminated = new JPanel();
        this.pColorTerminated.setLayout(new GridBagLayout());
        this.pColorTerminated.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("SelectRowColorTerminated")));
        this.addItem(this.pColorTerminated, this.colorTerminatedBox, 0, 0);
        this.colorTerminatedBox.setSelectedItem(this.trainManager.getRowColorNameForTerminated());
        JPanel pButton = new JPanel();
        pButton.add(this.saveButton);
        this.getContentPane().add(pOption);
        this.getContentPane().add(this.pTrains);
        this.getContentPane().add(this.pColor);
        this.getContentPane().add(this.pColorReset);
        this.getContentPane().add(this.pColorBuilt);
        this.getContentPane().add(this.pColorBuildFailed);
        this.getContentPane().add(this.pColorTrainEnRoute);
        this.getContentPane().add(this.pColorTerminated);
        this.getContentPane().add(pButton);
        this.addHelpMenu("package.jmri.jmrit.operations.Operations_TrainsTableColors", true);
        this.pack();
        this.setMinimumSize(new Dimension(400, 400));
        this.setTitle(Bundle.getMessage("MenuItemSetTrainColor"));
        this.addButtonAction(this.saveButton);
        this.addRadioButtonAction(this.manualRadioButton);
        this.addRadioButtonAction(this.autoRadioButton);
        this.addComboBoxAction(this.trainBox);
        this.makePanelsVisible();
        this.trainManager.addPropertyChangeListener(this);
    }

    @Override
    public void buttonActionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.saveButton) {
            this.trainManager.setRowColorsManual(this.manualRadioButton.isSelected());
            if (this.manualRadioButton.isSelected()) {
                Train train = (Train)this.trainBox.getSelectedItem();
                if (train != null) {
                    train.setTableRowColorName((String)this.colorBox.getSelectedItem());
                    train.setRowColorNameReset((String)this.colorResetBox.getSelectedItem());
                }
            } else {
                this.trainManager.setRowColorNameForBuildFailed((String)this.colorBuildFailedBox.getSelectedItem());
                this.trainManager.setRowColorNameForBuilt((String)this.colorBuiltBox.getSelectedItem());
                this.trainManager.setRowColorNameForTrainEnRoute((String)this.colorTrainEnRouteBox.getSelectedItem());
                this.trainManager.setRowColorNameForTerminated((String)this.colorTerminatedBox.getSelectedItem());
            }
            OperationsXml.save();
            if (Setup.isCloseWindowOnSaveEnabled()) {
                this.dispose();
            }
            return;
        }
    }

    @Override
    public void radioButtonActionPerformed(ActionEvent ae) {
        this.makePanelsVisible();
    }

    private void makePanelsVisible() {
        this.pTrains.setVisible(this.manualRadioButton.isSelected());
        this.pColor.setVisible(this.manualRadioButton.isSelected());
        this.pColorReset.setVisible(this.manualRadioButton.isSelected());
        this.pColorBuildFailed.setVisible(!this.manualRadioButton.isSelected());
        this.pColorBuilt.setVisible(!this.manualRadioButton.isSelected());
        this.pColorTrainEnRoute.setVisible(!this.manualRadioButton.isSelected());
        this.pColorTerminated.setVisible(!this.manualRadioButton.isSelected());
    }

    @Override
    public void comboBoxActionPerformed(ActionEvent ae) {
        Train train = (Train)this.trainBox.getSelectedItem();
        if (train != null) {
            this.colorBox.setSelectedItem(train.getTableRowColorName());
            this.colorResetBox.setSelectedItem(train.getRowColorNameReset());
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("TrainsListLength")) {
            this.trainManager.updateTrainComboBox(this.trainBox);
        }
    }

    @Override
    public void dispose() {
        this.trainManager.removePropertyChangeListener(this);
        super.dispose();
    }
}

