/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.trains.tools;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.List;
import jmri.InstanceManager;
import jmri.jmrit.operations.routes.RouteLocation;
import jmri.jmrit.operations.setup.Control;
import jmri.jmrit.operations.trains.Train;
import jmri.jmrit.operations.trains.TrainManager;
import jmri.jmrit.operations.trains.TrainsTableFrame;
import jmri.jmrit.operations.trains.tools.Bundle;
import jmri.jmrit.operations.trains.tools.PrintTrainAction;
import jmri.util.davidflanagan.HardcopyWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrintTrainsAction
extends PrintTrainAction {
    static final String NEW_LINE = "\n";
    static final String TAB = "\t";
    static final char FORM_FEED = '\f';
    TrainManager trainManager = InstanceManager.getDefault(TrainManager.class);
    TrainsTableFrame trainsTableFrame;
    public static final int MAX_NAME_LENGTH = Control.max_len_string_train_name - 10;
    private static final Logger log = LoggerFactory.getLogger(PrintTrainsAction.class);

    public PrintTrainsAction(boolean isPreview, TrainsTableFrame frame) {
        super(isPreview);
        this.trainsTableFrame = frame;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.printTrains();
    }

    private void printTrains() {
        HardcopyWriter writer = null;
        try {
            writer = new HardcopyWriter(new Frame(), Bundle.getMessage("TitleTrainsTable"), Control.reportFontSize, 0.5, 0.5, 0.5, 0.5, this.isPreview);
        }
        catch (HardcopyWriter.PrintCanceledException printCanceledException) {
            log.debug("Print cancelled");
            return;
        }
        List<Train> trains = this.trainsTableFrame.getSortByList();
        this.printSummaryTrains(writer, trains);
        try {
            writer.write(12);
            int numberOfLines = writer.getLinesPerPage();
            for (Train train : trains) {
                if (!train.isBuildEnabled() && !this.trainsTableFrame.showAllBox.isSelected() || train.getRoute() == null) continue;
                List<RouteLocation> route = train.getRoute().getLocationsBySequenceList();
                if (numberOfLines - writer.getCurrentLineNumber() < route.size() + 10) {
                    writer.write(12);
                } else if (writer.getCurrentLineNumber() > 0) {
                    writer.write(NEW_LINE);
                }
                this.printTrain(writer, train);
            }
        }
        catch (IOException iOException) {
            log.error("Exception in print train details");
        }
        writer.close();
    }

    protected void printSummaryTrains(HardcopyWriter writer, List<Train> trains) {
        try {
            String s = String.valueOf(Bundle.getMessage("Name")) + TAB + TAB + Bundle.getMessage("Description") + TAB + Bundle.getMessage("Route") + TAB + TAB + Bundle.getMessage("Departs") + TAB + TAB + Bundle.getMessage("Time") + "  " + Bundle.getMessage("Terminates") + TAB + NEW_LINE;
            writer.write(s);
            for (Train train : trains) {
                if (!train.isBuildEnabled() && !this.trainsTableFrame.showAllBox.isSelected()) continue;
                String name = this.truncate(train.getName());
                String desc = this.truncate(train.getDescription());
                String route = this.truncate(train.getTrainRouteName());
                String departs = this.truncate(train.getTrainDepartsName());
                String terminates = this.truncate(train.getTrainTerminatesName());
                s = String.valueOf(name) + " " + desc + " " + route + " " + departs + " " + train.getDepartureTime() + " " + terminates + NEW_LINE;
                writer.write(s);
            }
        }
        catch (IOException iOException) {
            log.error("Error printing trains summary");
        }
    }

    private String truncate(String string) {
        if ((string = string.trim()).length() > MAX_NAME_LENGTH) {
            string = string.substring(0, MAX_NAME_LENGTH);
        }
        StringBuffer buf = new StringBuffer(string);
        int j = string.length();
        while (j < MAX_NAME_LENGTH) {
            buf.append(" ");
            ++j;
        }
        return buf.toString();
    }
}

