/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.trains.tools;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.text.MessageFormat;
import javax.swing.AbstractAction;
import jmri.jmrit.operations.routes.Route;
import jmri.jmrit.operations.routes.RouteLocation;
import jmri.jmrit.operations.setup.Control;
import jmri.jmrit.operations.trains.Train;
import jmri.jmrit.operations.trains.TrainEditFrame;
import jmri.jmrit.operations.trains.tools.Bundle;
import jmri.util.davidflanagan.HardcopyWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrintTrainAction
extends AbstractAction {
    static final String NEW_LINE = "\n";
    static final String TAB = "\t";
    TrainEditFrame trainEditFrame;
    boolean isPreview;
    protected static final int NUMBER_OF_HEADER_LINES = 10;
    private static final Logger log = LoggerFactory.getLogger(PrintTrainAction.class);

    public PrintTrainAction(boolean isPreview, TrainEditFrame frame) {
        super(isPreview ? Bundle.getMessage("MenuItemPreview") : Bundle.getMessage("MenuItemPrint"));
        this.isPreview = isPreview;
        this.trainEditFrame = frame;
    }

    public PrintTrainAction(boolean isPreview) {
        this(isPreview, null);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Train train = this.trainEditFrame._train;
        if (train == null) {
            return;
        }
        HardcopyWriter writer = null;
        try {
            writer = new HardcopyWriter(new Frame(), MessageFormat.format(Bundle.getMessage("TitleTrain"), train.getName()), Control.reportFontSize, 0.5, 0.5, 0.5, 0.5, this.isPreview);
        }
        catch (HardcopyWriter.PrintCanceledException printCanceledException) {
            log.debug("Print cancelled");
            return;
        }
        this.printTrain(writer, train);
        writer.close();
    }

    protected void printTrain(HardcopyWriter writer, Train train) {
        try {
            String s = String.valueOf(Bundle.getMessage("Name")) + ": " + train.getName() + NEW_LINE;
            writer.write(s);
            s = String.valueOf(Bundle.getMessage("Description")) + ": " + train.getDescription() + NEW_LINE;
            writer.write(s);
            s = String.valueOf(Bundle.getMessage("Departs")) + ": " + train.getTrainDepartsName() + NEW_LINE;
            writer.write(s);
            s = String.valueOf(Bundle.getMessage("DepartTime")) + ": " + train.getDepartureTime() + NEW_LINE;
            writer.write(s);
            s = String.valueOf(Bundle.getMessage("Terminates")) + ": " + train.getTrainTerminatesName() + NEW_LINE;
            writer.write(s);
            s = NEW_LINE;
            writer.write(s);
            s = String.valueOf(Bundle.getMessage("Route")) + ": " + train.getTrainRouteName() + NEW_LINE;
            writer.write(s);
            Route route = train.getRoute();
            if (route != null) {
                for (RouteLocation rl : route.getLocationsBySequenceList()) {
                    s = TAB + rl.getName() + NEW_LINE;
                    writer.write(s);
                }
            }
            if (!train.getComment().equals("")) {
                s = String.valueOf(Bundle.getMessage("Comment")) + ": " + train.getComment() + NEW_LINE;
                writer.write(s);
            }
        }
        catch (IOException iOException) {
            log.error("Error printing train report");
        }
    }
}

