/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.trains.tools;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;
import jmri.InstanceManager;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.locations.LocationManager;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.operations.trains.Train;
import jmri.jmrit.operations.trains.TrainManagerXml;
import jmri.jmrit.operations.trains.TrainPrintUtilities;
import jmri.jmrit.operations.trains.TrainUtilities;
import jmri.jmrit.operations.trains.tools.Bundle;
import jmri.util.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrintSavedTrainManifestAction
extends AbstractAction
implements PropertyChangeListener {
    private static final Logger log = LoggerFactory.getLogger(PrintSavedTrainManifestAction.class);
    boolean _isPreview;
    Train _train;

    public PrintSavedTrainManifestAction(boolean isPreview, Train train) {
        super(isPreview ? Bundle.getMessage("MenuItemPreviewSavedManifest") : Bundle.getMessage("MenuItemPrintSavedManifest"));
        this._isPreview = isPreview;
        this._train = train;
        this.setEnabled(Setup.isSaveTrainManifestsEnabled());
        Setup.getDefault().addPropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("saveTrainManifestChange")) {
            this.setEnabled(Setup.isSaveTrainManifestsEnabled());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Location departs;
        File file = this.getFile();
        if (file == null || !file.exists()) {
            log.debug("User didn't select a file");
            return;
        }
        if (this._isPreview && Setup.isManifestEditorEnabled()) {
            TrainUtilities.openDesktop(file);
            return;
        }
        String logoURL = "";
        if (this._train != null && !this._train.getManifestLogoPathName().equals("")) {
            logoURL = FileUtil.getExternalFilename(this._train.getManifestLogoPathName());
        } else if (!Setup.getManifestLogoURL().equals("")) {
            logoURL = FileUtil.getExternalFilename(Setup.getManifestLogoURL());
        }
        String printerName = "";
        if (this._train != null && (departs = InstanceManager.getDefault(LocationManager.class).getLocationByName(this._train.getTrainDepartsName())) != null) {
            printerName = departs.getDefaultPrinterName();
        }
        TrainPrintUtilities.printReport(file, file.getName(), this._isPreview, Setup.getFontName(), false, logoURL, printerName, Setup.getManifestOrientation(), Setup.getManifestFontSize(), Setup.isPrintPageHeaderEnabled());
    }

    protected File getFile() {
        String pathName = InstanceManager.getDefault(TrainManagerXml.class).getBackupManifestDirectoryName();
        if (this._train != null) {
            pathName = InstanceManager.getDefault(TrainManagerXml.class).getBackupManifestDirectoryName(this._train.getName());
        }
        JFileChooser fc = new JFileChooser(pathName);
        fc.setFileFilter(new FileNameExtensionFilter(Bundle.getMessage("TextFiles"), "txt"));
        int retVal = fc.showOpenDialog(null);
        if (retVal != 0) {
            return null;
        }
        return fc.getSelectedFile();
    }
}

