/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.trains.tools;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JOptionPane;
import jmri.InstanceManager;
import jmri.jmrit.XmlFile;
import jmri.jmrit.operations.routes.RouteLocation;
import jmri.jmrit.operations.setup.OperationsSetupXml;
import jmri.jmrit.operations.trains.Train;
import jmri.jmrit.operations.trains.TrainCommon;
import jmri.jmrit.operations.trains.TrainManager;
import jmri.jmrit.operations.trains.tools.Bundle;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportTrains
extends XmlFile {
    private static String operationsFileName = "ExportOperationsTrainRoster.csv";
    private static final Logger log = LoggerFactory.getLogger(ExportTrains.class);

    public void writeOperationsTrainsFile() {
        this.makeBackupFile(ExportTrains.defaultOperationsFilename());
        try {
            if (!this.checkFile(ExportTrains.defaultOperationsFilename())) {
                File file = new File(ExportTrains.defaultOperationsFilename());
                File parentDir = file.getParentFile();
                if (!parentDir.exists() && !parentDir.mkdir()) {
                    log.error("Directory wasn't created");
                }
                if (file.createNewFile()) {
                    log.debug("File created");
                }
            }
            this.writeFile(ExportTrains.defaultOperationsFilename());
        }
        catch (IOException e) {
            log.error("Exception while writing the new CSV operations file, may not be complete: {}", (Throwable)e);
        }
    }

    public void writeFile(String name) {
        log.debug("writeFile {}", (Object)name);
        File file = this.findFile(name);
        if (file == null) {
            file = new File(name);
        }
        try {
            Throwable throwable = null;
            Object var4_5 = null;
            try (CSVPrinter fileOut = new CSVPrinter((Appendable)new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8)), CSVFormat.DEFAULT);){
                fileOut.printRecord(new Object[]{Bundle.getMessage("Name"), Bundle.getMessage("Description"), Bundle.getMessage("Time"), Bundle.getMessage("Route"), Bundle.getMessage("Departs"), Bundle.getMessage("Terminates"), Bundle.getMessage("Status"), Bundle.getMessage("Comment"), Bundle.getMessage("LocoTypes"), Bundle.getMessage("CarTypes"), Bundle.getMessage("RoadOption"), Bundle.getMessage("Roads"), Bundle.getMessage("LoadOption"), Bundle.getMessage("Loads"), Bundle.getMessage("OwnerOption"), Bundle.getMessage("Owners"), Bundle.getMessage("Built"), Bundle.getMessage("NormalModeWhenBuilding"), Bundle.getMessage("AllowCarsToReturn"), Bundle.getMessage("AllowThroughCars"), Bundle.getMessage("SendCustomToStaging"), MessageFormat.format(Bundle.getMessage("SendToTerminal"), ""), Bundle.getMessage("AllowLocalMoves"), Bundle.getMessage("ServiceAllCars"), Bundle.getMessage("BuildConsist")});
                int count = 0;
                for (Train train : InstanceManager.getDefault(TrainManager.class).getTrainsByTimeList()) {
                    if (!train.isBuildEnabled()) continue;
                    ++count;
                    String routeName = "";
                    if (train.getRoute() != null) {
                        routeName = train.getRoute().getName();
                    }
                    fileOut.printRecord(new Object[]{train.getName(), train.getDescription(), train.getDepartureTime(), routeName, train.getTrainDepartsName(), train.getTrainTerminatesName(), train.getStatus(), train.getComment(), TrainCommon.formatStringToCommaSeparated(train.getLocoTypeNames()), TrainCommon.formatStringToCommaSeparated(train.getCarTypeNames()), this.getRoadOption(train), this.getRoads(train), this.getLoadOption(train), this.getLoads(train), this.getOwnerOption(train), this.getOwners(train), this.getBuilt(train), train.isBuildTrainNormalEnabled() ? Bundle.getMessage("ButtonYes") : "", train.isAllowReturnToStagingEnabled() ? Bundle.getMessage("ButtonYes") : "", train.isAllowThroughCarsEnabled() ? Bundle.getMessage("ButtonYes") : "", train.isSendCarsWithCustomLoadsToStagingEnabled() ? Bundle.getMessage("ButtonYes") : "", train.isSendCarsToTerminalEnabled() ? Bundle.getMessage("ButtonYes") : "", train.isAllowLocalMovesEnabled() ? Bundle.getMessage("ButtonYes") : "", train.isServiceAllCarsWithFinalDestinationsEnabled() ? Bundle.getMessage("ButtonYes") : "", train.isBuildConsistEnabled() ? Bundle.getMessage("ButtonYes") : ""});
                }
                fileOut.println();
                fileOut.printRecord(new Object[]{Bundle.getMessage("Name"), Bundle.getMessage("csvParameters"), Bundle.getMessage("Attributes")});
                for (Train train : InstanceManager.getDefault(TrainManager.class).getTrainsByTimeList()) {
                    if (!train.isBuildEnabled() || !train.isBuilt() || train.getRoute() == null) continue;
                    ArrayList<Object> line = new ArrayList<Object>();
                    line.addAll(Arrays.asList(train.getName(), Bundle.getMessage("Route")));
                    train.getRoute().getLocationsBySequenceList().forEach(rl -> {
                        boolean bl = line.add(rl.getName());
                    });
                    fileOut.printRecord(line);
                    line.clear();
                    line.addAll(Arrays.asList(train.getName(), Bundle.getMessage("csvArrivalTime")));
                    train.getRoute().getLocationsBySequenceList().forEach(rl -> {
                        boolean bl = line.add(train.getExpectedArrivalTime((RouteLocation)rl));
                    });
                    fileOut.printRecord(line);
                    line.clear();
                    line.addAll(Arrays.asList(train.getName(), Bundle.getMessage("csvDepartureTime")));
                    train.getRoute().getLocationsBySequenceList().forEach(rl -> {
                        boolean bl = line.add(train.getExpectedDepartureTime((RouteLocation)rl));
                    });
                    fileOut.printRecord(line);
                    line.clear();
                    line.addAll(Arrays.asList(train.getName(), Bundle.getMessage("csvTrainDirection")));
                    train.getRoute().getLocationsBySequenceList().forEach(rl -> {
                        boolean bl = line.add(rl.getTrainDirectionString());
                    });
                    fileOut.printRecord(line);
                    line.clear();
                    line.addAll(Arrays.asList(train.getName(), Bundle.getMessage("csvTrainWeight")));
                    train.getRoute().getLocationsBySequenceList().forEach(rl -> {
                        boolean bl = line.add(train.getTrainWeight((RouteLocation)rl));
                    });
                    fileOut.printRecord(line);
                    line.clear();
                    line.addAll(Arrays.asList(train.getName(), Bundle.getMessage("csvTrainLength")));
                    train.getRoute().getLocationsBySequenceList().forEach(rl -> {
                        boolean bl = line.add(train.getTrainLength((RouteLocation)rl));
                    });
                    fileOut.printRecord(line);
                    line.clear();
                    line.addAll(Arrays.asList(train.getName(), Bundle.getMessage("Engine")));
                    train.getRoute().getLocationsBySequenceList().forEach(rl -> {
                        boolean bl = line.add(train.getLeadEngine((RouteLocation)rl));
                    });
                    fileOut.printRecord(line);
                    line.clear();
                    line.addAll(Arrays.asList(train.getName(), Bundle.getMessage("Cars")));
                    train.getRoute().getLocationsBySequenceList().forEach(rl -> {
                        boolean bl = line.add(train.getNumberCarsInTrain((RouteLocation)rl));
                    });
                    fileOut.printRecord(line);
                    line.clear();
                    line.addAll(Arrays.asList(train.getName(), Bundle.getMessage("csvEmpties")));
                    train.getRoute().getLocationsBySequenceList().forEach(rl -> {
                        boolean bl = line.add(train.getNumberEmptyCarsInTrain((RouteLocation)rl));
                    });
                    fileOut.printRecord(line);
                    line.clear();
                    line.addAll(Arrays.asList(train.getName(), Bundle.getMessage("Loads")));
                    train.getRoute().getLocationsBySequenceList().forEach(rl -> {
                        boolean bl = line.add(train.getNumberLoadedCarsInTrain((RouteLocation)rl));
                    });
                    fileOut.printRecord(line);
                    fileOut.println();
                }
                fileOut.flush();
                fileOut.close();
                log.info("Exported {} trains to file {}", (Object)count, (Object)ExportTrains.defaultOperationsFilename());
                JOptionPane.showMessageDialog(null, MessageFormat.format(Bundle.getMessage("ExportedTrainsToFile"), count, ExportTrains.defaultOperationsFilename()), Bundle.getMessage("ExportComplete"), 1);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            log.error("Can not open export trains CSV file: {}", (Object)file.getName());
            JOptionPane.showMessageDialog(null, MessageFormat.format(Bundle.getMessage("ExportedTrainsToFile"), 0, ExportTrains.defaultOperationsFilename()), Bundle.getMessage("ExportFailed"), 0);
        }
    }

    private String getRoadOption(Train train) {
        String roadOption = Bundle.getMessage("AcceptAll");
        if (train.getRoadOption().equals(Train.INCLUDE_ROADS)) {
            roadOption = String.valueOf(Bundle.getMessage("AcceptOnly")) + " " + train.getRoadNames().length + " " + Bundle.getMessage("Roads");
        } else if (train.getRoadOption().equals(Train.EXCLUDE_ROADS)) {
            roadOption = String.valueOf(Bundle.getMessage("Exclude")) + " " + train.getRoadNames().length + " " + Bundle.getMessage("Roads");
        }
        return roadOption;
    }

    private String getRoads(Train train) {
        if (train.getRoadOption().equals(Train.ALL_ROADS)) {
            return "";
        }
        return TrainCommon.formatStringToCommaSeparated(train.getRoadNames());
    }

    private String getLoadOption(Train train) {
        String loadOption = Bundle.getMessage("AcceptAll");
        if (train.getLoadOption().equals(Train.INCLUDE_LOADS)) {
            loadOption = String.valueOf(Bundle.getMessage("AcceptOnly")) + " " + train.getLoadNames().length + " " + Bundle.getMessage("Loads");
        } else if (train.getLoadOption().equals(Train.EXCLUDE_LOADS)) {
            loadOption = String.valueOf(Bundle.getMessage("Exclude")) + " " + train.getLoadNames().length + " " + Bundle.getMessage("Loads");
        }
        return loadOption;
    }

    private String getLoads(Train train) {
        if (train.getLoadOption().equals(Train.ALL_LOADS)) {
            return "";
        }
        return TrainCommon.formatStringToCommaSeparated(train.getLoadNames());
    }

    private String getOwnerOption(Train train) {
        String ownerOption = Bundle.getMessage("AcceptAll");
        if (train.getOwnerOption().equals(Train.INCLUDE_OWNERS)) {
            ownerOption = String.valueOf(Bundle.getMessage("AcceptOnly")) + " " + train.getOwnerNames().length + " " + Bundle.getMessage("Owners");
        } else if (train.getOwnerOption().equals(Train.EXCLUDE_OWNERS)) {
            ownerOption = String.valueOf(Bundle.getMessage("Exclude")) + " " + train.getOwnerNames().length + " " + Bundle.getMessage("Owners");
        }
        return ownerOption;
    }

    private String getOwners(Train train) {
        if (train.getOwnerOption().equals(Train.ALL_OWNERS)) {
            return "";
        }
        return TrainCommon.formatStringToCommaSeparated(train.getOwnerNames());
    }

    private String getBuilt(Train train) {
        if (!train.getBuiltStartYear().equals("") && train.getBuiltEndYear().equals("")) {
            return String.valueOf(Bundle.getMessage("After")) + " " + train.getBuiltStartYear();
        }
        if (train.getBuiltStartYear().equals("") && !train.getBuiltEndYear().equals("")) {
            return String.valueOf(Bundle.getMessage("Before")) + " " + train.getBuiltEndYear();
        }
        if (!train.getBuiltStartYear().equals("") && !train.getBuiltEndYear().equals("")) {
            return String.valueOf(Bundle.getMessage("Range")) + " " + train.getBuiltStartYear() + ":" + train.getBuiltEndYear();
        }
        return "";
    }

    public static String defaultOperationsFilename() {
        return String.valueOf(OperationsSetupXml.getFileLocation()) + OperationsSetupXml.getOperationsDirectoryName() + File.separator + ExportTrains.getOperationsFileName();
    }

    public static void setOperationsFileName(String name) {
        operationsFileName = name;
    }

    public static String getOperationsFileName() {
        return operationsFileName;
    }
}

