/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.trains.tools;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import javax.swing.JOptionPane;
import jmri.InstanceManager;
import jmri.jmrit.XmlFile;
import jmri.jmrit.operations.routes.RouteLocation;
import jmri.jmrit.operations.setup.OperationsSetupXml;
import jmri.jmrit.operations.trains.Train;
import jmri.jmrit.operations.trains.TrainCommon;
import jmri.jmrit.operations.trains.TrainManager;
import jmri.jmrit.operations.trains.tools.Bundle;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportTrainLineups
extends XmlFile {
    private static String operationsFileName = "ExportOperationsTrainLineups.csv";
    private static final Logger log = LoggerFactory.getLogger(ExportTrainLineups.class);

    public void writeOperationsTrainsFile() {
        this.makeBackupFile(ExportTrainLineups.defaultOperationsFilename());
        try {
            if (!this.checkFile(ExportTrainLineups.defaultOperationsFilename())) {
                File file = new File(ExportTrainLineups.defaultOperationsFilename());
                File parentDir = file.getParentFile();
                if (!parentDir.exists() && !parentDir.mkdir()) {
                    log.error("Directory wasn't created");
                }
                if (file.createNewFile()) {
                    log.debug("File created");
                }
            }
            this.writeFile(ExportTrainLineups.defaultOperationsFilename());
        }
        catch (Exception e) {
            log.error("Exception while writing the new CSV operations file, may not be complete: {}", (Throwable)e);
        }
    }

    public void writeFile(String name) {
        log.debug("writeFile {}", (Object)name);
        File file = this.findFile(name);
        if (file == null) {
            file = new File(name);
        }
        try {
            Throwable throwable = null;
            Object var4_5 = null;
            try (CSVPrinter fileOut = new CSVPrinter((Appendable)new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8)), CSVFormat.DEFAULT);){
                fileOut.printRecord(new Object[]{Bundle.getMessage("Name"), Bundle.getMessage("Engine"), Bundle.getMessage("Location"), Bundle.getMessage("Direction"), Bundle.getMessage("Arrives"), Bundle.getMessage("Departs"), Bundle.getMessage("Pulls"), Bundle.getMessage("Drops"), Bundle.getMessage("Loads"), Bundle.getMessage("Empties"), Bundle.getMessage("Length"), Bundle.getMessage("Weight"), Bundle.getMessage("Engineer"), Bundle.getMessage("Conductor"), Bundle.getMessage("RouteLocationComment"), Bundle.getMessage("Description"), Bundle.getMessage("Comment")});
                int count = 0;
                for (Train train : InstanceManager.getDefault(TrainManager.class).getTrainsByTimeList()) {
                    if (!train.isBuildEnabled() || !train.isBuilt() || train.getRoute() == null) continue;
                    ++count;
                    for (RouteLocation rl : train.getRoute().getLocationsBySequenceList()) {
                        fileOut.printRecord(new Object[]{train.getName(), train.getLeadEngineRoadAndNumber(), TrainCommon.splitString(rl.getLocation().getName()), rl.getTrainDirectionString(), train.getExpectedArrivalTime(rl), train.getExpectedDepartureTime(rl), train.getNumberCarsPickedUp(rl), train.getNumberCarsSetout(rl), train.getNumberLoadedCarsInTrain(rl), train.getNumberEmptyCarsInTrain(rl), train.getTrainLength(rl), train.getTrainWeight(rl), "", "", rl.getComment(), train.getDescription(), train.getComment()});
                    }
                    fileOut.println();
                }
                fileOut.flush();
                fileOut.close();
                log.info("Exported {} trains to file {}", (Object)count, (Object)ExportTrainLineups.defaultOperationsFilename());
                JOptionPane.showMessageDialog(null, MessageFormat.format(Bundle.getMessage("ExportedTrainsToFile"), count, ExportTrainLineups.defaultOperationsFilename()), Bundle.getMessage("ExportComplete"), 1);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            log.error("Can not open export trains CSV file: {}", (Object)file.getName());
            JOptionPane.showMessageDialog(null, MessageFormat.format(Bundle.getMessage("ExportedTrainsToFile"), 0, ExportTrainLineups.defaultOperationsFilename()), Bundle.getMessage("ExportFailed"), 0);
        }
    }

    public static String defaultOperationsFilename() {
        return String.valueOf(OperationsSetupXml.getFileLocation()) + OperationsSetupXml.getOperationsDirectoryName() + File.separator + ExportTrainLineups.getOperationsFileName();
    }

    public static void setOperationsFileName(String name) {
        operationsFileName = name;
    }

    public static String getOperationsFileName() {
        return operationsFileName;
    }
}

