/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.trains.tools;

import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import jmri.InstanceManager;
import jmri.jmrit.operations.OperationsFrame;
import jmri.jmrit.operations.routes.Route;
import jmri.jmrit.operations.routes.RouteLocation;
import jmri.jmrit.operations.routes.RouteManager;
import jmri.jmrit.operations.trains.Train;
import jmri.jmrit.operations.trains.TrainManager;
import jmri.jmrit.operations.trains.tools.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeDepartureTimesFrame
extends OperationsFrame {
    JButton changeButton = new JButton(Bundle.getMessage("Change"));
    JComboBox<Integer> hourBox = new JComboBox();
    JCheckBox routesCheckBox = new JCheckBox(Bundle.getMessage("ModifyRouteTimes"));
    private static final Logger log = LoggerFactory.getLogger(ChangeDepartureTimesFrame.class);

    public ChangeDepartureTimesFrame() {
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        int i = 1;
        while (i < 24) {
            this.hourBox.addItem(i);
            ++i;
        }
        JPanel pHour = new JPanel();
        pHour.setLayout(new GridBagLayout());
        pHour.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("SelectHours")));
        this.addItem(pHour, this.hourBox, 0, 0);
        this.addItem(pHour, this.routesCheckBox, 1, 0);
        JPanel pButton = new JPanel();
        pButton.add(this.changeButton);
        this.getContentPane().add(pHour);
        this.getContentPane().add(pButton);
        this.addHelpMenu("package.jmri.jmrit.operations.Operations_ChangeTrainDepartureTimes", true);
        this.setTitle(Bundle.getMessage("TitleChangeDepartureTime"));
        this.addButtonAction(this.changeButton);
        this.initMinimumSize(new Dimension(500, 200));
    }

    @Override
    public void buttonActionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.changeButton) {
            log.debug("change button activated");
            TrainManager trainManager = InstanceManager.getDefault(TrainManager.class);
            List<Train> trains = trainManager.getTrainsByIdList();
            for (Train train : trains) {
                train.setDepartureTime(this.adjustHour(train.getDepartureTimeHour()), train.getDepartureTimeMinute());
            }
            if (this.routesCheckBox.isSelected()) {
                RouteManager routeManager = InstanceManager.getDefault(RouteManager.class);
                List<Route> routes = routeManager.getRoutesByNameList();
                for (Route route : routes) {
                    for (RouteLocation rl : route.getLocationsBySequenceList()) {
                        if (rl.getDepartureTime().equals("")) continue;
                        rl.setDepartureTime(this.adjustHour(rl.getDepartureTimeHour()), rl.getDepartureTimeMinute());
                    }
                }
            }
        }
    }

    private String adjustHour(String time) {
        int hour = (Integer)this.hourBox.getSelectedItem() + Integer.parseInt(time);
        if (hour > 23) {
            hour -= 24;
        }
        return Integer.toString(hour);
    }
}

