/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.trains.schedules;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import jmri.InstanceManager;
import jmri.jmrit.beantable.EnablingCheckboxRenderer;
import jmri.jmrit.operations.trains.Train;
import jmri.jmrit.operations.trains.TrainManager;
import jmri.jmrit.operations.trains.schedules.Bundle;
import jmri.jmrit.operations.trains.schedules.TrainSchedule;
import jmri.jmrit.operations.trains.schedules.TrainScheduleManager;
import jmri.jmrit.operations.trains.schedules.TrainsScheduleTableFrame;
import jmri.util.swing.XTableColumnModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrainsScheduleTableModel
extends AbstractTableModel
implements PropertyChangeListener {
    TrainManager trainManager = InstanceManager.getDefault(TrainManager.class);
    TrainScheduleManager scheduleManager = InstanceManager.getDefault(TrainScheduleManager.class);
    private static final int IDCOLUMN = 0;
    private static final int NAMECOLUMN = 1;
    private static final int DESCRIPTIONCOLUMN = 2;
    private static final int FIXEDCOLUMN = 3;
    public final int SORTBYNAME = 1;
    public final int SORTBYTIME = 2;
    public final int SORTBYDEPARTS = 3;
    public final int SORTBYTERMINATES = 4;
    public final int SORTBYROUTE = 5;
    public final int SORTBYID = 6;
    private int _sort = 2;
    List<Train> sysList = null;
    JTable _table = null;
    TrainsScheduleTableFrame _frame = null;
    private final int[] tableScheduleColumnWidths = new int[]{50, 70, 120};
    private static final Logger log = LoggerFactory.getLogger(TrainsScheduleTableModel.class);

    public TrainsScheduleTableModel() {
        this.trainManager.addPropertyChangeListener(this);
        this.scheduleManager.addPropertyChangeListener(this);
        this.updateList();
        this.addPropertyChangeTrainSchedules();
    }

    public void setSort(int sort) {
        this._sort = sort;
        this.updateList();
        this.initTable();
        if (this._table.getRowSorter() != null) {
            this._table.getRowSorter().setSortKeys(null);
        }
    }

    private void updateList() {
        this.removePropertyChangeTrains();
        if (this._sort == 6) {
            this.sysList = this.trainManager.getTrainsByIdList();
        } else if (this._sort == 1) {
            this.sysList = this.trainManager.getTrainsByNameList();
        } else if (this._sort == 2) {
            this.sysList = this.trainManager.getTrainsByTimeList();
        } else if (this._sort == 3) {
            this.sysList = this.trainManager.getTrainsByDepartureList();
        } else if (this._sort == 4) {
            this.sysList = this.trainManager.getTrainsByTerminatesList();
        } else if (this._sort == 5) {
            this.sysList = this.trainManager.getTrainsByRouteList();
        }
        this.addPropertyChangeTrains();
    }

    public List<Train> getSelectedTrainList() {
        return this.sysList;
    }

    void initTable(JTable table, TrainsScheduleTableFrame frame) {
        this._table = table;
        this._frame = frame;
        this.initTable();
    }

    void initTable() {
        if (this._table == null) {
            return;
        }
        XTableColumnModel tcm = new XTableColumnModel();
        this._table.setColumnModel(tcm);
        this._table.createDefaultColumnsFromModel();
        this._table.setDefaultRenderer(Boolean.class, new EnablingCheckboxRenderer());
        int i = 0;
        while (i < this.tableScheduleColumnWidths.length) {
            tcm.getColumn(i).setPreferredWidth(this.tableScheduleColumnWidths[i]);
            ++i;
        }
        this._frame.loadTableDetails(this._table);
    }

    @Override
    public int getRowCount() {
        return this.sysList.size();
    }

    public int getFixedColumn() {
        return 3;
    }

    @Override
    public int getColumnCount() {
        return this.getFixedColumn() + this.scheduleManager.numEntries();
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                if (this._sort == 6) {
                    return Bundle.getMessage("Id");
                }
                return Bundle.getMessage("Time");
            }
            case 1: {
                return Bundle.getMessage("Name");
            }
            case 2: {
                return Bundle.getMessage("Description");
            }
        }
        TrainSchedule ts = this.getSchedule(col);
        if (ts != null) {
            return ts.getName();
        }
        return "unknown";
    }

    @Override
    public Class<?> getColumnClass(int col) {
        switch (col) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
        }
        if (col >= this.getFixedColumn() && col < this.getColumnCount()) {
            return Boolean.class;
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        switch (col) {
            case 0: 
            case 1: 
            case 2: {
                return false;
            }
        }
        return true;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (row >= this.getRowCount()) {
            return "ERROR row " + row;
        }
        Train train = this.sysList.get(row);
        if (train == null) {
            return "ERROR train unknown " + row;
        }
        switch (col) {
            case 0: {
                if (this._sort == 6) {
                    return train.getId();
                }
                return train.getDepartureTime();
            }
            case 1: {
                return train.getIconName();
            }
            case 2: {
                return train.getDescription();
            }
        }
        TrainSchedule ts = this.getSchedule(col);
        if (ts != null) {
            return ts.containsTrainId(train.getId());
        }
        return "unknown " + col;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        TrainSchedule ts = this.getSchedule(col);
        if (ts != null) {
            Train train = this.sysList.get(row);
            if (train == null) {
                log.error("train not found");
                return;
            }
            if (((Boolean)value).booleanValue()) {
                ts.addTrainId(train.getId());
            } else {
                ts.removeTrainId(train.getId());
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        Train train;
        int row;
        if (e.getPropertyName().equals("TrainsListLength") || e.getPropertyName().equals("TrainsAction")) {
            this.updateList();
            this.fireTableDataChanged();
        } else if (e.getPropertyName().equals("trainScheduleListLength") || e.getPropertyName().equals("trainScheduleName")) {
            this.removePropertyChangeTrainSchedules();
            this.addPropertyChangeTrainSchedules();
            this.initTable();
        } else if (e.getPropertyName().equals("trainScheduleChanged")) {
            this.fireTableDataChanged();
        } else if (e.getSource().getClass().equals(Train.class) && (row = this.sysList.indexOf(train = (Train)e.getSource())) >= 0) {
            this.fireTableRowsUpdated(row, row);
        }
    }

    public TrainSchedule getSchedule(int col) {
        if (col >= this.getFixedColumn() && col < this.getColumnCount()) {
            List<TrainSchedule> trainSchedules = this.scheduleManager.getSchedulesByIdList();
            TrainSchedule ts = trainSchedules.get(col - this.getFixedColumn());
            return ts;
        }
        return null;
    }

    private void removePropertyChangeTrainSchedules() {
        List<TrainSchedule> trainSchedules = this.scheduleManager.getSchedulesByIdList();
        for (TrainSchedule ts : trainSchedules) {
            ts.removePropertyChangeListener(this);
        }
    }

    private void addPropertyChangeTrainSchedules() {
        List<TrainSchedule> trainSchedules = this.scheduleManager.getSchedulesByIdList();
        for (TrainSchedule ts : trainSchedules) {
            ts.addPropertyChangeListener(this);
        }
    }

    private void removePropertyChangeTrains() {
        if (this.sysList != null) {
            for (Train train : this.sysList) {
                train.removePropertyChangeListener(this);
            }
        }
    }

    private void addPropertyChangeTrains() {
        if (this.sysList != null) {
            for (Train train : this.sysList) {
                train.addPropertyChangeListener(this);
            }
        }
    }

    public void dispose() {
        this.trainManager.removePropertyChangeListener(this);
        this.scheduleManager.removePropertyChangeListener(this);
        this.removePropertyChangeTrains();
        this.removePropertyChangeTrainSchedules();
    }
}

