/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.trains.schedules;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import jmri.InstanceManager;
import jmri.jmrit.operations.OperationsFrame;
import jmri.jmrit.operations.OperationsXml;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.locations.LocationManager;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.operations.trains.Train;
import jmri.jmrit.operations.trains.TrainManager;
import jmri.jmrit.operations.trains.excel.TrainCustomManifest;
import jmri.jmrit.operations.trains.schedules.Bundle;
import jmri.jmrit.operations.trains.schedules.TrainSchedule;
import jmri.jmrit.operations.trains.schedules.TrainScheduleManager;
import jmri.jmrit.operations.trains.schedules.TrainsScheduleEditAction;
import jmri.jmrit.operations.trains.schedules.TrainsScheduleTableModel;
import jmri.swing.JTablePersistenceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrainsScheduleTableFrame
extends OperationsFrame
implements PropertyChangeListener {
    TrainManager trainManager = InstanceManager.getDefault(TrainManager.class);
    TrainScheduleManager trainScheduleManager = InstanceManager.getDefault(TrainScheduleManager.class);
    LocationManager locationManager = InstanceManager.getDefault(LocationManager.class);
    TrainsScheduleTableModel trainsScheduleModel = new TrainsScheduleTableModel();
    JTable trainsScheduleTable = new JTable(this.trainsScheduleModel);
    JScrollPane trainsPane;
    JLabel textSort = new JLabel(Bundle.getMessage("SortBy"));
    JRadioButton sortByName = new JRadioButton(Bundle.getMessage("Name"));
    JRadioButton sortByTime = new JRadioButton(Bundle.getMessage("Time"));
    JRadioButton noneButton = new JRadioButton(Bundle.getMessage("None"));
    JRadioButton anyButton = new JRadioButton(Bundle.getMessage("Any"));
    ButtonGroup schGroup = new ButtonGroup();
    JButton selectButton = new JButton(Bundle.getMessage("SelectAll"));
    JButton clearButton = new JButton(Bundle.getMessage("ClearAll"));
    JButton applyButton = new JButton(Bundle.getMessage("ButtonApply"));
    JButton buildButton = new JButton(Bundle.getMessage("Build"));
    JButton printButton = new JButton(Bundle.getMessage("Print"));
    JButton runFileButton = new JButton(Bundle.getMessage("RunFile"));
    JButton switchListsButton = new JButton();
    JButton terminateButton = new JButton(Bundle.getMessage("Terminate"));
    JButton activateButton = new JButton(Bundle.getMessage("Activate"));
    JButton saveButton = new JButton(Bundle.getMessage("ButtonSave"));
    JPanel schedule = new JPanel();
    JTextArea commentTextArea = new JTextArea(2, 70);
    JScrollPane commentScroller = new JScrollPane(this.commentTextArea, 20, 30);
    private static final Logger log = LoggerFactory.getLogger(TrainsScheduleTableFrame.class);

    public TrainsScheduleTableFrame() {
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.trainsPane = new JScrollPane(this.trainsScheduleTable);
        this.trainsPane.setVerticalScrollBarPolicy(20);
        this.trainsPane.setHorizontalScrollBarPolicy(30);
        this.trainsScheduleModel.initTable(this.trainsScheduleTable, this);
        JPanel pC = new JPanel();
        pC.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Comment")));
        pC.setLayout(new GridBagLayout());
        this.addItem(pC, this.commentScroller, 1, 0);
        this.adjustTextAreaColumnWidth(this.commentScroller, this.commentTextArea);
        JPanel cp1 = new JPanel();
        cp1.setLayout(new BoxLayout(cp1, 0));
        JPanel sortBy = new JPanel();
        sortBy.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("SortBy")));
        sortBy.add(this.sortByTime);
        sortBy.add(this.sortByName);
        this.schedule.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Active")));
        this.updateControlPanel();
        cp1.add(sortBy);
        cp1.add(this.schedule);
        JPanel pButtons = new JPanel();
        pButtons.setLayout(new BoxLayout(pButtons, 0));
        JPanel cp3 = new JPanel();
        cp3.setBorder(BorderFactory.createTitledBorder(""));
        cp3.add(this.clearButton);
        cp3.add(this.selectButton);
        JPanel cp4 = new JPanel();
        cp4.setBorder(BorderFactory.createTitledBorder(""));
        cp4.add(this.applyButton);
        cp4.add(this.buildButton);
        cp4.add(this.printButton);
        cp4.add(this.runFileButton);
        cp4.add(this.switchListsButton);
        cp4.add(this.terminateButton);
        JPanel cp5 = new JPanel();
        cp5.setBorder(BorderFactory.createTitledBorder(""));
        cp5.add(this.activateButton);
        cp5.add(this.saveButton);
        pButtons.add(cp3);
        pButtons.add(cp4);
        pButtons.add(cp5);
        this.selectButton.setToolTipText(Bundle.getMessage("SelectAllButtonTip"));
        this.clearButton.setToolTipText(Bundle.getMessage("ClearAllButtonTip"));
        this.applyButton.setToolTipText(Bundle.getMessage("ApplyButtonTip"));
        this.buildButton.setToolTipText(Bundle.getMessage("BuildSelectedTip"));
        this.runFileButton.setToolTipText(Bundle.getMessage("RunFileButtonTip"));
        this.activateButton.setToolTipText(Bundle.getMessage("ActivateButtonTip"));
        this.terminateButton.setToolTipText(Bundle.getMessage("TerminateSelectedTip"));
        this.setPrintButtonText();
        this.setSwitchListButtonText();
        JPanel controlPanel = new JPanel();
        controlPanel.setLayout(new BoxLayout(controlPanel, 1));
        controlPanel.add(pC);
        controlPanel.add(cp1);
        controlPanel.add(pButtons);
        JScrollPane controlPane = new JScrollPane(controlPanel);
        controlPane.setMinimumSize(new Dimension(500, 480));
        controlPane.setMaximumSize(new Dimension(2000, 500));
        controlPane.setVerticalScrollBarPolicy(21);
        this.getContentPane().add(this.trainsPane);
        this.getContentPane().add(controlPane);
        this.updateRunButton();
        this.addButtonAction(this.clearButton);
        this.addButtonAction(this.selectButton);
        this.addButtonAction(this.applyButton);
        this.addButtonAction(this.buildButton);
        this.addButtonAction(this.printButton);
        this.addButtonAction(this.runFileButton);
        this.addButtonAction(this.switchListsButton);
        this.addButtonAction(this.terminateButton);
        this.addButtonAction(this.activateButton);
        this.addButtonAction(this.saveButton);
        ButtonGroup sortGroup = new ButtonGroup();
        sortGroup.add(this.sortByTime);
        sortGroup.add(this.sortByName);
        this.sortByTime.setSelected(true);
        this.addRadioButtonAction(this.sortByTime);
        this.addRadioButtonAction(this.sortByName);
        this.addRadioButtonAction(this.noneButton);
        this.addRadioButtonAction(this.anyButton);
        JMenuBar menuBar = new JMenuBar();
        JMenu toolMenu = new JMenu(Bundle.getMessage("MenuTools"));
        toolMenu.add(new TrainsScheduleEditAction());
        menuBar.add(toolMenu);
        this.setJMenuBar(menuBar);
        this.addHelpMenu("package.jmri.jmrit.operations.Operations_TrainSchedules", true);
        this.setTitle(Bundle.getMessage("TitleScheduleTrains"));
        this.initMinimumSize(new Dimension(700, 500));
        this.addHorizontalScrollBarKludgeFix(controlPane, controlPanel);
        Setup.getDefault().addPropertyChangeListener(this);
        this.trainManager.addPropertyChangeListener(this);
        this.trainScheduleManager.addPropertyChangeListener(this);
        this.addPropertyChangeLocations();
        this.addPropertyChangeTrainSchedules();
    }

    @Override
    public void radioButtonActionPerformed(ActionEvent ae) {
        log.debug("radio button activated");
        this.clearTableSort(this.trainsScheduleTable);
        if (ae.getSource() == this.sortByName) {
            this.trainsScheduleModel.setSort(this.trainsScheduleModel.SORTBYNAME);
        } else if (ae.getSource() == this.sortByTime) {
            this.trainsScheduleModel.setSort(this.trainsScheduleModel.SORTBYTIME);
        } else if (ae.getSource() == this.noneButton || ae.getSource() == this.anyButton) {
            this.enableButtons(false);
            this.commentTextArea.setText("");
        } else {
            this.enableButtons(true);
            TrainSchedule ts = this.trainScheduleManager.getScheduleById(this.getSelectedScheduleId());
            this.commentTextArea.setText(ts.getComment());
        }
    }

    @Override
    public void buttonActionPerformed(ActionEvent ae) {
        log.debug("button activated");
        if (ae.getSource() == this.clearButton) {
            this.updateCheckboxes(false);
        }
        if (ae.getSource() == this.selectButton) {
            this.updateCheckboxes(true);
        }
        if (ae.getSource() == this.applyButton) {
            this.applySchedule();
        }
        if (ae.getSource() == this.buildButton) {
            this.switchListsButton.setEnabled(false);
            this.runFileButton.setEnabled(false);
            this.trainManager.buildSelectedTrains(this.getSortByList());
        }
        if (ae.getSource() == this.printButton) {
            this.trainManager.printSelectedTrains(this.getSortByList());
        }
        if (ae.getSource() == this.runFileButton) {
            if (!InstanceManager.getDefault(TrainCustomManifest.class).excelFileExists()) {
                log.warn("Manifest creator file not found!, directory name: {}, file name: {}", (Object)InstanceManager.getDefault(TrainCustomManifest.class).getDirectoryName(), (Object)InstanceManager.getDefault(TrainCustomManifest.class).getFileName());
                JOptionPane.showMessageDialog(this, MessageFormat.format(Bundle.getMessage("LoadDirectoryNameFileName"), InstanceManager.getDefault(TrainCustomManifest.class).getDirectoryName(), InstanceManager.getDefault(TrainCustomManifest.class).getFileName()), Bundle.getMessage("ManifestCreatorNotFound"), 0);
                return;
            }
            List<Train> trains = this.getSortByList();
            for (Train train : trains) {
                if (!train.isBuildEnabled()) continue;
                if (!train.isBuilt()) {
                    JOptionPane.showMessageDialog(this, MessageFormat.format(Bundle.getMessage("NeedToBuildBeforeRunFile"), train.getName()), Bundle.getMessage("ErrorTitle"), 0);
                    continue;
                }
                InstanceManager.getDefault(TrainCustomManifest.class).addCsvFile(train.createCsvManifestFile());
                train.setPrinted(true);
            }
            InstanceManager.getDefault(TrainCustomManifest.class).process();
        }
        if (ae.getSource() == this.switchListsButton) {
            this.trainScheduleManager.buildSwitchLists();
        }
        if (ae.getSource() == this.terminateButton) {
            this.trainManager.terminateSelectedTrains(this.getSortByList());
        }
        if (ae.getSource() == this.activateButton) {
            this.trainScheduleManager.setTrainScheduleActiveId(this.getSelectedScheduleId());
            this.activateButton.setEnabled(false);
        }
        if (ae.getSource() == this.saveButton) {
            this.storeValues();
            if (Setup.isCloseWindowOnSaveEnabled()) {
                this.dispose();
            }
        }
    }

    private void updateControlPanel() {
        this.schedule.removeAll();
        this.noneButton.setName("");
        this.noneButton.setSelected(true);
        this.commentTextArea.setText("");
        this.enableButtons(false);
        this.schedule.add(this.noneButton);
        this.schGroup.add(this.noneButton);
        int i = this.trainsScheduleModel.getFixedColumn();
        while (i < this.trainsScheduleModel.getColumnCount()) {
            log.debug("Column name: {}", (Object)this.trainsScheduleTable.getColumnName(i));
            TrainSchedule ts = this.trainScheduleManager.getScheduleByName(this.trainsScheduleTable.getColumnName(i));
            if (ts != null) {
                JRadioButton b = new JRadioButton();
                b.setText(ts.getName());
                b.setName(ts.getId());
                this.schedule.add(b);
                this.schGroup.add(b);
                this.addRadioButtonAction(b);
                if (b.getName().equals(this.trainScheduleManager.getTrainScheduleActiveId())) {
                    b.setSelected(true);
                    this.enableButtons(true);
                    this.commentTextArea.setText(ts.getComment());
                }
            }
            ++i;
        }
        this.anyButton.setName("ANY");
        this.schedule.add(this.anyButton);
        this.schGroup.add(this.anyButton);
        this.anyButton.setSelected(this.trainScheduleManager.getTrainScheduleActiveId().equals("ANY"));
        this.schedule.revalidate();
    }

    private void updateCheckboxes(boolean selected) {
        TrainSchedule ts = this.trainScheduleManager.getScheduleById(this.getSelectedScheduleId());
        if (ts != null) {
            for (Train train : this.trainManager.getTrainsByIdList()) {
                if (selected) {
                    ts.addTrainId(train.getId());
                    continue;
                }
                ts.removeTrainId(train.getId());
            }
        }
    }

    private void applySchedule() {
        TrainSchedule ts = this.trainScheduleManager.getScheduleById(this.getSelectedScheduleId());
        if (ts != null) {
            for (Train train : this.trainManager.getTrainsByIdList()) {
                train.setBuildEnabled(ts.containsTrainId(train.getId()));
            }
        }
    }

    private String getSelectedScheduleId() {
        Enumeration<AbstractButton> en = this.schGroup.getElements();
        while (en.hasMoreElements()) {
            AbstractButton b = en.nextElement();
            if (!b.isSelected()) continue;
            log.debug("schedule radio button {}", (Object)b.getText());
            return b.getName();
        }
        return null;
    }

    private void enableButtons(boolean enable) {
        this.selectButton.setEnabled(enable);
        this.clearButton.setEnabled(enable);
        this.applyButton.setEnabled(enable);
        this.buildButton.setEnabled(enable);
        this.printButton.setEnabled(enable);
        this.runFileButton.setEnabled(enable);
        this.switchListsButton.setEnabled(enable);
        this.terminateButton.setEnabled(enable);
        log.debug("Selected id: {}, Active id: {}", (Object)this.getSelectedScheduleId(), (Object)this.trainScheduleManager.getTrainScheduleActiveId());
        this.activateButton.setEnabled(this.getSelectedScheduleId() != null && !this.getSelectedScheduleId().equals(this.trainScheduleManager.getTrainScheduleActiveId()));
        this.commentTextArea.setEnabled(enable);
    }

    private List<Train> getSortByList() {
        if (this.sortByTime.isSelected()) {
            return this.trainManager.getTrainsByTimeList();
        }
        return this.trainManager.getTrainsByNameList();
    }

    private void setSwitchListButtonText() {
        if (!Setup.isSwitchListRealTime()) {
            this.switchListsButton.setText(Bundle.getMessage("Update"));
        } else if (this.trainManager.isPrintPreviewEnabled()) {
            this.switchListsButton.setText(Bundle.getMessage("PreviewSwitchLists"));
        } else {
            this.switchListsButton.setText(Bundle.getMessage("PrintSwitchLists"));
        }
    }

    private void setPrintButtonText() {
        if (this.trainManager.isPrintPreviewEnabled()) {
            this.printButton.setText(Bundle.getMessage("Preview"));
            this.printButton.setToolTipText(Bundle.getMessage("PreviewSelectedTip"));
        } else {
            this.printButton.setText(Bundle.getMessage("Print"));
            this.printButton.setToolTipText(Bundle.getMessage("PrintSelectedTip"));
        }
    }

    private void updateSwitchListButton() {
        List<Location> locations = this.locationManager.getList();
        for (Location location : locations) {
            if (location == null || !location.isSwitchListEnabled() || !location.getStatus().equals(Location.MODIFIED)) continue;
            this.switchListsButton.setBackground(Color.RED);
            return;
        }
        this.switchListsButton.setBackground(Color.GREEN);
    }

    private void updateRunButton() {
        this.runFileButton.setVisible(Setup.isGenerateCsvManifestEnabled());
    }

    @Override
    protected void storeValues() {
        TrainSchedule ts = this.trainScheduleManager.getScheduleById(this.getSelectedScheduleId());
        if (ts != null) {
            ts.setComment(this.commentTextArea.getText());
        }
        OperationsXml.save();
    }

    @Override
    public void dispose() {
        Setup.getDefault().removePropertyChangeListener(this);
        this.trainManager.removePropertyChangeListener(this);
        this.trainScheduleManager.removePropertyChangeListener(this);
        this.removePropertyChangeTrainSchedules();
        this.removePropertyChangeLocations();
        this.trainsScheduleModel.dispose();
        InstanceManager.getOptionalDefault(JTablePersistenceManager.class).ifPresent(tpm -> tpm.stopPersisting(this.trainsScheduleTable));
        super.dispose();
    }

    private void addPropertyChangeLocations() {
        for (Location location : this.locationManager.getList()) {
            location.addPropertyChangeListener(this);
        }
    }

    private void removePropertyChangeLocations() {
        for (Location location : this.locationManager.getList()) {
            location.removePropertyChangeListener(this);
        }
    }

    private void addPropertyChangeTrainSchedules() {
        List<TrainSchedule> trainSchedules = this.trainScheduleManager.getSchedulesByIdList();
        for (TrainSchedule ts : trainSchedules) {
            ts.addPropertyChangeListener(this);
        }
    }

    private void removePropertyChangeTrainSchedules() {
        List<TrainSchedule> trainSchedules = this.trainScheduleManager.getSchedulesByIdList();
        for (TrainSchedule ts : trainSchedules) {
            ts.removePropertyChangeListener(this);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("trainScheduleListLength") || e.getPropertyName().equals("trainScheduleName")) {
            this.updateControlPanel();
        }
        if (e.getPropertyName().equals("TrainsPrintPreview")) {
            this.setPrintButtonText();
            this.setSwitchListButtonText();
        }
        if (e.getPropertyName().equals("TrainsBuiltChange")) {
            this.switchListsButton.setEnabled(true);
            this.runFileButton.setEnabled(true);
        }
        if (e.getPropertyName().equals("setupSwitchListRealTime")) {
            this.setSwitchListButtonText();
        }
        if (e.getPropertyName().equals("locationStatus") || e.getPropertyName().equals("switchList")) {
            log.debug("update switch list button location ({})", e.getSource());
            this.updateSwitchListButton();
        }
        if (e.getPropertyName().equals("setupManifestCSVChange")) {
            this.updateRunButton();
        }
    }
}

