/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.trains.schedules;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JComboBox;
import jmri.InstanceManager;
import jmri.InstanceManagerAutoDefault;
import jmri.InstanceManagerAutoInitialize;
import jmri.beans.PropertyChangeSupport;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.locations.LocationManager;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.operations.trains.Train;
import jmri.jmrit.operations.trains.TrainCommon;
import jmri.jmrit.operations.trains.TrainCsvSwitchLists;
import jmri.jmrit.operations.trains.TrainManager;
import jmri.jmrit.operations.trains.TrainManagerXml;
import jmri.jmrit.operations.trains.TrainSwitchLists;
import jmri.jmrit.operations.trains.schedules.Bundle;
import jmri.jmrit.operations.trains.schedules.TrainSchedule;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrainScheduleManager
extends PropertyChangeSupport
implements InstanceManagerAutoDefault,
InstanceManagerAutoInitialize,
PropertyChangeListener {
    public static final String NONE = "";
    private String _trainScheduleActiveId = "";
    private int _id = 0;
    public static final String LISTLENGTH_CHANGED_PROPERTY = "trainScheduleListLength";
    public static final String SCHEDULE_ID_CHANGED_PROPERTY = "ActiveTrainScheduleId";
    protected Hashtable<String, TrainSchedule> _scheduleHashTable = new Hashtable();
    private static final Logger log = LoggerFactory.getLogger(TrainScheduleManager.class);

    public void dispose() {
        this._scheduleHashTable.clear();
    }

    public int numEntries() {
        return this._scheduleHashTable.size();
    }

    public void setTrainScheduleActiveId(String id) {
        String old = this._trainScheduleActiveId;
        this._trainScheduleActiveId = id;
        if (!old.equals(id)) {
            this.setDirtyAndFirePropertyChange(SCHEDULE_ID_CHANGED_PROPERTY, old, id);
        }
    }

    public String getTrainScheduleActiveId() {
        return this._trainScheduleActiveId;
    }

    public TrainSchedule getActiveSchedule() {
        return this.getScheduleById(this.getTrainScheduleActiveId());
    }

    public TrainSchedule getScheduleByName(String name) {
        Enumeration<TrainSchedule> en = this._scheduleHashTable.elements();
        while (en.hasMoreElements()) {
            TrainSchedule s = en.nextElement();
            if (!s.getName().equals(name)) continue;
            return s;
        }
        return null;
    }

    public TrainSchedule getScheduleById(String id) {
        return this._scheduleHashTable.get(id);
    }

    public TrainSchedule newSchedule(String name) {
        TrainSchedule schedule = this.getScheduleByName(name);
        if (schedule == null) {
            ++this._id;
            schedule = new TrainSchedule(Integer.toString(this._id), name);
            Integer oldSize = this._scheduleHashTable.size();
            this._scheduleHashTable.put(schedule.getId(), schedule);
            this.setDirtyAndFirePropertyChange(LISTLENGTH_CHANGED_PROPERTY, oldSize, this._scheduleHashTable.size());
        }
        return schedule;
    }

    public void register(TrainSchedule schedule) {
        Integer oldSize = this._scheduleHashTable.size();
        this._scheduleHashTable.put(schedule.getId(), schedule);
        int id = Integer.parseInt(schedule.getId());
        if (id > this._id) {
            this._id = id;
        }
        this.setDirtyAndFirePropertyChange(LISTLENGTH_CHANGED_PROPERTY, oldSize, this._scheduleHashTable.size());
    }

    public void deregister(TrainSchedule schedule) {
        if (schedule == null) {
            return;
        }
        Integer oldSize = this._scheduleHashTable.size();
        this._scheduleHashTable.remove(schedule.getId());
        this.setDirtyAndFirePropertyChange(LISTLENGTH_CHANGED_PROPERTY, oldSize, this._scheduleHashTable.size());
    }

    public List<TrainSchedule> getSchedulesByNameList() {
        List<TrainSchedule> sortList = this.getList();
        ArrayList<TrainSchedule> out = new ArrayList<TrainSchedule>();
        int i = 0;
        while (i < sortList.size()) {
            int j = 0;
            while (j < out.size()) {
                if (sortList.get(i).getName().compareToIgnoreCase(((TrainSchedule)out.get(j)).getName()) < 0) {
                    out.add(j, sortList.get(i));
                    break;
                }
                ++j;
            }
            if (!out.contains(sortList.get(i))) {
                out.add(sortList.get(i));
            }
            ++i;
        }
        return out;
    }

    public List<TrainSchedule> getSchedulesByIdList() {
        List<TrainSchedule> sortList = this.getList();
        ArrayList<TrainSchedule> out = new ArrayList<TrainSchedule>();
        int i = 0;
        while (i < sortList.size()) {
            int j = 0;
            while (j < out.size()) {
                try {
                    if (Integer.parseInt(sortList.get(i).getId()) < Integer.parseInt(((TrainSchedule)out.get(j)).getId())) {
                        out.add(j, sortList.get(i));
                        break;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    log.debug("list id number isn't a number");
                }
                ++j;
            }
            if (!out.contains(sortList.get(i))) {
                out.add(sortList.get(i));
            }
            ++i;
        }
        return out;
    }

    private List<TrainSchedule> getList() {
        if (this.numEntries() == 0) {
            this.createDefaultSchedules();
        }
        ArrayList<TrainSchedule> out = new ArrayList<TrainSchedule>();
        Enumeration<TrainSchedule> en = this._scheduleHashTable.elements();
        while (en.hasMoreElements()) {
            out.add(en.nextElement());
        }
        return out;
    }

    public JComboBox<TrainSchedule> getComboBox() {
        JComboBox<TrainSchedule> box = new JComboBox<TrainSchedule>();
        this.updateComboBox(box);
        return box;
    }

    public JComboBox<TrainSchedule> getSelectComboBox() {
        JComboBox<TrainSchedule> box = new JComboBox<TrainSchedule>();
        box.addItem(null);
        for (TrainSchedule sch : this.getSchedulesByIdList()) {
            box.addItem(sch);
        }
        return box;
    }

    public void updateComboBox(JComboBox<TrainSchedule> box) {
        if (box == null) {
            throw new IllegalArgumentException("Attempt to update non-existant comboBox");
        }
        box.removeAllItems();
        for (TrainSchedule sch : this.getSchedulesByNameList()) {
            box.addItem(sch);
        }
    }

    public void buildSwitchLists() {
        TrainSwitchLists trainSwitchLists = new TrainSwitchLists();
        TrainCsvSwitchLists trainCsvSwitchLists = new TrainCsvSwitchLists();
        String locationName = NONE;
        for (Location location : InstanceManager.getDefault(LocationManager.class).getLocationsByNameList()) {
            if (!location.isSwitchListEnabled() || locationName.equals(TrainCommon.splitString(location.getName()))) continue;
            trainCsvSwitchLists.buildSwitchList(location);
            trainSwitchLists.buildSwitchList(location);
            locationName = TrainCommon.splitString(location.getName());
            if (!Setup.isSwitchListRealTime() || !location.getStatus().equals(Location.UPDATED)) continue;
            trainSwitchLists.printSwitchList(location, InstanceManager.getDefault(TrainManager.class).isPrintPreviewEnabled());
        }
        InstanceManager.getDefault(TrainManager.class).setTrainsSwitchListStatus(Train.PRINTED);
    }

    public void store(Element root) {
        Element e = new Element("trainScheduleOptions");
        e.setAttribute("activeId", InstanceManager.getDefault(TrainScheduleManager.class).getTrainScheduleActiveId());
        root.addContent((Content)e);
        Element values = new Element("schedules");
        List<TrainSchedule> schedules = this.getSchedulesByIdList();
        for (TrainSchedule schedule : schedules) {
            values.addContent((Content)schedule.store());
        }
        root.addContent((Content)values);
    }

    public void load(Element root) {
        Attribute a;
        Element e = root.getChild("trainScheduleOptions");
        if (e != null && (a = e.getAttribute("activeId")) != null) {
            InstanceManager.getDefault(TrainScheduleManager.class).setTrainScheduleActiveId(a.getValue());
        }
        if ((e = root.getChild("schedules")) != null) {
            List eSchedules = root.getChild("schedules").getChildren("schedule");
            log.debug("TrainScheduleManager sees {} train schedules", (Object)eSchedules.size());
            for (Element eSchedule : eSchedules) {
                this.register(new TrainSchedule(eSchedule));
            }
        }
    }

    public void createDefaultSchedules() {
        log.debug("creating default schedules");
        this.newSchedule(Bundle.getMessage("Sunday"));
        this.newSchedule(Bundle.getMessage("Monday"));
        this.newSchedule(Bundle.getMessage("Tuesday"));
        this.newSchedule(Bundle.getMessage("Wednesday"));
        this.newSchedule(Bundle.getMessage("Thursday"));
        this.newSchedule(Bundle.getMessage("Friday"));
        this.newSchedule(Bundle.getMessage("Saturday"));
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        log.debug("ScheduleManager sees property change: ({}) old: ({}) new ({})", new Object[]{e.getPropertyName(), e.getOldValue(), e.getNewValue()});
    }

    protected void setDirtyAndFirePropertyChange(String p, Object old, Object n) {
        InstanceManager.getDefault(TrainManagerXml.class).setDirty(true);
        this.firePropertyChange(p, old, n);
    }

    @Override
    public void initialize() {
        InstanceManager.getDefault(TrainManagerXml.class);
    }
}

