/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.trains.schedules;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import jmri.InstanceManager;
import jmri.beans.PropertyChangeSupport;
import jmri.jmrit.operations.trains.TrainManagerXml;
import org.jdom2.Attribute;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrainSchedule
extends PropertyChangeSupport {
    public static final String NONE = "";
    public static final String ANY = "ANY";
    public static final String NAME_CHANGED_PROPERTY = "trainScheduleName";
    public static final String SCHEDULE_CHANGED_PROPERTY = "trainScheduleChanged";
    protected String _id = "";
    protected String _name = "";
    protected String _comment = "";
    protected List<String> _trainIds = new ArrayList<String>();
    private static final Logger log = LoggerFactory.getLogger(TrainSchedule.class);

    public TrainSchedule(String id, String name) {
        log.debug("New train schedule ({}) id: {}", (Object)name, (Object)id);
        this._name = name;
        this._id = id;
    }

    public String getId() {
        return this._id;
    }

    public void setName(String name) {
        String old = this._name;
        this._name = name;
        if (!old.equals(name)) {
            this.setDirtyAndFirePropertyChange(NAME_CHANGED_PROPERTY, old, name);
        }
    }

    public String toString() {
        return this._name;
    }

    public String getName() {
        return this._name;
    }

    public void setComment(String comment) {
        String old = this._comment;
        this._comment = comment;
        if (!old.equals(comment)) {
            this.setDirtyAndFirePropertyChange("AddTrainScheduleComment", old, comment);
        }
    }

    public String getComment() {
        return this._comment;
    }

    public void addTrainId(String id) {
        if (!this._trainIds.contains(id)) {
            this._trainIds.add(id);
            this.setDirtyAndFirePropertyChange(SCHEDULE_CHANGED_PROPERTY, null, id);
        }
    }

    public void removeTrainId(String id) {
        this._trainIds.remove(id);
        this.setDirtyAndFirePropertyChange(SCHEDULE_CHANGED_PROPERTY, id, null);
    }

    public boolean containsTrainId(String id) {
        return this._trainIds.contains(id);
    }

    public TrainSchedule(Element e) {
        Attribute a = e.getAttribute("id");
        if (a != null) {
            this._id = a.getValue();
        } else {
            log.warn("no id attribute in schedule element when reading operations");
        }
        a = e.getAttribute("name");
        if (a != null) {
            this._name = a.getValue();
        }
        if ((a = e.getAttribute("comment")) != null) {
            this._comment = a.getValue();
        }
        if ((a = e.getAttribute("trainIds")) != null) {
            String[] trainIds;
            String ids = a.getValue();
            String[] stringArray = trainIds = ids.split(",");
            int n = trainIds.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                this._trainIds.add(id);
                ++n2;
            }
        }
    }

    public Element store() {
        Element e = new Element("schedule");
        e.setAttribute("id", this.getId());
        e.setAttribute("name", this.getName());
        if (!this.getComment().equals(NONE)) {
            e.setAttribute("comment", this.getComment());
        }
        StringBuilder buf = new StringBuilder();
        for (String id : this._trainIds) {
            buf.append(String.valueOf(id) + ",");
        }
        e.setAttribute("trainIds", buf.toString());
        return e;
    }

    public void propertyChange(PropertyChangeEvent e) {
    }

    protected void setDirtyAndFirePropertyChange(String p, Object old, Object n) {
        InstanceManager.getDefault(TrainManagerXml.class).setDirty(true);
        this.firePropertyChange(p, old, n);
    }
}

