/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.trains.excel;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import jmri.InstanceManager;
import jmri.jmrit.operations.OperationsManager;
import jmri.jmrit.operations.setup.Control;
import jmri.jmrit.operations.trains.TrainManagerXml;
import jmri.jmrit.operations.trains.excel.TrainCustomManifest;
import jmri.jmrit.operations.trains.excel.TrainCustomSwitchList;
import jmri.util.FileUtil;
import jmri.util.SystemType;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TrainCustomCommon {
    protected final String xmlElement;
    protected String directoryName;
    private String mcAppName = "MC4JMRI.xls";
    private final String mcAppArg = "";
    private String csvNamesFileName = "CSVFilesFile.txt";
    private int fileCount = 0;
    private long waitTimeSeconds = 0L;
    private Process process;
    private boolean alive = false;
    private static final Logger log = LoggerFactory.getLogger(TrainCustomCommon.class);

    protected TrainCustomCommon(String dirName, String xmlElement) {
        this.directoryName = dirName;
        this.xmlElement = xmlElement;
    }

    public String getFileName() {
        return this.mcAppName;
    }

    public void setFileName(String name) {
        if (!this.getFileName().equals(name)) {
            this.mcAppName = name;
            InstanceManager.getDefault(TrainManagerXml.class).setDirty(true);
        }
    }

    public String getCommonFileName() {
        return this.csvNamesFileName;
    }

    public void setCommonFileName(String name) {
        this.csvNamesFileName = name;
    }

    public String getDirectoryName() {
        return this.directoryName;
    }

    public void setDirectoryName(String name) {
        this.directoryName = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @SuppressFBWarnings(value={"UW_UNCOND_WAIT"}, justification="FindBugs incorrectly reports not guarded by conditional control flow")
    public synchronized boolean addCsvFile(File csvFile) {
        if (csvFile != null && this.excelFileExists()) ** GOTO lbl13
        return false;
lbl-1000:
        // 1 sources

        {
            var2_2 = this;
            synchronized (var2_2) {
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException v0) {}
                continue;
            }
lbl13:
            // 3 sources

            ** while (InstanceManager.getDefault(TrainCustomManifest.class).isProcessAlive() || InstanceManager.getDefault(TrainCustomSwitchList.class).isProcessAlive())
        }
lbl14:
        // 1 sources

        ++this.fileCount;
        this.waitTimeSeconds = this.fileCount * Control.excelWaitTime;
        this.alive = true;
        csvNamesFile = new File(InstanceManager.getDefault(OperationsManager.class).getFile(this.getDirectoryName()), this.getCommonFileName());
        try {
            FileUtil.appendTextToFile(csvNamesFile, csvFile.getAbsolutePath());
            TrainCustomCommon.log.debug("Queuing file {} to list", (Object)csvFile.getAbsolutePath());
        }
        catch (IOException e) {
            TrainCustomCommon.log.error("Unable to write to {}", (Object)csvNamesFile, (Object)e);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @SuppressFBWarnings(value={"UW_UNCOND_WAIT"}, justification="FindBugs incorrectly reports not guarded by conditional control flow")
    public synchronized boolean process() {
        if (!this.excelFileExists()) {
            return false;
        }
        if (this.fileCount != 0) ** GOTO lbl15
        return true;
lbl-1000:
        // 1 sources

        {
            var1_1 = this;
            synchronized (var1_1) {
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException v0) {}
                continue;
            }
lbl15:
            // 3 sources

            ** while (InstanceManager.getDefault(TrainCustomManifest.class).isProcessAlive() || InstanceManager.getDefault(TrainCustomSwitchList.class).isProcessAlive())
        }
lbl16:
        // 1 sources

        TrainCustomCommon.log.debug("Queued {} files to custom Excel program", (Object)this.fileCount);
        if (SystemType.isWindows()) {
            cmd = "cmd /c start " + this.getFileName() + " ";
            try {
                this.process = Runtime.getRuntime().exec(cmd, null, InstanceManager.getDefault(OperationsManager.class).getFile(this.getDirectoryName()));
            }
            catch (IOException e) {
                TrainCustomCommon.log.error("Unable to execute {}", (Object)this.getFileName(), (Object)e);
            }
        } else {
            cmd = "open " + this.getFileName() + " ";
            try {
                this.process = Runtime.getRuntime().exec(cmd, null, InstanceManager.getDefault(OperationsManager.class).getFile(this.getDirectoryName()));
            }
            catch (IOException e) {
                TrainCustomCommon.log.error("Unable to execute {}", (Object)this.getFileName(), (Object)e);
            }
        }
        this.fileCount = 0;
        return true;
    }

    public boolean excelFileExists() {
        File file = new File(InstanceManager.getDefault(OperationsManager.class).getFile(this.getDirectoryName()), this.getFileName());
        return file.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"UW_UNCOND_WAIT"}, justification="FindBugs incorrectly reports not guarded by conditional control flow")
    public boolean checkProcessReady() {
        if (!this.isProcessAlive()) {
            return true;
        }
        if (this.alive) {
            log.debug("Wait time: {} seconds process ready", (Object)this.waitTimeSeconds);
            long loopCount = this.waitTimeSeconds;
            while (loopCount-- > 0L && this.alive) {
                TrainCustomCommon trainCustomCommon = this;
                synchronized (trainCustomCommon) {
                    try {
                        this.wait(1000L);
                    }
                    catch (InterruptedException e) {
                        log.error("Thread unexpectedly interrupted", (Throwable)e);
                    }
                }
            }
        }
        return !this.alive;
    }

    public boolean isProcessAlive() {
        if (this.process != null) {
            return this.process.isAlive();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"UW_UNCOND_WAIT"}, justification="FindBugs incorrectly reports not guarded by conditional control flow")
    public boolean waitForProcessToComplete() throws InterruptedException {
        if (this.process == null) {
            return true;
        }
        boolean status = false;
        Process process = this.process;
        synchronized (process) {
            block13: {
                File file = new File(InstanceManager.getDefault(OperationsManager.class).getFile(this.getDirectoryName()), this.getCommonFileName());
                if (!file.exists()) {
                    log.debug("Common file not found! Normal when processing multiple files");
                }
                log.debug("Waiting up to {} seconds for Excel program to complete", (Object)this.waitTimeSeconds);
                status = this.process.waitFor(this.waitTimeSeconds, TimeUnit.SECONDS);
                if (status && file.exists()) {
                    long loopCount = this.waitTimeSeconds;
                    while (loopCount-- > 0L && file.exists()) {
                        TrainCustomCommon trainCustomCommon = this;
                        synchronized (trainCustomCommon) {
                            try {
                                this.wait(1000L);
                            }
                            catch (InterruptedException e) {
                                log.error("Thread unexpectedly interrupted", (Throwable)e);
                            }
                        }
                    }
                }
                if (!file.exists()) break block13;
                log.error("Common file ({}) not deleted! Wait time {} seconds", (Object)file.getPath(), (Object)this.waitTimeSeconds);
                return false;
            }
            log.debug("Excel program complete!");
        }
        this.alive = false;
        return status;
    }

    public boolean doesCommonFileExist() {
        File file = new File(InstanceManager.getDefault(OperationsManager.class).getFile(this.getDirectoryName()), this.getCommonFileName());
        return file.exists();
    }

    public void load(Element options) {
        Element mc = options.getChild(this.xmlElement);
        if (mc != null) {
            Element common;
            Element file;
            Attribute a;
            Element directory = mc.getChild("directory");
            if (directory != null && (a = directory.getAttribute("name")) != null) {
                this.setDirectoryName(a.getValue());
            }
            if ((file = mc.getChild("runFile")) != null && (a = file.getAttribute("name")) != null) {
                this.mcAppName = a.getValue();
            }
            if ((common = mc.getChild("commonFile")) != null && (a = common.getAttribute("name")) != null) {
                this.csvNamesFileName = a.getValue();
            }
        }
    }

    public void store(Element options) {
        Element mc = new Element(this.xmlElement);
        Element file = new Element("runFile");
        file.setAttribute("name", this.getFileName());
        Element directory = new Element("directory");
        directory.setAttribute("name", this.getDirectoryName());
        Element common = new Element("commonFile");
        common.setAttribute("name", this.getCommonFileName());
        mc.addContent((Content)directory);
        mc.addContent((Content)file);
        mc.addContent((Content)common);
        options.addContent((Content)mc);
    }
}

