/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.trains;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import jmri.InstanceManager;
import jmri.jmrit.operations.OperationsFrame;
import jmri.jmrit.operations.OperationsMenu;
import jmri.jmrit.operations.OperationsXml;
import jmri.jmrit.operations.automation.AutomationsTableFrameAction;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.locations.LocationManager;
import jmri.jmrit.operations.rollingstock.cars.CarManagerXml;
import jmri.jmrit.operations.rollingstock.engines.EngineManagerXml;
import jmri.jmrit.operations.setup.AutoSave;
import jmri.jmrit.operations.setup.BuildReportOptionAction;
import jmri.jmrit.operations.setup.OptionAction;
import jmri.jmrit.operations.setup.PrintOptionAction;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.operations.trains.Bundle;
import jmri.jmrit.operations.trains.Train;
import jmri.jmrit.operations.trains.TrainEditFrame;
import jmri.jmrit.operations.trains.TrainManager;
import jmri.jmrit.operations.trains.TrainManagerXml;
import jmri.jmrit.operations.trains.TrainSwitchListEditFrame;
import jmri.jmrit.operations.trains.TrainsTableModel;
import jmri.jmrit.operations.trains.excel.SetupExcelProgramFrameAction;
import jmri.jmrit.operations.trains.excel.TrainCustomManifest;
import jmri.jmrit.operations.trains.schedules.TrainSchedule;
import jmri.jmrit.operations.trains.schedules.TrainScheduleManager;
import jmri.jmrit.operations.trains.schedules.TrainsScheduleAction;
import jmri.jmrit.operations.trains.tools.ChangeDepartureTimesAction;
import jmri.jmrit.operations.trains.tools.ExportTimetableAction;
import jmri.jmrit.operations.trains.tools.ExportTrainLineupsAction;
import jmri.jmrit.operations.trains.tools.ExportTrainRosterAction;
import jmri.jmrit.operations.trains.tools.PrintSavedTrainManifestAction;
import jmri.jmrit.operations.trains.tools.PrintTrainsAction;
import jmri.jmrit.operations.trains.tools.TrainByCarTypeAction;
import jmri.jmrit.operations.trains.tools.TrainCopyAction;
import jmri.jmrit.operations.trains.tools.TrainsByCarTypeAction;
import jmri.jmrit.operations.trains.tools.TrainsScriptAction;
import jmri.jmrit.operations.trains.tools.TrainsTableSetColorAction;
import jmri.swing.JTablePersistenceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrainsTableFrame
extends OperationsFrame
implements PropertyChangeListener {
    public static final String MOVE = Bundle.getMessage("Move");
    public static final String TERMINATE = Bundle.getMessage("Terminate");
    public static final String RESET = Bundle.getMessage("Reset");
    public static final String CONDUCTOR = Bundle.getMessage("Conductor");
    CarManagerXml carManagerXml = InstanceManager.getDefault(CarManagerXml.class);
    EngineManagerXml engineManagerXml = InstanceManager.getDefault(EngineManagerXml.class);
    TrainManager trainManager = InstanceManager.getDefault(TrainManager.class);
    TrainManagerXml trainManagerXml = InstanceManager.getDefault(TrainManagerXml.class);
    LocationManager locationManager = InstanceManager.getDefault(LocationManager.class);
    TrainsTableModel trainsModel;
    JTable trainsTable;
    JScrollPane trainsPane;
    JLabel numTrains = new JLabel();
    JLabel textTrains = new JLabel(Bundle.getMessage("trains"));
    JLabel textSep1 = new JLabel("      ");
    JRadioButton showTime = new JRadioButton(Bundle.getMessage("Time"));
    JRadioButton showId = new JRadioButton(Bundle.getMessage("Id"));
    JRadioButton moveRB = new JRadioButton(MOVE);
    JRadioButton terminateRB = new JRadioButton(TERMINATE);
    JRadioButton resetRB = new JRadioButton(RESET);
    JRadioButton conductorRB = new JRadioButton(CONDUCTOR);
    JButton addButton = new JButton(Bundle.getMessage("ButtonAdd"));
    JButton buildButton = new JButton(Bundle.getMessage("Build"));
    JButton printButton = new JButton(Bundle.getMessage("Print"));
    JButton openFileButton = new JButton(Bundle.getMessage("OpenFile"));
    JButton runFileButton = new JButton(Bundle.getMessage("RunFile"));
    JButton switchListsButton = new JButton(Bundle.getMessage("SwitchLists"));
    JButton terminateButton = new JButton(Bundle.getMessage("Terminate"));
    JButton saveButton = new JButton(Bundle.getMessage("SaveBuilds"));
    JCheckBox buildMsgBox = new JCheckBox(Bundle.getMessage("BuildMessages"));
    JCheckBox buildReportBox = new JCheckBox(Bundle.getMessage("BuildReport"));
    JCheckBox printPreviewBox = new JCheckBox(Bundle.getMessage("Preview"));
    JCheckBox openFileBox = new JCheckBox(Bundle.getMessage("OpenFile"));
    JCheckBox runFileBox = new JCheckBox(Bundle.getMessage("RunFile"));
    public JCheckBox showAllBox = new JCheckBox(Bundle.getMessage("ShowAllTrains"));
    TrainSwitchListEditFrame tslef;
    SortOrder _status = SortOrder.ASCENDING;
    private static final Logger log = LoggerFactory.getLogger(TrainsTableFrame.class);

    public TrainsTableFrame() {
        this.updateTitle();
        this.createShutDownTask();
        this.setModifiedFlag(true);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.trainsModel = new TrainsTableModel();
        this.trainsTable = new JTable(this.trainsModel);
        this.trainsPane = new JScrollPane(this.trainsTable);
        this.trainsModel.initTable(this.trainsTable, this);
        JPanel cp1 = new JPanel();
        cp1.setLayout(new BoxLayout(cp1, 0));
        JPanel show = new JPanel();
        show.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("ShowClickToSort")));
        show.add(this.showTime);
        show.add(this.showId);
        JPanel options = new JPanel();
        options.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Options")));
        options.add(this.showAllBox);
        options.add(this.buildMsgBox);
        options.add(this.buildReportBox);
        options.add(this.printPreviewBox);
        options.add(this.openFileBox);
        options.add(this.runFileBox);
        JPanel action = new JPanel();
        action.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Action")));
        action.add(this.moveRB);
        action.add(this.conductorRB);
        action.add(this.terminateRB);
        action.add(this.resetRB);
        cp1.add(show);
        cp1.add(options);
        cp1.add(action);
        this.addButton.setToolTipText(Bundle.getMessage("AddTrain"));
        this.buildButton.setToolTipText(Bundle.getMessage("BuildSelectedTip"));
        this.switchListsButton.setToolTipText(Bundle.getMessage("PreviewPrintSwitchListsTip"));
        this.terminateButton.setToolTipText(Bundle.getMessage("TerminateSelectedTip"));
        this.saveButton.setToolTipText(Bundle.getMessage("SaveBuildsTip"));
        this.openFileButton.setToolTipText(Bundle.getMessage("OpenFileButtonTip"));
        this.runFileButton.setToolTipText(Bundle.getMessage("RunFileButtonTip"));
        this.buildMsgBox.setToolTipText(Bundle.getMessage("BuildMessagesTip"));
        this.printPreviewBox.setToolTipText(Bundle.getMessage("PreviewTip"));
        this.openFileBox.setToolTipText(Bundle.getMessage("OpenFileTip"));
        this.runFileBox.setToolTipText(Bundle.getMessage("RunFileTip"));
        this.showAllBox.setToolTipText(Bundle.getMessage("ShowAllTrainsTip"));
        this.moveRB.setToolTipText(Bundle.getMessage("MoveTip"));
        this.terminateRB.setToolTipText(Bundle.getMessage("TerminateTip"));
        this.resetRB.setToolTipText(Bundle.getMessage("ResetTip"));
        JPanel addTrain = new JPanel();
        addTrain.setBorder(BorderFactory.createTitledBorder(""));
        addTrain.add(this.numTrains);
        addTrain.add(this.textTrains);
        addTrain.add(this.textSep1);
        addTrain.add(this.addButton);
        this.numTrains.setText(Integer.toString(this.trainManager.getNumEntries()));
        JPanel select = new JPanel();
        select.setBorder(BorderFactory.createTitledBorder(""));
        select.add(this.buildButton);
        select.add(this.printButton);
        select.add(this.openFileButton);
        select.add(this.runFileButton);
        select.add(this.switchListsButton);
        select.add(this.terminateButton);
        JPanel save = new JPanel();
        save.setBorder(BorderFactory.createTitledBorder(""));
        save.add(this.saveButton);
        JPanel cp2 = new JPanel();
        cp2.setLayout(new BoxLayout(cp2, 0));
        cp2.add(addTrain);
        cp2.add(select);
        cp2.add(save);
        JPanel controlPanel = new JPanel();
        controlPanel.setLayout(new BoxLayout(controlPanel, 1));
        controlPanel.add(cp1);
        controlPanel.add(cp2);
        JScrollPane controlPane = new JScrollPane(controlPanel);
        this.getContentPane().add(this.trainsPane);
        this.getContentPane().add(controlPane);
        this.addButtonAction(this.addButton);
        this.addButtonAction(this.buildButton);
        this.addButtonAction(this.printButton);
        this.addButtonAction(this.openFileButton);
        this.addButtonAction(this.runFileButton);
        this.addButtonAction(this.switchListsButton);
        this.addButtonAction(this.terminateButton);
        this.addButtonAction(this.saveButton);
        ButtonGroup showGroup = new ButtonGroup();
        showGroup.add(this.showTime);
        showGroup.add(this.showId);
        this.showTime.setSelected(true);
        ButtonGroup actionGroup = new ButtonGroup();
        actionGroup.add(this.moveRB);
        actionGroup.add(this.conductorRB);
        actionGroup.add(this.terminateRB);
        actionGroup.add(this.resetRB);
        this.addRadioButtonAction(this.showTime);
        this.addRadioButtonAction(this.showId);
        this.addRadioButtonAction(this.moveRB);
        this.addRadioButtonAction(this.terminateRB);
        this.addRadioButtonAction(this.resetRB);
        this.addRadioButtonAction(this.conductorRB);
        this.buildMsgBox.setSelected(this.trainManager.isBuildMessagesEnabled());
        this.buildReportBox.setSelected(this.trainManager.isBuildReportEnabled());
        this.printPreviewBox.setSelected(this.trainManager.isPrintPreviewEnabled());
        this.openFileBox.setSelected(this.trainManager.isOpenFileEnabled());
        this.runFileBox.setSelected(this.trainManager.isRunFileEnabled());
        this.showAllBox.setSelected(this.trainsModel.isShowAll());
        this.updateRunAndOpenButtons();
        this.addCheckBoxAction(this.buildMsgBox);
        this.addCheckBoxAction(this.buildReportBox);
        this.addCheckBoxAction(this.printPreviewBox);
        this.addCheckBoxAction(this.showAllBox);
        this.addCheckBoxAction(this.openFileBox);
        this.addCheckBoxAction(this.runFileBox);
        this.setPrintButtonText();
        this.setTrainActionButton();
        JMenuBar menuBar = new JMenuBar();
        JMenu toolMenu = new JMenu(Bundle.getMessage("MenuTools"));
        toolMenu.add(new OptionAction());
        toolMenu.add(new PrintOptionAction());
        toolMenu.add(new BuildReportOptionAction());
        toolMenu.add(new TrainsByCarTypeAction());
        toolMenu.add(new TrainByCarTypeAction(null));
        toolMenu.add(new ChangeDepartureTimesAction());
        toolMenu.add(new TrainsTableSetColorAction());
        toolMenu.add(new TrainsScheduleAction());
        toolMenu.add(new AutomationsTableFrameAction());
        toolMenu.add(new TrainCopyAction());
        toolMenu.add(new TrainsScriptAction(this));
        toolMenu.add(new PrintSavedTrainManifestAction(false, null));
        toolMenu.add(new PrintSavedTrainManifestAction(true, null));
        toolMenu.add(new SetupExcelProgramFrameAction());
        toolMenu.add(new ExportTrainRosterAction());
        toolMenu.add(new ExportTimetableAction());
        toolMenu.add(new ExportTrainLineupsAction());
        toolMenu.addSeparator();
        toolMenu.add(new PrintTrainsAction(false, this));
        toolMenu.add(new PrintTrainsAction(true, this));
        menuBar.add(toolMenu);
        menuBar.add(new OperationsMenu());
        this.setJMenuBar(menuBar);
        this.addHelpMenu("package.jmri.jmrit.operations.Operations_Trains", true);
        this.initMinimumSize();
        this.addHorizontalScrollBarKludgeFix(controlPane, controlPanel);
        InstanceManager.getDefault(TrainScheduleManager.class).addPropertyChangeListener(this);
        this.trainManager.addPropertyChangeListener(this);
        Setup.getDefault().addPropertyChangeListener(this);
        this.addPropertyChangeLocations();
        AutoSave.start();
    }

    @Override
    public void radioButtonActionPerformed(ActionEvent ae) {
        log.debug("radio button activated");
        this.clearTableSort(this.trainsTable);
        if (ae.getSource() == this.showId) {
            this.trainsModel.setSort(this.trainsModel.SORTBYID);
        }
        if (ae.getSource() == this.showTime) {
            this.trainsModel.setSort(this.trainsModel.SORTBYTIME);
        }
        if (ae.getSource() == this.moveRB) {
            this.trainManager.setTrainsFrameTrainAction(MOVE);
        }
        if (ae.getSource() == this.terminateRB) {
            this.trainManager.setTrainsFrameTrainAction(TERMINATE);
        }
        if (ae.getSource() == this.resetRB) {
            this.trainManager.setTrainsFrameTrainAction(RESET);
        }
        if (ae.getSource() == this.conductorRB) {
            this.trainManager.setTrainsFrameTrainAction(CONDUCTOR);
        }
    }

    @Override
    public void buttonActionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.addButton) {
            new TrainEditFrame(null);
        }
        if (ae.getSource() == this.buildButton) {
            this.runFileButton.setEnabled(false);
            this.trainManager.buildSelectedTrains(this.getSortByList());
        }
        if (ae.getSource() == this.printButton) {
            this.trainManager.printSelectedTrains(this.getSortByList());
        }
        if (ae.getSource() == this.openFileButton) {
            List<Train> trains = this.getSortByList();
            for (Train train : trains) {
                if (!train.isBuildEnabled()) continue;
                if (!train.isBuilt() && this.trainManager.isBuildMessagesEnabled()) {
                    int response = JOptionPane.showConfirmDialog(this, MessageFormat.format(Bundle.getMessage("NeedToBuildBeforeOpenFile"), train.getName()), Bundle.getMessage("ErrorTitle"), 2);
                    if (response != -1 && response != 2) continue;
                    break;
                }
                if (!train.isBuilt()) continue;
                train.openFile();
            }
        }
        if (ae.getSource() == this.runFileButton) {
            TrainCustomManifest tcm = InstanceManager.getDefault(TrainCustomManifest.class);
            if (!tcm.excelFileExists()) {
                log.warn("Manifest creator file not found!, directory name: {}, file name: {}", (Object)tcm.getDirectoryName(), (Object)tcm.getFileName());
                JOptionPane.showMessageDialog(this, MessageFormat.format(Bundle.getMessage("LoadDirectoryNameFileName"), tcm.getDirectoryName(), tcm.getFileName()), Bundle.getMessage("ManifestCreatorNotFound"), 0);
                return;
            }
            List<Train> trains = this.getSortByList();
            for (Train train : trains) {
                if (!train.isBuildEnabled()) continue;
                if (!train.isBuilt() && this.trainManager.isBuildMessagesEnabled()) {
                    int response = JOptionPane.showConfirmDialog(this, MessageFormat.format(Bundle.getMessage("NeedToBuildBeforeRunFile"), train.getName()), Bundle.getMessage("ErrorTitle"), 2);
                    if (response != -1 && response != 2) continue;
                    break;
                }
                if (!train.isBuilt()) continue;
                tcm.addCsvFile(train.createCsvManifestFile());
                train.setPrinted(true);
            }
            tcm.process();
        }
        if (ae.getSource() == this.switchListsButton) {
            if (this.tslef != null) {
                this.tslef.dispose();
            }
            this.tslef = new TrainSwitchListEditFrame();
            this.tslef.initComponents();
        }
        if (ae.getSource() == this.terminateButton) {
            this.trainManager.terminateSelectedTrains(this.getSortByList());
        }
        if (ae.getSource() == this.saveButton) {
            this.storeValues();
        }
    }

    protected String getSortBy() {
        String sortBy = TrainsTableModel.TIMECOLUMNNAME;
        this._status = SortOrder.ASCENDING;
        for (RowSorter.SortKey key : this.trainsTable.getRowSorter().getSortKeys()) {
            String name = this.trainsModel.getColumnName(key.getColumn());
            SortOrder status = key.getSortOrder();
            if (status.equals((Object)SortOrder.UNSORTED) || name.isEmpty()) continue;
            sortBy = name;
            this._status = status;
            break;
        }
        return sortBy;
    }

    public List<Train> getSortByList() {
        String sortBy = this.getSortBy();
        List<Train> sysList = sortBy.equals(TrainsTableModel.IDCOLUMNNAME) ? this.trainManager.getTrainsByIdList() : (sortBy.equals(TrainsTableModel.TIMECOLUMNNAME) ? this.trainManager.getTrainsByTimeList() : (sortBy.equals(TrainsTableModel.DEPARTSCOLUMNNAME) ? this.trainManager.getTrainsByDepartureList() : (sortBy.equals(TrainsTableModel.TERMINATESCOLUMNNAME) ? this.trainManager.getTrainsByTerminatesList() : (sortBy.equals(TrainsTableModel.ROUTECOLUMNNAME) ? this.trainManager.getTrainsByRouteList() : (sortBy.equals(TrainsTableModel.STATUSCOLUMNNAME) ? this.trainManager.getTrainsByStatusList() : (sortBy.equals(TrainsTableModel.DESCRIPTIONCOLUMNNAME) ? this.trainManager.getTrainsByDescriptionList() : this.trainManager.getTrainsByNameList()))))));
        return sysList;
    }

    private void setPrintButtonText() {
        if (this.printPreviewBox.isSelected()) {
            this.printButton.setText(Bundle.getMessage("Preview"));
            this.printButton.setToolTipText(Bundle.getMessage("PreviewSelectedTip"));
            this.buildReportBox.setToolTipText(Bundle.getMessage("BuildReportPreviewTip"));
        } else {
            this.printButton.setText(Bundle.getMessage("Print"));
            this.printButton.setToolTipText(Bundle.getMessage("PrintSelectedTip"));
            this.buildReportBox.setToolTipText(Bundle.getMessage("BuildReportPrintTip"));
        }
    }

    private void setTrainActionButton() {
        this.moveRB.setSelected(this.trainManager.getTrainsFrameTrainAction().equals(MOVE));
        this.terminateRB.setSelected(this.trainManager.getTrainsFrameTrainAction().equals(TERMINATE));
        this.resetRB.setSelected(this.trainManager.getTrainsFrameTrainAction().equals(RESET));
        this.conductorRB.setSelected(this.trainManager.getTrainsFrameTrainAction().equals(CONDUCTOR));
    }

    @Override
    public void checkBoxActionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.buildMsgBox) {
            this.trainManager.setBuildMessagesEnabled(this.buildMsgBox.isSelected());
        }
        if (ae.getSource() == this.buildReportBox) {
            this.trainManager.setBuildReportEnabled(this.buildReportBox.isSelected());
        }
        if (ae.getSource() == this.printPreviewBox) {
            this.trainManager.setPrintPreviewEnabled(this.printPreviewBox.isSelected());
            this.setPrintButtonText();
        }
        if (ae.getSource() == this.openFileBox) {
            this.trainManager.setOpenFileEnabled(this.openFileBox.isSelected());
            this.runFileBox.setSelected(false);
            this.trainManager.setRunFileEnabled(false);
        }
        if (ae.getSource() == this.runFileBox) {
            this.trainManager.setRunFileEnabled(this.runFileBox.isSelected());
            this.openFileBox.setSelected(false);
            this.trainManager.setOpenFileEnabled(false);
        }
        if (ae.getSource() == this.showAllBox) {
            this.trainsModel.setShowAll(this.showAllBox.isSelected());
        }
    }

    private void updateTitle() {
        String title = Bundle.getMessage("TitleTrainsTable");
        TrainSchedule sch = InstanceManager.getDefault(TrainScheduleManager.class).getActiveSchedule();
        if (sch != null) {
            title = String.valueOf(title) + " (" + sch.getName() + ")";
        }
        this.setTitle(title);
    }

    private void updateSwitchListButton() {
        List<Location> locations = this.locationManager.getList();
        for (Location location : locations) {
            if (location == null || !location.isSwitchListEnabled() || !location.getStatus().equals(Location.MODIFIED)) continue;
            this.switchListsButton.setBackground(Color.RED);
            return;
        }
        this.switchListsButton.setBackground(Color.GREEN);
    }

    private void updateRunAndOpenButtons() {
        this.openFileBox.setVisible(Setup.isGenerateCsvManifestEnabled());
        this.openFileButton.setVisible(Setup.isGenerateCsvManifestEnabled());
        this.runFileBox.setVisible(Setup.isGenerateCsvManifestEnabled());
        this.runFileButton.setVisible(Setup.isGenerateCsvManifestEnabled());
    }

    private synchronized void addPropertyChangeLocations() {
        List<Location> locations = this.locationManager.getList();
        for (Location location : locations) {
            location.addPropertyChangeListener(this);
        }
    }

    private synchronized void removePropertyChangeLocations() {
        List<Location> locations = this.locationManager.getList();
        for (Location location : locations) {
            location.removePropertyChangeListener(this);
        }
    }

    @Override
    public void dispose() {
        this.trainsModel.dispose();
        this.trainManager.runShutDownScripts();
        this.trainManager.removePropertyChangeListener(this);
        InstanceManager.getDefault(TrainScheduleManager.class).removePropertyChangeListener(this);
        Setup.getDefault().removePropertyChangeListener(this);
        this.removePropertyChangeLocations();
        this.setModifiedFlag(false);
        InstanceManager.getOptionalDefault(JTablePersistenceManager.class).ifPresent(tpm -> tpm.stopPersisting(this.trainsTable));
        super.dispose();
    }

    @Override
    protected void handleModified() {
        int result;
        if (!this.getModifiedFlag()) {
            return;
        }
        if (Setup.isAutoSaveEnabled()) {
            this.storeValues();
            return;
        }
        if (OperationsXml.areFilesDirty() && (result = JOptionPane.showOptionDialog(this, Bundle.getMessage("PromptQuitWindowNotWritten"), Bundle.getMessage("PromptSaveQuit"), 0, 2, null, new String[]{ResourceBundle.getBundle("jmri.util.UtilBundle").getString("WarnYesSave"), ResourceBundle.getBundle("jmri.util.UtilBundle").getString("WarnNoClose")}, ResourceBundle.getBundle("jmri.util.UtilBundle").getString("WarnYesSave"))) != 1) {
            this.storeValues();
        }
    }

    @Override
    protected void storeValues() {
        super.storeValues();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("ActiveTrainScheduleId")) {
            this.updateTitle();
        }
        if (e.getPropertyName().equals("locationStatus") || e.getPropertyName().equals("switchList")) {
            log.debug("update switch list button location ({})", e.getSource());
            this.updateSwitchListButton();
        }
        if (e.getPropertyName().equals("setupManifestCSVChange")) {
            this.updateRunAndOpenButtons();
        }
        if (e.getPropertyName().equals("TrainsListLength")) {
            this.numTrains.setText(Integer.toString(this.trainManager.getNumEntries()));
        }
        if (e.getPropertyName().equals("TrainsBuiltChange")) {
            this.runFileButton.setEnabled(true);
        }
    }
}

