/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.trains;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import jmri.InstanceManager;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.locations.Track;
import jmri.jmrit.operations.rollingstock.cars.Car;
import jmri.jmrit.operations.rollingstock.cars.CarColors;
import jmri.jmrit.operations.rollingstock.cars.CarLoads;
import jmri.jmrit.operations.rollingstock.cars.CarRoads;
import jmri.jmrit.operations.rollingstock.cars.CarTypes;
import jmri.jmrit.operations.rollingstock.engines.Engine;
import jmri.jmrit.operations.routes.Route;
import jmri.jmrit.operations.routes.RouteLocation;
import jmri.jmrit.operations.setup.Control;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.operations.trains.Bundle;
import jmri.jmrit.operations.trains.Train;
import jmri.jmrit.operations.trains.TrainCommon;
import jmri.jmrit.operations.trains.TrainManager;
import jmri.jmrit.operations.trains.TrainManagerXml;
import jmri.jmrit.operations.trains.TrainManifestText;
import jmri.jmrit.operations.trains.TrainPrintUtilities;
import jmri.jmrit.operations.trains.TrainSwitchListText;
import jmri.jmrit.operations.trains.TrainUtilities;
import jmri.jmrit.operations.trains.schedules.TrainSchedule;
import jmri.jmrit.operations.trains.schedules.TrainScheduleManager;
import jmri.util.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrainSwitchLists
extends TrainCommon {
    TrainManager trainManager = InstanceManager.getDefault(TrainManager.class);
    private static final char FORM_FEED = '\f';
    private static final boolean IS_PRINT_HEADER = true;
    private static final String HYPHEN = "-";
    String messageFormatText = "";
    private static final Logger log = LoggerFactory.getLogger(TrainSwitchLists.class);

    public void buildSwitchList(Location location) {
        boolean append = false;
        boolean checkFormFeed = true;
        if (!Setup.isSwitchListRealTime()) {
            if (!location.getStatus().equals(Location.MODIFIED) && !Setup.isSwitchListAllTrainsEnabled()) {
                return;
            }
            append = location.getSwitchListState() == 1;
            location.setSwitchListState(1);
        }
        log.debug("Append: {} for location ({})", (Object)append, (Object)location.getName());
        File file = InstanceManager.getDefault(TrainManagerXml.class).createSwitchListFile(location.getName());
        PrintWriter fileOut = null;
        try {
            fileOut = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file, append), StandardCharsets.UTF_8)), true);
        }
        catch (IOException iOException) {
            log.error("Can not open switchlist file: {}", (Object)file.getName());
            return;
        }
        try {
            TrainSchedule sch;
            if (!append) {
                this.newLine(fileOut, Setup.getRailroadName());
                this.newLine(fileOut);
                this.messageFormatText = TrainSwitchListText.getStringSwitchListFor();
                this.newLine(fileOut, MessageFormat.format(this.messageFormatText, TrainSwitchLists.splitString(location.getName())));
                if (!location.getSwitchListComment().equals("")) {
                    this.newLine(fileOut, location.getSwitchListComment());
                }
            } else {
                this.newLine(fileOut);
            }
            this.messageFormatText = TrainManifestText.getStringValid();
            String valid = MessageFormat.format(this.messageFormatText, TrainSwitchLists.getDate(true));
            if (Setup.isPrintTrainScheduleNameEnabled() && (sch = InstanceManager.getDefault(TrainScheduleManager.class).getActiveSchedule()) != null) {
                valid = String.valueOf(valid) + " (" + sch.getName() + ")";
            }
            List<Train> trains = this.trainManager.getTrainsArrivingThisLocationList(location);
            for (Train train : trains) {
                Route route;
                if (!Setup.isSwitchListRealTime() && train.getSwitchListStatus().equals(Train.PRINTED) || (route = train.getRoute()) == null) continue;
                boolean works = TrainSwitchLists.isThereWorkAtLocation(train, location);
                if (!works && !Setup.isSwitchListAllTrainsEnabled()) {
                    log.debug("No work for train ({}) at location ({})", (Object)train.getName(), (Object)location.getName());
                    continue;
                }
                if (checkFormFeed) {
                    if (append && !Setup.getSwitchListPageFormat().equals(Setup.PAGE_NORMAL)) {
                        fileOut.write(12);
                    }
                    if (Setup.isPrintValidEnabled()) {
                        this.newLine(fileOut, valid);
                    }
                } else if (!Setup.getSwitchListPageFormat().equals(Setup.PAGE_NORMAL)) {
                    fileOut.write(12);
                }
                checkFormFeed = false;
                this.pickupCars = false;
                this.dropCars = false;
                int stops = 1;
                boolean trainDone = false;
                List<Engine> engineList = this.engineManager.getByTrainBlockingList(train);
                List<Car> carList = this.carManager.getByTrainDestinationList(train);
                List<RouteLocation> routeList = route.getLocationsBySequenceList();
                RouteLocation rlPrevious = null;
                for (RouteLocation rl : routeList) {
                    if (!TrainSwitchLists.splitString(rl.getName()).equals(TrainSwitchLists.splitString(location.getName()))) {
                        rlPrevious = rl;
                        continue;
                    }
                    String expectedArrivalTime = train.getExpectedArrivalTime(rl);
                    if (expectedArrivalTime.equals("-1")) {
                        trainDone = true;
                    }
                    if (stops == 1) {
                        this.newLine(fileOut);
                        this.messageFormatText = TrainSwitchListText.getStringScheduledWork();
                        this.newLine(fileOut, MessageFormat.format(this.messageFormatText, train.getName(), train.getDescription()));
                        if (train.isTrainEnRoute()) {
                            if (!trainDone) {
                                this.messageFormatText = TrainSwitchListText.getStringDepartedExpected();
                                this.newLine(fileOut, MessageFormat.format(this.messageFormatText, TrainSwitchLists.splitString(train.getTrainDepartsName()), expectedArrivalTime, rl.getTrainDirectionString()));
                            }
                        } else if (!train.isLocalSwitcher()) {
                            if (rl == train.getTrainDepartsRouteLocation()) {
                                this.messageFormatText = TrainSwitchListText.getStringDepartsAt();
                                this.newLine(fileOut, MessageFormat.format(this.messageFormatText, TrainSwitchLists.splitString(train.getTrainDepartsName()), rl.getTrainDirectionString(), train.getFormatedDepartureTime()));
                            } else {
                                this.messageFormatText = TrainSwitchListText.getStringDepartsAtExpectedArrival();
                                this.newLine(fileOut, MessageFormat.format(this.messageFormatText, TrainSwitchLists.splitString(train.getTrainDepartsName()), train.getFormatedDepartureTime(), expectedArrivalTime, rl.getTrainDirectionString()));
                            }
                        }
                    } else if (rlPrevious == null || !TrainSwitchLists.splitString(rl.getName()).equals(TrainSwitchLists.splitString(rlPrevious.getName()))) {
                        if (Setup.getSwitchListPageFormat().equals(Setup.PAGE_PER_VISIT)) {
                            fileOut.write(12);
                        }
                        this.newLine(fileOut);
                        if (train.isTrainEnRoute()) {
                            if (expectedArrivalTime.equals("-1")) {
                                this.messageFormatText = TrainSwitchListText.getStringVisitNumberDone();
                                this.newLine(fileOut, MessageFormat.format(this.messageFormatText, stops, train.getName(), train.getDescription()));
                            } else if (rl != train.getTrainTerminatesRouteLocation()) {
                                this.messageFormatText = TrainSwitchListText.getStringVisitNumberDeparted();
                                this.newLine(fileOut, MessageFormat.format(this.messageFormatText, stops, train.getName(), expectedArrivalTime, rl.getTrainDirectionString(), train.getDescription()));
                            } else {
                                this.messageFormatText = TrainSwitchListText.getStringVisitNumberTerminatesDeparted();
                                this.newLine(fileOut, MessageFormat.format(this.messageFormatText, stops, train.getName(), expectedArrivalTime, TrainSwitchLists.splitString(rl.getName()), train.getDescription()));
                            }
                        } else if (rl != train.getTrainTerminatesRouteLocation()) {
                            this.messageFormatText = TrainSwitchListText.getStringVisitNumber();
                            this.newLine(fileOut, MessageFormat.format(this.messageFormatText, stops, train.getName(), expectedArrivalTime, rl.getTrainDirectionString(), train.getDescription()));
                        } else {
                            this.messageFormatText = TrainSwitchListText.getStringVisitNumberTerminates();
                            this.newLine(fileOut, MessageFormat.format(this.messageFormatText, stops, train.getName(), expectedArrivalTime, TrainSwitchLists.splitString(rl.getName()), train.getDescription()));
                        }
                    } else {
                        --stops;
                        if (rl.getTrainDirection() != rlPrevious.getTrainDirection() && !TrainSwitchListText.getStringTrainDirectionChange().isEmpty()) {
                            this.messageFormatText = TrainSwitchListText.getStringTrainDirectionChange();
                            this.newLine(fileOut, MessageFormat.format(this.messageFormatText, train.getName(), rl.getTrainDirectionString(), train.getDescription(), train.getTrainTerminatesName()));
                        }
                    }
                    rlPrevious = rl;
                    if (Setup.isSwitchListRouteLocationCommentEnabled() && !rl.getComment().trim().isEmpty()) {
                        this.newLine(fileOut, rl.getFormatedColorComment());
                    }
                    this.printTrackComments(fileOut, rl, carList, false);
                    if (Setup.getManifestFormat().equals(Setup.STANDARD_FORMAT)) {
                        this.pickupEngines(fileOut, engineList, rl, false);
                        if (train.isLocalSwitcher()) {
                            this.blockCarsByTrack(fileOut, train, carList, rl, true, false);
                            this.dropEngines(fileOut, engineList, rl, false);
                        } else {
                            this.dropEngines(fileOut, engineList, rl, false);
                            this.blockCarsByTrack(fileOut, train, carList, rl, true, false);
                        }
                    } else if (Setup.getManifestFormat().equals(Setup.TWO_COLUMN_FORMAT)) {
                        this.blockLocosTwoColumn(fileOut, engineList, rl, false);
                        this.blockCarsTwoColumn(fileOut, train, carList, rl, true, false);
                    } else {
                        this.blockLocosTwoColumn(fileOut, engineList, rl, false);
                        this.blockCarsByTrackNameTwoColumn(fileOut, train, carList, rl, true, false);
                    }
                    if (Setup.isPrintHeadersEnabled() || !Setup.getManifestFormat().equals(Setup.STANDARD_FORMAT)) {
                        this.printHorizontalLine(fileOut, false);
                    }
                    ++stops;
                    if (rl == train.getTrainTerminatesRouteLocation()) continue;
                    RouteLocation nextRl = train.getRoute().getNextRouteLocation(rl);
                    if (TrainSwitchLists.splitString(rl.getName()).equals(TrainSwitchLists.splitString(nextRl.getName())) || train.isLocalSwitcher() || trainDone) continue;
                    String trainDeparts = "";
                    if (Setup.isPrintLoadsAndEmptiesEnabled()) {
                        int emptyCars = train.getNumberEmptyCarsInTrain(rl);
                        trainDeparts = MessageFormat.format(TrainSwitchListText.getStringTrainDepartsLoads(), TrainCommon.splitString(rl.getName()), rl.getTrainDirectionString(), train.getNumberCarsInTrain(rl) - emptyCars, emptyCars, train.getTrainLength(rl), Setup.getLengthUnit().toLowerCase(), train.getTrainWeight(rl), train.getTrainTerminatesName(), train.getName());
                    } else {
                        trainDeparts = MessageFormat.format(TrainSwitchListText.getStringTrainDepartsCars(), TrainCommon.splitString(rl.getName()), rl.getTrainDirectionString(), train.getNumberCarsInTrain(rl), train.getTrainLength(rl), Setup.getLengthUnit().toLowerCase(), train.getTrainWeight(rl), train.getTrainTerminatesName(), train.getName());
                    }
                    this.newLine(fileOut, trainDeparts);
                }
                if (trainDone && !this.pickupCars && !this.dropCars) {
                    this.messageFormatText = TrainSwitchListText.getStringTrainDone();
                    this.newLine(fileOut, MessageFormat.format(this.messageFormatText, train.getName(), train.getDescription(), TrainSwitchLists.splitString(location.getName())));
                    continue;
                }
                if (stops > 1 && !this.pickupCars) {
                    this.messageFormatText = TrainSwitchListText.getStringNoCarPickUps();
                    this.newLine(fileOut, MessageFormat.format(this.messageFormatText, train.getName(), train.getDescription(), TrainSwitchLists.splitString(location.getName())));
                }
                if (stops <= true || this.dropCars) continue;
                this.messageFormatText = TrainSwitchListText.getStringNoCarDrops();
                this.newLine(fileOut, MessageFormat.format(this.messageFormatText, train.getName(), train.getDescription(), TrainSwitchLists.splitString(location.getName())));
            }
            if (Setup.isPrintTrackSummaryEnabled() && Setup.isSwitchListRealTime()) {
                this.clearUtilityCarTypes();
                if (Setup.getSwitchListPageFormat().equals(Setup.PAGE_NORMAL)) {
                    this.newLine(fileOut);
                    this.newLine(fileOut);
                } else {
                    fileOut.write(12);
                }
                this.messageFormatText = TrainSwitchListText.getStringSwitchListByTrack();
                this.newLine(fileOut, MessageFormat.format(this.messageFormatText, TrainSwitchLists.splitString(location.getName())));
                List rsList = this.carManager.getByTrainList();
                ArrayList<Car> carList = new ArrayList<Car>();
                for (Car rs : rsList) {
                    if ((rs.getLocation() == null || !TrainSwitchLists.splitString(rs.getLocation().getName()).equals(TrainSwitchLists.splitString(location.getName()))) && (rs.getDestination() == null || !TrainSwitchLists.splitString(rs.getDestination().getName()).equals(TrainSwitchLists.splitString(location.getName())))) continue;
                    carList.add(rs);
                }
                ArrayList<String> trackNames = new ArrayList<String>();
                for (Location loc : this.locationManager.getLocationsByNameList()) {
                    if (!TrainSwitchLists.splitString(loc.getName()).equals(TrainSwitchLists.splitString(location.getName()))) continue;
                    for (Track track : loc.getTracksByNameList(null)) {
                        String trackName = TrainSwitchLists.splitString(track.getName());
                        if (trackNames.contains(trackName)) continue;
                        trackNames.add(trackName);
                        String trainName = "";
                        this.newLine(fileOut);
                        this.newLine(fileOut, trackName);
                        for (Car car : carList) {
                            if (!TrainSwitchLists.splitString(car.getTrackName()).equals(trackName)) continue;
                            if (car.getRouteLocation() != null) {
                                if (!TrainSwitchLists.splitString(car.getRouteLocation().getLocation().getName()).equals(TrainSwitchLists.splitString(location.getName()))) continue;
                                if (!trainName.equals(car.getTrainName())) {
                                    trainName = car.getTrainName();
                                    this.messageFormatText = TrainSwitchListText.getStringScheduledWork();
                                    this.newLine(fileOut, MessageFormat.format(this.messageFormatText, car.getTrainName(), car.getTrain().getDescription()));
                                    this.printPickupCarHeader(fileOut, false, false);
                                }
                                if (car.isUtility()) {
                                    this.pickupUtilityCars(fileOut, carList, car, false, false);
                                    continue;
                                }
                                this.pickUpCar(fileOut, car, false);
                                continue;
                            }
                            if (car.isUtility()) {
                                String s = this.pickupUtilityCars(carList, car, false, false);
                                if (s == null) continue;
                                this.newLine(fileOut, String.valueOf(TrainSwitchListText.getStringHoldCar().split("\\{")[0]) + s.trim());
                                continue;
                            }
                            this.messageFormatText = TrainSwitchListText.getStringHoldCar();
                            this.newLine(fileOut, MessageFormat.format(this.messageFormatText, TrainSwitchLists.padAndTruncateIfNeeded(car.getRoadName(), InstanceManager.getDefault(CarRoads.class).getMaxNameLength()), TrainSwitchLists.padAndTruncateIfNeeded(TrainCommon.splitString(car.getNumber()), Control.max_len_string_print_road_number), TrainSwitchLists.padAndTruncateIfNeeded(car.getTypeName().split(HYPHEN)[0], InstanceManager.getDefault(CarTypes.class).getMaxNameLength()), TrainSwitchLists.padAndTruncateIfNeeded(String.valueOf(car.getLength()) + Setup.getLengthUnitAbv(), Control.max_len_string_length_name), TrainSwitchLists.padAndTruncateIfNeeded(car.getLoadName(), InstanceManager.getDefault(CarLoads.class).getMaxNameLength()), TrainSwitchLists.padAndTruncateIfNeeded(trackName, this.locationManager.getMaxTrackNameLength()), TrainSwitchLists.padAndTruncateIfNeeded(car.getColor(), InstanceManager.getDefault(CarColors.class).getMaxNameLength())));
                        }
                        for (Car car : carList) {
                            if (!TrainSwitchLists.splitString(car.getDestinationTrackName()).equals(trackName) || car.getRouteDestination() == null || !TrainSwitchLists.splitString(car.getRouteDestination().getLocation().getName()).equals(TrainSwitchLists.splitString(location.getName()))) continue;
                            if (!trainName.equals(car.getTrainName())) {
                                trainName = car.getTrainName();
                                this.messageFormatText = TrainSwitchListText.getStringScheduledWork();
                                this.newLine(fileOut, MessageFormat.format(this.messageFormatText, car.getTrainName(), car.getTrain().getDescription()));
                                this.printDropCarHeader(fileOut, false, false);
                            }
                            if (car.isUtility()) {
                                this.setoutUtilityCars(fileOut, carList, car, false, false);
                                continue;
                            }
                            this.dropCar(fileOut, car, false);
                        }
                    }
                }
            }
        }
        catch (IllegalArgumentException e) {
            this.newLine(fileOut, MessageFormat.format(Bundle.getMessage("ErrorIllegalArgument"), Bundle.getMessage("TitleSwitchListText"), e.getLocalizedMessage()));
            this.newLine(fileOut, this.messageFormatText);
            log.error("Illegal argument", (Throwable)e);
        }
        this.addCarsLocationUnknown(fileOut, false);
        fileOut.flush();
        fileOut.close();
        location.setStatus(Location.UPDATED);
    }

    public void printSwitchList(Location location, boolean isPreview) {
        File switchListFile = InstanceManager.getDefault(TrainManagerXml.class).getSwitchListFile(location.getName());
        if (!switchListFile.exists()) {
            log.warn("Switch list file missing for location ({})", (Object)location.getName());
            return;
        }
        if (isPreview && Setup.isManifestEditorEnabled()) {
            TrainUtilities.openDesktop(switchListFile);
        } else {
            TrainPrintUtilities.printReport(switchListFile, location.getName(), isPreview, Setup.getFontName(), false, FileUtil.getExternalFilename(Setup.getManifestLogoURL()), location.getDefaultPrinterName(), Setup.getSwitchListOrientation(), Setup.getManifestFontSize(), Setup.isPrintPageHeaderEnabled());
        }
        if (!isPreview) {
            location.setStatus(Location.PRINTED);
            location.setSwitchListState(2);
        }
    }

    protected void newLine(PrintWriter file, String string) {
        if (!string.isEmpty()) {
            this.newLine(file, string, false);
        }
    }
}

