/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.trains;

import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.filechooser.FileNameExtensionFilter;
import jmri.InstanceManager;
import jmri.jmrit.operations.OperationsFrame;
import jmri.jmrit.operations.OperationsPanel;
import jmri.jmrit.operations.OperationsXml;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.locations.LocationManager;
import jmri.jmrit.operations.setup.Control;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.operations.trains.Bundle;
import jmri.jmrit.operations.trains.Train;
import jmri.jmrit.operations.trains.TrainCommon;
import jmri.jmrit.operations.trains.TrainCsvSwitchLists;
import jmri.jmrit.operations.trains.TrainManager;
import jmri.jmrit.operations.trains.TrainManagerXml;
import jmri.jmrit.operations.trains.TrainPrintUtilities;
import jmri.jmrit.operations.trains.TrainSwitchLists;
import jmri.jmrit.operations.trains.TrainUtilities;
import jmri.jmrit.operations.trains.excel.SetupExcelProgramSwitchListFrameAction;
import jmri.jmrit.operations.trains.excel.TrainCustomSwitchList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrainSwitchListEditFrame
extends OperationsFrame
implements PropertyChangeListener {
    JScrollPane switchPane;
    LocationManager locationManager = InstanceManager.getDefault(LocationManager.class);
    List<JCheckBox> locationCheckBoxes = new ArrayList<JCheckBox>();
    List<JComboBox<String>> locationComboBoxes = new ArrayList<JComboBox<String>>();
    JPanel locationPanelCheckBoxes = new JPanel();
    JCheckBox switchListRealTimeCheckBox = new JCheckBox(Bundle.getMessage("SwitchListRealTime"));
    JCheckBox switchListAllTrainsCheckBox = new JCheckBox(Bundle.getMessage("SwitchListAllTrains"));
    JButton clearButton = new JButton(Bundle.getMessage("ClearAll"));
    JButton setButton = new JButton(Bundle.getMessage("SelectAll"));
    JButton printButton = new JButton(Bundle.getMessage("PrintSwitchLists"));
    JButton previewButton = new JButton(Bundle.getMessage("PreviewSwitchLists"));
    JButton printChangesButton = new JButton(Bundle.getMessage("PrintChanges"));
    JButton runButton = new JButton(Bundle.getMessage("RunFile"));
    JButton runChangeButton = new JButton(Bundle.getMessage("RunFileChanges"));
    JButton openFileButton = new JButton(Bundle.getMessage("OpenFile"));
    JButton updateButton = new JButton(Bundle.getMessage("Update"));
    JButton resetButton = new JButton(Bundle.getMessage("ResetSwitchLists"));
    JButton saveButton = new JButton(Bundle.getMessage("ButtonSave"));
    JComboBox<String> switchListPageComboBox = Setup.getSwitchListPageFormatComboBox();
    JPanel customPanel;
    private static final boolean IS_CHANGED = true;
    private static final boolean IS_PRINT = true;
    private static final boolean IS_PREVIEW = true;
    JFileChooser fc;
    private static final Logger log = LoggerFactory.getLogger(TrainSwitchListEditFrame.class);

    public TrainSwitchListEditFrame() {
        super(Bundle.getMessage("TitleSwitchLists"));
    }

    @Override
    public void initComponents() {
        this.locationManager.addPropertyChangeListener(this);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.switchListRealTimeCheckBox.setToolTipText(Bundle.getMessage("RealTimeTip"));
        this.switchListAllTrainsCheckBox.setToolTipText(Bundle.getMessage("AllTrainsTip"));
        this.switchListPageComboBox.setToolTipText(Bundle.getMessage("PageTrainTip"));
        this.printChangesButton.setToolTipText(Bundle.getMessage("PrintChangesTip"));
        this.resetButton.setToolTipText(Bundle.getMessage("ResetSwitchListTip"));
        this.switchPane = new JScrollPane(this.locationPanelCheckBoxes);
        this.switchPane.setVerticalScrollBarPolicy(20);
        this.switchPane.setBorder(BorderFactory.createTitledBorder(""));
        this.locationPanelCheckBoxes.setLayout(new GridBagLayout());
        this.updateLocationCheckboxes();
        this.enableSaveButton(false);
        JPanel pButtons = new JPanel();
        pButtons.setLayout(new GridBagLayout());
        pButtons.setBorder(BorderFactory.createTitledBorder(""));
        this.addItem(pButtons, this.clearButton, 0, 1);
        this.addItem(pButtons, this.setButton, 1, 1);
        JPanel pSwitchListOptions = new JPanel();
        pSwitchListOptions.setLayout(new GridBagLayout());
        pSwitchListOptions.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("BorderLayoutSwitchListOptions")));
        JPanel pSwitchListPageFormat = new JPanel();
        pSwitchListPageFormat.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("BorderLayoutSwitchListPageFormat")));
        pSwitchListPageFormat.add(this.switchListPageComboBox);
        this.addItem(pSwitchListOptions, this.switchListAllTrainsCheckBox, 1, 0);
        this.addItem(pSwitchListOptions, pSwitchListPageFormat, 2, 0);
        this.addItem(pSwitchListOptions, this.switchListRealTimeCheckBox, 3, 0);
        this.addItem(pSwitchListOptions, this.saveButton, 4, 0);
        JPanel controlPanel = new JPanel();
        controlPanel.setLayout(new GridBagLayout());
        controlPanel.setBorder(BorderFactory.createTitledBorder(""));
        this.addItem(controlPanel, this.previewButton, 0, 2);
        this.addItem(controlPanel, this.printButton, 1, 2);
        this.addItem(controlPanel, this.printChangesButton, 2, 2);
        this.addItem(controlPanel, this.updateButton, 0, 3);
        this.addItem(controlPanel, this.resetButton, 1, 3);
        this.customPanel = new JPanel();
        this.customPanel.setLayout(new GridBagLayout());
        this.customPanel.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("BorderLayoutCustomSwitchLists")));
        this.addItem(this.customPanel, this.runButton, 1, 5);
        this.addItem(this.customPanel, this.runChangeButton, 2, 5);
        this.addItem(this.customPanel, this.openFileButton, 3, 5);
        this.getContentPane().add(this.switchPane);
        this.getContentPane().add(pButtons);
        this.getContentPane().add(pSwitchListOptions);
        this.getContentPane().add(controlPanel);
        this.getContentPane().add(this.customPanel);
        this.customPanel.setVisible(Setup.isGenerateCsvSwitchListEnabled());
        this.switchListRealTimeCheckBox.setSelected(Setup.isSwitchListRealTime());
        this.switchListAllTrainsCheckBox.setSelected(Setup.isSwitchListAllTrainsEnabled());
        this.switchListPageComboBox.setSelectedItem(Setup.getSwitchListPageFormat());
        this.updateButton.setVisible(!this.switchListRealTimeCheckBox.isSelected());
        this.resetButton.setVisible(!this.switchListRealTimeCheckBox.isSelected());
        this.saveButton.setEnabled(false);
        this.addButtonAction(this.clearButton);
        this.addButtonAction(this.setButton);
        this.addButtonAction(this.printButton);
        this.addButtonAction(this.previewButton);
        this.addButtonAction(this.printChangesButton);
        this.addButtonAction(this.runButton);
        this.addButtonAction(this.runChangeButton);
        this.addButtonAction(this.openFileButton);
        this.addButtonAction(this.updateButton);
        this.addButtonAction(this.resetButton);
        this.addButtonAction(this.saveButton);
        this.addCheckBoxAction(this.switchListRealTimeCheckBox);
        this.addCheckBoxAction(this.switchListAllTrainsCheckBox);
        this.addComboBoxAction(this.switchListPageComboBox);
        Setup.getDefault().addPropertyChangeListener(this);
        JMenuBar menuBar = new JMenuBar();
        JMenu toolMenu = new JMenu(Bundle.getMessage("MenuTools"));
        toolMenu.add(new SetupExcelProgramSwitchListFrameAction());
        menuBar.add(toolMenu);
        this.setJMenuBar(menuBar);
        this.addHelpMenu("package.jmri.jmrit.operations.Operations_SwitchList", true);
        this.initMinimumSize(new Dimension(500, 500));
    }

    @Override
    public void buttonActionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.clearButton) {
            this.selectCheckboxes(false);
        }
        if (ae.getSource() == this.setButton) {
            this.selectCheckboxes(true);
        }
        if (ae.getSource() == this.previewButton) {
            this.buildSwitchList(false, true, true);
        }
        if (ae.getSource() == this.printButton) {
            this.buildSwitchList(false, true, false);
        }
        if (ae.getSource() == this.printChangesButton) {
            this.buildSwitchList(true, true, false);
        }
        if (ae.getSource() == this.updateButton) {
            this.buildSwitchList(false, false, true);
        }
        if (ae.getSource() == this.runButton) {
            this.runCustomSwitchLists(false);
        }
        if (ae.getSource() == this.runChangeButton) {
            this.runCustomSwitchLists(true);
        }
        if (ae.getSource() == this.openFileButton) {
            this.buildSwitchList(true, false, true);
            this.openCsvSwitchList();
        }
        if (ae.getSource() == this.resetButton) {
            this.reset();
        }
        if (ae.getSource() == this.saveButton) {
            this.save();
            if (Setup.isCloseWindowOnSaveEnabled()) {
                this.dispose();
            }
        }
    }

    @Override
    public void checkBoxActionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.switchListRealTimeCheckBox) {
            this.updateButton.setVisible(!this.switchListRealTimeCheckBox.isSelected());
            this.resetButton.setVisible(!this.switchListRealTimeCheckBox.isSelected());
        }
        this.enableSaveButton(true);
    }

    private void reset() {
        if (JOptionPane.showConfirmDialog(this, Bundle.getMessage("DoYouReallyWantDeleteSwitchListData"), Bundle.getMessage("ResetSwitchLists"), 0) != 0) {
            return;
        }
        for (JCheckBox checkbox : new ArrayList<JCheckBox>(this.locationCheckBoxes)) {
            String locationName = checkbox.getName();
            Location location = this.locationManager.getLocationByName(locationName);
            if (!location.isSwitchListEnabled()) continue;
            location.setSwitchListState(0);
            location.setStatus(Location.MODIFIED);
        }
        InstanceManager.getDefault(TrainManager.class).setTrainsSwitchListStatus("");
    }

    private void save() {
        int i = 0;
        while (i < this.locationCheckBoxes.size()) {
            String locationName = this.locationCheckBoxes.get(i).getName();
            Location location = this.locationManager.getLocationByName(locationName);
            JComboBox<String> comboBox = this.locationComboBoxes.get(i);
            String printerName = (String)comboBox.getSelectedItem();
            if (printerName == null || printerName.equals(TrainPrintUtilities.getDefaultPrinterName())) {
                location.setDefaultPrinterName("");
            } else {
                log.debug("Location {} has selected printer {}", (Object)location.getName(), (Object)printerName);
                location.setDefaultPrinterName(printerName);
            }
            ++i;
        }
        if (Setup.isSwitchListRealTime() && !this.switchListRealTimeCheckBox.isSelected()) {
            this.reset();
        }
        Setup.setSwitchListRealTime(this.switchListRealTimeCheckBox.isSelected());
        Setup.setSwitchListAllTrainsEnabled(this.switchListAllTrainsCheckBox.isSelected());
        Setup.setSwitchListPageFormat((String)this.switchListPageComboBox.getSelectedItem());
        OperationsXml.save();
        this.enableSaveButton(false);
        if (Setup.isCloseWindowOnSaveEnabled()) {
            this.dispose();
        }
    }

    private void buildSwitchList(boolean isChanged, boolean isPrint, boolean isPreview) {
        TrainSwitchLists trainSwitchLists = new TrainSwitchLists();
        TrainCsvSwitchLists trainCsvSwitchLists = new TrainCsvSwitchLists();
        for (JCheckBox checkbox : new ArrayList<JCheckBox>(this.locationCheckBoxes)) {
            String locationName = checkbox.getName();
            Location location = this.locationManager.getLocationByName(locationName);
            if (!location.isSwitchListEnabled() || isChanged && !location.getStatus().equals(Location.MODIFIED)) continue;
            trainCsvSwitchLists.buildSwitchList(location);
            trainSwitchLists.buildSwitchList(location);
            if (!isPrint) continue;
            trainSwitchLists.printSwitchList(location, isPreview);
        }
        InstanceManager.getDefault(TrainManager.class).setTrainsSwitchListStatus(Train.PRINTED);
    }

    private void selectCheckboxes(boolean enable) {
        for (JCheckBox checkbox : new ArrayList<JCheckBox>(this.locationCheckBoxes)) {
            String locationName = checkbox.getName();
            Location location = this.locationManager.getLocationByName(locationName);
            location.setSwitchListEnabled(enable);
        }
        this.saveButton.setEnabled(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLocationCheckboxes() {
        String name;
        List<Location> locations = this.locationManager.getLocationsByNameList();
        TrainSwitchListEditFrame trainSwitchListEditFrame = this;
        synchronized (trainSwitchListEditFrame) {
            for (Location location : locations) {
                location.removePropertyChangeListener(this);
            }
        }
        this.locationCheckBoxes.clear();
        this.locationComboBoxes.clear();
        this.locationPanelCheckBoxes.removeAll();
        this.addItem(this.locationPanelCheckBoxes, new JLabel(Bundle.getMessage("Location")), 0, 0);
        this.addItem(this.locationPanelCheckBoxes, new JLabel("        "), 1, 0);
        this.addItem(this.locationPanelCheckBoxes, new JLabel(Bundle.getMessage("Status")), 2, 0);
        this.addItem(this.locationPanelCheckBoxes, new JLabel("        "), 3, 0);
        this.addItem(this.locationPanelCheckBoxes, new JLabel(Bundle.getMessage("Comment")), 4, 0);
        this.addItem(this.locationPanelCheckBoxes, new JLabel("        "), 5, 0);
        this.addItem(this.locationPanelCheckBoxes, new JLabel(Bundle.getMessage("Printer")), 6, 0);
        int y = 1;
        Location mainLocation = null;
        for (Location location : locations) {
            name = TrainCommon.splitString(location.getName());
            if (mainLocation != null && TrainCommon.splitString(mainLocation.getName()).equals(name)) {
                location.setSwitchListEnabled(mainLocation.isSwitchListEnabled());
                if (!mainLocation.isSwitchListEnabled() || !location.getStatus().equals(Location.MODIFIED)) continue;
                mainLocation.setStatus(Location.MODIFIED);
                location.setStatus(Location.UPDATED);
                continue;
            }
            mainLocation = location;
        }
        mainLocation = null;
        for (Location location : locations) {
            name = TrainCommon.splitString(location.getName());
            if (mainLocation != null && TrainCommon.splitString(mainLocation.getName()).equals(name)) continue;
            mainLocation = location;
            JCheckBox checkBox = new JCheckBox();
            this.locationCheckBoxes.add(checkBox);
            checkBox.setSelected(location.isSwitchListEnabled());
            checkBox.setText(name);
            checkBox.setName(location.getName());
            this.addLocationCheckBoxAction(checkBox);
            this.addItemLeft(this.locationPanelCheckBoxes, checkBox, 0, y);
            JLabel status = new JLabel(location.getStatus());
            this.addItem(this.locationPanelCheckBoxes, status, 2, y);
            JButton button = new JButton(Bundle.getMessage("Add"));
            if (!location.getSwitchListComment().equals("")) {
                button.setText(Bundle.getMessage("ButtonEdit"));
            }
            button.setName(location.getName());
            this.addCommentButtonAction(button);
            this.addItem(this.locationPanelCheckBoxes, button, 4, y);
            JComboBox<String> comboBox = TrainPrintUtilities.getPrinterJComboBox();
            this.locationComboBoxes.add(comboBox);
            comboBox.setSelectedItem(location.getDefaultPrinterName());
            this.addComboBoxAction(comboBox);
            this.addItem(this.locationPanelCheckBoxes, comboBox, 6, y++);
        }
        TrainSwitchListEditFrame trainSwitchListEditFrame2 = this;
        synchronized (trainSwitchListEditFrame2) {
            for (Location location : locations) {
                location.addPropertyChangeListener(this);
            }
        }
        this.locationPanelCheckBoxes.revalidate();
        this.pack();
        this.repaint();
    }

    private void runCustomSwitchLists(boolean isChanged) {
        if (!Setup.isGenerateCsvSwitchListEnabled()) {
            return;
        }
        log.debug("run custom switch lists");
        TrainSwitchLists trainSwitchLists = new TrainSwitchLists();
        TrainCsvSwitchLists trainCsvSwitchLists = new TrainCsvSwitchLists();
        for (JCheckBox checkbox : new ArrayList<JCheckBox>(this.locationCheckBoxes)) {
            String locationName = checkbox.getName();
            Location location = this.locationManager.getLocationByName(locationName);
            if (!location.isSwitchListEnabled() || isChanged && !location.getStatus().equals(Location.MODIFIED)) continue;
            File csvFile = trainCsvSwitchLists.buildSwitchList(location);
            trainSwitchLists.buildSwitchList(location);
            if (csvFile == null || !csvFile.exists()) {
                log.error("CSV switch list file was not created for location {}", (Object)locationName);
                return;
            }
            InstanceManager.getDefault(TrainCustomSwitchList.class).addCsvFile(csvFile);
        }
        if (!InstanceManager.getDefault(TrainCustomSwitchList.class).excelFileExists()) {
            log.warn("Manifest creator file not found!, directory name: {}, file name: {}", (Object)InstanceManager.getDefault(TrainCustomSwitchList.class).getDirectoryName(), (Object)InstanceManager.getDefault(TrainCustomSwitchList.class).getFileName());
            JOptionPane.showMessageDialog(this, MessageFormat.format(Bundle.getMessage("LoadDirectoryNameFileName"), InstanceManager.getDefault(TrainCustomSwitchList.class).getDirectoryName(), InstanceManager.getDefault(TrainCustomSwitchList.class).getFileName()), Bundle.getMessage("ManifestCreatorNotFound"), 0);
            return;
        }
        InstanceManager.getDefault(TrainCustomSwitchList.class).process();
        InstanceManager.getDefault(TrainManager.class).setTrainsSwitchListStatus(Train.PRINTED);
    }

    private void openCsvSwitchList() {
        File file = this.selectFile();
        if (file != null) {
            TrainUtilities.openDesktop(file);
        }
    }

    private File selectFile() {
        if (this.fc == null) {
            this.fc = new JFileChooser(InstanceManager.getDefault(TrainManagerXml.class).getDefaultCsvSwitchListDirectoryName());
            this.fc.setFileFilter(new FileNameExtensionFilter("Comma Separated Values", "csv"));
            this.fc.setDialogTitle(Bundle.getMessage("TitleSwitchLists"));
        }
        this.fc.rescanCurrentDirectory();
        int retVal = this.fc.showOpenDialog(this);
        if (retVal == 0) {
            return this.fc.getSelectedFile();
        }
        return null;
    }

    private void enableSaveButton(boolean enable) {
        this.saveButton.setEnabled(enable);
        this.previewButton.setEnabled(!enable);
        this.printButton.setEnabled(!enable && (!Control.disablePrintingIfCustom || !Setup.isGenerateCsvSwitchListEnabled()));
        this.resetButton.setEnabled(!enable);
        this.runButton.setEnabled(!enable);
        this.openFileButton.setEnabled(!enable);
        this.printChangesButton.setEnabled(false);
        this.runChangeButton.setEnabled(false);
        this.updateButton.setEnabled(false);
        if (!enable) {
            this.enableChangeButtons();
        }
    }

    private void enableChangeButtons() {
        this.printChangesButton.setEnabled(false);
        this.runChangeButton.setEnabled(false);
        this.updateButton.setEnabled(false);
        for (Location location : this.locationManager.getLocationsByNameList()) {
            if (!location.getStatus().equals(Location.MODIFIED) || !location.isSwitchListEnabled()) continue;
            this.printChangesButton.setEnabled(!Control.disablePrintingIfCustom || !Setup.isGenerateCsvSwitchListEnabled());
            this.runChangeButton.setEnabled(true);
            this.updateButton.setEnabled(true);
        }
    }

    private void changeLocationCheckboxes(PropertyChangeEvent e) {
        Location l = (Location)e.getSource();
        for (JCheckBox checkbox : new ArrayList<JCheckBox>(this.locationCheckBoxes)) {
            if (!checkbox.getName().equals(l.getName())) continue;
            checkbox.setSelected(l.isSwitchListEnabled());
            break;
        }
    }

    private void addLocationCheckBoxAction(JCheckBox b) {
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TrainSwitchListEditFrame.this.locationCheckBoxActionPerformed(e);
            }
        });
    }

    public void locationCheckBoxActionPerformed(ActionEvent ae) {
        JCheckBox b = (JCheckBox)ae.getSource();
        log.debug("checkbox change {}", (Object)b.getName());
        Location l = this.locationManager.getLocationByName(b.getName());
        l.setSwitchListEnabled(b.isSelected());
        this.saveButton.setEnabled(true);
    }

    private void addCommentButtonAction(JButton b) {
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TrainSwitchListEditFrame.this.commentButtonActionPerformed(e);
            }
        });
    }

    public void commentButtonActionPerformed(ActionEvent ae) {
        JButton b = (JButton)ae.getSource();
        log.debug("button action {}", (Object)b.getName());
        Location l = this.locationManager.getLocationByName(b.getName());
        new TrainSwitchListCommentFrame(l);
    }

    @Override
    protected void comboBoxActionPerformed(ActionEvent ae) {
        log.debug("combo box action");
        this.enableSaveButton(true);
    }

    @Override
    public void dispose() {
        this.locationManager.removePropertyChangeListener(this);
        Setup.getDefault().removePropertyChangeListener(this);
        for (Location location : this.locationManager.getLocationsByNameList()) {
            location.removePropertyChangeListener(this);
        }
        super.dispose();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("switchList")) {
            this.changeLocationCheckboxes(e);
            this.enableChangeButtons();
        }
        if (e.getPropertyName().equals("locationsListLength") || e.getPropertyName().equals("locationName") || e.getPropertyName().equals("locationStatus") || e.getPropertyName().equals("switchListComment")) {
            this.updateLocationCheckboxes();
            this.enableChangeButtons();
        }
        if (e.getPropertyName().equals("setupSwitchListCSVChange")) {
            this.enableSaveButton(false);
            this.customPanel.setVisible(Setup.isGenerateCsvSwitchListEnabled());
        }
    }

    public static class TrainSwitchListCommentFrame
    extends OperationsFrame {
        JTextArea commentTextArea = new JTextArea(10, 90);
        JScrollPane commentScroller = new JScrollPane(this.commentTextArea, 20, 30);
        Dimension minScrollerDim = new Dimension(1200, 500);
        JColorChooser commentColorChooser = new JColorChooser();
        JButton saveButton = new JButton(Bundle.getMessage("ButtonSave"));
        JButton cancelButton = new JButton(Bundle.getMessage("ButtonCancel"));
        Location _location;

        private TrainSwitchListCommentFrame(Location location) {
            this.initComponents(location);
        }

        private void initComponents(Location location) {
            this._location = location;
            this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
            JPanel pC = new JPanel();
            pC.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Comment")));
            pC.setLayout(new GridBagLayout());
            this.commentScroller.setMinimumSize(this.minScrollerDim);
            this.addItem(pC, this.commentScroller, 1, 0);
            this.addItem(pC, OperationsPanel.getColorChooserPanel(location.getSwitchListComment(), this.commentColorChooser), 2, 0);
            JScrollPane panelPane = new JScrollPane(pC);
            this.commentTextArea.setText(TrainCommon.getTextColorString(location.getSwitchListComment()));
            JPanel pB = new JPanel();
            pB.setLayout(new GridBagLayout());
            this.addItem(pB, this.cancelButton, 0, 0);
            this.addItem(pB, this.saveButton, 1, 0);
            this.getContentPane().add(panelPane);
            this.getContentPane().add(pB);
            this.addButtonAction(this.saveButton);
            this.addButtonAction(this.cancelButton);
            this.setTitle(location.getName());
            this.initMinimumSize(new Dimension(600, 200));
        }

        @Override
        public void buttonActionPerformed(ActionEvent ae) {
            if (ae.getSource() == this.saveButton) {
                this._location.setSwitchListComment(TrainCommon.formatColorString(this.commentTextArea.getText(), this.commentColorChooser.getColor()));
                OperationsXml.save();
                if (Setup.isCloseWindowOnSaveEnabled()) {
                    super.dispose();
                }
            }
            if (ae.getSource() == this.cancelButton) {
                super.dispose();
            }
        }
    }
}

