/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.trains;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import jmri.InstanceManager;
import jmri.jmrit.operations.OperationsFrame;
import jmri.jmrit.operations.OperationsXml;
import jmri.jmrit.operations.rollingstock.cars.CarRoads;
import jmri.jmrit.operations.rollingstock.cars.CarTypes;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.operations.trains.Bundle;
import jmri.jmrit.operations.trains.Train;
import jmri.jmrit.operations.trains.TrainEditFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrainRoadOptionsFrame
extends OperationsFrame
implements PropertyChangeListener {
    Train _train = null;
    JPanel pRoadControls = new JPanel();
    JPanel panelRoads = new JPanel();
    JScrollPane paneRoads = new JScrollPane(this.panelRoads);
    JLabel trainName = new JLabel();
    JLabel trainDescription = new JLabel();
    JButton addRoadButton = new JButton(Bundle.getMessage("AddRoad"));
    JButton deleteRoadButton = new JButton(Bundle.getMessage("DeleteRoad"));
    JButton deleteAllRoadsButton = new JButton(Bundle.getMessage("DeleteAll"));
    JButton saveTrainButton = new JButton(Bundle.getMessage("SaveTrain"));
    JRadioButton roadNameAll = new JRadioButton(Bundle.getMessage("AcceptAll"));
    JRadioButton roadNameInclude = new JRadioButton(Bundle.getMessage("AcceptOnly"));
    JRadioButton roadNameExclude = new JRadioButton(Bundle.getMessage("Exclude"));
    ButtonGroup roadGroup = new ButtonGroup();
    JComboBox<String> comboBoxRoads = InstanceManager.getDefault(CarRoads.class).getComboBox();
    public static final String DISPOSE = "dispose";
    private static final int NUMBER_ROADS_PER_LINE = 6;
    private static final Logger log = LoggerFactory.getLogger(TrainRoadOptionsFrame.class);

    public TrainRoadOptionsFrame() {
        super(Bundle.getMessage("MenuItemRoadOptions"));
    }

    public void initComponents(TrainEditFrame parent) {
        parent.setChildFrame(this);
        this._train = parent._train;
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel p1 = new JPanel();
        p1.setLayout(new BoxLayout(p1, 0));
        p1.setMaximumSize(new Dimension(2000, 250));
        JPanel pName = new JPanel();
        pName.setLayout(new GridBagLayout());
        pName.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Name")));
        this.addItem(pName, this.trainName, 0, 0);
        JPanel pDesc = new JPanel();
        pDesc.setLayout(new GridBagLayout());
        pDesc.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Description")));
        this.addItem(pDesc, this.trainDescription, 0, 0);
        p1.add(pName);
        p1.add(pDesc);
        JPanel p3 = new JPanel();
        p3.setLayout(new BoxLayout(p3, 1));
        JScrollPane pane3 = new JScrollPane(p3);
        pane3.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("RoadsTrain")));
        pane3.setMaximumSize(new Dimension(2000, 400));
        JPanel pRoadRadioButtons = new JPanel();
        pRoadRadioButtons.setLayout(new FlowLayout());
        pRoadRadioButtons.add(this.roadNameAll);
        pRoadRadioButtons.add(this.roadNameInclude);
        pRoadRadioButtons.add(this.roadNameExclude);
        this.pRoadControls.setLayout(new FlowLayout());
        this.pRoadControls.add(this.comboBoxRoads);
        this.pRoadControls.add(this.addRoadButton);
        this.pRoadControls.add(this.deleteRoadButton);
        this.pRoadControls.add(this.deleteAllRoadsButton);
        this.pRoadControls.setVisible(false);
        p3.add(pRoadRadioButtons);
        p3.add(this.pRoadControls);
        this.panelRoads.setLayout(new GridBagLayout());
        this.paneRoads.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Roads")));
        ButtonGroup roadGroup = new ButtonGroup();
        roadGroup.add(this.roadNameAll);
        roadGroup.add(this.roadNameInclude);
        roadGroup.add(this.roadNameExclude);
        JPanel panelButtons = new JPanel();
        panelButtons.setLayout(new GridBagLayout());
        panelButtons.setBorder(BorderFactory.createTitledBorder(""));
        panelButtons.setMaximumSize(new Dimension(2000, 200));
        this.addItem(panelButtons, this.saveTrainButton, 0, 0);
        this.getContentPane().add(p1);
        this.getContentPane().add(pane3);
        this.getContentPane().add(this.paneRoads);
        this.getContentPane().add(panelButtons);
        this.addButtonAction(this.saveTrainButton);
        this.addButtonAction(this.deleteRoadButton);
        this.addButtonAction(this.deleteAllRoadsButton);
        this.addButtonAction(this.addRoadButton);
        this.addRadioButtonAction(this.roadNameAll);
        this.addRadioButtonAction(this.roadNameInclude);
        this.addRadioButtonAction(this.roadNameExclude);
        if (this._train != null) {
            this.trainName.setText(this._train.getName());
            this.trainDescription.setText(this._train.getDescription());
            this.updateButtons(true);
            this._train.addPropertyChangeListener(this);
        } else {
            this.updateButtons(false);
        }
        this.addHelpMenu("package.jmri.jmrit.operations.Operations_TrainRoadOptions", true);
        this.updateRoadComboBoxes();
        this.updateRoadNames();
        InstanceManager.getDefault(CarTypes.class).addPropertyChangeListener(this);
        InstanceManager.getDefault(CarRoads.class).addPropertyChangeListener(this);
        this.initMinimumSize(new Dimension(500, 400));
    }

    @Override
    public void buttonActionPerformed(ActionEvent ae) {
        if (this._train != null) {
            String roadName;
            if (ae.getSource() == this.saveTrainButton) {
                log.debug("train save button activated");
                this.saveTrain();
            }
            if (ae.getSource() == this.addRoadButton) {
                roadName = (String)this.comboBoxRoads.getSelectedItem();
                if (this._train.addRoadName(roadName)) {
                    this.updateRoadNames();
                }
                this.selectNextItemComboBox(this.comboBoxRoads);
            }
            if (ae.getSource() == this.deleteRoadButton) {
                roadName = (String)this.comboBoxRoads.getSelectedItem();
                if (this._train.deleteRoadName(roadName)) {
                    this.updateRoadNames();
                }
                this.selectNextItemComboBox(this.comboBoxRoads);
            }
            if (ae.getSource() == this.deleteAllRoadsButton) {
                this.deleteAllRoads();
            }
        }
    }

    @Override
    public void radioButtonActionPerformed(ActionEvent ae) {
        log.debug("radio button activated");
        if (this._train != null) {
            if (ae.getSource() == this.roadNameAll) {
                this._train.setRoadOption(Train.ALL_LOADS);
                this.updateRoadNames();
            }
            if (ae.getSource() == this.roadNameInclude) {
                this._train.setRoadOption(Train.INCLUDE_LOADS);
                this.updateRoadNames();
            }
            if (ae.getSource() == this.roadNameExclude) {
                this._train.setRoadOption(Train.EXCLUDE_LOADS);
                this.updateRoadNames();
            }
        }
    }

    protected void updateButtons(boolean enabled) {
        this.saveTrainButton.setEnabled(enabled);
        this.roadNameAll.setEnabled(enabled);
        this.roadNameInclude.setEnabled(enabled);
        this.roadNameExclude.setEnabled(enabled);
    }

    private void updateRoadNames() {
        log.debug("Update road names");
        this.panelRoads.removeAll();
        if (this._train != null) {
            this.roadNameAll.setSelected(this._train.getRoadOption().equals(Train.ALL_LOADS));
            this.roadNameInclude.setSelected(this._train.getRoadOption().equals(Train.INCLUDE_ROADS));
            this.roadNameExclude.setSelected(this._train.getRoadOption().equals(Train.EXCLUDE_ROADS));
            this.pRoadControls.setVisible(!this.roadNameAll.isSelected());
            if (!this.roadNameAll.isSelected()) {
                int x = 0;
                int y = 0;
                String[] stringArray = this._train.getRoadNames();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String roadName = stringArray[n2];
                    JLabel road = new JLabel();
                    road.setText(roadName);
                    this.addItemTop(this.panelRoads, road, x++, y);
                    if (x > 6) {
                        ++y;
                        x = 0;
                    }
                    ++n2;
                }
                this.revalidate();
            }
        } else {
            this.roadNameAll.setSelected(true);
        }
        this.panelRoads.repaint();
        this.panelRoads.revalidate();
    }

    private void deleteAllRoads() {
        if (this._train != null) {
            String[] stringArray = this._train.getRoadNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String road = stringArray[n2];
                this._train.deleteRoadName(road);
                ++n2;
            }
        }
        this.updateRoadNames();
    }

    private void saveTrain() {
        OperationsXml.save();
        if (Setup.isCloseWindowOnSaveEnabled()) {
            this.dispose();
        }
    }

    private void updateRoadComboBoxes() {
        InstanceManager.getDefault(CarRoads.class).updateComboBox(this.comboBoxRoads);
    }

    @Override
    public void dispose() {
        InstanceManager.getDefault(CarTypes.class).removePropertyChangeListener(this);
        InstanceManager.getDefault(CarRoads.class).removePropertyChangeListener(this);
        if (this._train != null) {
            this._train.removePropertyChangeListener(this);
        }
        super.dispose();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("CarRoads Length")) {
            this.updateRoadComboBoxes();
            this.updateRoadNames();
        }
    }
}

