/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.trains;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import jmri.InstanceManager;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.operations.trains.Bundle;
import jmri.jmrit.operations.trains.TrainCommon;
import jmri.jmrit.operations.trains.TrainManagerXml;
import jmri.jmrit.operations.trains.TrainUtilities;
import jmri.util.davidflanagan.HardcopyWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrainPrintUtilities {
    static final String NEW_LINE = "\n";
    static final char HORIZONTAL_LINE_SEPARATOR = '-';
    static final char VERTICAL_LINE_SEPARATOR = '|';
    static final char SPACE = ' ';
    private static final Logger log = LoggerFactory.getLogger(TrainPrintUtilities.class);

    public static void printReport(File file, String name, boolean isPreview, String fontName, boolean isBuildReport, String logoURL, String printerName, String orientation, int fontSize, boolean printHeader) {
        HardcopyWriter writer = null;
        boolean isLandScape = false;
        double margin = 0.5;
        Dimension pagesize = null;
        if (orientation.equals(Setup.LANDSCAPE)) {
            margin = 0.65;
            isLandScape = true;
        }
        if (orientation.equals(Setup.HANDHELD) || orientation.equals(Setup.HALFPAGE)) {
            printHeader = false;
            pagesize = new Dimension(TrainCommon.getPageSize((String)orientation).width + TrainCommon.PAPER_MARGINS.width, TrainCommon.getPageSize((String)orientation).height + TrainCommon.PAPER_MARGINS.height);
        }
        try {
            writer = new HardcopyWriter(new Frame(), name, fontSize, margin, margin, 0.5, 0.5, isPreview, printerName, isLandScape, printHeader, pagesize);
        }
        catch (HardcopyWriter.PrintCanceledException printCanceledException) {
            log.debug("Print cancelled");
            return;
        }
        if (!fontName.isEmpty()) {
            writer.setFontName(fontName);
        }
        BufferedReader in = null;
        try {
            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));
        }
        catch (FileNotFoundException fileNotFoundException) {
            log.error("Build file doesn't exist");
            writer.close();
            return;
        }
        if (!isBuildReport && logoURL != null && !logoURL.equals("")) {
            ImageIcon icon = new ImageIcon(logoURL);
            if (icon.getIconWidth() == -1) {
                log.error("Logo not found: {}", (Object)logoURL);
            } else {
                writer.write(icon.getImage(), new JLabel(icon));
            }
        }
        Color c = null;
        boolean printingColor = false;
        while (true) {
            String line;
            try {
                line = in.readLine();
            }
            catch (IOException iOException) {
                log.debug("Print read failed");
                break;
            }
            if (line == null) {
                if (!isPreview) break;
                try {
                    writer.write(" ");
                }
                catch (IOException iOException) {
                    log.debug("Print write failed for null line");
                }
                break;
            }
            if (isBuildReport) {
                if ((line = TrainPrintUtilities.filterBuildReport(line, false)).isEmpty()) {
                    continue;
                }
            } else {
                if (line.length() > 0) {
                    boolean horizontialLineSeparatorFound = true;
                    int i = 0;
                    while (i < line.length()) {
                        if (line.charAt(i) != '-') {
                            horizontialLineSeparatorFound = false;
                            break;
                        }
                        ++i;
                    }
                    if (horizontialLineSeparatorFound) {
                        writer.write(writer.getCurrentLineNumber(), 0, writer.getCurrentLineNumber(), line.length() + 1);
                        c = null;
                        continue;
                    }
                }
                if (!Setup.getPickupEnginePrefix().trim().isEmpty() && line.startsWith(String.valueOf(Setup.getPickupEnginePrefix()) + " ") || !Setup.getPickupCarPrefix().trim().isEmpty() && line.startsWith(String.valueOf(Setup.getPickupCarPrefix()) + " ") || !Setup.getSwitchListPickupCarPrefix().trim().isEmpty() && line.startsWith(String.valueOf(Setup.getSwitchListPickupCarPrefix()) + " ")) {
                    c = Setup.getPickupColor();
                } else if (!Setup.getDropEnginePrefix().trim().isEmpty() && line.startsWith(String.valueOf(Setup.getDropEnginePrefix()) + " ") || !Setup.getDropCarPrefix().trim().isEmpty() && line.startsWith(String.valueOf(Setup.getDropCarPrefix()) + " ") || !Setup.getSwitchListDropCarPrefix().trim().isEmpty() && line.startsWith(String.valueOf(Setup.getSwitchListDropCarPrefix()) + " ")) {
                    c = Setup.getDropColor();
                } else if (!Setup.getLocalPrefix().trim().isEmpty() && line.startsWith(String.valueOf(Setup.getLocalPrefix()) + " ") || !Setup.getSwitchListLocalPrefix().trim().isEmpty() && line.startsWith(String.valueOf(Setup.getSwitchListLocalPrefix()) + " ")) {
                    c = Setup.getLocalColor();
                } else if (line.contains("<FONT color=\"")) {
                    c = TrainCommon.getTextColor(line);
                    if (!line.endsWith("</FONT>")) {
                        printingColor = true;
                    }
                    if (line.contains(Character.toString('|'))) {
                        String s = line.substring(0, line.indexOf(124));
                        s = TrainCommon.getTextColorString(s);
                        try {
                            writer.write(c, s);
                        }
                        catch (IOException iOException) {
                            log.debug("Print write color failed");
                            break;
                        }
                        line = line.substring(line.indexOf(124));
                        c = TrainCommon.getTextColor(line);
                        StringBuffer sb = new StringBuffer();
                        int i = 0;
                        while (i < s.length()) {
                            sb.append(' ');
                            ++i;
                        }
                        line = sb.append(TrainCommon.getTextColorString(line)).toString();
                    } else {
                        line = TrainCommon.getTextColorString(line);
                    }
                } else if (line.contains("</FONT>")) {
                    printingColor = false;
                    line = TrainCommon.getTextColorString(line);
                } else if (!line.startsWith("    ") && !printingColor) {
                    c = null;
                }
                int i = 0;
                while (i < line.length()) {
                    if (line.charAt(i) == '|') {
                        if (Setup.isTabEnabled()) {
                            writer.write(writer.getCurrentLineNumber(), 0, writer.getCurrentLineNumber() + 1, 0);
                            writer.write(writer.getCurrentLineNumber(), line.length() + 1, writer.getCurrentLineNumber() + 1, line.length() + 1);
                        }
                        writer.write(writer.getCurrentLineNumber(), i + 1, writer.getCurrentLineNumber() + 1, i + 1);
                    }
                    ++i;
                }
                line = line.replace('|', ' ');
                if (c != null) {
                    try {
                        writer.write(c, String.valueOf(line) + NEW_LINE);
                        continue;
                    }
                    catch (IOException iOException) {
                        log.debug("Print write color failed");
                        break;
                    }
                }
            }
            try {
                writer.write(String.valueOf(line) + NEW_LINE);
            }
            catch (IOException iOException) {
                log.debug("Print write failed");
                break;
            }
        }
        try {
            in.close();
        }
        catch (IOException iOException) {
            log.debug("Print close failed");
        }
        writer.close();
    }

    public static void editReport(File file, String name) {
        PrintWriter out;
        BufferedReader in = null;
        try {
            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));
        }
        catch (FileNotFoundException fileNotFoundException) {
            log.error("Build file doesn't exist");
            return;
        }
        File buildReport = InstanceManager.getDefault(TrainManagerXml.class).createTrainBuildReportFile(String.valueOf(Bundle.getMessage("Report")) + " " + name);
        try {
            out = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(buildReport), StandardCharsets.UTF_8)), true);
        }
        catch (IOException iOException) {
            log.error("Can not create build report file");
            try {
                in.close();
            }
            catch (IOException iOException2) {}
            return;
        }
        String line = " ";
        try {
            while ((line = in.readLine()) != null) {
                if ((line = TrainPrintUtilities.filterBuildReport(line, Setup.isBuildReportIndentEnabled())).isEmpty()) continue;
                out.println(line);
            }
        }
        catch (IOException iOException) {
            log.debug("Print read failed");
        }
        try {
            in.close();
        }
        catch (IOException iOException) {
            log.debug("Close failed");
        }
        out.close();
        TrainUtilities.openDesktop(buildReport);
    }

    private static String filterBuildReport(String line, boolean indent) {
        String[] inputLine = line.split("\\s+");
        if (inputLine.length == 0) {
            return "";
        }
        if (inputLine[0].equals("7-") || inputLine[0].equals("5-") || inputLine[0].equals("3-") || inputLine[0].equals("1-")) {
            if (Setup.getBuildReportLevel().equals("1") && (inputLine[0].equals("3-") || inputLine[0].equals("5-") || inputLine[0].equals("7-"))) {
                return "";
            }
            if (Setup.getBuildReportLevel().equals("3") && (inputLine[0].equals("5-") || inputLine[0].equals("7-"))) {
                return "";
            }
            if (Setup.getBuildReportLevel().equals("5") && inputLine[0].equals("7-")) {
                return "";
            }
            int start = 0;
            if (indent) {
                if (inputLine[0].equals("7-")) {
                    inputLine[0] = "   ";
                } else if (inputLine[0].equals("5-")) {
                    inputLine[0] = "  ";
                } else if (inputLine[0].equals("3-")) {
                    inputLine[0] = " ";
                } else if (inputLine[0].equals("1-")) {
                    inputLine[0] = "";
                }
            } else {
                start = 1;
            }
            StringBuffer buf = new StringBuffer();
            int i = start;
            while (i < inputLine.length) {
                buf.append(String.valueOf(inputLine[i]) + " ");
                ++i;
            }
            if (buf.length() == 0) {
                return " ";
            }
            return buf.toString();
        }
        log.debug("ERROR first characters of build report not valid ({})", (Object)line);
        return "ERROR " + line;
    }

    public static JComboBox<String> getPrinterJComboBox() {
        PrintService[] services;
        JComboBox<String> box = new JComboBox<String>();
        PrintService[] printServiceArray = services = PrintServiceLookup.lookupPrintServices(null, null);
        int n = services.length;
        int n2 = 0;
        while (n2 < n) {
            PrintService printService = printServiceArray[n2];
            box.addItem(printService.getName());
            ++n2;
        }
        box.setSelectedItem(TrainPrintUtilities.getDefaultPrinterName());
        return box;
    }

    public static String getDefaultPrinterName() {
        if (PrintServiceLookup.lookupDefaultPrintService() != null) {
            return PrintServiceLookup.lookupDefaultPrintService().getName();
        }
        return "";
    }
}

