/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.trains;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.List;
import jmri.InstanceManager;
import jmri.jmrit.operations.rollingstock.cars.Car;
import jmri.jmrit.operations.rollingstock.engines.Engine;
import jmri.jmrit.operations.routes.RouteLocation;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.operations.trains.Bundle;
import jmri.jmrit.operations.trains.Train;
import jmri.jmrit.operations.trains.TrainCommon;
import jmri.jmrit.operations.trains.TrainManagerXml;
import jmri.jmrit.operations.trains.TrainManifestText;
import jmri.jmrit.operations.trains.schedules.TrainSchedule;
import jmri.jmrit.operations.trains.schedules.TrainScheduleManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrainManifest
extends TrainCommon {
    private static final Logger log = LoggerFactory.getLogger(TrainManifest.class);
    String messageFormatText = "";

    public TrainManifest(Train train) {
        PrintWriter fileOut;
        File file = InstanceManager.getDefault(TrainManagerXml.class).createTrainManifestFile(train.getName());
        try {
            fileOut = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8)), true);
        }
        catch (IOException iOException) {
            log.error("Can not open train manifest file: {}", (Object)file.getName());
            return;
        }
        try {
            TrainSchedule sch;
            if (!train.getRailroadName().equals("")) {
                this.newLine(fileOut, train.getRailroadName());
            } else {
                this.newLine(fileOut, Setup.getRailroadName());
            }
            this.newLine(fileOut);
            this.messageFormatText = TrainManifestText.getStringManifestForTrain();
            this.newLine(fileOut, MessageFormat.format(this.messageFormatText, train.getName(), train.getDescription()));
            this.messageFormatText = TrainManifestText.getStringValid();
            String valid = MessageFormat.format(this.messageFormatText, TrainManifest.getDate(true));
            if (Setup.isPrintTrainScheduleNameEnabled() && (sch = InstanceManager.getDefault(TrainScheduleManager.class).getActiveSchedule()) != null) {
                valid = String.valueOf(valid) + " (" + sch.getName() + ")";
            }
            if (Setup.isPrintValidEnabled()) {
                this.newLine(fileOut, valid);
            }
            if (!train.getComment().equals("")) {
                this.newLine(fileOut, train.getComment());
            }
            List<Engine> engineList = this.engineManager.getByTrainBlockingList(train);
            if (Setup.isPrintRouteCommentsEnabled() && !train.getRoute().getComment().equals("")) {
                this.newLine(fileOut, train.getRoute().getComment());
            }
            List<Car> carList = this.carManager.getByTrainDestinationList(train);
            log.debug("Train has {} cars assigned to it", (Object)carList.size());
            boolean hadWork = false;
            boolean noWork = false;
            String previousRouteLocationName = null;
            List<RouteLocation> routeList = train.getRoute().getLocationsBySequenceList();
            for (RouteLocation rl : routeList) {
                boolean printHeader = false;
                boolean hasWork = this.isThereWorkAtLocation(carList, engineList, rl);
                String routeLocationName = TrainManifest.splitString(rl.getName());
                if ((!routeLocationName.equals(previousRouteLocationName) || hasWork && !hadWork) && hasWork) {
                    this.newLine(fileOut);
                    hadWork = true;
                    noWork = false;
                    printHeader = true;
                    String expectedArrivalTime = train.getExpectedArrivalTime(rl);
                    this.messageFormatText = TrainManifestText.getStringScheduledWork();
                    String workAt = MessageFormat.format(this.messageFormatText, routeLocationName, train.getName(), train.getDescription());
                    if (!train.isShowArrivalAndDepartureTimesEnabled()) {
                        this.newLine(fileOut, workAt);
                    } else if (rl == train.getTrainDepartsRouteLocation()) {
                        this.messageFormatText = TrainManifestText.getStringWorkDepartureTime();
                        this.newLine(fileOut, MessageFormat.format(this.messageFormatText, routeLocationName, train.getFormatedDepartureTime(), train.getName(), train.getDescription()));
                    } else if (!rl.getDepartureTime().equals("")) {
                        this.messageFormatText = TrainManifestText.getStringWorkDepartureTime();
                        this.newLine(fileOut, MessageFormat.format(this.messageFormatText, routeLocationName, rl.getFormatedDepartureTime(), train.getName(), train.getDescription()));
                    } else if (Setup.isUseDepartureTimeEnabled() && rl != train.getTrainTerminatesRouteLocation()) {
                        this.messageFormatText = TrainManifestText.getStringWorkDepartureTime();
                        this.newLine(fileOut, MessageFormat.format(this.messageFormatText, routeLocationName, train.getExpectedDepartureTime(rl), train.getName(), train.getDescription()));
                    } else if (!expectedArrivalTime.equals("-1")) {
                        this.messageFormatText = TrainManifestText.getStringWorkArrivalTime();
                        this.newLine(fileOut, MessageFormat.format(this.messageFormatText, routeLocationName, expectedArrivalTime, train.getName(), train.getDescription()));
                    } else {
                        this.newLine(fileOut, workAt);
                    }
                    if (!rl.getComment().trim().equals("")) {
                        this.newLine(fileOut, rl.getFormatedColorComment());
                    }
                    if (Setup.isPrintLocationCommentsEnabled() && !rl.getLocation().getComment().equals("")) {
                        this.newLine(fileOut, rl.getLocation().getComment());
                    }
                }
                previousRouteLocationName = routeLocationName;
                this.printTrackComments(fileOut, rl, carList, true);
                if (train.getSecondLegOptions() != 0) {
                    if (rl == train.getSecondLegStartRouteLocation()) {
                        this.printChange(fileOut, rl, train, train.getSecondLegOptions());
                    }
                    if (rl == train.getSecondLegEndRouteLocation() && train.getSecondLegOptions() == 2) {
                        this.messageFormatText = TrainManifestText.getStringRemoveHelpers();
                        this.newLine(fileOut, MessageFormat.format(this.messageFormatText, TrainManifest.splitString(rl.getName()), train.getName(), train.getDescription(), train.getSecondLegNumberEngines(), train.getSecondLegEngineModel(), train.getSecondLegEngineRoad()));
                    }
                }
                if (train.getThirdLegOptions() != 0) {
                    if (rl == train.getThirdLegStartRouteLocation()) {
                        this.printChange(fileOut, rl, train, train.getThirdLegOptions());
                    }
                    if (rl == train.getThirdLegEndRouteLocation() && train.getThirdLegOptions() == 2) {
                        this.messageFormatText = TrainManifestText.getStringRemoveHelpers();
                        this.newLine(fileOut, MessageFormat.format(this.messageFormatText, TrainManifest.splitString(rl.getName()), train.getName(), train.getDescription(), train.getThirdLegNumberEngines(), train.getThirdLegEngineModel(), train.getThirdLegEngineRoad()));
                    }
                }
                if (Setup.getManifestFormat().equals(Setup.STANDARD_FORMAT)) {
                    this.pickupEngines(fileOut, engineList, rl, true);
                    if (train.isLocalSwitcher()) {
                        this.blockCarsByTrack(fileOut, train, carList, rl, printHeader, true);
                        this.dropEngines(fileOut, engineList, rl, true);
                    } else {
                        this.dropEngines(fileOut, engineList, rl, true);
                        this.blockCarsByTrack(fileOut, train, carList, rl, printHeader, true);
                    }
                } else if (Setup.getManifestFormat().equals(Setup.TWO_COLUMN_FORMAT)) {
                    this.blockLocosTwoColumn(fileOut, engineList, rl, true);
                    this.blockCarsTwoColumn(fileOut, train, carList, rl, printHeader, true);
                } else {
                    this.blockLocosTwoColumn(fileOut, engineList, rl, true);
                    this.blockCarsByTrackNameTwoColumn(fileOut, train, carList, rl, printHeader, true);
                }
                if (rl != train.getTrainTerminatesRouteLocation()) {
                    RouteLocation rlNext = train.getRoute().getNextRouteLocation(rl);
                    if (routeLocationName.equals(TrainManifest.splitString(rlNext.getName()))) continue;
                    if (hadWork) {
                        hadWork = false;
                        if (Setup.isPrintHeadersEnabled() || !Setup.getManifestFormat().equals(Setup.STANDARD_FORMAT)) {
                            this.printHorizontalLine(fileOut, true);
                        }
                        String trainDeparts = "";
                        if (Setup.isPrintLoadsAndEmptiesEnabled()) {
                            int emptyCars = train.getNumberEmptyCarsInTrain(rl);
                            this.messageFormatText = TrainManifestText.getStringTrainDepartsLoads();
                            trainDeparts = MessageFormat.format(this.messageFormatText, routeLocationName, rl.getTrainDirectionString(), train.getNumberCarsInTrain(rl) - emptyCars, emptyCars, train.getTrainLength(rl), Setup.getLengthUnit().toLowerCase(), train.getTrainWeight(rl), train.getTrainTerminatesName(), train.getName());
                        } else {
                            this.messageFormatText = TrainManifestText.getStringTrainDepartsCars();
                            trainDeparts = MessageFormat.format(this.messageFormatText, routeLocationName, rl.getTrainDirectionString(), train.getNumberCarsInTrain(rl), train.getTrainLength(rl), Setup.getLengthUnit().toLowerCase(), train.getTrainWeight(rl), train.getTrainTerminatesName(), train.getName());
                        }
                        this.newLine(fileOut, trainDeparts);
                        continue;
                    }
                    if (!noWork) {
                        this.newLine(fileOut);
                    }
                    noWork = true;
                    this.messageFormatText = TrainManifestText.getStringNoScheduledWork();
                    String s = MessageFormat.format(this.messageFormatText, routeLocationName, train.getName(), train.getDescription());
                    if (!rl.getComment().equals("")) {
                        s = routeLocationName;
                        if (rl.getComment().trim().length() > 0) {
                            this.messageFormatText = TrainManifestText.getStringNoScheduledWorkWithRouteComment();
                            s = MessageFormat.format(this.messageFormatText, routeLocationName, rl.getFormatedColorComment(), train.getName(), train.getDescription());
                        }
                    }
                    if (train.isShowArrivalAndDepartureTimesEnabled()) {
                        if (rl == train.getTrainDepartsRouteLocation()) {
                            this.messageFormatText = TrainManifestText.getStringDepartTime();
                            s = String.valueOf(s) + MessageFormat.format(this.messageFormatText, train.getFormatedDepartureTime());
                        } else if (!rl.getDepartureTime().equals("")) {
                            this.messageFormatText = TrainManifestText.getStringDepartTime();
                            s = String.valueOf(s) + MessageFormat.format(this.messageFormatText, rl.getFormatedDepartureTime());
                        } else if (Setup.isUseDepartureTimeEnabled() && !rl.getComment().equals("")) {
                            this.messageFormatText = TrainManifestText.getStringDepartTime();
                            s = String.valueOf(s) + MessageFormat.format(this.messageFormatText, train.getExpectedDepartureTime(rl));
                        }
                    }
                    this.newLine(fileOut, s);
                    if (!Setup.isPrintLocationCommentsEnabled() || rl.getLocation().getComment().equals("")) continue;
                    this.newLine(fileOut, rl.getLocation().getComment());
                    continue;
                }
                if (!hadWork) {
                    this.newLine(fileOut);
                } else if (Setup.isPrintHeadersEnabled() || !Setup.getManifestFormat().equals(Setup.STANDARD_FORMAT)) {
                    this.printHorizontalLine(fileOut, true);
                }
                this.messageFormatText = TrainManifestText.getStringTrainTerminates();
                this.newLine(fileOut, MessageFormat.format(this.messageFormatText, routeLocationName, train.getName(), train.getDescription()));
            }
            this.addCarsLocationUnknown(fileOut, true);
        }
        catch (IllegalArgumentException e) {
            this.newLine(fileOut, MessageFormat.format(Bundle.getMessage("ErrorIllegalArgument"), Bundle.getMessage("TitleManifestText"), e.getLocalizedMessage()));
            this.newLine(fileOut, this.messageFormatText);
            log.error("Illegal argument", (Throwable)e);
        }
        fileOut.flush();
        fileOut.close();
        train.setModified(false);
    }

    private void printChange(PrintWriter fileOut, RouteLocation rl, Train train, int legOptions) throws IllegalArgumentException {
        if ((legOptions & 2) == 2) {
            String numberEngines = train.getSecondLegNumberEngines();
            String endLocationName = train.getSecondLegEndLocationName();
            String engineModel = train.getSecondLegEngineModel();
            String engineRoad = train.getSecondLegEngineRoad();
            if (rl == train.getThirdLegStartRouteLocation()) {
                numberEngines = train.getThirdLegNumberEngines();
                endLocationName = train.getThirdLegEndLocationName();
                engineModel = train.getThirdLegEngineModel();
                engineRoad = train.getThirdLegEngineRoad();
            }
            this.messageFormatText = TrainManifestText.getStringAddHelpers();
            this.newLine(fileOut, MessageFormat.format(this.messageFormatText, TrainManifest.splitString(rl.getName()), train.getName(), train.getDescription(), numberEngines, endLocationName, engineModel, engineRoad));
        } else if ((legOptions & 1) == 1 && ((legOptions & 8) == 8 || (legOptions & 4) == 4)) {
            this.messageFormatText = TrainManifestText.getStringLocoAndCabooseChange();
            this.newLine(fileOut, MessageFormat.format(this.messageFormatText, TrainManifest.splitString(rl.getName()), train.getName(), train.getDescription()));
        } else if ((legOptions & 1) == 1) {
            this.messageFormatText = TrainManifestText.getStringLocoChange();
            this.newLine(fileOut, MessageFormat.format(this.messageFormatText, TrainManifest.splitString(rl.getName()), train.getName(), train.getDescription()));
        } else if ((legOptions & 8) == 8 || (legOptions & 4) == 4) {
            this.messageFormatText = TrainManifestText.getStringCabooseChange();
            this.newLine(fileOut, MessageFormat.format(this.messageFormatText, TrainManifest.splitString(rl.getName()), train.getName(), train.getDescription()));
        }
    }

    private void newLine(PrintWriter file, String string) {
        if (!string.isEmpty()) {
            this.newLine(file, string, true);
        }
    }
}

