/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.trains;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import jmri.InstanceManager;
import jmri.InstanceManagerAutoDefault;
import jmri.InstanceManagerAutoInitialize;
import jmri.jmrit.operations.OperationsManager;
import jmri.jmrit.operations.OperationsXml;
import jmri.jmrit.operations.automation.AutomationManager;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.operations.trains.Bundle;
import jmri.jmrit.operations.trains.Train;
import jmri.jmrit.operations.trains.TrainLogger;
import jmri.jmrit.operations.trains.TrainManager;
import jmri.jmrit.operations.trains.schedules.TrainScheduleManager;
import jmri.util.FileUtil;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.ProcessingInstruction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrainManagerXml
extends OperationsXml
implements InstanceManagerAutoDefault,
InstanceManagerAutoInitialize {
    private boolean fileLoaded = false;
    private String operationsFileName = "OperationsTrainRoster.xml";
    private static final String BUILD_REPORT_FILE_NAME = String.valueOf(Bundle.getMessage("train")) + " (";
    private static final String MANIFEST_FILE_NAME = String.valueOf(Bundle.getMessage("train")) + " (";
    private static final String SWITCH_LIST_FILE_NAME = String.valueOf(Bundle.getMessage("location")) + " (";
    private static final String BACKUP_BUILD_REPORT_FILE_NAME = String.valueOf(Bundle.getMessage("Report")) + " " + Bundle.getMessage("train") + " (";
    private static final String FILE_TYPE_TXT = ").txt";
    private static final String FILE_TYPE_CSV = ").csv";
    static final String BUILD_STATUS = "buildstatus";
    static final String MANIFESTS = "manifests";
    static final String SWITCH_LISTS = "switchLists";
    public static final String CSV_MANIFESTS = "csvManifests";
    public static final String CSV_SWITCH_LISTS = "csvSwitchLists";
    static final String JSON_MANIFESTS = "jsonManifests";
    static final String MANIFESTS_BACKUPS = "manifestsBackups";
    static final String SWITCH_LISTS_BACKUPS = "switchListsBackups";
    static final String BUILD_STATUS_BACKUPS = "buildStatusBackups";
    private static final Logger log = LoggerFactory.getLogger(TrainManagerXml.class);

    @Override
    public void writeFile(String name) throws FileNotFoundException, IOException {
        log.debug("writeFile {}", (Object)name);
        File file = this.findFile(name);
        if (file == null) {
            file = new File(name);
        }
        Element root = new Element("operations-config");
        Document doc = TrainManagerXml.newDocument(root, String.valueOf(this.dtdLocation) + "operations-trains.dtd");
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("type", "text/xsl");
        m.put("href", "/xml/XSLT/operations-trains.xsl");
        ProcessingInstruction p = new ProcessingInstruction("xml-stylesheet", m);
        doc.addContent(0, (Content)p);
        InstanceManager.getDefault(TrainManager.class).store(root);
        InstanceManager.getDefault(TrainScheduleManager.class).store(root);
        InstanceManager.getDefault(AutomationManager.class).store(root);
        this.writeXML(file, doc);
        this.setDirty(false);
    }

    @Override
    public void readFile(String name) throws JDOMException, IOException {
        if (this.findFile(name) == null) {
            log.debug("{} file could not be found", (Object)name);
            this.fileLoaded = true;
            return;
        }
        Element root = this.rootFromName(name);
        if (root == null) {
            log.debug("{} file could not be read", (Object)name);
            return;
        }
        InstanceManager.getDefault(TrainManager.class).load(root);
        InstanceManager.getDefault(TrainScheduleManager.class).load(root);
        this.fileLoaded = true;
        InstanceManager.getDefault(AutomationManager.class).load(root);
        InstanceManager.getDefault(TrainManager.class).loadTrainIcons();
        InstanceManager.getDefault(TrainManager.class).runStartUpScripts();
        log.debug("Trains have been loaded!");
        InstanceManager.getDefault(TrainLogger.class).enableTrainLogging(Setup.isTrainLoggerEnabled());
        for (Train train : InstanceManager.getDefault(TrainManager.class).getTrainsByIdList()) {
            if (train.getStatusCode() != 1) continue;
            log.warn("Reseting train {}, was building when saved", (Object)train.getName());
            train.reset();
        }
        this.setDirty(false);
    }

    public boolean isTrainFileLoaded() {
        return this.fileLoaded;
    }

    public File createTrainBuildReportFile(String name) {
        return this.createFile(this.defaultBuildReportFileName(name), false);
    }

    public File getTrainBuildReportFile(String name) {
        File file = new File(this.defaultBuildReportFileName(name));
        return file;
    }

    public String defaultBuildReportFileName(String name) {
        return String.valueOf(OperationsXml.getFileLocation()) + OperationsXml.getOperationsDirectoryName() + File.separator + BUILD_STATUS + File.separator + BUILD_REPORT_FILE_NAME + name + FILE_TYPE_TXT;
    }

    public File createTrainManifestFile(String name) {
        this.savePreviousManifestFile(name);
        return this.createFile(this.getDefaultManifestFileName(name), false);
    }

    public File getTrainManifestFile(String name) {
        File file = new File(this.getDefaultManifestFileName(name));
        return file;
    }

    public String getDefaultManifestFileName(String name) {
        return String.valueOf(OperationsXml.getFileLocation()) + OperationsXml.getOperationsDirectoryName() + File.separator + MANIFESTS + File.separator + MANIFEST_FILE_NAME + name + FILE_TYPE_TXT;
    }

    public String getBackupManifestFileName(String name, String lastModified) {
        return String.valueOf(this.getBackupManifestDirectoryName()) + name + File.separator + MANIFEST_FILE_NAME + name + ") " + lastModified + ".txt";
    }

    public String getBackupManifestDirectoryName() {
        return String.valueOf(OperationsXml.getFileLocation()) + OperationsXml.getOperationsDirectoryName() + File.separator + MANIFESTS_BACKUPS + File.separator;
    }

    public String getBackupManifestDirectoryName(String name) {
        return String.valueOf(this.getBackupManifestDirectoryName()) + File.separator + name + File.separator;
    }

    public String getBackupSwitchListFileName(String name, String lastModified) {
        return String.valueOf(this.getBackupSwitchListDirectoryName()) + name + File.separator + SWITCH_LIST_FILE_NAME + name + ") " + lastModified + ".txt";
    }

    public String getBackupSwitchListDirectoryName() {
        return String.valueOf(OperationsXml.getFileLocation()) + OperationsXml.getOperationsDirectoryName() + File.separator + SWITCH_LISTS_BACKUPS + File.separator;
    }

    public String getBackupSwitchListDirectoryName(String name) {
        return String.valueOf(this.getBackupSwitchListDirectoryName()) + File.separator + name + File.separator;
    }

    public String getBackupBuildStatusFileName(String name, String lastModified) {
        return String.valueOf(this.getBackupBuildStatusDirectoryName()) + name + File.separator + BACKUP_BUILD_REPORT_FILE_NAME + name + ") " + lastModified + ".txt";
    }

    public String getBackupBuildStatusDirectoryName() {
        return String.valueOf(OperationsXml.getFileLocation()) + OperationsXml.getOperationsDirectoryName() + File.separator + BUILD_STATUS_BACKUPS + File.separator;
    }

    public String getBackupBuildStatusDirectoryName(String name) {
        return String.valueOf(this.getBackupBuildStatusDirectoryName()) + File.separator + name + File.separator;
    }

    public File createTrainCsvManifestFile(String name) {
        return this.createFile(this.getDefaultCsvManifestFileName(name), false);
    }

    public File getTrainCsvManifestFile(String name) {
        File file = new File(this.getDefaultCsvManifestFileName(name));
        return file;
    }

    public String getDefaultCsvManifestFileName(String name) {
        return String.valueOf(this.getDefaultCsvManifestDirectory()) + MANIFEST_FILE_NAME + name + FILE_TYPE_CSV;
    }

    private String getDefaultCsvManifestDirectory() {
        return String.valueOf(OperationsXml.getFileLocation()) + OperationsXml.getOperationsDirectoryName() + File.separator + CSV_MANIFESTS + File.separator;
    }

    public void createDefaultCsvManifestDirectory() {
        FileUtil.createDirectory(this.getDefaultCsvManifestDirectory());
    }

    public File createManifestFile(String name, String ext) {
        return this.createFile(this.getDefaultManifestFileName(name, ext), false);
    }

    public File getManifestFile(String name, String ext) {
        return new File(this.getDefaultManifestFileName(name, ext));
    }

    private String getDefaultManifestFileName(String name, String ext) {
        return String.valueOf(InstanceManager.getDefault(OperationsManager.class).getPath(JSON_MANIFESTS)) + File.separator + "train-" + name + "." + ext;
    }

    public File createSwitchListFile(String name) {
        this.savePreviousSwitchListFile(name);
        return this.createFile(this.getDefaultSwitchListName(name), false);
    }

    public File getSwitchListFile(String name) {
        File file = new File(this.getDefaultSwitchListName(name));
        return file;
    }

    public String getDefaultSwitchListName(String name) {
        return String.valueOf(OperationsXml.getFileLocation()) + OperationsXml.getOperationsDirectoryName() + File.separator + SWITCH_LISTS + File.separator + SWITCH_LIST_FILE_NAME + name + FILE_TYPE_TXT;
    }

    public File createCsvSwitchListFile(String name) {
        return this.createFile(this.getDefaultCsvSwitchListFileName(name), true);
    }

    public File getCsvSwitchListFile(String name) {
        File file = new File(this.getDefaultCsvSwitchListFileName(name));
        return file;
    }

    public String getDefaultCsvSwitchListFileName(String name) {
        return String.valueOf(this.getDefaultCsvSwitchListDirectoryName()) + SWITCH_LIST_FILE_NAME + name + FILE_TYPE_CSV;
    }

    public String getDefaultCsvSwitchListDirectoryName() {
        return String.valueOf(OperationsXml.getFileLocation()) + OperationsXml.getOperationsDirectoryName() + File.separator + CSV_SWITCH_LISTS + File.separator;
    }

    public void createDefaultCsvSwitchListDirectory() {
        FileUtil.createDirectory(this.getDefaultCsvSwitchListDirectoryName());
    }

    @Override
    public void setOperationsFileName(String name) {
        this.operationsFileName = name;
    }

    @Override
    public String getOperationsFileName() {
        return this.operationsFileName;
    }

    private void savePreviousManifestFile(String name) {
        if (Setup.isSaveTrainManifestsEnabled()) {
            this.createFile(String.valueOf(this.getBackupManifestDirectoryName()) + " ", false);
            this.createFile(String.valueOf(this.getBackupManifestDirectoryName(name)) + " ", false);
            File file = this.findFile(this.getDefaultManifestFileName(name));
            if (file == null) {
                log.debug("No ({}) manifest file to backup", (Object)name);
            } else if (file.canWrite()) {
                String lastModified = new SimpleDateFormat("yyyyMMdd-HHmmss").format(file.lastModified());
                String backupName = this.getBackupManifestFileName(name, lastModified);
                if (file.renameTo(new File(backupName))) {
                    log.debug("created new manifest backup file {}", (Object)backupName);
                } else {
                    log.error("could not create manifest backup file {}", (Object)backupName);
                }
            }
        }
    }

    private void savePreviousSwitchListFile(String name) {
        if (Setup.isSaveTrainManifestsEnabled()) {
            this.createFile(String.valueOf(this.getBackupSwitchListDirectoryName()) + " ", false);
            this.createFile(String.valueOf(this.getBackupSwitchListDirectoryName(name)) + " ", false);
            File file = this.findFile(this.getDefaultSwitchListName(name));
            if (file == null) {
                log.debug("No ({}) switch list file to backup", (Object)name);
            } else if (file.canRead()) {
                String lastModified = new SimpleDateFormat("yyyyMMdd-HHmmss").format(file.lastModified());
                String backupName = this.getBackupSwitchListFileName(name, lastModified);
                File backupCopy = new File(backupName);
                try {
                    FileUtil.copy(file, backupCopy);
                    log.debug("created new switch list backup file {}", (Object)backupName);
                }
                catch (Exception exception) {
                    log.error("could not create switch list backup file {}", (Object)backupName);
                }
            }
        }
    }

    public void savePreviousBuildStatusFile(String name) {
        if (Setup.isSaveTrainManifestsEnabled()) {
            this.createFile(String.valueOf(this.getBackupBuildStatusDirectoryName()) + " ", false);
            this.createFile(String.valueOf(this.getBackupBuildStatusDirectoryName(name)) + " ", false);
            File file = this.findFile(this.defaultBuildReportFileName(name));
            if (file == null) {
                log.debug("No ({}) train build status file to backup", (Object)name);
            } else if (file.canRead()) {
                String lastModified = new SimpleDateFormat("yyyyMMdd-HHmmss").format(file.lastModified());
                String backupName = this.getBackupBuildStatusFileName(name, lastModified);
                File backupCopy = new File(backupName);
                try {
                    FileUtil.copy(file, backupCopy);
                    log.debug("created new train build status backup file {}", (Object)backupName);
                }
                catch (Exception exception) {
                    log.error("could not create train build status backup file {}", (Object)backupName);
                }
            }
        }
    }

    public void dispose() {
    }

    @Override
    public void initialize() {
        this.load();
    }
}

