/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.trains;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import jmri.InstanceManager;
import jmri.jmrit.operations.OperationsFrame;
import jmri.jmrit.operations.OperationsXml;
import jmri.jmrit.operations.rollingstock.cars.CarLoads;
import jmri.jmrit.operations.rollingstock.cars.CarTypes;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.operations.trains.Bundle;
import jmri.jmrit.operations.trains.Train;
import jmri.jmrit.operations.trains.TrainEditFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrainLoadOptionsFrame
extends OperationsFrame
implements PropertyChangeListener {
    private static boolean loadAndType = false;
    Train _train = null;
    JPanel pLoadControls = new JPanel();
    JPanel panelLoads = new JPanel();
    JScrollPane paneLoads = new JScrollPane(this.panelLoads);
    JLabel trainName = new JLabel();
    JLabel trainDescription = new JLabel();
    JButton addLoadButton = new JButton(Bundle.getMessage("AddLoad"));
    JButton deleteLoadButton = new JButton(Bundle.getMessage("DeleteLoad"));
    JButton deleteAllLoadsButton = new JButton(Bundle.getMessage("DeleteAll"));
    JButton saveTrainButton = new JButton(Bundle.getMessage("SaveTrain"));
    JRadioButton loadNameAll = new JRadioButton(Bundle.getMessage("AcceptAll"));
    JRadioButton loadNameInclude = new JRadioButton(Bundle.getMessage("AcceptOnly"));
    JRadioButton loadNameExclude = new JRadioButton(Bundle.getMessage("Exclude"));
    ButtonGroup loadGroup = new ButtonGroup();
    JCheckBox loadAndTypeCheckBox = new JCheckBox(Bundle.getMessage("TypeAndLoad"));
    JComboBox<String> comboBoxTypes = InstanceManager.getDefault(CarTypes.class).getComboBox();
    JComboBox<String> comboBoxLoads = InstanceManager.getDefault(CarLoads.class).getComboBox(null);
    public static final String DISPOSE = "dispose";
    private static final Logger log = LoggerFactory.getLogger(TrainLoadOptionsFrame.class);

    public TrainLoadOptionsFrame() {
        super(Bundle.getMessage("MenuItemLoadOptions"));
    }

    public void initComponents(TrainEditFrame parent) {
        parent.setChildFrame(this);
        this._train = parent._train;
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel p1 = new JPanel();
        p1.setLayout(new BoxLayout(p1, 0));
        p1.setMaximumSize(new Dimension(2000, 250));
        JPanel pName = new JPanel();
        pName.setLayout(new GridBagLayout());
        pName.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Name")));
        this.addItem(pName, this.trainName, 0, 0);
        JPanel pDesc = new JPanel();
        pDesc.setLayout(new GridBagLayout());
        pDesc.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Description")));
        this.addItem(pDesc, this.trainDescription, 0, 0);
        p1.add(pName);
        p1.add(pDesc);
        JPanel p3 = new JPanel();
        p3.setLayout(new BoxLayout(p3, 1));
        JScrollPane pane3 = new JScrollPane(p3);
        pane3.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("LoadsTrain")));
        pane3.setMaximumSize(new Dimension(2000, 400));
        JPanel pLoadRadioButtons = new JPanel();
        pLoadRadioButtons.setLayout(new FlowLayout());
        pLoadRadioButtons.add(this.loadNameAll);
        pLoadRadioButtons.add(this.loadNameInclude);
        pLoadRadioButtons.add(this.loadNameExclude);
        pLoadRadioButtons.add(this.loadAndTypeCheckBox);
        this.pLoadControls.setLayout(new FlowLayout());
        this.pLoadControls.add(this.comboBoxTypes);
        this.pLoadControls.add(this.comboBoxLoads);
        this.pLoadControls.add(this.addLoadButton);
        this.pLoadControls.add(this.deleteLoadButton);
        this.pLoadControls.add(this.deleteAllLoadsButton);
        this.pLoadControls.setVisible(false);
        p3.add(pLoadRadioButtons);
        p3.add(this.pLoadControls);
        this.panelLoads.setLayout(new GridBagLayout());
        this.paneLoads.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Loads")));
        ButtonGroup loadGroup = new ButtonGroup();
        loadGroup.add(this.loadNameAll);
        loadGroup.add(this.loadNameInclude);
        loadGroup.add(this.loadNameExclude);
        JPanel panelButtons = new JPanel();
        panelButtons.setLayout(new GridBagLayout());
        panelButtons.setBorder(BorderFactory.createTitledBorder(""));
        panelButtons.setMaximumSize(new Dimension(2000, 200));
        this.addItem(panelButtons, this.saveTrainButton, 0, 0);
        this.getContentPane().add(p1);
        this.getContentPane().add(pane3);
        this.getContentPane().add(this.paneLoads);
        this.getContentPane().add(panelButtons);
        this.addButtonAction(this.saveTrainButton);
        this.addButtonAction(this.deleteLoadButton);
        this.addButtonAction(this.deleteAllLoadsButton);
        this.addButtonAction(this.addLoadButton);
        this.addRadioButtonAction(this.loadNameAll);
        this.addRadioButtonAction(this.loadNameInclude);
        this.addRadioButtonAction(this.loadNameExclude);
        this.addComboBoxAction(this.comboBoxTypes);
        if (this._train != null) {
            this.trainName.setText(this._train.getName());
            this.trainDescription.setText(this._train.getDescription());
            this.updateButtons(true);
            this._train.addPropertyChangeListener(this);
        } else {
            this.updateButtons(false);
        }
        this.addHelpMenu("package.jmri.jmrit.operations.Operations_TrainLoadOptions", true);
        this.updateTypeComboBoxes();
        this.updateLoadComboBoxes();
        this.updateLoadNames();
        InstanceManager.getDefault(CarTypes.class).addPropertyChangeListener(this);
        InstanceManager.getDefault(CarLoads.class).addPropertyChangeListener(this);
        this.loadAndTypeCheckBox.setSelected(loadAndType);
        this.initMinimumSize(new Dimension(600, 400));
    }

    @Override
    public void buttonActionPerformed(ActionEvent ae) {
        if (this._train != null) {
            String loadName;
            if (ae.getSource() == this.saveTrainButton) {
                log.debug("train save button activated");
                this.saveTrain();
            }
            if (ae.getSource() == this.addLoadButton) {
                loadName = (String)this.comboBoxLoads.getSelectedItem();
                if (this.loadAndTypeCheckBox.isSelected()) {
                    loadName = this.comboBoxTypes.getSelectedItem() + " & " + loadName;
                }
                if (this._train.addLoadName(loadName)) {
                    this.updateLoadNames();
                }
                this.selectNextItemComboBox(this.comboBoxLoads);
            }
            if (ae.getSource() == this.deleteLoadButton) {
                loadName = (String)this.comboBoxLoads.getSelectedItem();
                if (this.loadAndTypeCheckBox.isSelected()) {
                    loadName = this.comboBoxTypes.getSelectedItem() + " & " + loadName;
                }
                if (this._train.deleteLoadName(loadName)) {
                    this.updateLoadNames();
                }
                this.selectNextItemComboBox(this.comboBoxLoads);
            }
            if (ae.getSource() == this.deleteAllLoadsButton) {
                this.deleteAllLoads();
            }
        }
    }

    @Override
    public void radioButtonActionPerformed(ActionEvent ae) {
        log.debug("radio button activated");
        if (this._train != null) {
            if (ae.getSource() == this.loadNameAll) {
                this._train.setLoadOption(Train.ALL_LOADS);
                this.updateLoadNames();
            }
            if (ae.getSource() == this.loadNameInclude) {
                this._train.setLoadOption(Train.INCLUDE_LOADS);
                this.updateLoadNames();
            }
            if (ae.getSource() == this.loadNameExclude) {
                this._train.setLoadOption(Train.EXCLUDE_LOADS);
                this.updateLoadNames();
            }
        }
    }

    @Override
    public void comboBoxActionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.comboBoxTypes) {
            this.updateLoadComboBoxes();
        }
    }

    protected void updateButtons(boolean enabled) {
        this.saveTrainButton.setEnabled(enabled);
        this.loadNameAll.setEnabled(enabled);
        this.loadNameInclude.setEnabled(enabled);
        this.loadNameExclude.setEnabled(enabled);
        this.loadAndTypeCheckBox.setEnabled(enabled);
    }

    private void updateLoadNames() {
        log.debug("Update load names");
        this.panelLoads.removeAll();
        if (this._train != null) {
            this.loadNameAll.setSelected(this._train.getLoadOption().equals(Train.ALL_LOADS));
            this.loadNameInclude.setSelected(this._train.getLoadOption().equals(Train.INCLUDE_ROADS));
            this.loadNameExclude.setSelected(this._train.getLoadOption().equals(Train.EXCLUDE_ROADS));
            this.pLoadControls.setVisible(!this.loadNameAll.isSelected());
            if (!this.loadNameAll.isSelected()) {
                int x = 0;
                int y = 0;
                int numberOfLoads = this.getNumberOfCheckboxesPerLine() / 2 + 1;
                String[] stringArray = this._train.getLoadNames();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String loadName = stringArray[n2];
                    JLabel load = new JLabel();
                    load.setText(loadName);
                    this.addItemTop(this.panelLoads, load, x++, y);
                    if (x > numberOfLoads) {
                        ++y;
                        x = 0;
                    }
                    ++n2;
                }
                this.revalidate();
            }
        } else {
            this.loadNameAll.setSelected(true);
        }
        this.panelLoads.repaint();
        this.panelLoads.revalidate();
    }

    private void deleteAllLoads() {
        if (this._train != null) {
            String[] stringArray = this._train.getLoadNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String load = stringArray[n2];
                this._train.deleteLoadName(load);
                ++n2;
            }
        }
        this.updateLoadNames();
    }

    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}, justification="GUI ease of use")
    private void saveTrain() {
        loadAndType = this.loadAndTypeCheckBox.isSelected();
        OperationsXml.save();
        if (Setup.isCloseWindowOnSaveEnabled()) {
            this.dispose();
        }
    }

    private void updateTypeComboBoxes() {
        InstanceManager.getDefault(CarTypes.class).updateComboBox(this.comboBoxTypes);
        int i = this.comboBoxTypes.getItemCount() - 1;
        while (i >= 0) {
            String type = this.comboBoxTypes.getItemAt(i);
            if (this._train != null && !this._train.isTypeNameAccepted(type)) {
                this.comboBoxTypes.removeItem(type);
            }
            --i;
        }
    }

    private void updateLoadComboBoxes() {
        String carType = (String)this.comboBoxTypes.getSelectedItem();
        InstanceManager.getDefault(CarLoads.class).updateComboBox(carType, this.comboBoxLoads);
    }

    @Override
    public void dispose() {
        InstanceManager.getDefault(CarTypes.class).removePropertyChangeListener(this);
        InstanceManager.getDefault(CarLoads.class).removePropertyChangeListener(this);
        if (this._train != null) {
            this._train.removePropertyChangeListener(this);
        }
        super.dispose();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("CarLoads_Name") || e.getPropertyName().equals("CarLoads_Load")) {
            this.updateLoadComboBoxes();
            this.updateLoadNames();
        }
        if (e.getPropertyName().equals("CarTypes Length") || e.getPropertyName().equals("TrainTypes")) {
            this.updateTypeComboBoxes();
        }
    }
}

