/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.trains;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import jmri.InstanceManager;
import jmri.jmrit.display.Editor;
import jmri.jmrit.display.LocoIcon;
import jmri.jmrit.operations.rollingstock.cars.Car;
import jmri.jmrit.operations.rollingstock.cars.CarManager;
import jmri.jmrit.operations.routes.Route;
import jmri.jmrit.operations.routes.RouteLocation;
import jmri.jmrit.operations.trains.Bundle;
import jmri.jmrit.operations.trains.Train;
import jmri.jmrit.operations.trains.TrainConductorAction;
import jmri.jmrit.operations.trains.tools.ShowCarsInTrainAction;
import jmri.jmrit.throttle.ThrottleFrame;
import jmri.jmrit.throttle.ThrottleFrameManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrainIcon
extends LocoIcon {
    Train _train = null;
    int _consistNumber = 0;
    ThrottleFrame _tf = null;
    private static final Logger log = LoggerFactory.getLogger(TrainIcon.class);

    public TrainIcon(Editor editor) {
        super(editor);
    }

    @Override
    public void setShowToolTip(boolean set) {
        this._showTooltip = true;
    }

    @Override
    public boolean showPopUp(JPopupMenu popup) {
        if (this._train != null) {
            String actionText = this._train.getCurrentRouteLocation() == this._train.getTrainTerminatesRouteLocation() ? Bundle.getMessage("Terminate") : Bundle.getMessage("Move");
            popup.add(new AbstractAction(actionText){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TrainIcon.this._train.move();
                }
            });
            popup.add(this.makeTrainRouteMenu());
            popup.add(new TrainConductorAction(this._train));
            popup.add(new ShowCarsInTrainAction(this._train));
            if (!this.isEditable()) {
                popup.add(new AbstractAction(Bundle.getMessage("SetX&Y")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (!TrainIcon.this._train.setTrainIconCoordinates()) {
                            JOptionPane.showMessageDialog(null, Bundle.getMessage("SeeOperationsSettings"), Bundle.getMessage("SetX&YisDisabled"), 0);
                        }
                    }
                });
            }
        }
        popup.add(new ThrottleAction(Bundle.getMessage("Throttle")));
        popup.add(this.makeLocoIconMenu());
        if (!this.isEditable()) {
            this.getEditor().setRemoveMenu(this, popup);
        }
        return true;
    }

    public void setTrain(Train train) {
        this._train = train;
    }

    public Train getTrain() {
        return this._train;
    }

    public void setConsistNumber(int cN) {
        this._consistNumber = cN;
    }

    private int getConsistNumber() {
        return this._consistNumber;
    }

    private void createThrottle() {
        this._tf = InstanceManager.getDefault(ThrottleFrameManager.class).createThrottleFrame();
        if (this.getConsistNumber() > 0) {
            this._tf.getAddressPanel().setAddress(this.getConsistNumber(), false);
            if (JOptionPane.showConfirmDialog(null, Bundle.getMessage("SendFunctionCommands"), Bundle.getMessage("ConsistThrottle"), 0) == 0) {
                this._tf.getAddressPanel().setRosterEntry(this._entry);
            }
        } else {
            this._tf.getAddressPanel().setRosterEntry(this._entry);
        }
        this._tf.toFront();
    }

    private JMenu makeTrainRouteMenu() {
        JMenu routeMenu = new JMenu(Bundle.getMessage("Route"));
        Route route = this._train.getRoute();
        if (route == null) {
            return routeMenu;
        }
        List carList = InstanceManager.getDefault(CarManager.class).getByTrainList(this._train);
        for (RouteLocation rl : route.getLocationsBySequenceList()) {
            int pickupCars = 0;
            int dropCars = 0;
            String current = "     ";
            if (this._train.getCurrentRouteLocation() == rl) {
                current = "-> ";
            }
            for (Car car : carList) {
                if (car.getRouteLocation() == rl && !car.getTrackName().equals("")) {
                    ++pickupCars;
                }
                if (car.getRouteDestination() != rl) continue;
                ++dropCars;
            }
            String rText = "";
            String pickups = "";
            String drops = "";
            if (pickupCars > 0) {
                pickups = " " + Bundle.getMessage("Pickup") + " " + pickupCars;
                if (dropCars > 0) {
                    drops = ", " + Bundle.getMessage("SetOut") + " " + dropCars;
                }
            } else if (dropCars > 0) {
                drops = " " + Bundle.getMessage("SetOut") + " " + dropCars;
            }
            rText = pickupCars > 0 || dropCars > 0 ? String.valueOf(current) + rl.getName() + "  (" + pickups + drops + " )" : String.valueOf(current) + rl.getName();
            routeMenu.add(new RouteAction(rText, rl));
        }
        return routeMenu;
    }

    @Override
    public void doMouseDragged(MouseEvent event) {
        RouteLocation next;
        log.debug("Mouse dragged, X={} Y={}", (Object)this.getX(), (Object)this.getY());
        if (this._train != null && (next = this._train.getNextRouteLocation(this._train.getCurrentRouteLocation())) != null) {
            Point nextPoint = next.getTrainIconCoordinates();
            log.debug("Next location ({}), X={} Y={}", new Object[]{next.getName(), nextPoint.x, nextPoint.y});
            if (Math.abs(this.getX() - nextPoint.x) < next.getTrainIconRangeX() && Math.abs(this.getY() - nextPoint.y) < next.getTrainIconRangeY()) {
                log.debug("Train icon ({}) within range of ({})", (Object)this._train.getName(), (Object)next.getName());
                if (JOptionPane.showConfirmDialog(null, MessageFormat.format(Bundle.getMessage("MoveTrainTo"), next.getName()), MessageFormat.format(Bundle.getMessage("MoveTrain"), this._train.getIconName()), 0) == 0) {
                    this._train.move();
                }
            }
        }
    }

    public class RouteAction
    extends AbstractAction {
        RouteLocation _rl;

        public RouteAction(String actionName, RouteLocation rl) {
            super(actionName);
            this._rl = rl;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            log.debug("Route location selected {}", (Object)this._rl.getName());
            Route route = TrainIcon.this._train.getRoute();
            List<RouteLocation> routeList = route.getLocationsBySequenceList();
            int r = 0;
            while (r < routeList.size()) {
                RouteLocation rl = routeList.get(r);
                if (TrainIcon.this._train.getCurrentRouteLocation() == rl) {
                    log.debug("Train is at location {}", (Object)rl.getName());
                    if (rl == this._rl) break;
                    int i = r + 1;
                    while (i < routeList.size()) {
                        RouteLocation nextRl = routeList.get(i);
                        if (nextRl == this._rl && i == r + 1) {
                            TrainIcon.this._train.move();
                        } else if (nextRl == this._rl && JOptionPane.showConfirmDialog(null, MessageFormat.format(Bundle.getMessage("MoveTrainTo"), this._rl.getName()), MessageFormat.format(Bundle.getMessage("MoveTrain"), TrainIcon.this._train.getIconName()), 0) == 0) {
                            while (TrainIcon.this._train.getCurrentRouteLocation() != this._rl) {
                                TrainIcon.this._train.move();
                            }
                        }
                        ++i;
                    }
                }
                ++r;
            }
        }
    }

    public class ThrottleAction
    extends AbstractAction {
        public ThrottleAction(String actionName) {
            super(actionName);
            if (TrainIcon.this._entry == null) {
                this.setEnabled(false);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TrainIcon.this.createThrottle();
        }
    }
}

